/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.business.PurInStockHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurInstockUtil;

public class PurInstockDefaultOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("*");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("sumtax");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("sumtaxamount");
        e.getFieldKeys().add("businessdirect");
        e.getFieldKeys().add("materialentry.*");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("materialentry.seq");
        e.getFieldKeys().add("materialentry.poentryid");
        e.getFieldKeys().add("materialentry.taxamount");
        e.getFieldKeys().add("materialentry.tax");
        e.getFieldKeys().add("materialentry.price");
        e.getFieldKeys().add("materialentry.amount");
        e.getFieldKeys().add("materialentry.qty");
        e.getFieldKeys().add("materialentry.srcentryid");
        e.getFieldKeys().add("materialentry.linetype");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("purtype");
        e.getFieldKeys().add("basicqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject bill : e.getDataEntities()) {
            PurInStockHelper.tryExecuteInStockUpdate((String)bill.getString("id"));
        }
        ArrayList<DynamicObject> normalDys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> returnDys = new ArrayList<DynamicObject>(8);
        for (DynamicObject dy : e.getDataEntities()) {
            String businessdirect = dy.getString("businessdirect");
            if ("return".equals(businessdirect)) {
                returnDys.add(dy);
                continue;
            }
            normalDys.add(dy);
        }
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        boolean xkScmConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud");
        boolean iERPConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"ierp");
        if (!CollectionUtils.isEmpty(normalDys)) {
            PurInstockUtil.handleBeforeExecute(normalDys.toArray(new DynamicObject[0]), easConfig || xkScmConfig || iERPConfig, easConfig);
        }
        if (!CollectionUtils.isEmpty(returnDys)) {
            this.writeBackOrder(returnDys, easConfig || xkScmConfig || iERPConfig);
        }
    }

    private void writeBackOrder(List<DynamicObject> returnDys, boolean erpFlag) {
        if (!erpFlag) {
            return;
        }
        HashMap<String, Map> headDataMap = new HashMap<String, Map>(8);
        for (DynamicObject dyn : returnDys) {
            String number = dyn.getString("billno").toLowerCase();
            headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
        }
        List writeBackDynamicObjects = OrderUtil.getWriteBackObjesByOrder(returnDys, headDataMap, (String)"materialentry");
        ArrayList<DynamicObject> writeBackDynamicObjReturn = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> writeBackDynamicObj = new ArrayList<DynamicObject>(8);
        for (DynamicObject dyn : writeBackDynamicObjects) {
            if ("1".equals(dyn.getString("replenishtype"))) {
                writeBackDynamicObjReturn.add(dyn);
                continue;
            }
            writeBackDynamicObj.add(dyn);
        }
        if (writeBackDynamicObjReturn.size() > 0) {
            OrderUtil.writeBackOrderReturnInfo(writeBackDynamicObjReturn, Collections.singletonList("suminstockretqty"), (String)"materialentry", (String)"audit");
        }
        if (writeBackDynamicObj.size() > 0) {
            OrderUtil.writeBackOrderReturnInfo(writeBackDynamicObj, Collections.singletonList("suminstockretqty"), (String)"materialentry", (String)"audit");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        PurInstockUtil.handleAfterExecute(e.getDataEntities(), easConfig);
        PurInStockHelper.updateAutoConfirmStatus((DynamicObject[])e.getDataEntities());
    }
}

