/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.LanguageHelper;
import kd.scm.pur.business.PurInvoiceHelper;
import kd.scm.pur.business.bean.PushApBillResp;

public final class PurInvoiceToApBillOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInvoiceToApBillOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("entryentity1.isentrypay");
        e.getFieldKeys().add("entryentity1.pobillid1");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject bill = extendedDataEntity.getDataEntity();
                    StringBuilder checkMessage = new StringBuilder();
                    try {
                        checkMessage.append(PurInvoiceHelper.checkPurInvoiceData((DynamicObject[])new DynamicObject[]{bill}));
                    }
                    catch (KDException exception) {
                        checkMessage.append(exception.getMessage());
                    }
                    if (checkMessage.length() <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, checkMessage.toString());
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList<Object> pkIds = new ArrayList<Object>(1024);
        for (DynamicObject bill : e.getDataEntities()) {
            pkIds.add(bill.get("id"));
        }
        ArrayList<Long> successIds = new ArrayList<Long>(1024);
        StringBuilder message = new StringBuilder();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_invoice"));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            StringBuilder errorMessage = new StringBuilder();
            HashSet executePushApBill = new HashSet(1024);
            try {
                List results = PurInvoiceHelper.batchPushApBill((DynamicObject[])dynamicObjects);
                for (PushApBillResp result : results) {
                    if (result.getIsPushSuccess().booleanValue()) {
                        successIds.add(result.getBillId());
                        executePushApBill.addAll(result.getBillnoSet());
                        continue;
                    }
                    errorMessage.append(result.getMessage());
                }
            }
            catch (KDException exception) {
                if (exception.getMessage() == null || exception.getMessage().isEmpty()) {
                    errorMessage.append(((Object)((Object)exception)).getClass().getName());
                }
                errorMessage.append(exception.getMessage());
            }
            String name = LanguageHelper.getLocalValue(this.operateMeta.get("name"));
            if (!executePushApBill.isEmpty()) {
                message.append(MessageFormat.format(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u6210\u529f\uff0c\u5e94\u4ed8\u5355\u53f7\u4e3a{0}\u3002", (String)"PurInvoiceToApBillOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]), ((Object)executePushApBill).toString())).append("\t\n");
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Info);
                operateErrorInfo.setTitle(name);
                operateErrorInfo.setMessage(message.toString());
                this.getOperationResult().getAllErrorInfo().add(operateErrorInfo);
            }
            if (errorMessage.length() > 0) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (String)"PurInvoiceToApBillOp_1", (String)"scm-pur-opplugin", (Object[])new Object[0])).append(System.lineSeparator()).append((CharSequence)errorMessage);
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setTitle(name);
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(errorMsg.toString());
                this.getOperationResult().getAllErrorInfo().add(operateErrorInfo);
                this.getOperationResult().setSuccess(false);
            }
        }
        this.getOperationResult().setSuccessPkIds(successIds);
    }
}

