/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.invcloud.InvoiceCloudHelper;
import kd.scm.common.invcloud.enums.InvCheckStatusEnum;
import kd.scm.common.invcloud.enums.InvSourceEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.pur.business.PurEasInvoiceSendHelper;
import kd.scm.pur.opplugin.util.PurEasInvoiceConfirmInvoiceOpUtil;
import kd.scm.pur.opplugin.util.UpdateTagUtil;
import kd.scm.pur.opplugin.validator.PurInVoiceUnConfirmValidator;

public class PurInvoiceUnConfirmInvoiceOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInvoiceUnConfirmInvoiceOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("entryentity1");
        e.getFieldKeys().add("entryentity1.isentrypay");
        e.getFieldKeys().add("entryentity1.entrypaytype");
        e.getFieldKeys().add("ispay");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("entryentity.invcode");
        e.getFieldKeys().add("entryentity.invno");
        e.getFieldKeys().add("entryentity1.pobillid1");
        e.getFieldKeys().add("entryentity1.poentryid1");
        e.getFieldKeys().add("entryentity1.pobillno1");
        e.getFieldKeys().add("entryentity1.srcentryid1");
        e.getFieldKeys().add("materialentry.ischeckorinvoice");
        e.getFieldKeys().add("entryentity.invserialnum");
        e.getFieldKeys().add("entryentity.invsource");
        e.getFieldKeys().add("entryentity.invcheckstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurInVoiceUnConfirmValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] invoices = e.getDataEntities();
        if (ApiConfigUtil.getEasConfig() != null) {
            boolean status = PurEasInvoiceSendHelper.getParamStatus((DynamicObject[])invoices);
            if (!status) {
                return;
            }
            PurEasInvoiceConfirmInvoiceOpUtil.checkEasInvioces(e, invoices, "unreceive", "A", "2");
        }
        if (!e.isCancel()) {
            PurEasInvoiceConfirmInvoiceOpUtil.setCfmStatus("A", "2", invoices);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] Objs = e.getDataEntities();
        UpdateTagUtil.updateTag(Objs, (boolean)Boolean.FALSE);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] invoices;
        for (DynamicObject invoiceObject : invoices = e.getDataEntities()) {
            this.unSignInvoice(invoiceObject);
        }
    }

    private void unSignInvoice(DynamicObject invoiceObject) {
        ArrayList<String> serialNos = new ArrayList<String>();
        DynamicObjectCollection entryEntityCol = invoiceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntityCol) {
            String invCheckStatus = dynamicObject.getString("invcheckstatus");
            String invSource = dynamicObject.getString("invsource");
            if (!InvCheckStatusEnum.PASS.getVal().equals(invCheckStatus) || !InvSourceEnum.INVOICECLOUD.getVal().equals(invSource)) continue;
            String invSerialNum = dynamicObject.getString("invserialnum");
            serialNos.add(invSerialNum);
        }
        if (serialNos.size() > 0) {
            InvoiceCloudHelper.unsignInvoice((DynamicObject)invoiceObject, serialNos);
        }
    }
}

