/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;

public class PurOrderChangeCQScmOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("*");
        e.getFieldKeys().add("materialentry.*");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (ApiConfigUtil.hasCQScmConfig()) {
            String poEntryId;
            DynamicObjectCollection material;
            DynamicObject[] dyns = e.getDataEntities();
            HashSet<String> orderBillEntryPks = new HashSet<String>(dyns.length);
            for (DynamicObject bill : dyns) {
                String pobillid = bill.getString("pobillid");
                material = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : material) {
                    poEntryId = row.getString("poentryid");
                    if (!StringUtils.isNotBlank((CharSequence)poEntryId) || poEntryId.equals("0")) continue;
                    orderBillEntryPks.add(poEntryId);
                }
            }
            if (!orderBillEntryPks.isEmpty()) {
                HashMap<String, Map<String, Object>> oderEntryOldValue = new HashMap<String, Map<String, Object>>();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_order", (String)"materialentry.id id,materialentry.qty qty,materialentry.price price,materialentry.taxprice taxprice,materialentry.taxrate taxrate,materialentry.taxrateid taxrateid,materialentry.dctrate dctrate,materialentry.entrydelidate entrydelidate,materialentry.deliaddr deliaddr,materialentry.poentryid poentryid,materialentry.promiseday promiseday", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", orderBillEntryPks)}, (String)"id");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        String poEntryId2 = row.getString("poentryid");
                        HashMap<String, BigDecimal> oldValue = (HashMap<String, BigDecimal>)oderEntryOldValue.get(poEntryId2);
                        if (oldValue == null) {
                            oldValue = new HashMap<String, BigDecimal>();
                        }
                        oldValue.put("qtyold", row.getBigDecimal("qty"));
                        oldValue.put("taxpriceold", row.getBigDecimal("taxprice"));
                        oldValue.put("priceold", row.getBigDecimal("price"));
                        oldValue.put("taxrateold", row.getBigDecimal("taxrate"));
                        Object taxRateIdObj = row.get("taxrateid");
                        if (null != taxRateIdObj) {
                            oldValue.put("taxrateidold_id", (BigDecimal)taxRateIdObj);
                        }
                        oldValue.put("dctrateold", row.getBigDecimal("dctrate"));
                        oldValue.put("delidateold", (BigDecimal)((Object)row.getDate("entrydelidate")));
                        oldValue.put("deliaddrold", (BigDecimal)((Object)row.getString("deliaddr")));
                        oldValue.put("promisedayold", (BigDecimal)((Object)row.getDate("promiseday")));
                        if (null != oderEntryOldValue.get(poEntryId2)) continue;
                        oderEntryOldValue.put(poEntryId2, oldValue);
                    }
                }
                if (!oderEntryOldValue.isEmpty()) {
                    for (DynamicObject bill : dyns) {
                        material = bill.getDynamicObjectCollection("materialentry");
                        for (DynamicObject row : material) {
                            poEntryId = row.getString("poentryid");
                            Map oldValue = (Map)oderEntryOldValue.get(poEntryId);
                            if (oldValue == null) continue;
                            for (Map.Entry entry : oldValue.entrySet()) {
                                String key = (String)entry.getKey();
                                Object value = entry.getValue();
                                row.set(key, value);
                            }
                        }
                        this.setMinDeliInfo(oderEntryOldValue, bill);
                    }
                }
                if (!orderBillEntryPks.isEmpty()) {
                    this.changeSrcPurOrderStatus(orderBillEntryPks);
                }
            }
        }
    }

    private void setMinDeliInfo(Map<String, Map<String, Object>> oderEntryOldValue, DynamicObject bill) {
        HashMap<String, Object> minValue = new HashMap<String, Object>();
        Date delidate = bill.getDate("delidate");
        for (Map.Entry<String, Map<String, Object>> entry : oderEntryOldValue.entrySet()) {
            Map<String, Object> oldValue = entry.getValue();
            for (Map.Entry<String, Object> innerEntry : oldValue.entrySet()) {
                String innerEntryKey = innerEntry.getKey();
                Object innerEntryValue = innerEntry.getValue();
                if (delidate == null || !"delidateold".equals(innerEntryKey) || !delidate.after((Date)innerEntryValue)) continue;
                minValue.putAll(oldValue);
            }
        }
        if (!minValue.isEmpty()) {
            bill.set("delidate", minValue.get("delidateold"));
            bill.set("deliaddress", minValue.get("deliaddrold"));
        }
    }

    private void changeSrcPurOrderStatus(Set<String> srcPobillIdSet) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"pur_order", (String)"cfmstatus", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", srcPobillIdSet)})) {
            obj.set("cfmstatus", (Object)ConfirmStatusEnum.ALERT.getVal());
        }
        if (objs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])objs);
        }
    }
}

