/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.pur.business.PurModuleListHelper;

public final class PurOrderDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String PUR_ENTRYENTITY = "materialentry";
    private static Log log = LogFactory.getLog(PurOrderDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("businesstype");
        filds.add("materialentry.mftorderentryid");
        e.getFieldKeys().add("jointdatachannelid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> mftorderentryids = new ArrayList<String>(8);
        for (DynamicObject obj : dataEntities) {
            DynamicObject businesstype = obj.getDynamicObject("businesstype");
            if (businesstype == null || !BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) continue;
            DynamicObjectCollection materialentrys = obj.getDynamicObjectCollection(PUR_ENTRYENTITY);
            for (DynamicObject entry : materialentrys) {
                String mftorderentryid = entry.getString("mftorderentryid");
                if (mftorderentryid == null || mftorderentryid.isEmpty()) continue;
                mftorderentryids.add(mftorderentryid);
            }
        }
        if (!CollectionUtils.isEmpty(mftorderentryids)) {
            log.info("\u5f00\u59cb\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u59d4\u5916\u6e05\u5355\u63a5\u53e3");
            Map result = PurModuleListHelper.unAuditAndDeletePurModuleList(mftorderentryids);
            log.info("\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u59d4\u5916\u6e05\u5355\u63a5\u53e3\u7ed3\u679c --> " + result);
            boolean success = (Boolean)result.get("success");
            if (!success) {
                String msg = (String)result.get("message");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u59d4\u5916\u6e05\u5355\u63a5\u53e3\u5931\u8d25\u3002", (String)"PurOrderDeleteOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]), msg));
            }
        }
    }
}

