/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pur.business.MalOrderHelper;

public class PurOrderSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurOrderSaveOp.class);
    private static final String PUR_ENTRYENTITY = "materialentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bizpartner");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("srctype");
        e.getFieldKeys().add("materialentry.pobillid");
        e.getFieldKeys().add("materialentry.pobillno");
        e.getFieldKeys().add("materialentry.poentryid");
        e.getFieldKeys().add("materialentry.entryrcvorg");
        e.getFieldKeys().add("materialentry.entrysettleorg");
        e.getFieldKeys().add("materialentry.rcvpersonname");
        e.getFieldKeys().add("materialentry.rcvpersontel");
        e.getFieldKeys().add("materialentry.deliaddr");
        e.getFieldKeys().add("materialentry.rcvpersonid");
        e.getFieldKeys().add("materialentry.srcbillid");
        e.getFieldKeys().add("materialentry.srcentryid");
        e.getFieldKeys().add("materialentry.pcbillno");
        e.getFieldKeys().add("materialentry.pcbillid");
        e.getFieldKeys().add("materialentry.pcentryid");
        e.getFieldKeys().add("deliaddress");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("saloutqtydown");
        e.getFieldKeys().add("saloutbaseqtydown");
        e.getFieldKeys().add("saloutqtyup");
        e.getFieldKeys().add("saloutbaseqtyup");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("basicunit");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List extendedDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            dataEntity.getLong("supplier_id");
            dataEntity.set("bizpartner", (Object)BizPartnerUtil.getBizPartnerBySupplier((Object)dataEntity.getLong("supplier_id")));
        }
        this.updateGoodsReceiver(e.getDataEntities());
    }

    private void updateGoodsReceiver(DynamicObject[] dyos) {
        for (DynamicObject dyo : dyos) {
            DynamicObjectCollection entryCol;
            String srctype = dyo.getString("srctype");
            if (PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal().equals(srctype) || PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal().equals(srctype)) {
                entryCol = dyo.getDynamicObjectCollection(PUR_ENTRYENTITY);
                try {
                    Map successMap;
                    Object resultObj;
                    Object successRes;
                    Long srcBillIds = 0L;
                    if (null != entryCol && entryCol.size() > 0) {
                        for (DynamicObject entrydyo : entryCol) {
                            String srcBillIdStr = entrydyo.getString("srcbillid");
                            if (!StringUtils.isNotEmpty((CharSequence)srcBillIdStr)) continue;
                            srcBillIds = Long.valueOf(srcBillIdStr);
                            break;
                        }
                    }
                    if (!((successRes = this.getAddressByMalOrderId(srcBillIds)) instanceof Map) || !((resultObj = (successMap = (Map)successRes).get("result")) instanceof Map)) continue;
                    Map result = (Map)resultObj;
                    Object receiptPhone = result.get("receiptPhone");
                    Object receiptWholeaddress = result.get("receiptWholeaddress");
                    Object receiptName = result.get("receiptName");
                    for (DynamicObject entrydyo : entryCol) {
                        if (Objects.nonNull(receiptName)) {
                            entrydyo.set("rcvpersonname", (Object)((String)receiptName));
                        }
                        if (Objects.nonNull(receiptPhone)) {
                            entrydyo.set("rcvpersontel", (Object)((String)receiptPhone));
                        }
                        if (!Objects.nonNull(receiptWholeaddress)) continue;
                        entrydyo.set("deliaddr", (Object)((String)receiptWholeaddress));
                    }
                    continue;
                }
                catch (Exception e) {
                    SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
                    continue;
                }
            }
            entryCol = dyo.getDynamicObjectCollection(PUR_ENTRYENTITY);
            for (DynamicObject entrydyo : entryCol) {
                DynamicObject rcvpersonid = entrydyo.getDynamicObject("rcvpersonid");
                if (rcvpersonid == null) continue;
                entrydyo.set("rcvpersonname", (Object)rcvpersonid.getString("name"));
            }
        }
        MalOrderHelper.writeOrderProtocolFiled((DynamicObject[])dyos);
    }

    private Object getAddressByMalOrderId(Long srcBillIds) {
        Object successRes = null;
        try {
            successRes = DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalAddressService", (String)"getAddressByMalOrderId", (Object[])new Object[]{srcBillIds});
        }
        catch (Throwable e) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
        }
        return successRes;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dyos = e.getDataEntities();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dyo : dyos) {
            DynamicObjectCollection entryCol;
            String srctype = dyo.getString("srctype");
            if (!PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal().equals(srctype) && !PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal().equals(srctype) || null == (entryCol = dyo.getDynamicObjectCollection(PUR_ENTRYENTITY)) || entryCol.size() <= 0) continue;
            Long invOrgId = 0L;
            try {
                DynamicObject rcvDyo = (DynamicObject)((DynamicObject)entryCol.get(0)).get("entryrcvorg");
                Long orgId = rcvDyo != null ? rcvDyo.getLong("id") : 0L;
                invOrgId = OrgServiceHelper.getToOrg((String)OrgTypeEnum.INVENTORY.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)orgId, (Long)0L);
            }
            catch (KDException exc) {
                sb.append("getToOrg error------>").append(exc.getMessage()).append(System.lineSeparator());
            }
            for (DynamicObject entrydyo : entryCol) {
                if (invOrgId != 0L) {
                    entrydyo.set("entrysettleorg", (Object)invOrgId);
                }
                if (StringUtils.isBlank((CharSequence)entrydyo.getString("pobillno"))) {
                    entrydyo.set("pobillno", dyo.get("billno"));
                }
                if (StringUtils.isBlank((CharSequence)entrydyo.getString("pobillid"))) {
                    entrydyo.set("pobillid", dyo.get("id"));
                }
                if (!StringUtils.isBlank((CharSequence)entrydyo.getString("poentryid"))) continue;
                entrydyo.set("poentryid", entrydyo.get("id"));
            }
        }
        if (sb.length() > 0) {
            log.info(sb.toString());
        }
    }
}

