/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;

public class PurOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private Log logger = LogFactory.getLog(PurOrderWriteBackPlugin.class);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("cfmstatus");
        fieldKeys.add("logstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("billno");
        fieldKeys.add("jdorderstatus");
        fieldKeys.add("entryentity.goods");
        fieldKeys.add("entryentity.erpbillnumber");
        fieldKeys.add("entryentity.erpbillstatus");
        fieldKeys.add("entryentity.jdorder");
        fieldKeys.add("entryentity.erplogstatus");
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("materialentry.goods");
        e.getFieldKeys().add("materialentry.jdorder");
        e.getFieldKeys().add("jdorderid");
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        String operation = e.getRule().getOp();
        HashMap<Long, Object> prod_jdOrderMap = new HashMap<Long, Object>();
        if (e.getTargetActiveRow() != null && e.getSrcActiveRow() != null) {
            DynamicObject srcBillObj = (DynamicObject)e.getSrcActiveRow().getParent();
            DynamicObject desBillObj = (DynamicObject)e.getTargetActiveRow().getParent();
            DynamicObjectCollection desDyos = (DynamicObjectCollection)desBillObj.get("materialentry");
            for (DynamicObject desDyo : desDyos) {
                prod_jdOrderMap.put(desDyo.getLong("goods.id"), desDyo.get("jdorder"));
            }
            String srcEnityType = srcBillObj.getDataEntityType().getName();
            String desEnityType = desBillObj.getDataEntityType().getName();
            if (srcEnityType.equalsIgnoreCase("mal_order") && desEnityType.equalsIgnoreCase("pur_order") && operation.equalsIgnoreCase("audit")) {
                String orderBillStatus = desBillObj.getString("billstatus");
                this.logger.info("\u5ba1\u6838\u53cd\u5199----->\u5ba1\u6838\u64cd\u4f5c---->\u534f\u540c\u8ba2\u5355\u72b6\u6001\uff1a" + orderBillStatus);
                DynamicObjectCollection dyos = (DynamicObjectCollection)srcBillObj.get("entryentity");
                String srcType = desBillObj.getString("srctype");
                for (DynamicObject dyo : dyos) {
                    Long prodId = dyo.getLong("goods.id");
                    Object prodIdObj = prod_jdOrderMap.get(prodId);
                    if (prodIdObj == null || !PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal().equals(srcType)) continue;
                    dyo.set("erplogstatus", (Object)"C");
                    dyo.set("jdorder", prodIdObj);
                }
                if (PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal().equals(srcType) && StringUtils.isNotBlank((CharSequence)desBillObj.getString("jdorderid"))) {
                    srcBillObj.set("jdorderstatus", (Object)JDOrderStatusEnum.CONFIRM.getName());
                }
            }
        }
    }
}

