/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PurSumTaxUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PurSumTaxUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u534f\u540c\u5bf9\u8d26\u5355\u5355\u5934\u7a0e\u989d\u5408\u8ba1\u53d6\u5206\u5f55\u7a0e\u989d\u6c42\u548c\u65e7\u6570\u636e\u5347\u7ea7\u3002", (String)"PurSumTaxUpgradePlugin_1", (String)"scm-pur-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"PurSumTaxUpgradePlugin_2", (String)"scm-pur-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"PurSumTaxUpgradePlugin_3", (String)"scm-pur-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        int pageSize = 200;
        DBRoute dbRoute = new DBRoute("pur");
        String sqlAll = "select fid from T_PUR_CHECK order by fid";
        try (DataSet dataSet1 = DB.queryDataSet((String)"PurSumTaxUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf\u3002", (String)"PurSumTaxUpgradePlugin_4", (String)"scm-pur-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / pageSize;
            if (count % pageSize != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
                if (subIdList.isEmpty()) continue;
                String ids = String.join((CharSequence)",", (CharSequence[])subIdList.stream().map(String::valueOf).toArray(String[]::new));
                String sql = "select a.fid,a.fsumtax,b.fentryid,b.ftax from T_PUR_CHECK a  inner join T_PUR_CHECKENTRY2 b on a.fid = b.fid where a.fid in (" + ids + ")  order by a.fid";
                Map<Long, BigDecimal> sqlParms = this.callPurSumTaxUpgradePlugin(dbRoute, sql);
                dbRoute = new DBRoute(dbKey);
                ArrayList<Object[]> parms = new ArrayList<Object[]>(sqlParms.size());
                for (Map.Entry<Long, BigDecimal> entry : sqlParms.entrySet()) {
                    Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
                    parms.add(parm);
                }
                if (parms.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                this.updateData(dbRoute, parms);
            }
        }
        return true;
    }

    private Map<Long, BigDecimal> callPurSumTaxUpgradePlugin(DBRoute dbRoute, String sql) {
        HashMap<Long, BigDecimal> sqlParms = new HashMap<Long, BigDecimal>();
        BigDecimal sumTax = BigDecimal.ZERO;
        try (DataSet dataSet = DB.queryDataSet((String)"PurSumTaxUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
            if (dataSet != null) {
                long billId = 0L;
                Iterator iterator = dataSet.iterator();
                if (iterator.hasNext()) {
                    BigDecimal tax;
                    Row row = (Row)iterator.next();
                    billId = row.getLong("fid");
                    if (billId == row.getLong("fid")) {
                        tax = row.getBigDecimal("ftax");
                        if (tax != null) {
                            sumTax = sumTax.add(tax);
                        }
                    } else {
                        sqlParms.put(billId, sumTax);
                        billId = row.getLong("fid");
                        sumTax = row.getBigDecimal("ftax");
                    }
                    if (iterator.hasNext()) {
                        do {
                            if (billId == (row = (Row)iterator.next()).getLong("fid")) {
                                tax = row.getBigDecimal("ftax");
                                if (tax == null) continue;
                                sumTax = sumTax.add(tax);
                                continue;
                            }
                            sqlParms.put(billId, sumTax);
                            billId = row.getLong("fid");
                            sumTax = row.getBigDecimal("ftax");
                        } while (iterator.hasNext());
                    }
                }
                sqlParms.put(billId, sumTax);
            }
        }
        return sqlParms;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_PUR_CHECK set fsumtax = ? where fid = ?", parms);
    }
}

