/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;

public class PurReceiptReturnUtil {
    private static Log log = LogFactory.getLog((String)"PurRequestUtil");

    public static void writeBackPoSumRecRetQty(List<DynamicObject> objs, boolean isAdd) {
        HashSet<String> poIdSet = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> poentryListMap = new HashMap<String, List<DynamicObject>>(16);
        HashMap<String, String> replenishtypeMap = new HashMap<String, String>(16);
        for (DynamicObject obj : objs) {
            for (DynamicObject entry : obj.getDynamicObjectCollection("materialentry")) {
                String poentryId = entry.getString("poentryid");
                if (!StringUtils.isNotBlank((String)poentryId)) continue;
                poIdSet.add(entry.getString("pobillid"));
                poentryListMap.computeIfAbsent(poentryId, k -> new ArrayList(16)).add(entry);
                replenishtypeMap.put(poentryId, obj.getString("replenishtype"));
            }
        }
        PurReceiptReturnUtil.writeBackPurOrder(poIdSet, poentryListMap, replenishtypeMap, isAdd);
    }

    private static void writeBackPurOrder(Set<String> poIdSet, Map<String, List<DynamicObject>> poentryListMap, Map<String, String> replenishtypeMap, boolean isAdd) {
        DynamicObject[] poDyns;
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("billno,billstatus,logstatus,cfmstatus,srctype,materialentry.sumrecretqty,materialentry.pobillid,materialentry.poentryid").append(",materialentry.sumrecretbaseqty,materialentry.sumreceiptqty,materialentry.sumreceiptbaseqty").append(",materialentry.qty,materialentry.sumrefundqty,materialentry.sumrefundbaseqty").append(",materialentry.suminstockqty,materialentry.sumoutstockqty,materialentry.suminstockretqty").append(",materialentry.vmistockqty,materialentry.srcentryid").append(",materialentry.material,materialentry.unit,materialentry.basicunit,materialentry.rowlogstatus");
        HashMap<String, String> logStoreMap = new HashMap<String, String>(64);
        for (DynamicObject dyn : poDyns = BusinessDataServiceHelper.load((String)"pur_order", (String)selectSb.toString(), (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", poIdSet)})) {
            for (DynamicObject entry : dyn.getDynamicObjectCollection("materialentry")) {
                BigDecimal sumrecretbaseqty;
                List<DynamicObject> receiveEntryDynList = poentryListMap.get(entry.getString("poentryid"));
                if (receiveEntryDynList == null || receiveEntryDynList.isEmpty()) continue;
                BigDecimal returnQty = BigDecimal.ZERO;
                for (DynamicObject temp : receiveEntryDynList) {
                    returnQty = returnQty.add(temp.getBigDecimal("qty").abs());
                }
                BigDecimal sumrecretqty = entry.getBigDecimal("sumrecretqty");
                BigDecimal sumrefundqty = entry.getBigDecimal("sumrefundqty");
                DynamicObject materialObj = entry.getDynamicObject("material");
                DynamicObject unitObj = entry.getDynamicObject("unit");
                DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                BigDecimal sumrefundbaseqty = entry.getBigDecimal("sumrefundbaseqty");
                String replenishtype = replenishtypeMap.get(entry.getString("poentryid"));
                if (isAdd) {
                    sumrecretqty = sumrecretqty.add(returnQty);
                    sumrecretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrecretqty, (DynamicObject)basicUnitObj);
                } else {
                    sumrecretqty = sumrecretqty.subtract(returnQty);
                    sumrecretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrecretqty, (DynamicObject)basicUnitObj);
                }
                if ("1".equals(replenishtype)) {
                    if (isAdd) {
                        sumrefundqty = sumrefundqty.add(returnQty);
                        sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                    } else {
                        sumrefundqty = sumrefundqty.subtract(returnQty);
                        sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                    }
                }
                logStoreMap.put(entry.getString("poentryid"), sumrecretqty.toPlainString());
                entry.set("sumrecretqty", (Object)sumrecretqty);
                entry.set("sumrecretbaseqty", (Object)sumrecretbaseqty);
                entry.set("sumrefundqty", (Object)sumrefundqty);
                entry.set("sumrefundbaseqty", (Object)sumrefundbaseqty);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("writeBackPurOrder#logStoreMap:{}", (Object)SerializationUtils.toJsonString(logStoreMap));
        }
        OrderUtil.updateOrderCfmStatusByOrders((DynamicObject[])poDyns);
    }
}

