/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.isc.util.PurReturnSaveUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.opplugin.util.PurOrderStatusUtil;

public class PurReturnUtil {
    public static final String FINISH = "F";
    public static final String CONFIRMED = "B";
    public static final String AUTOCONFIRM = "G";
    private static Log log = LogFactory.getLog((String)"PurReturnUtil");

    public static void writeBackRefundApplyConfirmStatus(DynamicObject[] returnDyns, String status) {
        Set malReturnReqIdSet;
        QFilter[] filters;
        QFilter srcBillIdQFilter;
        if (returnDyns == null || returnDyns.length == 0) {
            return;
        }
        Long[] ids = new Long[returnDyns.length];
        for (int i = 0; i < returnDyns.length; ++i) {
            ids[i] = (Long)returnDyns[i].getPkValue();
        }
        Map map = BFTrackerServiceHelper.findSourceBills((String)returnDyns[0].getDynamicObjectType().getName(), (Long[])ids);
        Set refundApplyBillIdSet = (Set)map.get("pm_purrefundapplybill");
        if (refundApplyBillIdSet != null && refundApplyBillIdSet.size() > 0) {
            DynamicObject[] requestReqDyns;
            if ("A".equalsIgnoreCase(status) || CONFIRMED.equalsIgnoreCase(status)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ids", new ArrayList(refundApplyBillIdSet));
                params.put("status", status);
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upRefundConfirmStatus", (Object[])new Object[]{params});
            }
            List refundApplyBillIdList = refundApplyBillIdSet.stream().map(s -> s.toString()).collect(Collectors.toList());
            srcBillIdQFilter = new QFilter("materialentry.srcbillid", "in", refundApplyBillIdList);
            filters = new QFilter[]{srcBillIdQFilter};
            for (DynamicObject requsetReqDyn : requestReqDyns = BusinessDataServiceHelper.load((String)"pur_request", (String)"cfmstatus", (QFilter[])filters)) {
                requsetReqDyn.set("cfmstatus", (Object)status);
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])requestReqDyns);
        }
        if ((malReturnReqIdSet = (Set)map.get("mal_returnreq")) != null && malReturnReqIdSet.size() > 0) {
            DynamicObject[] malRequestReqDyns;
            srcBillIdQFilter = new QFilter("id", "in", (Object)malReturnReqIdSet);
            filters = new QFilter[]{srcBillIdQFilter};
            for (DynamicObject malRequestReqDyn : malRequestReqDyns = BusinessDataServiceHelper.load((String)"mal_returnreq", (String)"cfmstatus", (QFilter[])filters)) {
                malRequestReqDyn.set("cfmstatus", (Object)status);
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])malRequestReqDyns);
        }
    }

    public static void writeBackPoSumReturnQty(DynamicObject[] objs, boolean isAdd) {
        HashSet<String> poIdSet = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> poentryListMap = new HashMap<String, List<DynamicObject>>(16);
        HashMap<String, String> replenishTypePoentryIdMap = new HashMap<String, String>(16);
        for (DynamicObject obj : objs) {
            for (DynamicObject entry : obj.getDynamicObjectCollection("materialentry")) {
                String poentryId = entry.getString("poentryid");
                if (!StringUtils.isNotBlank((String)poentryId)) continue;
                poIdSet.add(entry.getString("pobillid"));
                poentryListMap.computeIfAbsent(poentryId, k -> new ArrayList(16)).add(entry);
                replenishTypePoentryIdMap.put(poentryId, obj.getString("replenishtype"));
            }
        }
        PurReturnUtil.writeBackPurOrder(poIdSet, poentryListMap, replenishTypePoentryIdMap, isAdd);
    }

    private static void writeBackPurOrder(Set<String> poIdSet, Map<String, List<DynamicObject>> poentryListMap, Map<String, String> replenishtypeMap, boolean isAdd) {
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus,org,srctype").append(",materialentry.pobillid,materialentry.poentryid,materialentry.srcbillid").append(",materialentry.sumrefundqty,materialentry.sumrefundbaseqty,materialentry.material,materialentry.unit,materialentry.basicunit").append(",materialentry.id,materialentry.qty,materialentry.sumreceiveqty,materialentry.sumoutstockqty,materialentry.suminstockretqty").append(",materialentry.sumreceiptqty,materialentry.sumreceiptbaseqty").append(",materialentry.suminstockqty,materialentry.suminstockbaseqty").append(",materialentry.sumrecretqty,materialentry.sumrecretbaseqty").append(",materialentry.suminstockretqty,materialentry.suminstockretbaseqty").append(",materialentry.vmistockqty,materialentry.srcentryid,materialentry.entrystatus,materialentry.rowlogstatus");
        DynamicObject[] poDyns = BusinessDataServiceHelper.load((String)"pur_order", (String)selectSb.toString(), (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", poIdSet)});
        HashMap<String, String> logStoreMap = new HashMap<String, String>(64);
        for (DynamicObject dyn : poDyns) {
            for (DynamicObject entry : dyn.getDynamicObjectCollection("materialentry")) {
                BigDecimal suminstockretbaseqty;
                String poEntryIdString = entry.getString("poentryid");
                List<DynamicObject> receiveEntryDynList = poentryListMap.get(poEntryIdString);
                if (receiveEntryDynList == null || receiveEntryDynList.isEmpty()) continue;
                BigDecimal returnQty = BigDecimal.ZERO;
                for (DynamicObject temp : receiveEntryDynList) {
                    returnQty = returnQty.add(temp.getBigDecimal("qty").abs());
                }
                DynamicObject materialObj = entry.getDynamicObject("material");
                DynamicObject unitObj = entry.getDynamicObject("unit");
                DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                String needReSendFlag = replenishtypeMap.get(poEntryIdString);
                if ("1".equals(needReSendFlag)) {
                    BigDecimal sumrefundbaseqty;
                    BigDecimal sumrefundqty = entry.getBigDecimal("sumrefundqty");
                    if (isAdd) {
                        sumrefundqty = sumrefundqty.add(returnQty);
                        sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                    } else {
                        sumrefundqty = sumrefundqty.subtract(returnQty);
                        sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                    }
                    entry.set("sumrefundqty", (Object)sumrefundqty);
                    entry.set("sumrefundbaseqty", (Object)sumrefundbaseqty);
                }
                BigDecimal suminstockretqty = entry.getBigDecimal("suminstockretqty");
                if (isAdd) {
                    suminstockretqty = suminstockretqty.add(returnQty);
                    suminstockretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockretqty, (DynamicObject)basicUnitObj);
                } else {
                    suminstockretqty = suminstockretqty.subtract(returnQty);
                    suminstockretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockretqty, (DynamicObject)basicUnitObj);
                }
                logStoreMap.put(entry.getPkValue().toString(), suminstockretqty.toPlainString());
                entry.set("suminstockretqty", (Object)suminstockretqty);
                entry.set("suminstockretbaseqty", (Object)suminstockretbaseqty);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("writeBackPurOrder#logStoreMap:{}", (Object)SerializationUtils.toJsonString(logStoreMap));
        }
        OrderUtil.updateOrderCfmStatusByOrders((DynamicObject[])poDyns);
    }

    public static void handleBeforeExecute(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            HashMap<String, Map> headDataMap = new HashMap<String, Map>((int)((double)dyns.length / 0.75));
            HashMap<String, Map> entryDataMap = new HashMap<String, Map>(16);
            DynamicObjectCollection entryCol = null;
            HashSet<String> poEntryIds = new HashSet<String>(16);
            for (DynamicObject dyn : dyns) {
                String number = dyn.getString("billno").toLowerCase();
                headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
                    poEntryIds.add(entry.getString("poentryid"));
                }
            }
            DynamicObject[] poOrders = PurOrderStatusUtil.getPurOrders(poEntryIds);
            PurReturnSaveUtil helper = new PurReturnSaveUtil();
            helper.beforeAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
            PurOrderStatusUtil.changePurOrderStatus(poOrders);
        }
    }

    public static void handleAfterExecute(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            HashMap<String, Map> headDataMap = new HashMap<String, Map>((int)((double)dyns.length / 0.75));
            HashMap<String, Map> entryDataMap = new HashMap<String, Map>();
            DynamicObjectCollection entryCol = null;
            for (DynamicObject dyn : dyns) {
                String number = dyn.getString("billno").toLowerCase();
                headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
                }
            }
            PurReturnSaveUtil helper = new PurReturnSaveUtil();
            helper.afterAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
            for (DynamicObject dyn : dyns) {
                dyn.set("modifier", (Object)dyn.getDynamicObject("creator"));
            }
        }
    }
}

