/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;

public class PurSaloutstockUtil {
    private static final String MATERIALENTRY = "materialentry";

    private PurSaloutstockUtil() {
    }

    public static void writeBack(Set<Long> srcIdSet, Map<Long, BigDecimal> minvalueMap, boolean isClose) {
        DynamicObject[] purOrders;
        for (DynamicObject purOrder : purOrders = PurSaloutstockUtil.queryOrder(srcIdSet)) {
            DynamicObjectCollection materialentry = purOrder.getDynamicObjectCollection(MATERIALENTRY);
            for (DynamicObject col : materialentry) {
                long entryid = col.getLong("id");
                if (!minvalueMap.containsKey(entryid)) continue;
                BigDecimal shortHarvestValue = minvalueMap.get(entryid);
                BigDecimal sumoutstockqty = col.getBigDecimal("sumoutstockqty");
                BigDecimal relateoutstockqty = col.getBigDecimal("relateoutstockqty");
                if (isClose) {
                    sumoutstockqty = sumoutstockqty.subtract(shortHarvestValue);
                    relateoutstockqty = relateoutstockqty.subtract(shortHarvestValue);
                } else {
                    sumoutstockqty = sumoutstockqty.add(shortHarvestValue);
                    relateoutstockqty = relateoutstockqty.add(shortHarvestValue);
                }
                DynamicObject unitObj = col.getDynamicObject("unit");
                DynamicObject basicUnitObj = col.getDynamicObject("basicunit");
                DynamicObject materialObj = col.getDynamicObject("material");
                BigDecimal sumoutstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumoutstockqty, (DynamicObject)basicUnitObj);
                BigDecimal relateoutstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)relateoutstockqty, (DynamicObject)basicUnitObj);
                col.set("sumoutstockqty", (Object)sumoutstockqty);
                col.set("relateoutstockqty", (Object)relateoutstockqty);
                col.set("sumoutstockbaseqty", (Object)sumoutstockbaseqty);
                col.set("relateoutstockbaseqty", (Object)relateoutstockbaseqty);
            }
        }
        OrderUtil.updateOrderCfmStatus((DynamicObject[])purOrders);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOrders);
    }

    public static DynamicObject[] queryOrder(Set<Long> srcIdSet) {
        return BusinessDataServiceHelper.load((Object[])srcIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_order"));
    }

    public static void reverseWrite(List<ExtendedDataEntity> dataEntities, boolean isClose) {
        HashSet<Long> srcIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> minvalueMap = new HashMap<Long, BigDecimal>();
        PurSaloutstockUtil.dealParam(dataEntities, srcIdSet, minvalueMap);
        PurSaloutstockUtil.writeBack(srcIdSet, minvalueMap, isClose);
    }

    public static void dealParam(List<ExtendedDataEntity> dataEntities, HashSet<Long> srcIdSet, HashMap<Long, BigDecimal> minvalueMap) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject materialentry = dataEntity.getDataEntity();
            PurSaloutstockUtil.assembleParam(srcIdSet, minvalueMap, materialentry, null);
        }
    }

    public static void assembleParam(Set<Long> srcIdSet, Map<Long, BigDecimal> minvalueMap, DynamicObject materialentry, HashMap<Long, Long> relationMap) {
        Long entryId = materialentry.getLong("id");
        Long billId = ((DynamicObject)materialentry.getParent()).getLong("id");
        HashSet<Long> billIds = new HashSet<Long>(1);
        billIds.add(billId);
        HashSet<Long> entryIds = new HashSet<Long>(1);
        entryIds.add(entryId);
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)"scp_saloutstock", (String)MATERIALENTRY, (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"scp_saloutstock", (Long[])billIds.toArray(new Long[0]));
        HashSet orderIdSet = new HashSet();
        Set entries = sourceBills.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!"pur_order".equals(key) && !"scp_order".equals(key)) continue;
            HashSet value = (HashSet)entry.getValue();
            orderIdSet.addAll((Collection)entry.getValue());
        }
        if (!bfRowList.isEmpty()) {
            Long srcbillid = 0L;
            Long srcentryid = 0L;
            for (BFRow row : bfRowList) {
                Long srcId = row.getSId().getBillId();
                if (!orderIdSet.contains(srcId)) continue;
                srcbillid = srcId;
                srcentryid = row.getSId().getEntryId();
                break;
            }
            BigDecimal qty = materialentry.getBigDecimal("qty");
            BigDecimal sumreceiptqty = materialentry.getBigDecimal("sumreceiptqty");
            sumreceiptqty = sumreceiptqty == null ? BigDecimal.ZERO : sumreceiptqty;
            BigDecimal suminstockqty = materialentry.getBigDecimal("suminstockqty");
            suminstockqty = suminstockqty == null ? BigDecimal.ZERO : suminstockqty;
            BigDecimal subtract1 = qty.subtract(suminstockqty);
            BigDecimal subtract2 = qty.subtract(sumreceiptqty);
            if (BigDecimal.ZERO.compareTo(subtract1) == 0 && BigDecimal.ZERO.compareTo(subtract2) == 0) {
                return;
            }
            srcIdSet.add(srcbillid);
            BigDecimal minSubtract = subtract1.min(subtract2);
            BigDecimal sumMinValue = minvalueMap.get(srcentryid);
            if (sumMinValue != null) {
                minvalueMap.put(srcentryid, sumMinValue.add(minSubtract));
            } else {
                minvalueMap.put(srcentryid, minSubtract);
            }
            if (relationMap != null) {
                relationMap.put(materialentry.getLong("id"), srcentryid);
            }
        }
    }

    public static void reverseWriteAcceptTaxAmount(DynamicObject[] dataEntities, boolean isClose) {
        HashSet<Long> srcIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> minvalueMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject dataEntity : dataEntities) {
            Long billId = (Long)dataEntity.getPkValue();
            PurSaloutstockUtil.assembleParamByAcceptTaxAmount(billId, srcIdSet, minvalueMap, dataEntity, null);
        }
        PurSaloutstockUtil.writeBackAcceptTaxAmount(srcIdSet, minvalueMap, isClose);
    }

    private static void writeBackAcceptTaxAmount(Set<Long> srcIdSet, Map<Long, BigDecimal> minvalueMap, boolean isClose) {
        DynamicObject[] purOrders;
        for (DynamicObject purOrder : purOrders = PurSaloutstockUtil.queryOrder(srcIdSet)) {
            DynamicObjectCollection materialentry = purOrder.getDynamicObjectCollection(MATERIALENTRY);
            for (DynamicObject col : materialentry) {
                long entryid = col.getLong("id");
                if (!minvalueMap.containsKey(entryid)) continue;
                BigDecimal shortHarvestValue = minvalueMap.get(entryid);
                BigDecimal sumapaccepttaxamount = col.getBigDecimal("sumapaccepttaxamount");
                BigDecimal relateapaccepttaxamount = col.getBigDecimal("relateapaccepttaxamount");
                if (isClose) {
                    sumapaccepttaxamount = sumapaccepttaxamount.subtract(shortHarvestValue);
                    relateapaccepttaxamount = relateapaccepttaxamount.subtract(shortHarvestValue);
                } else {
                    sumapaccepttaxamount = sumapaccepttaxamount.add(shortHarvestValue);
                    relateapaccepttaxamount = relateapaccepttaxamount.add(shortHarvestValue);
                }
                col.set("sumapaccepttaxamount", (Object)sumapaccepttaxamount);
                col.set("relateapaccepttaxamount", (Object)relateapaccepttaxamount);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purOrders);
    }

    public static void assembleParamByAcceptTaxAmount(Long billId, Set<Long> srcIdSet, Map<Long, BigDecimal> minvalueMap, DynamicObject materialentry, HashMap<Long, Long> relationMap) {
        Long entryId = materialentry.getLong("id");
        HashSet<Long> billIds = new HashSet<Long>(1);
        billIds.add(billId);
        HashSet<Long> entryIds = new HashSet<Long>(1);
        entryIds.add(entryId);
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)"scp_accept_apply", (String)MATERIALENTRY, (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (!bfRowList.isEmpty()) {
            BigDecimal sumaccepttaxamount;
            BFRow bfRow = (BFRow)bfRowList.get(0);
            long srcbillid = bfRow.getSId().getBillId();
            long srcentryid = bfRow.getSId().getEntryId();
            BigDecimal taxamount = materialentry.getBigDecimal("taxamount");
            BigDecimal subtract2 = taxamount.subtract(sumaccepttaxamount = (sumaccepttaxamount = materialentry.getBigDecimal("sumaccepttaxamount")) == null ? BigDecimal.ZERO : sumaccepttaxamount);
            if (BigDecimal.ZERO.compareTo(subtract2) == 0) {
                return;
            }
            srcIdSet.add(srcbillid);
            BigDecimal sumMinValue = minvalueMap.get(srcentryid);
            if (sumMinValue != null) {
                minvalueMap.put(srcentryid, sumMinValue.add(subtract2));
            } else {
                minvalueMap.put(srcentryid, subtract2);
            }
            if (relationMap != null) {
                relationMap.put(srcentryid, materialentry.getLong("id"));
            }
        }
    }
}

