/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;

public class PurOrderValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(PurOrderValidator.class);
    private StringBuffer errorMsg = new StringBuffer();

    public void validate() {
        log.info("@@@kd.scm.pur.opplugin.validator.PurOrderValidator.validate");
        String token = null;
        if (MalOrderUtil.getDefaultMalVersion()) {
            return;
        }
        HashMap<String, String> logStoreMap = new HashMap<String, String>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyo = dataEntity.getDataEntity();
            String srctype = dyo.getString("srctype");
            String jdOrderId = dyo.getString("jdorderid");
            if (srctype.equalsIgnoreCase(ProductSourceEnum.PRODUCTSOURCE_JD.getVal()) && StringUtils.isNotBlank((CharSequence)jdOrderId)) {
                if (token == null) {
                    token = JDAccessTokenUtil.getAccessTokenByKD((String)RequestContext.get().getTenantId());
                }
                logStoreMap.put(jdOrderId, token);
                boolean isValid = JDOrderUtil.checkJdOrderStatus((String)token, (String)jdOrderId);
                if (!isValid) {
                    this.errorMsg.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u4eac\u4e1c\u8ba2\u5355{0}\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurOrderValidator_0", (String)"scm-pur-opplugin", (Object[])new Object[0]), jdOrderId));
                }
            }
            if (this.errorMsg.length() <= 0) continue;
            this.addErrorMessage(dataEntity, this.errorMsg.toString());
        }
        if (log.isInfoEnabled()) {
            log.info("validate#logStoreMap:{}", (Object)SerializationUtils.toJsonString(logStoreMap));
        }
    }
}

