/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.deliver;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.common.util.DateUtil;
import kd.scm.pur.report.deliver.PurDeliveryRptCols;
import kd.scm.pur.report.deliver.PurDeliveryRptParam;
import kd.scm.pur.report.deliver.PurDeliverySumRptCols;

public class PurDeliveryRptHandle
implements IReportDataHandle {
    private PurDeliveryRptParam reportParam;

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        List<String> addClums = this.reportParam.getDivClums();
        addClums.remove("promisedate");
        addClums.remove("deliverydate");
        addClums.remove("promiseqty");
        addClums.remove("qty");
        ReportColumn tempQtyCol = null;
        Date startDate = this.reportParam.getStartdate();
        String datetype = this.reportParam.getDatetype();
        String clumnName = null;
        for (int i = 0; i < addClums.size(); ++i) {
            clumnName = i == addClums.size() - 1 ? this.getClunName(startDate, datetype, true, i) : this.getClunName(startDate, datetype, false, i);
            if (null != this.reportParam.getGroup() && "4".equals(datetype)) {
                List<Map> group = this.getSortGroup();
                Map groupMap = group.get(i);
                if (null != groupMap.get("endDay")) {
                    int beginDay = Integer.parseInt(String.valueOf(groupMap.get("beginDay")));
                    int endDay = Integer.parseInt(String.valueOf(groupMap.get("endDay")));
                    startDate = DateUtil.addDays((Date)startDate, (int)(endDay - beginDay + 1));
                }
            } else {
                if ("1".equals(datetype)) {
                    startDate = DateUtil.addDays((Date)startDate, (int)1);
                }
                if ("2".equals(datetype)) {
                    startDate = DateUtil.addWeek((Date)startDate, (int)1);
                }
                if ("3".equals(datetype)) {
                    startDate = DateUtil.addMonth((Date)startDate, (int)1);
                }
            }
            if (!"type".equals(clumnName)) {
                tempQtyCol = ReportColumnFactory.createDecimalColumn((LocaleString)new LocaleString(clumnName), (String)addClums.get(i), (int)2);
            }
            cols.add((AbstractReportColumn)tempQtyCol);
        }
        return cols;
    }

    private List<Map> getSortGroup() {
        List group = (List)SerializationUtils.fromJsonString((String)this.reportParam.getGroup(), List.class);
        for (int i = 0; i < group.size() - 1; ++i) {
            for (int j = 0; j < group.size() - 1 - i; ++j) {
                int maxBeginDay;
                Map min = (Map)group.get(j);
                Map max = (Map)group.get(j + 1);
                int minBeginDay = Integer.parseInt(String.valueOf(min.get("beginDay")));
                if (minBeginDay <= (maxBeginDay = Integer.parseInt(String.valueOf(max.get("beginDay"))))) continue;
                Map temp = max;
                max = min;
                min = temp;
            }
        }
        return group;
    }

    public String getClunName(Date currentTime, String dateType, Boolean isLast, int i) {
        SimpleDateFormat month = new SimpleDateFormat("MM");
        SimpleDateFormat day = new SimpleDateFormat("dd");
        String monString = Integer.valueOf(month.format(currentTime)).toString();
        String dayString = Integer.valueOf(day.format(currentTime)).toString();
        String aftermon = "";
        String afterday = "";
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(monString).append('.').append(dayString);
        if (null != this.reportParam.getGroup()) {
            List<Map> group = this.getSortGroup();
            Map groupMap = group.get(i);
            int beginDay = Integer.parseInt(String.valueOf(groupMap.get("beginDay")));
            int endDay = 0;
            if (null != groupMap.get("endDay")) {
                endDay = Integer.parseInt(String.valueOf(groupMap.get("endDay")));
                currentTime = DateUtil.addDays((Date)currentTime, (int)(endDay - beginDay + 1));
                currentTime = DateUtil.addDays((Date)currentTime, (int)-1);
                aftermon = Integer.valueOf(month.format(currentTime)).toString();
                afterday = Integer.valueOf(day.format(currentTime)).toString();
                strBuilder.append('-');
                strBuilder.append(aftermon).append('.').append(afterday);
            } else {
                strBuilder.append('-');
                strBuilder.append('~');
            }
        } else {
            if ("2".equals(dateType)) {
                currentTime = DateUtil.addWeek((Date)currentTime, (int)1);
                currentTime = DateUtil.addDays((Date)currentTime, (int)-1);
                aftermon = Integer.valueOf(month.format(currentTime)).toString();
                afterday = Integer.valueOf(day.format(currentTime)).toString();
            }
            if ("3".equals(dateType)) {
                currentTime = DateUtil.addMonth((Date)currentTime, (int)1);
                currentTime = DateUtil.addDays((Date)currentTime, (int)-1);
                aftermon = Integer.valueOf(month.format(currentTime)).toString();
                afterday = Integer.valueOf(day.format(currentTime)).toString();
            }
            if ("2".equals(dateType) || "3".equals(dateType)) {
                strBuilder.append('-');
                if (!isLast.booleanValue()) {
                    strBuilder.append(aftermon).append('.').append(afterday);
                } else {
                    strBuilder.append('~');
                }
            }
            if ("1".equals(dateType) && isLast.booleanValue()) {
                strBuilder.append('-');
                strBuilder.append('~');
            }
        }
        return strBuilder.toString();
    }

    public void setupCtx(ReportDataCtx ctx) {
        Map params = ctx.getParams();
        this.reportParam = (PurDeliveryRptParam)params.get("param");
        ctx.setFixedFs(this.getFixedFilter());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("promisedate");
        repoColFilter.add("deliverydate");
        repoColFilter.add("promiseqty");
        repoColFilter.add("qty");
        repoColFilter.add("promisestatus");
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        if (this.reportParam.getOrgs().size() > 0) {
            fs.add(new QFilter("purorg", "in", this.reportParam.getOrgs()));
        }
        if (this.reportParam.getMulmaterials().size() > 0) {
            fs.add(new QFilter("material", "in", this.reportParam.getMulmaterials()));
        }
        if (this.reportParam.getMulrecorgs().size() > 0) {
            fs.add(new QFilter("recorg", "in", this.reportParam.getMulrecorgs()));
        }
        if (this.reportParam.getMulsuppliers().size() > 0) {
            fs.add(new QFilter("supplier", "in", this.reportParam.getMulsuppliers()));
        }
        if (this.reportParam.getStartdate() != null) {
            fs.add(new QFilter("billdate", ">=", (Object)this.reportParam.getStartdate()));
        }
        if (this.reportParam.getMulpurpersons().size() > 0) {
            fs.add(new QFilter("person", "in", this.reportParam.getMulpurpersons()));
        }
        if (this.reportParam.getBillstatus().equals("2")) {
            fs.add(new QFilter("billstatus", "=", (Object)"A"));
        }
        if (this.reportParam.getBillstatus().equals("3")) {
            fs.add(new QFilter("billstatus", "=", (Object)"B"));
        }
        if (this.reportParam.getBillstatus().equals("4")) {
            fs.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        if (this.reportParam.getEntrystatus().equals("2")) {
            fs.add(new QFilter("entrystatus", "=", (Object)"A"));
        }
        if (this.reportParam.getEntrystatus().equals("3")) {
            fs.add(new QFilter("entrystatus", "=", (Object)"B"));
        }
        fs.add(QFilter.isNotNull((String)"material"));
        return fs;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurDeliveryRptCols(this.reportParam, ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurDeliverySumRptCols(this.reportParam, ctx));
    }
}

