/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.deliveryrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.common.util.DateUtil;
import kd.scm.pur.report.deliveryrate.PurOrderDeliveryParam;
import kd.scm.pur.report.deliveryrate.trans.PurDeliverQtyTransform;
import kd.scm.pur.report.deliveryrate.trans.PurDeliverRateTransform;

public class PurOrderDeliveryHandle
implements IReportDataHandle {
    private PurOrderDeliveryParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (PurOrderDeliveryParam)ctx.getParam(PurOrderDeliveryParam.class.getName());
        this.setPageFs(ctx);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurDeliverQtyTransform(ctx, this.reportParam));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurDeliverRateTransform());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("poentryid");
        repoColFilter.add("entrydelidate");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if ("orderqty".equals(field) || "ontimeqty".equals(field) || "delayqty".equals(field)) {
                reportCol.setHyperlink(true);
            }
            if (!"basicunit".equals(field)) continue;
            reportCol.setHide(true);
        }
        return columns;
    }

    private void setPageFs(ReportDataCtx ctx) {
        ArrayList<QFilter> pageFs = ctx.getPageFs();
        if (pageFs == null) {
            pageFs = new ArrayList<QFilter>();
            ctx.setPageFs(pageFs);
        }
        pageFs.addAll(this.getPageFilter());
    }

    private List<QFilter> getPageFilter() {
        String billsattus;
        List<Long> matIds;
        List<Long> billids;
        Date endDate;
        Date startDate;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", this.reportParam.getOrgs()));
        qFilters.add(new QFilter("poentryid", "!=", (Object)"0"));
        List<Long> spIds = this.reportParam.getSpIds();
        if (spIds != null && !spIds.isEmpty()) {
            qFilters.add(new QFilter("supplier", "in", spIds));
        }
        if ((startDate = this.reportParam.getStartdate()) != null) {
            qFilters.add(new QFilter("entrydelidate", ">=", (Object)startDate));
        }
        if ((endDate = this.reportParam.getEnddate()) != null) {
            qFilters.add(new QFilter("entrydelidate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if ((billids = this.reportParam.getBillIds()) != null && !billids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", billids));
        }
        if ((matIds = this.reportParam.getMatIds()) != null && !matIds.isEmpty()) {
            qFilters.add(new QFilter("material", "in", matIds));
        }
        if (StringUtils.isEmpty((CharSequence)(billsattus = this.reportParam.getBillstatus())) || "A".equals(billsattus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.add(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.add(new QFilter("billstatus", "=", (Object)billsattus));
        }
        return qFilters;
    }
}

