/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.isc.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.eip.helper.PurOrderHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.business.erp.IPurOrderQtyService;
import kd.scm.pur.business.erp.OrderQtyServiceFactory;

public class PurOrderSaveUtil
extends PurOrderHelper {
    private static Log log = LogFactory.getLog(PurOrderSaveUtil.class);
    private static String ENTITY_KEY = "pur_order";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    public void handleBeforeExecute(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            ArrayList<DynamicObject> dynsList = new ArrayList<DynamicObject>();
            for (DynamicObject dyn : dyns) {
                if (BillStatusEnum.CLOSED.getVal().equals(dyn.getString("billstatus"))) continue;
                dynsList.add(dyn);
            }
            if (dynsList.size() != dyns.length) {
                for (DynamicObject dyn : dyns) {
                    if (null == dyn.get("logstatus") || dyn.getString("logstatus").isEmpty()) {
                        dyn.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
                        continue;
                    }
                    dyn.set("logstatus", (Object)LogisticsStatusEnum.ALLINSTOCK.getVal());
                    dyn.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
                }
                OrderUtil.updateOrderCfmStatus((DynamicObject[])dyns, (boolean)true);
                return;
            }
            HashMap<String, Map<String, Object>> headDataMap = new HashMap<String, Map<String, Object>>((int)((double)dyns.length / 0.75));
            HashMap<String, Map<String, Object>> entryDataMap = new HashMap<String, Map<String, Object>>();
            DynamicObjectCollection entryCol = null;
            for (DynamicObject dyn : dynsList) {
                String number = dyn.getString("billno").toLowerCase();
                headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
                }
            }
            this.beforeAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
            this.afterAddEntityTransaction(Arrays.asList(dyns), headDataMap, entryDataMap);
        }
    }

    public void handleAfterExecute(DynamicObject[] dyns, boolean erpFlag, boolean easConfig, boolean xkConfig) {
        if (erpFlag) {
            ArrayList<Object> newPKs = new ArrayList<Object>();
            boolean isnewversion = MalOrderParamUtil.getDefaultMalVersion();
            String bizFlowParam = MalOrderParamUtil.getBizFlowParam();
            String jointSystemType = PurJointChannelHelper.getJointSystemType(dyns);
            IPurOrderQtyService qtyService = OrderQtyServiceFactory.getJointOrderQtyService(jointSystemType, "pur_order");
            for (DynamicObject dyn : dyns) {
                boolean source;
                try {
                    dyn.set("modifier", (Object)dyn.getDynamicObject("creator"));
                }
                catch (Exception e2) {
                    dyn.set("modifier", (Object)dyn.getLong("creator"));
                    log.error((Throwable)e2);
                }
                String srcType = dyn.getString("srctype");
                DynamicObjectCollection entryList = dyn.getDynamicObjectCollection(this.getEntryKey());
                if (entryList != null && !entryList.isEmpty()) {
                    qtyService.qtyCalculate(entryList);
                }
                if (!easConfig) continue;
                boolean bl = source = StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal(), (CharSequence)srcType) || StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal(), (CharSequence)srcType);
                if (!StringUtils.equalsIgnoreCase((CharSequence)bizFlowParam, (CharSequence)"3") && !isnewversion || !source) continue;
                dyn.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
                newPKs.add(dyn.getPkValue());
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyns);
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_order", (DynamicObject[])dyns, (OperateOption)option);
            if (newPKs.size() > 0) {
                List successPkIds;
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pur_order", (Object[])newPKs.toArray(), (OperateOption)option);
                if (!auditResult.isSuccess()) {
                    log.info("@@@kd.scm.pur.opplugin.PurOrderDefaultOp\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                }
                if (!CollectionUtils.isEmpty((Collection)(successPkIds = auditResult.getSuccessPkIds()))) {
                    HashMap<Long, Long> idAuditorMap = new HashMap<Long, Long>(dyns.length);
                    for (DynamicObject dyn : dyns) {
                        idAuditorMap.put(dyn.getLong("id"), dyn.getLong("auditor_id"));
                    }
                    this.updateMalOrderAuditor(successPkIds, idAuditorMap);
                }
            }
        }
    }

    public void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
    }

    public void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
    }

    private void updateMalOrderAuditor(List<Object> successPkIds, Map<Long, Long> idAuditorMap) {
        log.info("idAuditorMap:" + idAuditorMap);
        QFilter qFilter = new QFilter("id", "in", successPkIds);
        qFilter.and(QFilter.of((String)" creator != auditor ", (Object[])new Object[0]));
        DynamicObject[] dynList = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,creator,auditor", (QFilter[])qFilter.toArray());
        if (dynList != null && dynList.length > 0) {
            for (DynamicObject dyn : dynList) {
                dyn.set("auditor_id", (Object)idAuditorMap.get(dyn.getLong("id")));
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynList);
        }
    }

    private void setPropValue(DynamicObject entrydyo, BigDecimal qty, String propName, String basePropName) {
        if (StringUtils.isNotEmpty((CharSequence)propName)) {
            entrydyo.set(propName, (Object)qty);
        }
        if (StringUtils.isNotEmpty((CharSequence)basePropName)) {
            entrydyo.set(basePropName, (Object)this.getSaloutQty(entrydyo, qty));
        }
    }

    private BigDecimal getSaloutQty(DynamicObject entrydyo, BigDecimal qty) {
        DynamicObject materialObj = entrydyo.getDynamicObject("material");
        DynamicObject unitObj = entrydyo.getDynamicObject("unit");
        DynamicObject basicUnitObj = entrydyo.getDynamicObject("basicunit");
        return CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)qty, (DynamicObject)basicUnitObj);
    }
}

