/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.SRMBillEntityTypeHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;
import kd.scm.sccore.business.SalOutStockAvailableBasicQtyHelper;

public final class PurAvailableStockBasicQtyHelper {
    private static final Log log = LogFactory.getLog(PurAvailableStockBasicQtyHelper.class);

    public static List<DynamicObject> queryOrderData(Collection<Long> orderEntryIds, Map<String, String> customParamMap) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        properties.add("qty");
        String entityFields = SRMBillEntityTypeHelper.getEntityFields((String)"pur_order", (Collection)properties);
        QFilter filter = new QFilter("materialentry.id", "in", orderEntryIds);
        return OrderAvailableStockQtyHelper.queryOrderData((QFilter)filter, (String)entityFields, null, customParamMap);
    }

    public static List<DynamicObject> queryOrderDataCoreEntryIds(Collection<String> coreEntryIds, Map<String, String> customParamMap) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        properties.add("qty");
        String valueProperty = customParamMap.getOrDefault("valueproperty", "relateoutstockbaseqty");
        properties.add(valueProperty);
        String entityFields = SRMBillEntityTypeHelper.getEntityFields((String)"pur_order", (Collection)properties);
        QFilter filter = new QFilter("materialentry.poentryid", "in", coreEntryIds);
        return OrderAvailableStockQtyHelper.queryOrderData((QFilter)filter, (String)entityFields, null, customParamMap);
    }

    public static Map<Long, Map<String, BigDecimal>> assembleOrderAvailableBasicQty(Collection<Long> orderEntryIds, Map<String, String> customParamMap) {
        if (orderEntryIds == null || orderEntryIds.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:orderEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyHelper_0", (String)"scm-pur-business", (Object[])new Object[0]));
        }
        List<DynamicObject> orderData = PurAvailableStockBasicQtyHelper.queryOrderData(orderEntryIds, customParamMap);
        Map orderAvailableBasicQty = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicCustomQty(orderData, customParamMap);
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        for (DynamicObject order : orderData) {
            materialIds.add(order.getLong("material"));
            unitIds.add(order.getLong("unit"));
            unitIds.add(order.getLong("basicunit"));
        }
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        HashMap<String, BigDecimal> rowMap = null;
        HashMap<Long, Map<String, BigDecimal>> orderAvailableDataMap = new HashMap<Long, Map<String, BigDecimal>>(1024);
        BigDecimal convQty = BigDecimal.ZERO;
        BigDecimal convBasicQty = BigDecimal.ZERO;
        for (DynamicObject order : orderData) {
            Long entryId = order.getLong("orderentryid");
            BigDecimal orderBasicQty = (BigDecimal)orderAvailableBasicQty.get(entryId);
            BigDecimal qty = order.getBigDecimal("qty");
            BigDecimal basicQty = order.getBigDecimal("basicqty");
            Object material = order.get("material");
            Object unit = order.get("unit");
            Object basicunit = order.get("basicunit");
            if (material.equals(0L)) {
                convQty = orderBasicQty;
                convBasicQty = orderBasicQty;
            }
            if (unit.equals(basicunit)) {
                convQty = orderBasicQty;
                convBasicQty = orderBasicQty;
            } else {
                convBasicQty = orderBasicQty;
                convQty = CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)), (BigDecimal)orderBasicQty, (DynamicObject)((DynamicObject)measureunitsCache.get(unit)));
                if (convQty == null || convQty.compareTo(BigDecimal.ZERO) == 0) {
                    if (orderBasicQty.compareTo(basicQty) == 0) {
                        convQty = qty;
                        convBasicQty = basicQty;
                    } else {
                        throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u7531\u4e8e\u5f53\u524d\u8f6c\u6362\u7684\u5355\u636e\u884c\u4e2d\u7269\u6599\u4e0d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\uff0c\u65e0\u6cd5\u652f\u6301\u90e8\u5206\u4e0b\u63a8\u4e1a\u52a1\u3002", (String)"PurAvailableStockBasicQtyHelper_1", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
                    }
                }
            }
            rowMap = new HashMap<String, BigDecimal>(2);
            rowMap.put("basicqty", convBasicQty);
            rowMap.put("qty", convQty);
            orderAvailableDataMap.put(entryId, rowMap);
        }
        materialCaches.clear();
        measureunitsCache.clear();
        materialIds.clear();
        unitIds.clear();
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#getOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString(orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }

    public static Map<String, BigDecimal> assembleOrderVerifyBasicQty(Map<String, BigDecimal> coreEntryIdBasicQtyMap, Map<String, String> customParamMap) {
        if (coreEntryIdBasicQtyMap == null || coreEntryIdBasicQtyMap.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:orderEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyHelper_0", (String)"scm-pur-business", (Object[])new Object[0]));
        }
        String valueProperty = customParamMap.getOrDefault("valueproperty", "relateoutstockbaseqty");
        List<DynamicObject> orderData = PurAvailableStockBasicQtyHelper.queryOrderDataCoreEntryIds(coreEntryIdBasicQtyMap.keySet(), customParamMap);
        Map orderAvailableBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicQty(orderData);
        Map orderBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderBasicQty(orderData, customParamMap);
        HashMap<String, BigDecimal> orderAvailableDataMap = new HashMap<String, BigDecimal>(1024);
        for (DynamicObject order : orderData) {
            BigDecimal orderBasicQty;
            BigDecimal availableValueBasicQty;
            String poentryid = order.getString("poentryid");
            Long entryId = order.getLong("orderentryid");
            BigDecimal coreSumBasicQty = coreEntryIdBasicQtyMap.get(poentryid);
            BigDecimal valuePropertyBasicQty = order.getBigDecimal(valueProperty);
            BigDecimal orderAvailableBasicQty = orderAvailableBasicQtyMap.getOrDefault(poentryid, BigDecimal.ZERO);
            orderAvailableDataMap.put(poentryid, orderAvailableBasicQty.compareTo(availableValueBasicQty = (orderBasicQty = orderBasicQtyMap.getOrDefault(entryId, BigDecimal.ZERO)).subtract(valuePropertyBasicQty).add(coreSumBasicQty)) <= 0 ? orderAvailableBasicQty : availableValueBasicQty);
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#getOrderStockBasicQty#rowMap:{}", (Object)SerializationUtils.toJsonString(orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }

    private static Map<String, BigDecimal> assembleErpStockBasicQty(List<DynamicObject> orders, Map<String, String> customParamMap) {
        Map messageMap = OrderAvailableStockQtyHelper.getErpStockBasicQty((String)"manualqueryorderavailableqty", orders, customParamMap);
        HashMap<String, BigDecimal> erpOrderQtyMap = new HashMap<String, BigDecimal>(1024);
        if (!messageMap.isEmpty()) {
            for (Map.Entry entry : messageMap.entrySet()) {
                BigDecimal receiveBaseQtySum;
                String entryKey = (String)entry.getKey();
                Map entryValue = (Map)entry.getValue();
                BigDecimal inBaseQtySum = (BigDecimal)entryValue.get("inBaseQtySum");
                BigDecimal maxErpStockBasicQty = inBaseQtySum.compareTo(receiveBaseQtySum = (BigDecimal)entryValue.get("receiveBaseQtySum")) >= 0 ? inBaseQtySum : receiveBaseQtySum;
                erpOrderQtyMap.put(entryKey, maxErpStockBasicQty);
            }
        }
        return erpOrderQtyMap;
    }

    public static Map<String, Map<String, BigDecimal>> assembleSalOutStcokAvailableBasicQty(List<DynamicObject> salOutStocks, Map<String, String> customParamMap) {
        return SalOutStockAvailableBasicQtyHelper.assmibleSalOutStockAvailableBasicQty(salOutStocks, customParamMap);
    }

    public static Map<String, BigDecimal> queryMaxOrderStockBasicQty(Collection<String> erpOrderEntryIds, Map<String, String> customParamsMap) {
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#queryMaxOrderStockBasicQty#erpOrderEntryIds:{}", (Object)SerializationUtils.toJsonString(erpOrderEntryIds));
        }
        String sourceJointChannelId = customParamsMap.getOrDefault("sourceJointChannelId", SystemJointChannelHelper.getDefaultJointChannelId());
        QFilter qFilter = new QFilter("materialentry.poentryid", "in", erpOrderEntryIds);
        qFilter.and(new QFilter("materialentry.jointdatachannelid", "=", (Object)sourceJointChannelId));
        String warehouseAssistDataString = customParamsMap.get("warehouseAssistData");
        if (warehouseAssistDataString != null && !warehouseAssistDataString.isEmpty()) {
            Map warehouseAssistData = (Map)SerializationUtils.fromJsonString((String)warehouseAssistDataString, Map.class);
            HashSet wareHouseIds = new HashSet(1024);
            for (Map.Entry entry : warehouseAssistData.entrySet()) {
                Collection entryValue = (Collection)entry.getValue();
                if (entryValue == null || entryValue.isEmpty()) continue;
                wareHouseIds.addAll(entryValue);
            }
            if (!wareHouseIds.isEmpty()) {
                qFilter.and(new QFilter("materialentry.warehouse.id", "in", wareHouseIds));
            }
        }
        HashMap<String, BigDecimal> orderBasicQtyMap = new HashMap<String, BigDecimal>(1024);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"getPoEntryIdBasicQtyMap", (String)"pur_saloutstock", (String)"materialentry.material material,materialentry.basicunit basicunit,materialentry.unit unit,materialentry.qty qty,materialentry.basicqty basicqty,materialentry.entrystatus entrystatus, materialentry.sumreceiptqty sumreceiptqty,materialentry.suminstockqty suminstockqty,materialentry.poentryid poentryid,materialentry.sumreceiptbaseqty sumreceiptbaseqty,materialentry.suminstockbaseqty suminstockbaseqty", (QFilter[])new QFilter[]{qFilter}, (String)"id");
        DataSet dataSet = queryDataSet.copy();
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        while (queryDataSet.hasNext()) {
            Row row = queryDataSet.next();
            materialIds.add(row.getLong("material"));
            unitIds.add(row.getLong("unit"));
            unitIds.add(row.getLong("basicunit"));
        }
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String poEntryId = row.getString("poentryid");
            BigDecimal basicQty = row.getBigDecimal("basicqty");
            BigDecimal qty = row.getBigDecimal("qty");
            String entrystatus = row.getString("entrystatus");
            Object material = row.get("material");
            Object unit = row.get("unit");
            Object basicunit = row.get("basicunit");
            BigDecimal suminstockqty = row.getBigDecimal("suminstockqty");
            BigDecimal suminstockbaseqty = BigDecimal.ZERO;
            if (suminstockqty.compareTo(BigDecimal.ZERO) > 0) {
                suminstockbaseqty = suminstockbaseqty.compareTo(BigDecimal.ZERO) == 0 ? (unit.equals(basicunit) ? row.getBigDecimal("suminstockbaseqty") : CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(unit)), (BigDecimal)suminstockqty, (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)))) : row.getBigDecimal("suminstockbaseqty");
            }
            BigDecimal sumreceiptqty = row.getBigDecimal("sumreceiptqty");
            BigDecimal sumreceiptBasicqty = row.getBigDecimal("sumreceiptbaseqty");
            if (sumreceiptqty.compareTo(BigDecimal.ZERO) > 0) {
                sumreceiptBasicqty = sumreceiptBasicqty.compareTo(BigDecimal.ZERO) == 0 ? (unit.equals(basicunit) ? row.getBigDecimal("sumreceiptbaseqty") : CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(unit)), (BigDecimal)sumreceiptqty, (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)))) : row.getBigDecimal("sumreceiptbaseqty");
            }
            BigDecimal maxStockBasicQty = null;
            BigDecimal orderBasicQty = (BigDecimal)orderBasicQtyMap.get(poEntryId);
            if (orderBasicQty == null) {
                orderBasicQty = BigDecimal.ZERO;
            }
            maxStockBasicQty = suminstockqty.compareTo(sumreceiptqty) >= 0 ? suminstockbaseqty : sumreceiptBasicqty;
            if ("B".equals(entrystatus)) {
                orderBasicQty = orderBasicQty.add(maxStockBasicQty);
            } else if ("A".equals(entrystatus)) {
                orderBasicQty = orderBasicQty.add(basicQty);
            }
            orderBasicQtyMap.put(poEntryId, orderBasicQty);
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#queryMaxOrderStockBasicQty#orderBasicQtyMap:{}", (Object)SerializationUtils.toJsonString(orderBasicQtyMap));
        }
        return orderBasicQtyMap;
    }

    public static Map<Long, BigDecimal> querySalOutStockBasicQty(Collection<Long> salOutEntryIds, Map<String, String> customParamsMap) {
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#queryStockBasicQty:{}", (Object)SerializationUtils.toJsonString(salOutEntryIds));
        }
        String sourceJointChannelId = customParamsMap.getOrDefault("sourceJointChannelId", SystemJointChannelHelper.getDefaultJointChannelId());
        HashMap<Long, BigDecimal> salOutBasicQtyMap = new HashMap<Long, BigDecimal>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PurAvailableStockBasicQtyHelper.class.getName(), (String)"pur_saloutstock", (String)"materialentry.id entryid,materialentry.basicqty basicqty,materialentry.entrystatus entrystatus,materialentry.sumreceiptqty sumreceiptqty,materialentry.suminstockqty suminstockqty", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", salOutEntryIds)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                String entrystatus = row2.getString("entrystatus");
                BigDecimal sumreceiptqty = row2.getBigDecimal("sumreceiptqty");
                BigDecimal suminstockqty = row2.getBigDecimal("suminstockqty");
                salOutBasicQtyMap.put(row2.getLong("entryid"), row2.getBigDecimal("basicqty"));
            }
        }
        if (salOutBasicQtyMap.size() < salOutEntryIds.size()) {
            salOutEntryIds.forEach(row -> {
                if (!salOutBasicQtyMap.containsKey(row)) {
                    salOutBasicQtyMap.put((Long)row, BigDecimal.ZERO);
                }
            });
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#salOutBasicQtyMap:{}", (Object)SerializationUtils.toJsonString(salOutBasicQtyMap));
        }
        return salOutBasicQtyMap;
    }

    public static Collection<String> getTargetWriteBasicProperty(String targetEntity, String qtyValueDim) {
        String writeBasicQtyProperty;
        HashSet<String> linkCoreValueKeys = new HashSet<String>(16);
        String string = writeBasicQtyProperty = "basicqty".equals(qtyValueDim) ? OrderAvailableStockQtyHelper.getTargetWriteBasicQtyProperty((String)targetEntity) : "";
        if (!writeBasicQtyProperty.isEmpty()) {
            linkCoreValueKeys.add(writeBasicQtyProperty);
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#getTargetWriteBasicProperty#linkCoreValueKeys:{}", (Object)SerializationUtils.toJsonString(linkCoreValueKeys));
        }
        return linkCoreValueKeys;
    }

    public static Map<String, Collection<String>> getValidatorAvailableOperate(String entityNumber) {
        HashMap<String, Collection<String>> linkCoreValueKeys = new HashMap<String, Collection<String>>(2);
        HashSet<String> operateTypeSet = new HashSet<String>(10);
        operateTypeSet.add("submit");
        operateTypeSet.add("submitandnew");
        HashSet<String> operateNumberSet = new HashSet<String>(10);
        operateNumberSet.add("confirmpromise");
        linkCoreValueKeys.put("operateType", operateTypeSet);
        linkCoreValueKeys.put("operateNumber", operateNumberSet);
        return linkCoreValueKeys;
    }

    public static Collection<String> getAvailableQtyField(String entityNumber, String qtyValueDim) {
        HashSet<String> availableQtyFields = new HashSet<String>(2);
        availableQtyFields.add("basicqty");
        switch (entityNumber) {
            case "pur_deliveryschedule": 
            case "scp_scheduledelivery": {
                availableQtyFields.add("promisebasicqty");
            }
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#getAvailableQtyField#availableQtyFields:{}", (Object)SerializationUtils.toJsonString(availableQtyFields));
        }
        return availableQtyFields;
    }
}

