/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.pur.common.domain.WriteOffQtyRow;

public final class PurReplenishReqHelper {
    public static void updateErpOrderQty(DynamicObject[] dynamicObjects, Map<Long, WriteOffQtyRow> writeOffQtyRowMap) {
        DynamicProperty qtyPro = null;
        DynamicProperty basicQtyPro = null;
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectType rowsDynamicObjectType = rows.getDynamicObjectType();
            qtyPro = rowsDynamicObjectType.getProperty("orderedqty");
            basicQtyPro = rowsDynamicObjectType.getProperty("orderedbaseqty");
            for (DynamicObject row : rows) {
                Long entryId = row.getLong("id");
                WriteOffQtyRow writeOffQtyRow = writeOffQtyRowMap.get(entryId);
                if (writeOffQtyRow == null) continue;
                if (qtyPro != null) {
                    qtyPro.setValue((Object)row, (Object)writeOffQtyRow.getQtyValue());
                }
                if (basicQtyPro == null) continue;
                basicQtyPro.setValue((Object)row, (Object)writeOffQtyRow.getBasicQtyValue());
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
    }

    public static void clearErpOrderNumber(DynamicObject[] dynamicObjects, Map<Long, WriteOffQtyRow> writeOffQtyRowMap) {
        DynamicProperty orderNum = null;
        for (DynamicObject bill : dynamicObjects) {
            bill.set("orderstatus", (Object)"A");
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectType rowsDynamicObjectType = rows.getDynamicObjectType();
            orderNum = rowsDynamicObjectType.getProperty("ordernum");
            for (DynamicObject row : rows) {
                Long entryId = row.getLong("id");
                WriteOffQtyRow writeOffQtyRow = writeOffQtyRowMap.get(entryId);
                if (writeOffQtyRow == null || orderNum == null) continue;
                orderNum.setValue((Object)row, null);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
    }
}

