/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.changemodel.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PriceProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class ChangeMicroservicesHelp {
    private static final Log log = LogFactory.getLog(ChangeMicroservicesHelp.class);

    public static void executeChangeOperate(Map<Long, Long> purIdToOmIdMap, Map<Long, List<Map<String, Object>>> omXOrders) {
        if (ChangeMicroservicesHelp.isNullOrEmpty(purIdToOmIdMap) || ChangeMicroservicesHelp.isNullOrEmpty(omXOrders)) {
            return;
        }
        Object[] purOrderIds = purIdToOmIdMap.keySet().toArray(new Long[0]);
        try (TXHandle txHandle = TX.required((String)"scm_pur_ChangeMicroservicesHelp");){
            OperationResult changeResult = OperationServiceHelper.executeOperate((String)"bizchange", (String)"pur_order", (Object[])purOrderIds, (OperateOption)ChangeMicroservicesHelp.getOption());
            if (!changeResult.isSuccess()) {
                throw new KDBizException(changeResult.getMessage());
            }
            List successPurOrderIds = changeResult.getSuccessPkIds();
            DynamicObject[] xOrders = ChangeMicroservicesHelp.queryGeneratedOrders(successPurOrderIds);
            if (xOrders == null || xOrders.length == 0) {
                throw new KDBizException("The change order generated by the change operation does not exist.");
            }
            ChangeMicroservicesHelp.changeFieldHandle(omXOrders, xOrders, purIdToOmIdMap);
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pur_xorder", (DynamicObject[])xOrders, (OperateOption)ChangeMicroservicesHelp.getOption());
            if (!saveResult.isSuccess()) {
                throw new KDBizException("Save change order error: " + saveResult.getMessage());
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            throw new KDBizException(exception.getMessage());
        }
    }

    private static OperateOption getOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        return option;
    }

    private static DynamicObject[] queryGeneratedOrders(List<Object> purOrderIds) {
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)"pur_xorder").getDynamicObjectType();
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"pur_xorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", purOrderIds), new QFilter("changestatus", "=", (Object)BizChangeStatusEnum.UNCHANGE.getValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal())});
        Object[] idsArray = ids.stream().map(id -> id.getLong("id")).toArray();
        return BusinessDataServiceHelper.load((Object[])idsArray, (DynamicObjectType)type);
    }

    private static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    private static void changeFieldHandle(Map<Long, List<Map<String, Object>>> omXOrders, DynamicObject[] xOrders, Map<Long, Long> purIdToOmIdMap) {
        for (DynamicObject xOrder : xOrders) {
            Long purOrderId;
            Long omOrderId;
            List<Map<String, Object>> entryLines;
            if (xOrder == null || (entryLines = omXOrders.get(omOrderId = purIdToOmIdMap.get(purOrderId = Long.valueOf(xOrder.getLong("sourcebillid"))))) == null || entryLines.isEmpty()) continue;
            Map<String, Object> omXOrder = entryLines.get(0);
            xOrder.set("changereason", omXOrder.get("reason"));
            if ("D".equals(omXOrder.get("confirmstatus"))) {
                xOrder.set("cfmstatus", (Object)"B");
            } else {
                xOrder.set("cfmstatus", (Object)Character.valueOf('A'));
            }
            Map<String, String> botpMapping = ChangeMicroservicesHelp.buildOmToPurFiledMap();
            ChangeMicroservicesHelp.changeHeadField(xOrder, omXOrder, botpMapping);
            ChangeMicroservicesHelp.changeEntryField(xOrder, entryLines, botpMapping);
        }
    }

    private static void changeEntryField(DynamicObject xOrder, List<Map<String, Object>> omXOrder, Map<String, String> botpMapping) {
        DynamicObjectCollection xOrderEntries = xOrder.getDynamicObjectCollection("materialentry");
        DataEntityPropertyCollection entryProperties = xOrderEntries.getDynamicObjectType().getProperties();
        Map<Long, DynamicObject> poEntryIdToXEntryMap = ChangeMicroservicesHelp.buildField2EntryMap(xOrder);
        String[] changeProperties = ChangeModelHelper.getEnableProperty((IDataEntityType)xOrder.getDataEntityType(), (String)"materialentry");
        for (Map<String, Object> omXEntryLine : omXOrder) {
            DynamicObject xOrderEntry;
            Long entryId = (Long)omXEntryLine.get("billentry.sourceentryid");
            if (entryId == null || (xOrderEntry = poEntryIdToXEntryMap.get(entryId)) == null) continue;
            for (String purFieldName : changeProperties) {
                BigDecimal omXPrice;
                String omXFieldName = botpMapping.get(purFieldName);
                if (StringUtils.isEmpty((CharSequence)omXFieldName)) continue;
                IDataEntityProperty propertyType = (IDataEntityProperty)entryProperties.get((Object)purFieldName);
                if ("price".equals(purFieldName) && propertyType instanceof PriceProp && (omXPrice = (BigDecimal)omXEntryLine.get("billentry." + omXFieldName)) != null) {
                    int omXScale = omXPrice.scale();
                    PriceProp priceProp = (PriceProp)propertyType;
                    priceProp.setScale(omXScale);
                }
                if (propertyType.getParent() != null && propertyType.getParent() instanceof FlexEntityType) continue;
                xOrderEntry.set(purFieldName, omXEntryLine.get("billentry." + omXFieldName));
            }
        }
    }

    private static void changeHeadField(DynamicObject xOrder, Map<String, Object> omXOrder, Map<String, String> botpMapping) {
        String[] changeProperties = ChangeModelHelper.getEnableProperty((IDataEntityType)xOrder.getDataEntityType());
        if (changeProperties == null || changeProperties.length == 0) {
            return;
        }
        DataEntityPropertyCollection propertyTypes = xOrder.getDynamicObjectType().getProperties();
        DynamicObject person = ChangeMicroservicesHelp.handleOperatorField(omXOrder);
        for (String purFieldName : changeProperties) {
            IDataEntityProperty propertyType;
            String omXFieldName = botpMapping.get(purFieldName);
            if ("person".equals(purFieldName)) {
                xOrder.set("person", (Object)person);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)omXFieldName) || (propertyType = (IDataEntityProperty)propertyTypes.get((Object)purFieldName)) == null || propertyType.getParent() != null && propertyType.getParent() instanceof FlexEntityType) continue;
            xOrder.set(purFieldName, omXOrder.get(omXFieldName));
        }
    }

    private static DynamicObject handleOperatorField(Map<String, Object> omXOrder) {
        Object operatorIdObj = omXOrder.get("operator");
        if (!(operatorIdObj instanceof Long) || ((Long)operatorIdObj).equals(0L)) {
            return null;
        }
        Long operatorId = (Long)operatorIdObj;
        QFilter filter = new QFilter("person", "=", (Object)operatorId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pur_bizperson", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, String> buildOmToPurFiledMap() {
        ConvertRuleReader reader = new ConvertRuleReader();
        List convertRuleElements = reader.loadRules("pm_om_purorderbill", "pur_order");
        if (convertRuleElements == null || convertRuleElements.isEmpty()) {
            return Collections.emptyMap();
        }
        List fieldMapItems = ((ConvertRuleElement)convertRuleElements.get(0)).getFieldMapPolicy().getFieldMaps();
        HashMap<String, String> botpMapping = new HashMap<String, String>(fieldMapItems.size());
        for (FieldMapItem fieldMapItem : fieldMapItems) {
            String sourceFieldKey = fieldMapItem.getSourceFieldKey();
            String targetFieldKey = fieldMapItem.getTargetFieldKey();
            if (StringUtils.isBlank((CharSequence)sourceFieldKey) || StringUtils.isBlank((CharSequence)targetFieldKey)) continue;
            botpMapping.put(targetFieldKey, sourceFieldKey);
        }
        return botpMapping;
    }

    private static Map<Long, DynamicObject> buildField2EntryMap(DynamicObject bill) {
        if (bill == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> fieldToEntry = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("materialentry");
        for (DynamicObject entryLine : entries) {
            Long field = entryLine.getLong("poentryid");
            fieldToEntry.put(field, entryLine);
        }
        return fieldToEntry;
    }

    public static Object[] queryMaxVersionPurXOrder(List<String> omIds) {
        DynamicObjectCollection purIdCollection = QueryServiceHelper.query((String)"pur_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", omIds)});
        List purOrderIds = purIdCollection.stream().map(id -> id.get("id")).collect(Collectors.toList());
        DynamicObjectCollection purXOrderIdCollection = QueryServiceHelper.query((String)"pur_xorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", purOrderIds), new QFilter("changestatus", "!=", (Object)"D")});
        Object[] purXOrderIds = purXOrderIdCollection.stream().map(id -> id.get("id")).toArray();
        DynamicObjectType purXOrderType = BusinessDataServiceHelper.newDynamicObject((String)"pur_xorder").getDynamicObjectType();
        DynamicObject[] purXOrders = BusinessDataServiceHelper.load((Object[])purXOrderIds, (DynamicObjectType)purXOrderType);
        return Arrays.stream(purXOrders).collect(Collectors.toMap(o -> o.get("sourcebillid"), Function.identity(), BinaryOperator.maxBy(Comparator.comparing(o -> Integer.parseInt(o.getString("version")))))).values().stream().map(o -> o.get("id")).toArray();
    }

    public static void restorePurOrderConFirmStatus(List<String> omIds) {
        DynamicObject[] purOrders = BusinessDataServiceHelper.load((String)"pur_order", (String)"logstatus,cfmdate,rejectdate,cfmstatus,changer,changestatus", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", omIds)});
        if (purOrders == null || purOrders.length == 0) {
            log.error("PurOrder status update failed because the corresponding order is empty.");
            throw new KDBizException("PurOrder status update failed because the corresponding order is empty.");
        }
        for (DynamicObject purOrder : purOrders) {
            if (purOrder == null) continue;
            ChangeMicroservicesHelp.updateConfirmationStatus(purOrder);
            ChangeMicroservicesHelp.updateChangeStatus(purOrder);
        }
        SaveServiceHelper.update((DynamicObject[])purOrders);
    }

    public static void updateChangeStatus(DynamicObject purOrder) {
        if (null == purOrder.get("changer")) {
            purOrder.set("changestatus", (Object)"A");
        } else {
            purOrder.set("changestatus", (Object)"C");
        }
    }

    public static void updateConfirmationStatus(DynamicObject purOrder) {
        String logStatus = purOrder.getString("logstatus");
        Object cfmDate = purOrder.get("cfmdate");
        Object rejectDate = purOrder.get("rejectdate");
        if (cfmDate == null) {
            if (rejectDate != null) {
                purOrder.set("cfmstatus", (Object)"C");
            } else if ("D".equals(logStatus) || "E".equals(logStatus) || "F".equals(logStatus) || "G".equals(logStatus)) {
                purOrder.set("cfmstatus", (Object)"E");
            } else {
                purOrder.set("cfmstatus", (Object)"A");
            }
        } else {
            purOrder.set("cfmstatus", (Object)"B");
        }
    }
}

