/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.erp.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pur.business.erp.impl.PurOrderQtyService;

public class PurOrderXkQtyService
extends PurOrderQtyService {
    @Override
    public void qtyCalculate(DynamicObjectCollection entryList) {
        for (DynamicObject entrydyo : entryList) {
            BigDecimal qty = entrydyo.getBigDecimal("qty");
            this.entryQtyCalculate(entrydyo, qty);
        }
    }

    @Override
    protected void entryQtyCalculate(DynamicObject entrydyo, BigDecimal qty) {
        boolean iscontrolqty = entrydyo.getBoolean("iscontrolqty");
        BigDecimal saloutratedown = entrydyo.getBigDecimal("saloutratedown");
        BigDecimal saloutqtydown = entrydyo.getBigDecimal("saloutqtydown");
        BigDecimal saloutrateup = entrydyo.getBigDecimal("saloutrateup");
        BigDecimal saloutqtyup = entrydyo.getBigDecimal("saloutqtyup");
        this.log.info("\u8d85\u53d1\u63a7\u5236\u4f20\u5165\u53c2\u6570:qty=" + qty + ";saloutrateup=" + saloutrateup + ";saloutqtyup=" + saloutqtyup + ";saloutratedown=" + saloutratedown + ";saloutqtydown=" + saloutqtydown);
        if (saloutqtydown == null || saloutqtydown.compareTo(BigDecimal.ZERO) == 0) {
            saloutqtydown = qty;
            this.setQtyPropValue(entrydyo, saloutqtydown, "saloutqtydown", "saloutbaseqtydown");
        }
        if (saloutqtyup == null || saloutqtyup.compareTo(BigDecimal.ZERO) == 0) {
            saloutqtyup = qty;
            this.setQtyPropValue(entrydyo, saloutqtyup, "saloutqtyup", "saloutbaseqtyup");
        }
        if (iscontrolqty) {
            BigDecimal big100 = new BigDecimal("100");
            if (qty.compareTo(saloutqtydown) > 0) {
                saloutratedown = qty.subtract(saloutqtydown).divide(qty, qty.scale() + 2, RoundingMode.HALF_UP).multiply(big100);
                entrydyo.set("saloutratedown", (Object)saloutratedown);
            }
            if (saloutqtyup.compareTo(qty) > 0) {
                saloutrateup = saloutqtyup.subtract(qty).divide(qty, qty.scale() + 2, RoundingMode.HALF_UP).multiply(big100);
                entrydyo.set("saloutrateup", (Object)saloutrateup);
            }
        }
    }
}

