/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;

final class PurSupplierAssignHelper {
    private static final Log log = LogFactory.getLog(PurSupplierAssignHelper.class);

    PurSupplierAssignHelper() {
    }

    Map<Long, Boolean> updateSupplierColl(Map<Long, Boolean> supplierUpdateInfoMap, Map<String, String> customParamMap) {
        Long supplierId;
        Date now;
        Long currencyUserId;
        DynamicObject[] suppliers;
        DynamicObject[] supplierColls;
        HashMap<Long, Boolean> resultMap;
        HashSet<Long> allSupplierIds;
        PurSupplierAssignHelper purSupplierAssignHelper;
        block14: {
            purSupplierAssignHelper = new PurSupplierAssignHelper();
            if (supplierUpdateInfoMap == null || supplierUpdateInfoMap.isEmpty()) {
                throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierUpdateInfoMap\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierAssignHelper_0", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
            }
            if (log.isInfoEnabled()) {
                log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(supplierUpdateInfoMap), (Object)SerializationUtils.toJsonString(customParamMap));
            }
            allSupplierIds = new HashSet<Long>(supplierUpdateInfoMap.keySet());
            resultMap = new HashMap<Long, Boolean>(64);
            QFilter qFilter = new QFilter("supplier.id", "in", allSupplierIds);
            String mainOrgId = customParamMap.get("mainOrgId");
            if (mainOrgId != null) {
                qFilter.and(new QFilter("useorg.id", "=", (Object)Long.parseLong(mainOrgId)));
            }
            supplierColls = BusinessDataServiceHelper.load((String)"pur_suppliercollinfo", (String)"id,supplier,issuppliercoll,modifytime,modifier,enabletime,disabletime", (QFilter[])new QFilter[]{qFilter});
            suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,issuppcolla,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", allSupplierIds)});
            currencyUserId = 1L;
            try {
                currencyUserId = RequestContext.get().getCurrUserId();
            }
            catch (RuntimeException runtimeException) {
                if (!log.isInfoEnabled()) break block14;
                log.warn((Throwable)runtimeException);
            }
        }
        HashSet<Long> insertSupplierIds = new HashSet<Long>(1024);
        if (supplierColls.length == 0) {
            insertSupplierIds.addAll(allSupplierIds);
        }
        ArrayList<DynamicObject> updateDataColl = new ArrayList<DynamicObject>(1024);
        HashSet<Long> updateSupplierIds = new HashSet<Long>(16);
        for (DynamicObject supplier : supplierColls) {
            now = TimeServiceHelper.now();
            supplierId = supplier.getLong("supplier.id");
            updateSupplierIds.add(supplierId);
            boolean isSupplierColl = supplierUpdateInfoMap.get(supplierId);
            if (isSupplierColl) {
                supplier.set("enabletime", (Object)now);
            } else {
                supplier.set("disabletime", (Object)now);
            }
            supplier.set("issuppliercoll", (Object)isSupplierColl);
            supplier.set("modifytime", (Object)now);
            supplier.set("modifier", (Object)currencyUserId);
            updateDataColl.add(supplier);
        }
        for (DynamicObject supplier : suppliers) {
            now = TimeServiceHelper.now();
            supplierId = supplier.getLong("id");
            supplier.set("issuppcolla", (Object)supplierUpdateInfoMap.get(supplierId));
            supplier.set("modifytime", (Object)now);
            supplier.set("modifier", (Object)currencyUserId);
        }
        if (allSupplierIds.size() > updateSupplierIds.size()) {
            allSupplierIds.removeAll(updateSupplierIds);
            insertSupplierIds.addAll(allSupplierIds);
        }
        if (!updateDataColl.isEmpty()) {
            SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])updateDataColl.toArray(new DynamicObject[0]));
        }
        if (!insertSupplierIds.isEmpty()) {
            purSupplierAssignHelper.insertSupplierColl(insertSupplierIds, customParamMap);
        }
        if (suppliers.length > 0) {
            SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])suppliers);
        }
        return resultMap;
    }

    public Map<Long, Boolean> insertSupplierCollByEvent(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierUpdateInfoMap\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierAssignHelper_0", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        QFilter qFilter = new QFilter("id", "in", supplierIds);
        qFilter.and("issuppcolla", "=", (Object)"1");
        DynamicObject[] supplierDataColl = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,name,createorg,useorg,issuppcolla", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        Long currencyUserId = this.getCurrncyUserId();
        String processSource = customParamMap.get(PurSupplierCollInitiateHelper.PROCESSSOURCE);
        ArrayList<DynamicObject> saveDataColl = new ArrayList<DynamicObject>(1024);
        DynamicObject supplierCollData = null;
        for (DynamicObject supplier : supplierDataColl) {
            this.assmablePurSupplierCollInfo(saveDataColl, supplierCollData, currencyUserId, processSource, supplier);
        }
        this.savePurSupplierCollInfo(resultMap, saveDataColl);
        return resultMap;
    }

    private void assmablePurSupplierCollInfo(Collection<DynamicObject> saveDataColl, DynamicObject supplierCollData, Long currencyUserId, String processSource, DynamicObject supplier) {
        Long supplierId = supplier.getLong("id");
        Date now = TimeServiceHelper.now();
        supplierCollData = BusinessDataServiceHelper.newDynamicObject((String)"pur_suppliercollinfo");
        supplierCollData.set("number", (Object)supplier.getString("number"));
        supplierCollData.set("name", (Object)supplier.getString("name"));
        supplierCollData.set("supplier", (Object)supplierId);
        DynamicObject createorg = supplier.getDynamicObject("createorg");
        if (createorg != null) {
            supplierCollData.set("createorg", (Object)createorg.getLong("id"));
            DynamicObject useorg = supplier.getDynamicObject("useorg");
            if (useorg != null) {
                supplierCollData.set("useorg", (Object)useorg.getLong("id"));
            } else {
                supplierCollData.set("useorg", (Object)createorg.getLong("id"));
            }
        }
        supplierCollData.set("issuppliercoll", (Object)Boolean.TRUE);
        supplierCollData.set("processsource", (Object)processSource);
        supplierCollData.set("enabletime", (Object)now);
        supplierCollData.set("creator", (Object)currencyUserId);
        supplierCollData.set("createtime", (Object)now);
        supplierCollData.set("modifytime", (Object)now);
        supplierCollData.set("modifier", (Object)currencyUserId);
        saveDataColl.add(supplierCollData);
    }

    private void savePurSupplierCollInfo(Map<Long, Boolean> resultMap, Collection<DynamicObject> saveDataColl) {
        if (!saveDataColl.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"pur_suppliercollinfo", (DynamicObject[])saveDataColl.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                for (Object object : operationResult.getSuccessPkIds()) {
                    resultMap.put(Long.parseLong(object.toString()), Boolean.TRUE);
                }
            } else {
                StringBuilder message = new StringBuilder();
                operationResult.getAllErrorOrValidateInfo().forEach(row -> message.append(row.getMessage()));
                throw new KDBizException(new ErrorCode("", message.toString()), new Object[0]);
            }
        }
    }

    public Map<Long, Boolean> insertSupplierColl(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierUpdateInfoMap\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierAssignHelper_0", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        DynamicObject[] supplierDataColl = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,name,createorg,useorg,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        Long currencyUserId = this.getCurrncyUserId();
        String processSource = customParamMap.get(PurSupplierCollInitiateHelper.PROCESSSOURCE);
        ArrayList<DynamicObject> saveDataColl = new ArrayList<DynamicObject>(1024);
        DynamicObject supplierCollData = null;
        for (DynamicObject supplier : supplierDataColl) {
            this.assmablePurSupplierCollInfo(saveDataColl, supplierCollData, currencyUserId, processSource, supplier);
            supplier.set("issuppcolla", (Object)Boolean.TRUE);
        }
        SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])supplierDataColl);
        this.savePurSupplierCollInfo(resultMap, saveDataColl);
        return resultMap;
    }

    private Long getCurrncyUserId() {
        Long currencyUserId;
        block2: {
            currencyUserId = 1L;
            try {
                currencyUserId = RequestContext.get().getCurrUserId();
            }
            catch (RuntimeException runtimeException) {
                if (!log.isInfoEnabled()) break block2;
                log.warn((Throwable)runtimeException);
            }
        }
        return currencyUserId;
    }
}

