/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;

final class PurSupplierCollInactiveHelper {
    private static final int MINASYNSIZE = 50;
    private static final Log log = LogFactory.getLog(PurSupplierCollInactiveHelper.class);

    PurSupplierCollInactiveHelper() {
    }

    public Map<Long, String> querySupplierTryCloseInfo(Collection<Long> supplierIds) {
        HashMap<Long, String> verifySupplierCollMap = new HashMap<Long, String>(supplierIds.size());
        if (supplierIds.size() > 50) {
            HashMap<Long, Future> resultMap = new HashMap<Long, Future>(supplierIds.size());
            for (final Long supplier : supplierIds) {
                Future future = PurSupplierCollInitiateHelper.INIT_WORKER_THREAD_POOL.submit((Callable)new Callable<Map<Long, String>>(){

                    @Override
                    public Map<Long, String> call() throws Exception {
                        return PurSupplierCollInactiveHelper.this.verifyTryCloseInfo(supplier);
                    }
                }, RequestContext.get());
                resultMap.put(supplier, future);
            }
            StringBuilder exceptionMessage = new StringBuilder();
            for (Map.Entry entry : resultMap.entrySet()) {
                Future entryValue = (Future)entry.getValue();
                try {
                    Map object = (Map)entryValue.get();
                    verifySupplierCollMap.putAll(object);
                }
                catch (InterruptedException | ExecutionException e) {
                    exceptionMessage.append(e.getMessage());
                }
            }
            if (log.isWarnEnabled()) {
                log.warn("exceptionMessage:{}", (Object)exceptionMessage);
            }
        } else {
            for (Long supplier : supplierIds) {
                verifySupplierCollMap.putAll(this.verifyTryCloseInfo(supplier));
            }
        }
        return verifySupplierCollMap;
    }

    public Map<Long, String> verifyTryCloseInfo(Long supplierId) {
        HashMap<Long, String> verifySupplierCollMap = new HashMap<Long, String>(16);
        QFilter commonQFilter = new QFilter("supplier.id", "=", (Object)supplierId);
        verifySupplierCollMap.putAll(this.innerQuery("pur_invoice", "id,supplier,entryentity1.poentryid1 poentryid", commonQFilter.copy().and(new QFilter("cfmstatus", "=", (Object)"A"))));
        if (verifySupplierCollMap.isEmpty()) {
            verifySupplierCollMap.putAll(this.innerQuery("pur_check", "id,supplier,materialentry.poentryid poentryid", commonQFilter.copy().and(new QFilter("invstatus", "=", (Object)"A")).and(new QFilter("cfmstatus", "=", (Object)"A"))));
        }
        commonQFilter.and(new QFilter("materialentry.poentryid", "!=", (Object)""));
        if (verifySupplierCollMap.isEmpty()) {
            verifySupplierCollMap.putAll(this.innerQuery("pur_deliveryschedule", "id,supplier,materialentry.poentryid poentryid", commonQFilter.copy().and(new QFilter("materialentry.entrystatus", "=", (Object)"A")).and(QFilter.of((String)"materialentry.basicqty < materialentry.sumoutstockbaseqty ", (Object[])new Object[0]))));
        }
        if (verifySupplierCollMap.isEmpty()) {
            verifySupplierCollMap.putAll(this.innerQuery("pur_accept_apply", "id,supplier,materialentry.poentryid poentryid", commonQFilter.copy().and(new QFilter("cfmstatus", "=", (Object)"A"))));
        }
        if (verifySupplierCollMap.isEmpty()) {
            verifySupplierCollMap.putAll(this.innerQuery("pur_order", "id,supplier,materialentry.poentryid poentryid", commonQFilter));
        } else {
            commonQFilter.and(new QFilter("materialentry.poentryid", "in", verifySupplierCollMap.values()));
            Map<Long, String> orderCheckMap = this.innerQuery("pur_order", "id,supplier,materialentry.poentryid poentryid", commonQFilter);
            if (orderCheckMap.isEmpty()) {
                verifySupplierCollMap.clear();
            }
        }
        return verifySupplierCollMap;
    }

    private Map<Long, String> innerQuery(String entityNumber, String selectFieldString, QFilter qFilter) {
        HashMap<Long, String> verifySupplierCollMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)entityNumber, (String)selectFieldString, (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                verifySupplierCollMap.put(row.getLong("supplier"), row.getString("poentryid"));
            }
        }
        return verifySupplierCollMap;
    }

    public QFilter getMustInactiveQFilter() {
        return new QFilter("billstatus", "in", (Object)new String[]{"C", "D"});
    }
}

