/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.business.suppliercoll.jointbill.PurInitJointDataServiceHelper;

public final class PurBillJointInitiateTask
extends AbstractTask {
    private static final String DEFAULT_BATCH_SIZE = "100";
    private static final Log log = LogFactory.getLog(PurBillJointInitiateTask.class);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String executeChannel;
        int batchSize;
        block10: {
            Object executeChannelParam;
            block9: {
                if (log.isInfoEnabled()) {
                    log.info("{},execute start" + PurBillJointInitiateTask.class.getName());
                }
                Object batchSizeString = paramMap.getOrDefault(PurSupplierCollInitiateHelper.BATCHSIZE, DEFAULT_BATCH_SIZE);
                executeChannelParam = paramMap.get(PurSupplierCollInitiateHelper.EXECUTECHANNEL);
                batchSize = 0;
                executeChannel = null;
                try {
                    batchSize = Integer.parseInt(String.valueOf(batchSizeString));
                }
                catch (RuntimeException runtimeException) {
                    batchSize = Integer.parseInt(DEFAULT_BATCH_SIZE);
                    if (!log.isWarnEnabled()) break block9;
                    log.warn((Throwable)runtimeException);
                }
            }
            try {
                executeChannel = executeChannelParam.toString();
            }
            catch (RuntimeException runtimeException) {
                executeChannel = SystemJointChannelHelper.getDefaultJointChannelId();
                if (!log.isWarnEnabled()) break block10;
                log.warn((Throwable)runtimeException);
            }
        }
        try {
            Object executeBillDataString = paramMap.get(PurSupplierCollInitiateHelper.EXECUTEBILLSTRING);
            if (executeBillDataString != null) {
                Map executeParamData = (Map)SerializationUtils.fromJsonString((String)executeBillDataString.toString(), Map.class);
                PurInitJointDataServiceHelper.executeInitJointBill(executeChannel, executeParamData, batchSize);
            }
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
            throw runtimeException;
        }
        if (log.isInfoEnabled()) {
            log.info("{},execute end" + PurBillJointInitiateTask.class.getName());
        }
    }

    public boolean isSupportReSchedule() {
        return Boolean.FALSE;
    }
}

