/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.scc.common.SccAttachMentUtil;
import kd.scm.scc.common.SccConsultUtil;
import kd.scm.scc.opplugin.SccContractSaveOp;

public class SccContractPlementSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SccContractSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("id");
        filds.add("srcbillid");
        filds.add("srcbillentity");
        filds.add("supplier");
        filds.add("bizpartner_id");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List extendedDataEntities = e.getValidExtDataEntities();
        String entityName = ((ExtendedDataEntity)extendedDataEntities.get(0)).getDataEntity().getDataEntityType().getName();
        String srcEntityName = SccConsultUtil.getSrcEntityName((String)entityName);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            dataEntity.set("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier((Object)dataEntity.getLong("supplier_id")));
            long srcid = dataEntity.getLong("srcbillid");
            List attachList = AttachmentServiceHelper.getAttachments((String)srcEntityName, (Object)srcid, (String)"signattachment");
            if (attachList == null || attachList.size() <= 0) continue;
            dataEntity.set("signattachmentcount", (Object)attachList.size());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] contracts;
        for (DynamicObject con : contracts = e.getDataEntities()) {
            String srcEntyity = con.getString("srcbillentity");
            String srcid = con.getString("srcbillid");
            try (TXHandle h1 = TX.requiresNew();){
                try {
                    SccAttachMentUtil.copyAttachMent((String)srcEntyity, (String)srcid, (String)"signattachment", (String)con.getDataEntityType().getName(), (Long)con.getLong("id"), (String)"signattachment");
                }
                catch (Throwable e1) {
                    log.error("\u9644\u4ef6\u540c\u6b65\u5931\u8d25" + e1.getMessage());
                }
            }
        }
    }
}

