/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;

public abstract class AbstractSendMsgReview
implements IEventServicePlugin {
    protected abstract String getSrcBillName();

    protected abstract String getBillName();

    protected abstract String getSrcIdName();

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        List ids = ((EntityEvent)evt).getBusinesskeys();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : ids) {
            idList.add(Long.parseLong(id));
        }
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObject[] conm_Reviewapply = BusinessDataServiceHelper.load((String)"conm_reviewapply", (String)"id,contractnum,srcbillentity", (QFilter[])filter.toArray());
        if (conm_Reviewapply != null) {
            ArrayList<Object> contractBillNoList = new ArrayList<Object>();
            HashMap<String, Long> idBillNomap = new HashMap<String, Long>();
            for (DynamicObject dynamicObject : conm_Reviewapply) {
                contractBillNoList.add(dynamicObject.get("contractnum"));
                idBillNomap.put(dynamicObject.getString("contractnum"), dynamicObject.getLong("id"));
            }
            QFilter billNofilter = new QFilter("billno", "in", contractBillNoList);
            String srcEntity = conm_Reviewapply[0].getString("srcbillentity");
            if (!this.getSrcBillName().equals(srcEntity)) {
                return null;
            }
            DynamicObject[] conmBills = BusinessDataServiceHelper.load((String)srcEntity, (String)"supplier,org,billno,iscollaconsult", (QFilter[])billNofilter.toArray());
            HashSet<String> orgIds = new HashSet<String>(ids.size());
            for (DynamicObject conm_purcontract : conmBills) {
                orgIds.add(String.valueOf(conm_purcontract.getLong("org.id")));
            }
            Map enableSupMap = ParamUtil.getParam((String)"2AN7+R08B0/5", (String)"sccsrm", orgIds);
            ArrayList<Map<Long, DynamicObject>> list = AbstractSendMsgReview.getBizpartnerMapList(conmBills, enableSupMap, idBillNomap);
            HashMap<String, List<Long>> idsMap = new HashMap<String, List<Long>>();
            this.fillUserIdMap(list, idsMap);
            return idsMap;
        }
        return null;
    }

    private static ArrayList<Map<Long, DynamicObject>> getBizpartnerMapList(DynamicObject[] conm_purcontracts, Map<String, String> enableSupMap, Map<String, Long> map) {
        ArrayList<Map<Long, DynamicObject>> list = new ArrayList<Map<Long, DynamicObject>>();
        for (DynamicObject purcontract : conm_purcontracts) {
            DynamicObject supplier = purcontract.getDynamicObject("supplier");
            String billno = purcontract.getString("billno");
            if (!supplier.getBoolean("issuppcolla") || purcontract.getBoolean("iscollaconsult") || !"true".equals(enableSupMap.get(String.valueOf(purcontract.getLong("org.id"))))) continue;
            HashMap<Long, DynamicObject> applyIDWithSupIdMap = new HashMap<Long, DynamicObject>();
            Long reviewappliId = map.get(billno);
            applyIDWithSupIdMap.put(reviewappliId, supplier);
            list.add(applyIDWithSupIdMap);
        }
        return list;
    }

    private void fillUserIdMap(ArrayList<Map<Long, DynamicObject>> list, HashMap<String, List<Long>> ids) {
        for (Map<Long, DynamicObject> contractIdWithSupIdMap : list) {
            for (Map.Entry<Long, DynamicObject> contractIdWithSupIdMapEntry : contractIdWithSupIdMap.entrySet()) {
                DynamicObject supplier = contractIdWithSupIdMapEntry.getValue();
                HashSet<Long> bizidSet = new HashSet<Long>();
                bizidSet.add(supplier.getDynamicObject("bizpartner").getLong("id"));
                List adminSupUserIdsByBizPartner = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizidSet);
                ids.put(contractIdWithSupIdMapEntry.getKey().toString(), adminSupUserIdsByBizPartner);
            }
        }
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        String srmContractId;
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        StringBuilder url = new StringBuilder();
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        if (StringUtils.isNotEmpty((CharSequence)businesskey) && (srmContractId = this.getSrmContractId(businesskey)) != null) {
            String domainContextUrl = UrlService.getDomainContextUrl();
            url.append(domainContextUrl).append("/index.html?formId=").append(this.getBillName());
            url.append("&pkId=").append(srmContractId);
        }
        urlMaps.put(businesskey, url.toString());
        return urlMaps;
    }

    private String getSrmContractId(String businesskey) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(businesskey));
        DynamicObject conm_Reviewapply = QueryServiceHelper.queryOne((String)"conm_reviewapply", (String)"contractnum", (QFilter[])filter.toArray());
        String contractnum = conm_Reviewapply.getString("contractnum");
        QFilter billNofilter = new QFilter("billno", "=", (Object)contractnum);
        DynamicObject conm_purcontract = QueryServiceHelper.queryOne((String)this.getSrcBillName(), (String)"id", (QFilter[])billNofilter.toArray());
        if (conm_purcontract != null) {
            QFilter srcIdFilter = new QFilter(this.getSrcIdName(), "=", (Object)conm_purcontract.getLong("id"));
            DynamicObject sccbill = QueryServiceHelper.queryOne((String)this.getBillName(), (String)"id", (QFilter[])srcIdFilter.toArray());
            return sccbill == null ? null : sccbill.getString("id");
        }
        return null;
    }
}

