/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.FeatureCheckUtil;

public class SccConPurchaseListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map checkResult = FeatureCheckUtil.checkScFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            e.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            e.setCancel(true);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object[] pks = e.getListSelectedData().getPrimaryKeyValues();
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("elecsign") || operateKey.equals("uploadfile") || operateKey.equals("consult")) {
            String entityName;
            DynamicObject sccPurchase;
            String validstatus;
            if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SccConChangeEditPlugin_2", (String)"scm-scc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (operate.getOperateKey().equals("uploadfile") && pks.length == 1 && !"A".equals(validstatus = (sccPurchase = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)(entityName = ((AbstractOperate)e.getSource()).getEntityId()))).getString("validstatus"))) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e3a\u672a\u751f\u6548\u624d\u80fd\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"SccConChangeEditPlugin_3", (String)"scm-scc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("elecsign") && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("sign");
            return;
        }
        if (e.getOperateKey().equals("uploadfile") && e.getOperationResult().isSuccess()) {
            this.doUploadFile();
        }
    }

    private void doUploadFile() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] pks = list.getSelectedRows().getPrimaryKeyValues();
        Long id = Long.parseLong(pks[0].toString());
        HashMap<String, String> paramMap = new HashMap<String, String>(1024);
        paramMap.put("uploadfile", "view");
        String entityId = ((IListView)this.getView()).getBillFormId();
        BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)entityId, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)id, paramMap, null);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterArrayList = e.getQFilters();
        filterArrayList.add(BizPartnerUtil.assembleQFilterBizPartner());
        ArrayList<String> confirmstatusList = new ArrayList<String>(8);
        confirmstatusList.add("A");
        confirmstatusList.add("B");
        confirmstatusList.add("C");
        confirmstatusList.add("D");
        QFilter qfilter1 = new QFilter("confirmstatus", "in", confirmstatusList);
        QFilter qfilter2 = new QFilter("confirmstatus", "=", (Object)"E");
        qfilter2.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!"scc_change".equals(this.getView().getFormShowParameter().getCustomParams().get("billFormId"))) {
            ArrayList<String> reviewstatusList = new ArrayList<String>(2);
            reviewstatusList.add("C");
            reviewstatusList.add("E");
            qfilter2.and(new QFilter("reviewstatus", "in", reviewstatusList));
        }
        QFilter filter = qfilter1.or(qfilter2);
        filterArrayList.add(filter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
        switch (fieldName = args.getFieldName()) {
            case "attachmentcount": {
                args.setCancel(true);
                this.openAttachment(primaryKeyValue);
                break;
            }
            case "signattachmentcount": {
                args.setCancel(true);
                this.openSignAttachment(primaryKeyValue);
                break;
            }
        }
    }

    private void openSignAttachment(Object primaryKeyValue) {
        String entity = ((IListView)this.getView()).getBillFormId();
        DynamicObject sccBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)entity);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scc_signattach_download");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("entity", sccBill.getDataEntityType().getName());
        param.put("billId", primaryKeyValue);
        formShowParameter.setCustomParams(param);
        this.getView().showForm(formShowParameter);
    }

    private void openAttachment(Object primaryKey) {
        String entityName = ((IListView)this.getView()).getBillFormId();
        DynamicObject sccBill = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)entityName);
        DynamicObjectCollection attachentrys = sccBill.getDynamicObjectCollection("attachentry");
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject attachentry : attachentrys) {
            DynamicObjectCollection attachments = attachentry.getDynamicObjectCollection("attachment");
            for (DynamicObject attachment : attachments) {
                list.add(attachment.get("fbasedataid_id"));
            }
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("v", list);
        value.put("l", true);
        value.put("r", 3);
        value.put("tempAttPageId", this.getView().getPageId());
        value.put("maxAtmCount", 20);
        value.put("maxAtmSize", 10);
        value.put("sortField", "uploadTime");
        value.put("sortType", "ASC");
        value.put("entityNum", sccBill.getDataEntityType().getName());
        value.put("logEntityNum", sccBill.getDataEntityType().getName());
        Object pkValue = sccBill.getPkValue();
        value.put("billPkId", pkValue == null ? "" : pkValue.toString());
        value.put("attKey", "attachmentfield");
        value.put("k", "attachmentfield");
        String tableName = "scc_purchase".equals(entityName) ? "t_scc_purchase_fj" : "t_scc_conpurchase_fj";
        value.put("tableName", tableName);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scc_attachment_download");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(value);
        this.getView().showForm(formShowParameter);
    }
}

