/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.scc.common.SccConsultUtil;

public class SccConsultPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("consult") && e.getOperationResult().isSuccess()) {
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            this.doConsult();
        }
    }

    private void doConsult() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("scc_contract_negotiation");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "consult"));
        showParameter.setCustomParam("entityname", (Object)this.getView().getEntityId());
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"consult", (CharSequence)actionId)) {
            Map returnMap = (Map)evt.getReturnData();
            if (returnMap == null || returnMap.isEmpty()) {
                return;
            }
            Object tempAttaObj = returnMap.get("tempAttaPanel");
            String tempAttaStr = tempAttaObj == null ? null : tempAttaObj.toString();
            Map attaPanelMap = (Map)SerializationUtils.fromJsonString((String)tempAttaStr, Map.class);
            String entityId = this.getView().getEntityId();
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityId);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)type);
            String attachKey = "attachment";
            List attaPanelFileList = (List)attaPanelMap.get("attachmentpanelap");
            ArrayList<Map> attaFieldFileList = new ArrayList<Map>(attaPanelFileList.size());
            for (Map attaPanelFile : attaPanelFileList) {
                attaFieldFileList.add(SccConsultUtil.transAttaPanel2AttaField((Map)attaPanelFile, (String)attachKey, (String)entityId));
            }
            List attaList = AttachmentFieldServiceHelper.saveAttachments((String)entityId, (String)this.getView().getPageId(), attaFieldFileList);
            SccConsultUtil.bindDataToAttachEntry((Map)returnMap, (DynamicObject)data, (String)attachKey, (List)attaList);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("PkId", data.getPkValue());
            paramMap.put("PageId", this.getView().getPageId());
            AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString(paramMap));
            data.set("attachmentcount", (Object)(data.getInt("attachmentcount") + attaList.size()));
            Date now = TimeServiceHelper.now();
            data.set("confirmstatus", (Object)"D");
            data.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            data.set("confirmdate", (Object)now);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            String srcEntityName = SccConsultUtil.getSrcEntityName((String)entityId);
            String srcIdName = SccConsultUtil.getSrcIdName((String)entityId);
            ArrayList<HashMap<String, Object>> fileInfoList = this.buildParamMap(data);
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SupServiceImpl", (String)"fileSync", (Object[])new Object[]{srcEntityName, data.getLong(srcIdName), "attachSync", RequestContext.get().getCurrUserId(), now, fileInfoList});
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SupServiceImpl", (String)"operateInfoSync", (Object[])new Object[]{srcEntityName, new Object[]{data.getLong(srcIdName)}, "consult", RequestContext.get().getCurrUserId(), TimeServiceHelper.now()});
            this.getView().invokeOperation("refresh");
        }
    }

    private ArrayList<HashMap<String, Object>> buildParamMap(DynamicObject data) {
        DynamicObjectCollection attachentry = data.getDynamicObjectCollection("attachentry");
        ArrayList<HashMap<String, Object>> fileInfoList = new ArrayList<HashMap<String, Object>>();
        for (DynamicObject entry : attachentry) {
            if (!"B".equals(entry.get("filesource"))) continue;
            HashMap<String, Object> fileInfoMap = new HashMap<String, Object>();
            HashSet<Long> fileIdSet = new HashSet<Long>();
            DynamicObjectCollection attachments = entry.getDynamicObjectCollection("attachment");
            for (DynamicObject attachment : attachments) {
                fileIdSet.add(attachment.getDynamicObject("fbasedataid").getLong("id"));
            }
            fileInfoMap.put("position", "attachment");
            fileInfoMap.put("attachIds", fileIdSet);
            fileInfoMap.put("attachName", entry.get("attachname"));
            fileInfoMap.put("uploadTime", entry.get("uploadtime"));
            long uploaderId = this.getUploader(entry);
            fileInfoMap.put("uploader", uploaderId);
            if ("0" == entry.get("mappingid")) {
                this.setMappingId(entry);
            }
            fileInfoMap.put("mappingId", entry.getLong("mappingid"));
            fileInfoMap.put("remark", entry.getString("remark"));
            fileInfoMap.put("isconsult", entry.getString("isconsult"));
            fileInfoList.add(fileInfoMap);
        }
        return fileInfoList;
    }

    private long getUploader(DynamicObject entry) {
        Object uploader = entry.get("uploader");
        if (uploader instanceof Long) {
            return entry.getLong("uploader");
        }
        return entry.getDynamicObject("uploader").getLong("id");
    }

    private void setMappingId(DynamicObject attachentry) {
        attachentry.set("mappingid", (Object)DB.genGlobalLongId());
    }
}

