/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.FeatureCheckUtil;

public class SccSupplementEditPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map checkResult = FeatureCheckUtil.checkScFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map checkResult = FeatureCheckUtil.checkScFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            this.getView().showMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        if ("uploadfile".equals(operate.getOperateKey())) {
            this.checkStatus(e);
            if (e.isCancel()) {
                return;
            }
            HashMap<String, Object> attachInfoMap = this.getAttachInfoMap();
            this.getView().getPageCache().put("attachInfo", SerializationUtils.toJsonString(attachInfoMap));
        }
        if ("confirmupload".equals(operate.getOperateKey())) {
            this.checkStatus(e);
            if (e.isCancel()) {
                return;
            }
            this.checkChange(e);
        }
        if ("deleteattachentry".equals(operate.getOperateKey())) {
            List<DynamicObject> attachentry = SccSupplementEditPlugin.getSelectObject(this.getView(), "attachentry");
            boolean flag = false;
            for (DynamicObject dynamicObject : attachentry) {
                String filesource = dynamicObject.getString("filesource");
                if (!"A".equals(filesource) && !dynamicObject.getBoolean("isconsult")) continue;
                flag = true;
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u4e0a\u4f20\u7684\u9644\u4ef6\u6216\u78cb\u5546\u751f\u6210\u7684\u9644\u4ef6\u4e0d\u80fd\u5220\u9664\u3002", (String)"SccConPurchaseEditPlugin_2", (String)"scm-scc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void checkChange(BeforeDoOperationEventArgs e) {
        if (!e.isCancel()) {
            int newSize;
            DynamicObjectCollection attachentry = this.getModel().getEntryEntity("attachentry");
            boolean changeFlag = false;
            for (DynamicObject attach : attachentry) {
                List iDataEntityProperties = attach.getDataEntityState().GetDirtyProperties();
                if (iDataEntityProperties.isEmpty()) continue;
                changeFlag = true;
                break;
            }
            HashMap<String, Object> attachInfoMap = this.getAttachInfoMap();
            String attachInfo = this.getView().getPageCache().get("attachInfo");
            HashMap cacheMap = (HashMap)SerializationUtils.fromJsonString((String)attachInfo, Map.class);
            int oldSize = (Integer)cacheMap.get("size");
            if (oldSize != (newSize = ((Integer)attachInfoMap.get("size")).intValue())) {
                changeFlag = true;
            }
            if (!changeFlag) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u534f\u540c\u9644\u4ef6\uff0c\u518d\u70b9\u51fb\u786e\u8ba4\u4e0a\u4f20\u3002", (String)"SccConPurchaseEditPlugin_0", (String)"scm-scc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private HashMap<String, Object> getAttachInfoMap() {
        HashMap<String, Object> attachInfoMap = new HashMap<String, Object>();
        DynamicObjectCollection attachentry = this.getModel().getEntryEntity("attachentry");
        attachInfoMap.put("size", attachentry.size());
        ArrayList<String> attachUidList = new ArrayList<String>();
        for (DynamicObject entry : attachentry) {
            DynamicObjectCollection attachments = entry.getDynamicObjectCollection("attachment");
            for (DynamicObject attachment : attachments) {
                attachUidList.add(attachment.getDynamicObject("fbasedataid").getString("uid"));
            }
        }
        attachInfoMap.put("attachUidList", attachUidList);
        return attachInfoMap;
    }

    public static List<DynamicObject> getSelectObject(IFormView view, String entryKey) {
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        IDataModel model = view.getModel();
        int[] selectedIndexs = grid.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> selectedRows = new ArrayList<DynamicObject>(selectedIndexs.length);
        for (int selectedIndex : selectedIndexs) {
            selectedRows.add(model.getEntryRowEntity(entryKey, selectedIndex));
        }
        return selectedRows;
    }

    private void checkStatus(BeforeDoOperationEventArgs e) {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject sccPurchase = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.getView().getEntityId());
        if (!"A".equals(sccPurchase.getString("validstatus"))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e3a\u672a\u751f\u6548\u624d\u80fd\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"SccConPurchaseEditPlugin_3", (String)"scm-scc-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!"scc".equals(appId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"corordition_page"});
        }
        if (Boolean.parseBoolean(String.valueOf(model.getValue("iselecsignature")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_elecsign"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_elecsign"});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("uploadfile") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_close", "bar_uploadfile", "sign_page", "bar_refresh", "bar_elecsign", "bar_consult", "bar_confirm1", "bar_unconfirm"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"addrow_attach", "deleterow_attach"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"attachment_page"});
            this.selectAttachTab("attachment_page");
            this.setContainerCollapse(true);
            HashMap<String, Object> attachInfoMap = this.getAttachInfoMap();
            this.getView().getPageCache().put("attachInfo", SerializationUtils.toJsonString(attachInfoMap));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_confirmupload", "bar_cancelupload"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"addrow_attach", "deleterow_attach"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachment_page"});
        }
        Tab tab_attachment = (Tab)this.getView().getControl("tab_attachment");
        tab_attachment.selectTab("attachment_page");
    }

    private void selectAttachTab(String page) {
        Tab tab_attachment = (Tab)this.getView().getControl("tab_attachment");
        tab_attachment.activeTab(page);
        tab_attachment.selectTab(page);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = e.getOperateKey()) {
                case "elecsign": {
                    this.getView().invokeOperation("sign");
                    break;
                }
                case "uploadfile": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_close", "bar_uploadfile", "bar_refresh", "sign_page", "bar_elecsign", "bar_consult", "bar_confirm1", "bar_unconfirm"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_confirmupload", "bar_cancelupload"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"addrow_attach", "deleterow_attach"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"addrow_attach", "deleterow_attach"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"attachment_page"});
                    this.selectAttachTab("attachment_page");
                    this.setContainerCollapse(true);
                    break;
                }
                case "cancelupload": 
                case "confirmupload": {
                    this.ifDisplaySignBar();
                    this.getView().getFormShowParameter().getCustomParams().remove("uploadfile");
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_close", "bar_uploadfile", "bar_refresh", "sign_page", "bar_consult", "bar_confirm1", "bar_unconfirm"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"addrow_attach", "deleterow_attach"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachment_page"});
                    this.getView().invokeOperation("refresh");
                    this.setContainerCollapse(false);
                    break;
                }
            }
        }
    }

    private void ifDisplaySignBar() {
        IDataModel model = this.getModel();
        if (Boolean.parseBoolean(String.valueOf(model.getValue("iselecsignature")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_elecsign"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_elecsign"});
        }
    }

    private void setContainerCollapse(boolean b) {
        Container fs_baseinfo = (Container)this.getView().getControl("fs_baseinfo");
        Container fs_financeinfo = (Container)this.getView().getControl("fs_details");
        Container fs_compontinfo = (Container)this.getView().getControl("fs_createbillinfo");
        Container fs_attachment = (Container)this.getView().getControl("fs_attachment");
        fs_attachment.setCollapse(false);
        fs_financeinfo.setCollapse(b);
        fs_baseinfo.setCollapse(b);
        fs_compontinfo.setCollapse(b);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("attachment".equals(proName) && ApiConfigUtil.hasCQScmConfig()) {
            DynamicObjectCollection attachentrys = this.getModel().getEntryEntity("attachentry");
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObject attachentry = (DynamicObject)attachentrys.get(index);
            DynamicObjectCollection newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            StringBuilder attachName = new StringBuilder();
            for (DynamicObject attachfile : newValue) {
                String filename = attachfile.getDynamicObject("fbasedataid").getString("name");
                if (attachName.length() == 0) {
                    attachName.append(filename);
                    continue;
                }
                attachName.append(";").append(filename);
            }
            this.getModel().beginInit();
            attachentry.set("attachname", (Object)attachName);
            Date now = TimeServiceHelper.now();
            attachentry.set("uploadtime", (Object)now);
            attachentry.set("uploader_id", (Object)RequestContext.get().getCurrUserId());
            this.getModel().endInit();
            this.getView().updateView("attachentry");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setContainerCollapse(false);
    }
}

