/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile.inquiry;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.util.StringUtils;
import kd.scm.scp.common.utils.BigDecimalUtils;
import kd.scm.scp.common.utils.MobileControlUtils;

public class ScpInquiryQuoInputEdit
extends AbstractMobBillPlugIn {
    public static final String CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE = "custom_material_entry_enable_cache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"last", "next", "back", "finish"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initQuoteData();
    }

    private void initQuoteData() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter showParameter = view.getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        int selectIndex = (Integer)customParams.get("currentryrowindex");
        Map rowIndexToQuoteInfo = (Map)customParams.get("customparamsquoteinfo");
        pageCache.put("currentryrowindex", String.valueOf(selectIndex));
        pageCache.put("customparamsquoteinfo", SerializationUtils.toJsonString((Object)rowIndexToQuoteInfo));
        Map customMaterialEntryEnable = (Map)customParams.get("custom_material_entry_enable");
        pageCache.put(CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE, SerializationUtils.toJsonString((Object)customMaterialEntryEnable));
        this.setQuoteInfo(view, rowIndexToQuoteInfo, String.valueOf(selectIndex));
    }

    private boolean currentEntryIsEnable(String currentEntryIndex) {
        IPageCache pageCache = this.getView().getPageCache();
        String enableStr = pageCache.get(CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE);
        if (StringUtils.isBlank((String)enableStr)) {
            return true;
        }
        Map enbleMap = (Map)SerializationUtils.fromJsonString((String)enableStr, Map.class);
        Map<String, Object> entryInfo = this.getEntryInfo(currentEntryIndex);
        Object entryId = entryInfo.get("entryid");
        return (Boolean)enbleMap.get(String.valueOf(entryId));
    }

    private Map<String, Object> getEntryInfo(String currentEntryIndex) {
        IPageCache pageCache = this.getView().getPageCache();
        Map rowIndexToQuoteInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("customparamsquoteinfo"), Map.class);
        return (Map)rowIndexToQuoteInfo.get(currentEntryIndex);
    }

    private void setViewByRowIdx(IFormView view, int selectIndex, int rows) {
        if (rows == 0) {
            return;
        }
        if (rows == 1) {
            view.setEnable(Boolean.valueOf(true), new String[]{"finish"});
            view.setEnable(Boolean.valueOf(false), new String[]{"last", "next"});
            view.setVisible(Boolean.valueOf(false), new String[]{"back"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "finish"});
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("next"), "#FFFFFF", "#999999");
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("last"), "#FFFFFF", "#999999");
            return;
        }
        if (selectIndex == 0) {
            view.setEnable(Boolean.valueOf(true), new String[]{"back", "next"});
            view.setEnable(Boolean.valueOf(false), new String[]{"last"});
            view.setVisible(Boolean.valueOf(false), new String[]{"finish"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "back"});
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("last"), "#212121", "#FFFFFF");
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("next"), "#FFFFFF", "#276FF5");
        } else if (selectIndex > 0 && selectIndex < rows - 1) {
            view.setVisible(Boolean.valueOf(false), new String[]{"finish"});
            view.setEnable(Boolean.valueOf(true), new String[]{"last", "back", "next"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "back"});
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("last"), "#FFFFFF", "#276FF5");
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("next"), "#FFFFFF", "#276FF5");
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "finish"});
            view.setVisible(Boolean.valueOf(false), new String[]{"back"});
            view.setEnable(Boolean.valueOf(true), new String[]{"last", "finish"});
            view.setEnable(Boolean.valueOf(false), new String[]{"next"});
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("last"), "#FFFFFF", "#276FF5");
            MobileControlUtils.controlSetFrontAndBackColor(this.getControl("next"), "#212121", "#FFFFFF");
        }
    }

    private void setQuoteInfo(IFormView view, Map<String, Map<String, Object>> rowIndexToQuoteInfo, String rowIndex) {
        IDataModel model = this.getModel();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.setViewByRowIdx(view, Integer.parseInt(rowIndex), rowIndexToQuoteInfo.size());
        Map<String, Object> quoteInfo = rowIndexToQuoteInfo.get(rowIndex);
        Long orgId = Long.valueOf(quoteInfo.get("org").toString());
        Long unitId = Long.valueOf(quoteInfo.get("unit").toString());
        Long materialId = Long.valueOf(quoteInfo.get("material").toString());
        Long taxRateId = quoteInfo.get("taxrateid") == null || Long.parseLong(quoteInfo.get("taxrateid").toString()) == 0L ? null : Long.valueOf(quoteInfo.get("taxrateid").toString());
        Object taxRateTmp = quoteInfo.get("taxrate");
        BigDecimal taxRate = taxRateTmp == null ? BigDecimal.ZERO : new BigDecimal(taxRateTmp.toString());
        Long currId = Long.valueOf(quoteInfo.get("curr").toString());
        String materialDesc = (String)quoteInfo.get("materialdesc");
        Long baseUnitId = Long.valueOf(quoteInfo.get("basicunit").toString());
        Object basicQtyObj = quoteInfo.get("basicqty");
        BigDecimal basicQty = this.castToBigDecimal(basicQtyObj);
        String goodsDesc = (String)quoteInfo.get("goodsdesc");
        Object deliDateObj = quoteInfo.get("entrydelidate");
        Date deliDate = null;
        try {
            String deliDateStr = deliDateObj == null ? "" : deliDateObj.toString();
            deliDate = StringUtils.isEmpty((String)deliDateStr) ? null : dateFormat.parse(deliDateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{0}\u3002", (String)"ScpInquiryQuoToolEdit_0", (String)"scm-scp-mobile", (Object[])new Object[0]), e.getMessage()));
        }
        Object qtyObj = quoteInfo.get("qty");
        BigDecimal qty = this.castToBigDecimal(qtyObj);
        Object taxPriceObj = quoteInfo.get("taxprice");
        String deliAddr = (String)quoteInfo.get("entrydeliaddr");
        model.setValue("org", (Object)orgId);
        model.setValue("unit", (Object)unitId);
        model.setValue("material", (Object)materialId);
        model.setValue("taxrateid", (Object)taxRateId);
        model.setValue("taxrate", (Object)taxRate);
        model.setValue("curr", (Object)currId);
        model.setValue("qty", (Object)qty);
        model.setValue("entryseq", (Object)Integer.parseInt(rowIndex));
        model.setValue("taxprice", (Object)this.castToBigDecimal(taxPriceObj));
        model.setValue("materialdesc", (Object)materialDesc);
        model.setValue("basicunit", (Object)baseUnitId);
        model.setValue("basicqty", (Object)basicQty);
        model.setValue("goodsdesc", (Object)goodsDesc);
        model.setValue("entrydelidate", (Object)deliDate);
        model.setValue("entrydeliaddr", (Object)deliAddr);
        Label qtyLabel = (Label)this.getControl("qtylabel");
        Label unitLabel = (Label)this.getControl("unitlabel");
        DynamicObject unitDy = (DynamicObject)model.getValue("unit");
        String unitName = unitDy == null ? "" : unitDy.getString("name");
        unitLabel.setText(unitName);
        qtyLabel.setText(BigDecimalUtils.getMicquartBigDecimal(qty, false));
        boolean enable = this.currentEntryIsEnable(rowIndex);
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"flexpanelap"});
    }

    private BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        BigDecimal fieldValue = BigDecimal.ZERO;
        fieldValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        return fieldValue.compareTo(BigDecimal.ZERO) == 0 ? null : fieldValue;
    }

    private void clickReCacheQuoteInfo(IPageCache pageCache, int currIndex, Map<String, Map<String, Object>> rowIndexToQuoteInfo) {
        Map<String, Object> quoteInfo = rowIndexToQuoteInfo.get(String.valueOf(currIndex));
        this.backFillQuoParams(quoteInfo);
        pageCache.put("customparamsquoteinfo", SerializationUtils.toJsonString(rowIndexToQuoteInfo));
    }

    public void click(EventObject e) {
        super.click(e);
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        Control source = (Control)e.getSource();
        String opKey = source.getKey();
        int currIndex = Integer.parseInt(pageCache.get("currentryrowindex"));
        Map rowIndexToQuoteInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("customparamsquoteinfo"), Map.class);
        switch (opKey) {
            case "last": {
                int lastIndex = currIndex - 1;
                this.lastOrNextOp(view, pageCache, rowIndexToQuoteInfo, currIndex, lastIndex);
                break;
            }
            case "next": {
                int nextIndex = currIndex + 1;
                this.lastOrNextOp(view, pageCache, rowIndexToQuoteInfo, currIndex, nextIndex);
                break;
            }
            case "back": 
            case "finish": {
                this.closeCurrPageOp(currIndex);
                break;
            }
        }
    }

    private void closeCurrPageOp(int currIndex) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        HashMap<Long, Map> entryIdToQuoteInfo = new HashMap<Long, Map>(16);
        Map rowIndexToQuoteInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("customparamsquoteinfo"), Map.class);
        this.clickReCacheQuoteInfo(pageCache, currIndex, rowIndexToQuoteInfo);
        Collection quoteInfos = rowIndexToQuoteInfo.values();
        for (Map quoteMap : quoteInfos) {
            Long entryId;
            Object id = quoteMap.get("entryid");
            if (id == null || (entryId = Long.valueOf(id.toString())).equals(0L)) continue;
            entryIdToQuoteInfo.put(entryId, quoteMap);
        }
        view.returnDataToParent(entryIdToQuoteInfo);
        view.close();
    }

    private void lastOrNextOp(IFormView view, IPageCache pageCache, Map<String, Map<String, Object>> rowIndexToQuoteInfo, int currIndex, int lastOrNextIdx) {
        this.clickReCacheQuoteInfo(pageCache, currIndex, rowIndexToQuoteInfo);
        this.setQuoteInfo(view, rowIndexToQuoteInfo, String.valueOf(lastOrNextIdx));
        pageCache.put("currentryrowindex", String.valueOf(lastOrNextIdx));
    }

    private void backFillQuoParams(Map<String, Object> quoteInfo) {
        IDataModel model = this.getModel();
        DynamicObject taxRateObj = (DynamicObject)model.getValue("taxrateid");
        Long taxRateId = taxRateObj == null ? null : Long.valueOf(taxRateObj.getLong("id"));
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate");
        quoteInfo.put("qty", model.getValue("qty"));
        quoteInfo.put("taxrateid", taxRateId);
        quoteInfo.put("taxrate", taxRate);
        quoteInfo.put("taxprice", model.getValue("taxprice"));
    }
}

