/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.scp.common.enums.SupplierStatusEnum;

public class InquiryBizHelper {
    public static void setSupplierStatus(DynamicObjectCollection rows) {
        Map<String, String> myStatus = InquiryBizHelper.getMyStatusOfSupplier(rows);
        for (DynamicObject row : rows) {
            String status = myStatus.get(row.getString("id"));
            if (status != null && !status.trim().equals("")) {
                row.set("supplierstatus", (Object)status);
                continue;
            }
            if (!row.getString("bizstatus").equals(BizStatusEnum.ENROLMENT.getVal())) {
                row.set("supplierstatus", (Object)SupplierStatusEnum.NOT_INVOLVE.getVal());
                continue;
            }
            if (row.getDate("enddate").before(TimeServiceHelper.now())) {
                row.set("supplierstatus", (Object)SupplierStatusEnum.NOT_INVOLVE.getVal());
                continue;
            }
            row.set("supplierstatus", (Object)SupplierStatusEnum.PENDING_QUOTE.getVal());
        }
    }

    public static Map<String, String> getMyStatusOfSupplier(DynamicObjectCollection rows) {
        HashMap<String, String> myStatus = new HashMap<String, String>(10);
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        ArrayList<Long> billIds = new ArrayList<Long>(10);
        for (DynamicObject row2 : rows) {
            billIds.add(row2.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", billIds).and("entryentity.supplier", "in", (Object)supplierIds).and("supplierstatus", "!=", (Object)SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entryentity.supentrystatus", (QFilter[])new QFilter[]{filter}, (String)"entryentity.supentrystatus desc");){
            dataSet.forEach(row -> myStatus.put(row.getString("id"), row.getString("entryentity.supentrystatus")));
        }
        return myStatus;
    }

    public static Map<String, Object> verifyUnquote(DynamicObject inquiryBill) {
        String supEntryStatus;
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put("succed", "true");
        DynamicObject quoSupEntry = InquiryBizHelper.getCurrUserQuoSupEntry(inquiryBill);
        if (quoSupEntry != null && (supEntryStatus = quoSupEntry.getString("supentrystatus")).equals(SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal())) {
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u60a8\u5df2\u505a\u4e0d\u62a5\u4ef7\u5904\u7406,\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"InquiryBizHandleHelper_0", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return returnMap;
        }
        if (InquiryBizHelper.hasQuotedInCurrTurns(inquiryBill)) {
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u4ef7\u5355,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"InquiryBizHandleHelper_1", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return returnMap;
        }
        Date endDate = inquiryBill.getDate("enddate");
        if (!TimeServiceHelper.now().before(endDate)) {
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u5df2\u8fc7,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"InquiryBizHandleHelper_2", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return returnMap;
        }
        String bizStatus = inquiryBill.getString("bizstatus");
        if (!bizStatus.equals(BizStatusEnum.ENROLMENT.getVal())) {
            returnMap.put("succed", "false");
            returnMap.put("message", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e0d\u5728\u62a5\u4ef7\u4e2d,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"InquiryBizHandleHelper_3", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return returnMap;
        }
        return returnMap;
    }

    public static Map<String, Object> verifyQuote(DynamicObject inquiryBill) {
        DynamicObject quoSupEntry;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("succed", "true");
        boolean flag = true;
        String bizStatus = inquiryBill.getString("bizstatus");
        String errorInfo = null;
        if (!bizStatus.equals(BizStatusEnum.ENROLMENT.getVal())) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e0d\u662f\u5f85\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\u3002", (String)"InquiryBizHandleHelper_10", (String)"scm-scp-mobile", (Object[])new Object[0]);
        }
        if ((quoSupEntry = InquiryBizHelper.getQuoMaxEntry(inquiryBill)) != null && flag) {
            Object enddate;
            String supEntryStatus = quoSupEntry.getString("supentrystatus");
            if (SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal().equals(supEntryStatus) && flag) {
                flag = false;
                errorInfo = ResManager.loadKDString((String)"\u6211\u7684\u72b6\u6001\u4e3a\u4e0d\u62a5\u4ef7,\u4e0d\u5141\u8bb8\u62a5\u4ef7\u3002", (String)"InquiryBizHandleHelper_11", (String)"scm-scp-mobile", (Object[])new Object[0]);
            }
            if ((enddate = quoSupEntry.get("deadline")) == null || TimeServiceHelper.now().after((Date)enddate)) {
                flag = false;
                errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\u3002", (String)"InquiryBizHandleHelper_12", (String)"scm-scp-mobile", (Object[])new Object[0]);
            }
        } else if (quoSupEntry == null && flag && !"1".equals(inquiryBill.getString("turns"))) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\u3002", (String)"InquiryBizHandleHelper_13", (String)"scm-scp-mobile", (Object[])new Object[0]);
        }
        Object enddate = inquiryBill.get("enddate");
        if (TimeServiceHelper.now().after((Date)enddate) && flag) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\u3002", (String)"InquiryBizHandleHelper_14", (String)"scm-scp-mobile", (Object[])new Object[0]);
        }
        returnMap.put("succed", String.valueOf(flag));
        returnMap.put("message", errorInfo);
        return returnMap;
    }

    private static DynamicObject getQuoMaxEntry(DynamicObject inquiryBill) {
        DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> entryTrunsMap = new HashMap<String, DynamicObject>();
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        String supplierId = "";
        for (DynamicObject col : cols) {
            DynamicObject supplier = col.getDynamicObject("supplier");
            if (supplier == null || !supplierIds.contains(supplier.getLong("id"))) continue;
            supplierId = col.getString("supplier_id");
            DynamicObject dy = (DynamicObject)entryTrunsMap.get(supplierId);
            if (dy == null) {
                entryTrunsMap.put(supplierId, col);
                continue;
            }
            if (dy.getInt("entryturns") >= col.getInt("entryturns")) continue;
            entryTrunsMap.put(supplierId, col);
        }
        return (DynamicObject)entryTrunsMap.get(supplierId);
    }

    public static DynamicObject getCurrUserQuoSupEntry(DynamicObject inquiryBill) {
        DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            List userIds;
            Object quoter = col.get("quoter");
            if (quoter == null || !(userIds = BizPartnerUtil.getSupUserIds()).contains(quoter)) continue;
            return col;
        }
        return null;
    }

    public static boolean hasQuotedInCurrTurns(DynamicObject inquiryBill) {
        QFilter inquiryBillNofilter = new QFilter("inquiryno", "=", (Object)inquiryBill.getString("billno"));
        QFilter turnsFilter = new QFilter("turns", "=", (Object)inquiryBill.getString("turns"));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
        QFilter supplierFilter = new QFilter("supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner());
        QFilter[] filters = new QFilter[]{inquiryBillNofilter, turnsFilter, statusFilter, supplierFilter, entrystatusFilter};
        Boolean[] flag = new Boolean[]{false};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"InquiryBizHandleHelper.hasQuotedInCurrTurns", (String)"quo_quote", (String)"id,supplier,billno,billstatus", (QFilter[])filters, (String)"");){
            ds.forEach(row -> {
                flag[0] = true;
            });
        }
        return flag[0];
    }

    public static void confirmUnquote(DynamicObject inquiryBill) {
        DynamicObject[] quoteBills;
        if (inquiryBill == null) {
            return;
        }
        List supplierList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        if (supplierList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7\u4f9b\u5e94\u5546\u7528\u6237\u627e\u4e0d\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546\u3002", (String)"InquiryBizHandleHelper_4", (String)"scm-scp-mobile", (Object[])new Object[0]));
        }
        String supscope = inquiryBill.getString("supscope");
        DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
        if ("2".equals(supscope)) {
            for (DynamicObject[] row : cols) {
                InquiryBizHelper.setUnquoteInfo(supplierList, (DynamicObject)row);
            }
        } else {
            DynamicObject quoSupEntry = InquiryBizHelper.getCurrUserQuoSupEntry(inquiryBill);
            if (quoSupEntry == null) {
                quoSupEntry = cols.addNew();
                quoSupEntry.set("supplier", supplierList.get(0));
            }
            InquiryBizHelper.setUnquoteInfo(quoSupEntry);
        }
        for (DynamicObject quoteBill : quoteBills = InquiryBizHelper.getQuoteBillByCurrSupAndBillno(inquiryBill.getString("billno"), supplierList)) {
            DynamicObjectCollection materialentrys = quoteBill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentrys) {
                entry.set("entrystatus", (Object)"B");
            }
        }
        SaveServiceHelper.save((DynamicObject[])quoteBills);
        ArrayList<String> inquiryBillNoList = new ArrayList<String>(10);
        inquiryBillNoList.add(inquiryBill.getString("billno"));
        InquiryUtil.updateInquiryQuoResult((DynamicObject[])new DynamicObject[]{inquiryBill}, inquiryBillNoList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inquiryBill});
    }

    public static DynamicObject[] getQuoteBillByCurrSupAndBillno(String billno, List<Long> supplierList) {
        if (!supplierList.isEmpty()) {
            QFilter inquirynoFilter = new QFilter("inquiryno", "=", (Object)billno);
            QFilter supplierFilter = new QFilter("supplier", "in", supplierList);
            QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
            return BusinessDataServiceHelper.load((String)"quo_quote", (String)"id,billno,materialentry.entrystatus", (QFilter[])new QFilter[]{inquirynoFilter, supplierFilter, entrystatusFilter});
        }
        return new DynamicObject[0];
    }

    private static void setUnquoteInfo(List<Long> supplierList, DynamicObject quoSupEntry) {
        if (supplierList.contains(quoSupEntry.getLong("supplier.id"))) {
            InquiryBizHelper.setUnquoteInfo(quoSupEntry);
        }
    }

    private static void setUnquoteInfo(DynamicObject quoSupEntry) {
        quoSupEntry.set("quoter", (Object)RequestContext.get().getUserId());
        quoSupEntry.set("quotedate", (Object)TimeServiceHelper.now());
        quoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal());
    }

    public static void setInquiryStatus(DynamicObjectCollection rows) {
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject row2 : rows) {
            billIds.add(row2.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", billIds).and("entryentity.supplier", "in", (Object)supplierIds);
        HashMap<String, Map<String, Object>> supplierInfoMap = new HashMap<String, Map<String, Object>>(billIds.size());
        Map<String, Date> turnsLogMap = null;
        ArrayList<String> supstatus = new ArrayList<String>();
        supstatus.add("C");
        supstatus.add("D");
        supstatus.add("E");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entryentity.supplier,entryentity.supentrystatus,entryentity.entryturns,entryentity.entrycount,entryentity.deadline,entryentity.supplierbizstatus", (QFilter[])new QFilter[]{filter}, (String)"entryentity.deadline desc");){
            dataSet.forEach(row -> {
                HashMap<String, Object> infoMap = (HashMap<String, Object>)supplierInfoMap.get(row.getString("id"));
                String supentrystatus = row.getString("entryentity.supentrystatus");
                if (infoMap == null) {
                    infoMap = new HashMap<String, Object>();
                    infoMap.put("supplierbizstatus", row.getString("entryentity.supplierbizstatus"));
                    infoMap.put("deadline", row.getDate("entryentity.deadline"));
                    infoMap.put("supentrystatus", supentrystatus);
                    infoMap.put("supplierId", row.getString("entryentity.supplier"));
                    supplierInfoMap.put(row.getString("id"), infoMap);
                }
                if (supstatus.contains(supentrystatus) && infoMap != null) {
                    infoMap.put("supentrystatus", supentrystatus);
                }
            });
        }
        turnsLogMap = InquiryBizHelper.getTurnsInfo(billIds);
        for (DynamicObject row3 : rows) {
            InquiryBizHelper.setSupplierExtendInfo(supplierInfoMap, turnsLogMap, row3);
        }
    }

    private static Map<String, Date> getTurnsInfo(List<Long> billIds) {
        HashMap<String, Date> turnsLogMap = new HashMap<String, Date>(billIds.size());
        QFilter filter = new QFilter("id", "in", billIds).and("entrylog.turns_log", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entrylog.logdeadline", (QFilter[])new QFilter[]{filter}, null);){
            dataSet.forEach(row -> turnsLogMap.put(row.getString("id"), row.getDate("entrylog.logdeadline")));
        }
        return turnsLogMap;
    }

    private static void setSupplierExtendInfo(Map<String, Map<String, Object>> supplierInfoMap, Map<String, Date> turnsLogMap, DynamicObject row) {
        Map<String, Object> supplierInfo = supplierInfoMap.get(row.getString("id"));
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("supplierProStatus", "supplierprostatus");
        paramMap.put("supplierstatus", "supplierstatus");
        paramMap.put("bizstatus", row.getString("bizstatus"));
        if (supplierInfo != null && supplierInfo.get("supplierId") != null) {
            String supplierbizstatus = (String)supplierInfo.get("supplierbizstatus");
            String status = (String)supplierInfo.get("supentrystatus");
            paramMap.put("supplierbizstatus", supplierbizstatus);
            paramMap.put("status", status);
            Date deadLine = (Date)supplierInfo.get("deadline");
            InquiryBizHelper.setInquirySupplierProStatus(paramMap, deadLine, row);
            row.set("turns", StringUtils.isBlank((Object)supplierInfo.get("")) ? "1" : supplierInfo.get(""));
            if (deadLine != null) {
                row.set("enddate", (Object)deadLine);
            }
        } else {
            Date date = null;
            if (turnsLogMap != null && turnsLogMap.size() > 0 && turnsLogMap.get(row.getString("id")) != null) {
                date = turnsLogMap.get(row.getString("id"));
                row.set("enddate", (Object)date);
            } else {
                date = row.getDate("enddate");
            }
            InquiryBizHelper.setInquirySupplierProStatus(paramMap, date, row);
            if (!"1".equals(row.getString("turns"))) {
                row.set("supplierprostatus", (Object)SupInquiryStatusEnum.PARTICALADOPTION.getVal());
                row.set("supplierstatus", (Object)"Z");
            }
            if (BizStatusEnum.END.getVal().equals(row.getString("bizstatus"))) {
                row.set("supplierProStatus", (Object)BizStatusEnum.END.getVal());
            }
            row.set("turns", (Object)"1");
        }
    }

    public static void setInquirySupplierProStatus(Map<String, String> paramMap, Date deadLine, DynamicObject row) {
        if (paramMap == null) {
            return;
        }
        String supplierbizstatus = paramMap.get("supplierbizstatus");
        String bizstatus = paramMap.get("bizstatus");
        String status = paramMap.get("status");
        String supplierProStatus = paramMap.get("supplierProStatus");
        String supplierstatus = paramMap.get("supplierstatus");
        InquirySupParticipateUtils.setSupProStatus((DynamicObject)row, (Date)deadLine, (String)supplierProStatus, (String)supplierbizstatus);
        if (status == null || status.trim().equals("")) {
            if ("A".equals(bizstatus)) {
                if (deadLine != null && deadLine.before(TimeServiceHelper.now())) {
                    row.set(supplierstatus, (Object)"Z");
                } else {
                    row.set(supplierstatus, (Object)"Y");
                }
            } else {
                row.set(supplierstatus, (Object)"Z");
            }
        } else {
            row.set(supplierstatus, (Object)status);
        }
    }
}

