/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class QuoteMaterialHelper {
    private static final String QUO_TURNS = "quoturns";

    public static Map<String, Map<String, Object>> getPriceInfoMap(String inquiryNo, Long supplierId) {
        QFilter[] qFilters = null;
        qFilters = supplierId == null ? new QFilter[]{new QFilter("inquiryno", "=", (Object)inquiryNo), new QFilter("billstatus", "=", (Object)"C"), new QFilter("materialentry.entrystatus", "=", (Object)"A"), new QFilter("bizpartner", "in", (Object)BizPartnerUtil.getBizPartnerIds())} : new QFilter[]{new QFilter("inquiryno", "in", (Object)inquiryNo), new QFilter("billstatus", "=", (Object)"C"), new QFilter("materialentry.entrystatus", "=", (Object)"A"), new QFilter("supplier", "=", (Object)supplierId)};
        DynamicObject[] quoteBillsDyns = BusinessDataServiceHelper.load((String)"quo_quote", (String)"id,curr,exchtype,materialentry.srcentryid,materialentry.taxrateid,materialentry.taxrate,materialentry.price,materialentry.taxprice,materialentry.quotecurr,materialentry.exrate,materialentry.entryquotation,materialentry.quoturns", (QFilter[])qFilters, (String)"inquiryno,billdate desc");
        if (quoteBillsDyns == null) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        return QuoteMaterialHelper.fillWrapInfoMap(quoteBillsDyns);
    }

    private static Map<String, Map<String, Object>> fillWrapInfoMap(DynamicObject[] quoteBillsDyns) {
        HashMap<String, Map<String, Object>> wrapInfoMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, BigDecimal> exrateMap = new HashMap<String, BigDecimal>();
        for (DynamicObject dynamicObject : quoteBillsDyns) {
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentry) {
                DynamicObject quotecurr = entry.getDynamicObject("quotecurr");
                if (quotecurr == null || !quotecurr.getBoolean("enable")) {
                    return wrapInfoMap;
                }
                BigDecimal exrate = QuoteMaterialHelper.dealExrateInfo(entry, dynamicObject, exrateMap);
                if (exrate == null) {
                    return wrapInfoMap;
                }
                if (!QuoteMaterialHelper.validateTaxrate(entry)) continue;
                wrapInfoMap.put(entry.getString("srcentryid"), QuoteMaterialHelper.wrapInfoMap(entry));
            }
        }
        return wrapInfoMap;
    }

    public static BigDecimal dealExrateInfo(DynamicObject entry, DynamicObject info, Map<String, BigDecimal> exrateMap) {
        StringBuilder str = new StringBuilder();
        BigDecimal exrate = null;
        if (entry != null && exrateMap != null) {
            long quoCurrId = entry.getLong("quotecurr_id");
            long currId = info.getLong("curr_id");
            long exchtype = info.getLong("exchtype_id");
            if (0L != currId && 0L != quoCurrId) {
                if (currId == quoCurrId) {
                    return BigDecimal.ONE;
                }
                String rowKey = str.append(quoCurrId).append("--").append(exchtype).append("--").append(currId).toString();
                exrate = exrateMap.computeIfAbsent(rowKey, key -> {
                    BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)exchtype, (Long)quoCurrId, (Long)currId, (Date)TimeServiceHelper.now());
                    if (null == rate || rate.compareTo(BigDecimal.ZERO) == 0) {
                        rate = null;
                    }
                    return rate;
                });
            }
        }
        return exrate;
    }

    protected static boolean validateTaxrate(DynamicObject entry) {
        long aLong;
        DynamicObject taxrateid = entry.getDynamicObject("taxrateid");
        return taxrateid == null || (aLong = taxrateid.getLong("id")) == 0L || taxrateid.getBoolean("enable");
    }

    protected static Map<String, Object> wrapInfoMap(DynamicObject entry) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("taxrateid", entry.getDynamicObject("taxrateid"));
        infoMap.put("taxrate", entry.getBigDecimal("taxrate"));
        infoMap.put("price", entry.getBigDecimal("price"));
        infoMap.put("taxprice", entry.getBigDecimal("taxprice"));
        infoMap.put("quotecurr", entry.getDynamicObject("quotecurr"));
        infoMap.put("exrate", entry.getBigDecimal("exrate"));
        String quotation = entry.getString("entryquotation");
        infoMap.put("entryquotation", StringUtils.isBlank((CharSequence)quotation) ? "0" : quotation);
        infoMap.put(QUO_TURNS, entry.getString(QUO_TURNS));
        return infoMap;
    }
}

