/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ParamUtil;

public final class ScpAutoStockBillHelper {
    public static final String PM_PURORDER = "pm_purorderbill";
    public static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    public static final String PM_PURACCEPTBILL = "pm_puracceptbill";
    public static final String PM_OM_PURORDERBILL = "pm_om_purorderbill";
    public static final String PM_RECEIPTNOTICE = "pm_receiptnotice";
    private static final Log log = LogFactory.getLog((String)ScpAutoStockBillHelper.class.getName());

    public static void buildParam(DynamicObject bill, DynamicObject row, Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Set<String> salOutEntryIds, Map<String, String> autoExtEntryPro, Boolean isAccept) {
        String poBillId = row.getString("pobillid");
        String poEntryId = row.getString("poentryid");
        if (!poBillId.isEmpty() && !poEntryId.isEmpty()) {
            salOutEntryIds.add(row.getString("id"));
            Collection<Long> orderEntry = pushOrderData.get(Long.parseLong(poBillId));
            if (orderEntry != null) {
                orderEntry.add(Long.parseLong(poEntryId));
            } else {
                orderEntry = new HashSet<Long>(16);
                orderEntry.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), orderEntry);
            }
            List<Map<String, String>> salOutInfoS = rowSalOutInfoMap.get(poEntryId);
            Map<String, String> cosmicParam = ScpAutoStockBillHelper.assembleCosmicParam(poEntryId, bill, row, autoExtEntryPro, isAccept);
            if (salOutInfoS != null) {
                salOutInfoS.add(cosmicParam);
            } else {
                salOutInfoS = new ArrayList<Map<String, String>>();
                salOutInfoS.add(cosmicParam);
                rowSalOutInfoMap.put(poEntryId, salOutInfoS);
            }
        }
    }

    private static Map<String, String> assembleCosmicParam(String poEntryId, DynamicObject bill, DynamicObject row, Map<String, String> autoExtEntryPro, Boolean isAccept) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
        String billNo = bill.getString("billno");
        String billId = bill.getString("id");
        String entryId = row.getString("id");
        BigDecimal qty = row.getBigDecimal("qty");
        BigDecimal basicQty = row.getBigDecimal("basicqty");
        if (!isAccept.booleanValue()) {
            salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
            salOutInfoMap.put("basicqty_" + poEntryId, basicQty.toPlainString());
            salOutInfoMap.put("saloutNo_" + poEntryId, billNo);
            salOutInfoMap.put("saloutId_" + poEntryId, billId);
            salOutInfoMap.put("saloutEntryId_" + poEntryId, entryId);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
            String suplot1 = row.getString("suplot");
            Date proddate1 = row.getDate("proddate");
            Date duedate1 = row.getDate("duedate");
            if (suplot1 != null) {
                salOutInfoMap.put("suplot_" + poEntryId, suplot1);
            }
            if (proddate1 != null) {
                salOutInfoMap.put("proddate_" + poEntryId, sf.format(proddate1));
            }
            if (duedate1 != null) {
                salOutInfoMap.put("duedate_" + poEntryId, sf.format(duedate1));
            }
        } else {
            String note = row.getString("note");
            salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
            salOutInfoMap.put("soubillnumber_" + poEntryId, billNo);
            salOutInfoMap.put("soubillid_" + poEntryId, billId);
            salOutInfoMap.put("soubillentryid_" + poEntryId, entryId);
            if (note != null) {
                salOutInfoMap.put("entrycomment_" + poEntryId, note);
            }
        }
        Map<String, String> autoExtStockBill = ScpAutoStockBillHelper.assembleAutoExtStockBill(row, autoExtEntryPro);
        if (!autoExtStockBill.isEmpty()) {
            for (Map.Entry<String, String> entry : autoExtStockBill.entrySet()) {
                salOutInfoMap.put(entry.getKey() + "_" + poEntryId, entry.getValue());
            }
        }
        return salOutInfoMap;
    }

    private static Map<String, String> assembleAutoExtStockBill(DynamicObject bill, Map<String, String> sdkEntryMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, sdkEntryMap));
        return extStockData;
    }

    public static void updateSalOutStockReceiptBillNO(Map<String, Object> messageMap) {
        if (!messageMap.isEmpty()) {
            HashMap<Long, String> autoNoOfMap = new HashMap<Long, String>(16);
            for (Map.Entry<String, Object> entry : messageMap.entrySet()) {
                String billnumber;
                String entryKey = entry.getKey();
                Map msgMap = (Map)entry.getValue();
                Object billstatus = msgMap.get("billstatus");
                if (billstatus == null || "".equals(billstatus) || (billnumber = String.valueOf(msgMap.get("billnumber"))) == null || billnumber.isEmpty()) continue;
                autoNoOfMap.putIfAbsent(Long.valueOf(entryKey), billnumber);
            }
            if (!autoNoOfMap.isEmpty()) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)"id,billno,materialentry.autorecbillno", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", autoNoOfMap.keySet())});
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject bill : dynamicObjects) {
                        DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                        for (DynamicObject row : rows) {
                            Long entryId = row.getLong("id");
                            String autoBillNo = (String)autoNoOfMap.get(entryId);
                            if (autoBillNo == null || autoBillNo.isEmpty()) continue;
                            row.set("autorecbillno", (Object)autoBillNo);
                        }
                    }
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
            }
        }
    }

    public static Map<Long, Boolean> verifyAutoReceiptBill(Collection<Long> unitOrgIds) {
        String paramKey = "autocreatebilltype";
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(unitOrgIds.size());
        Boolean isAutoReceive = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"isautoreceive");
        for (Long unitOrg : unitOrgIds) {
            Map sysParaMap = ParamUtil.getSysParameter((String)"eae607fb000143ac", (String)unitOrg.toString());
            Object paramValue = sysParaMap.get(paramKey);
            Object orgAutoReceive = sysParaMap.get("isautoreceive");
            if (orgAutoReceive != null) {
                isAutoReceive = Boolean.valueOf(orgAutoReceive.toString());
            }
            if (paramValue != null) {
                if (isAutoReceive.booleanValue() && "receiptbill".equals(paramValue)) {
                    resultMap.put(unitOrg, Boolean.TRUE);
                    continue;
                }
                resultMap.put(unitOrg, Boolean.FALSE);
                continue;
            }
            resultMap.put(unitOrg, isAutoReceive);
        }
        return resultMap;
    }

    public static Map<Long, Boolean> verifyAutoReceiptNoticeBill(Collection<Long> unitOrgIds) {
        String paramKey = "autocreatebilltype";
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(unitOrgIds.size());
        Boolean isAutoReceive = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"isautoreceive");
        for (Long unitOrg : unitOrgIds) {
            Map sysParaMap = ParamUtil.getSysParameter((String)"eae607fb000143ac", (String)unitOrg.toString());
            Object paramValue = sysParaMap.get(paramKey);
            Object orgAutoReceive = sysParaMap.get("isautoreceive");
            if (orgAutoReceive != null) {
                isAutoReceive = Boolean.valueOf(orgAutoReceive.toString());
            }
            if (isAutoReceive.booleanValue() && "receiptnotice".equals(paramValue)) {
                resultMap.put(unitOrg, Boolean.TRUE);
                continue;
            }
            resultMap.put(unitOrg, Boolean.FALSE);
        }
        return resultMap;
    }

    public static Map<Long, Boolean> verifyAutoInStockBill(Collection<Long> unitOrgIds) {
        String paramKey = "autocreatebilltype";
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(unitOrgIds.size());
        boolean isAutoReceive = Boolean.FALSE;
        for (Long unitOrg : unitOrgIds) {
            Map sysParaMap = ParamUtil.getSysParameter((String)"eae607fb000143ac", (String)unitOrg.toString());
            Object paramValue = sysParaMap.get(paramKey);
            Object orgAutoReceive = sysParaMap.get("isautoreceive");
            if (orgAutoReceive != null) {
                isAutoReceive = Boolean.parseBoolean(orgAutoReceive.toString());
            }
            if (isAutoReceive && "inbill".equals(paramValue)) {
                resultMap.put(unitOrg, Boolean.TRUE);
                continue;
            }
            resultMap.put(unitOrg, Boolean.FALSE);
        }
        return resultMap;
    }
}

