/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;

public class ScpBillRevokeHelper {
    public static OperationResult revokeListBill(Object[] primaryKeyValues, String entityNumber) {
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)entityNumber, (String)"id,billstatus", (QFilter[])qFilter.toArray());
        ArrayList<Long> submitList = new ArrayList<Long>(dynList.size());
        ArrayList<Long> auditList = new ArrayList<Long>(dynList.size());
        for (DynamicObject dyn : dynList) {
            Long billid = dyn.getLong("id");
            String billstatus = dyn.getString("billstatus");
            if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                auditList.add(billid);
                continue;
            }
            submitList.add(billid);
        }
        OperateOption option = OperateOption.create();
        OperationResult unauditResult = null;
        if (!auditList.isEmpty() && (unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (Object[])auditList.toArray(), (OperateOption)option)) != null && unauditResult.isSuccess() && StringUtils.isEmpty((Object)unauditResult.getMessage())) {
            Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)"unaudit");
            unauditResult.setMessage(LocaleString.fromMap((Map)((Map)entityOperate.get("successMsg"))).getLocaleValue());
        }
        OperationResult unsubmitResult = null;
        if (!submitList.isEmpty() && (unsubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)entityNumber, (Object[])submitList.toArray(), (OperateOption)option)) != null && unsubmitResult.isSuccess() && StringUtils.isEmpty((Object)unsubmitResult.getMessage())) {
            Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)"unsubmit");
            unsubmitResult.setMessage(LocaleString.fromMap((Map)((Map)entityOperate.get("successMsg"))).getLocaleValue());
        }
        OperationResult operationResult = unauditResult;
        if (unsubmitResult != null) {
            if (operationResult == null) {
                operationResult = unsubmitResult;
            } else {
                operationResult.mergeOperateResult(unsubmitResult);
            }
        }
        return operationResult;
    }
}

