/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.LanguageHelper;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.scp.business.ScpBillParamHelper;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpDeliveryScheduleHelper {
    public static final String SCP_SCHEDULE_DELIVERY = "scp_scheduledelivery";
    private static final Log log = LogFactory.getLog((String)ScpDeliveryScheduleHelper.class.getName());

    public static Map<String, Object> executeDeliver(DynamicObject[] dynamicObjects, Set<String> deliverEntryId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.TRUE);
        if (deliverEntryId.size() > 0) {
            Map<String, String> deliveryExtEntryPro = ScpDeliveryScheduleHelper.assembleDeliveryExtEntryPro();
            returnMap.putAll(ScpDeliveryScheduleHelper.doMultiRowExecute(dynamicObjects, new ArrayList<String>(deliverEntryId), deliveryExtEntryPro));
        } else {
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6ee1\u8db3\u53d1\u8d27\u6761\u4ef6\u7684\u884c\u3002", (String)"ScpDeliveryScheduleHelper_1", (String)"scm-scp-business", (Object[])new Object[0]));
        }
        return returnMap;
    }

    public static Boolean verifyIsDraw(Long billId) {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurDeliveryScheduleService", (String)"verifyIsDraw", (Object[])new Object[]{billId});
    }

    @Deprecated
    public static Set<String> assembleCanDeliveryData(DynamicObject[] dynamicObjects) {
        HashSet<Long> selectRows = new HashSet<Long>(156);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                selectRows.add(row.getLong("id"));
            }
        }
        return ScpDeliveryScheduleHelper.assembleCanDeliveryData(dynamicObjects, selectRows);
    }

    public static Set<String> assembleCanDeliveryData(DynamicObject[] dynamicObjects, Set<Long> selectRows) {
        HashSet<String> canDeliveryEntry = new HashSet<String>(156);
        StringBuilder checkMessage = new StringBuilder();
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId)) continue;
                String seq = row.getString("seq");
                String promisestatus = row.getString("promisestatus");
                String entrystatus = row.getString("entrystatus");
                BigDecimal promiseqty = row.getBigDecimal("promiseqty");
                BigDecimal sumoutstockqty = row.getBigDecimal("sumoutstockqty");
                Date promisedate = row.getDate("promisedate");
                LocalDate localStartday = LocalDate.now(ZoneId.systemDefault()).atStartOfDay().toLocalDate();
                LocalDate localDeliDate = null;
                if (promisedate != null) {
                    localDeliDate = promisedate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                }
                if (promiseqty.compareTo(BigDecimal.ZERO) > 0 && sumoutstockqty.compareTo(promiseqty) >= 0) {
                    checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u5df2\u53d1\u8d27\u6570\u91cf\u5c0f\u4e8e\u786e\u8ba4\u6570\u91cf\u65f6\u624d\u80fd\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleHelper_5", (String)"scm-scp-business", (Object[])new Object[]{seq})).append("\r\n");
                    continue;
                }
                if ("D".equalsIgnoreCase(promisestatus) || !"A".equalsIgnoreCase(entrystatus)) {
                    checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u884c\u72b6\u6001\u4e3a\u6b63\u5e38\u5e76\u4e14\u91c7\u8d2d\u65b9\u5df2\u786e\u8ba4\u7684\u5206\u5f55\u624d\u5141\u8bb8\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleHelper_8", (String)"scm-scp-business", (Object[])new Object[]{seq})).append("\r\n");
                    continue;
                }
                if ("A".equalsIgnoreCase(promisestatus) || "C".equalsIgnoreCase(promisestatus) || !"A".equalsIgnoreCase(entrystatus)) {
                    checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u884c\u72b6\u6001\u4e3a\u6b63\u5e38\u5e76\u4e14\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u5206\u5f55\u624d\u5141\u8bb8\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleHelper_6", (String)"scm-scp-business", (Object[])new Object[]{seq})).append("\r\n");
                    continue;
                }
                if (localDeliDate != null && localStartday.isAfter(localDeliDate)) {
                    checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u786e\u8ba4\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"ScpDeliveryScheduleHelper_7", (String)"scm-scp-business", (Object[])new Object[]{seq})).append("\r\n");
                    continue;
                }
                canDeliveryEntry.add(String.valueOf(entryId));
            }
        }
        if (checkMessage.length() > 0) {
            throw new KDException(new ErrorCode("SRMEXCEPTIONCODE001", checkMessage.toString()), new Object[0]);
        }
        return canDeliveryEntry;
    }

    public static boolean verifyUniqueSourceBill(DynamicObject[] dynamicObjects, Set<Long> selectRows) {
        HashSet<String> sourceOrderEntry = new HashSet<String>(selectRows.size());
        HashSet<String> sourceEmptyEntry = new HashSet<String>(selectRows.size());
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId)) continue;
                String srcbillid = row.getString("srcbillid");
                if (!srcbillid.isEmpty() && !"0".equals(srcbillid)) {
                    sourceOrderEntry.add(srcbillid);
                    continue;
                }
                sourceEmptyEntry.add(srcbillid);
            }
        }
        return sourceOrderEntry.isEmpty() || sourceEmptyEntry.isEmpty();
    }

    public static boolean verifySourceOrderBill(DynamicObject[] dynamicObjects, Set<Long> selectRows) {
        HashSet<String> sourceOrderEntry = new HashSet<String>(selectRows.size());
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                String srcbillid;
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId) || (srcbillid = row.getString("srcbillid")).isEmpty() || "0".equals(srcbillid)) continue;
                sourceOrderEntry.add(srcbillid);
            }
        }
        return !sourceOrderEntry.isEmpty();
    }

    public static Map<String, Object> verifyDraftSaloutStockBill(DynamicObject[] dynamicObjects, Set<Long> selectRows) {
        HashSet<String> checkScheduleEntry = new HashSet<String>(selectRows.size());
        HashSet<Long> scheduleBillIds = new HashSet<Long>(selectRows.size());
        HashSet<Long> orderBillIds = new HashSet<Long>(selectRows.size());
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                Long entryId = row.getLong("id");
                if (!selectRows.contains(entryId)) continue;
                String billid = bill.getString("id");
                String entryid = row.getString("id");
                String srcbillid = row.getString("srcbillid");
                if (!entryid.isEmpty() && !"0".equals(entryid)) {
                    checkScheduleEntry.add(entryid);
                }
                if (!billid.isEmpty() && !"0".equals(billid)) {
                    scheduleBillIds.add(Long.parseLong(billid));
                }
                if (srcbillid.isEmpty() || "0".equals(srcbillid)) continue;
                orderBillIds.add(Long.parseLong(billid));
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        if (!checkScheduleEntry.isEmpty()) {
            resultMap.putAll(ScpOrderBillHelper.assembleEntryCheckMessage(orderBillIds));
            resultMap.putAll(ScpDeliveryScheduleHelper.assembleEntryCheckMessage(scheduleBillIds));
            if (!ScpBillParamHelper.getBooleanBillParam("scp_saloutstock", "verifydraftbill").booleanValue()) {
                resultMap.putAll(ScpSalOutStockBillHelper.verifySalOutDraftData(checkScheduleEntry, Boolean.FALSE));
            }
            scheduleBillIds.clear();
            checkScheduleEntry.clear();
        }
        return resultMap;
    }

    public static Map<String, Object> assembleEntryCheckMessage(Set<Long> scheduleBillIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        Set<Long> allSalOutEntry = ScpDeliveryScheduleHelper.assembleAvailableEntry(scheduleBillIds);
        if (allSalOutEntry.isEmpty()) {
            resultMap.put("succed", Boolean.FALSE);
            String tips = ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5168\u90e8\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleHelper_3", (String)"scm-scp-business", (Object[])new Object[0]);
            resultMap.put("message", tips);
        }
        return resultMap;
    }

    public static Set<Long> assembleAvailableEntry(Set<Long> scheduleBillIds) {
        HashSet<Long> allSalOutEntry = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)SCP_SCHEDULE_DELIVERY, (String)"id,materialentry.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", scheduleBillIds).and(QFilter.of((String)"materialentry.relateoutstockbasicqty < materialentry.promisebasicqty ", (Object[])new Object[0]))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryid = row.getLong("entryid");
                allSalOutEntry.add(entryid);
            }
        }
        return allSalOutEntry;
    }

    public static OperationResult executeConfirmPromiseCheck(Object[] pkIds, ListSelectedRowCollection listSelectedRows) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", "scp");
        operateOption.setVariableValue("isOnlyValidator", "true");
        String str = SerializationUtils.toJsonString((Object)listSelectedRows);
        operateOption.setVariableValue("bos_listselectedrowcollection", str);
        return OperationServiceHelper.executeOperate((String)"confirmpromise", (String)SCP_SCHEDULE_DELIVERY, (Object[])pkIds, (OperateOption)operateOption);
    }

    public static OperationResult executeConfirmPromise(DynamicObject[] dynamicObjects, ListSelectedRowCollection listSelectedRows) {
        DynamicObjectCollection rows;
        OperateOption operateOption = OperateOption.create();
        HashSet<Object> selectedEntryIds = new HashSet<Object>(listSelectedRows.size());
        for (ListSelectedRow selectedRow : listSelectedRows) {
            selectedEntryIds.add(selectedRow.getEntryPrimaryKeyValue());
        }
        operateOption.setVariableValue("currbizappid", "scp");
        String str = SerializationUtils.toJsonString((Object)listSelectedRows);
        operateOption.setVariableValue("bos_listselectedrowcollection", str);
        StringBuilder validFalseSelectRowIds = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            rows = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                Object entryPkId = row.getPkValue();
                int rowIndex = row.getInt("seq");
                if (!selectedEntryIds.contains(entryPkId)) continue;
                BigDecimal promiseqtyValue = row.getBigDecimal("promiseqty");
                Date promisedateValue = row.getDate("promisedate");
                if (promisedateValue != null && promiseqtyValue.compareTo(BigDecimal.ZERO) != 0) continue;
                validFalseSelectRowIds.append(rowIndex).append(",");
            }
        }
        if (validFalseSelectRowIds != null && validFalseSelectRowIds.length() > 0) {
            validFalseSelectRowIds.deleteCharAt(validFalseSelectRowIds.length() - 1);
            String errorMessage = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c\uff08{0}\uff09\u884c\u786e\u8ba4\u6570\u91cf\u548c\u786e\u8ba4\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScpDeliveryScheduleHelper_0", (String)"scm-scp-business", (Object[])new Object[0]), validFalseSelectRowIds.toString());
            OperationResult result = new OperationResult();
            result.setMessage(errorMessage);
            result.setSuccess(false);
            return result;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            rows = dynamicObject.getDynamicObjectCollection("materialentry");
            DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
            DynamicProperty promiseqty = dynamicObjectType.getProperty("promiseqty");
            DynamicProperty promisebasicqty = dynamicObjectType.getProperty("promisebasicqty");
            DynamicProperty promisedate = dynamicObjectType.getProperty("promisedate");
            DynamicProperty supplierremark = dynamicObjectType.getProperty("supplierremark");
            for (DynamicObject row : rows) {
                Object entryPkId = row.getPkValue();
                if (!row.getDataEntityState().isChanged() || selectedEntryIds.contains(entryPkId)) continue;
                if (promiseqty != null) {
                    promiseqty.setValue((Object)row, (Object)BigDecimal.ZERO);
                }
                if (promisebasicqty != null) {
                    promisebasicqty.setValue((Object)row, (Object)BigDecimal.ZERO);
                }
                if (promisedate != null) {
                    promisedate.setValue((Object)row, null);
                }
                if (supplierremark == null) continue;
                supplierremark.setValue((Object)row, (Object)"");
            }
        }
        return OperationServiceHelper.executeOperate((String)"confirmpromise", (String)SCP_SCHEDULE_DELIVERY, (DynamicObject[])dynamicObjects, (OperateOption)operateOption);
    }

    private static Map<String, Object> doMultiRowExecute(DynamicObject[] dynamicObjects, List<String> canDeliverEntryId, Map<String, String> deliveryExtEntryPro) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.TRUE);
        returnMap.put("message", "");
        LinkedHashMap<Long, Collection<Long>> pushScheduleData = new LinkedHashMap<Long, Collection<Long>>(20);
        LinkedHashMap<String, List<Map<String, String>>> rowDeliverInfoMap = new LinkedHashMap<String, List<Map<String, String>>>(56);
        ArrayList<HashMap<String, String>> orderInfoS = null;
        HashMap<String, String> orderInfoMap = null;
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(1024);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                Long billId = bill.getLong("id");
                Long entryId = row.getLong("id");
                if (!canDeliverEntryId.contains(entryId.toString())) continue;
                orderInfoMap = new HashMap<String, String>();
                ArrayList<Long> orderEntry = (ArrayList<Long>)pushScheduleData.get(billId);
                if (orderEntry != null) {
                    orderEntry.add(entryId);
                } else {
                    orderEntry = new ArrayList<Long>(16);
                    orderEntry.add(entryId);
                    pushScheduleData.put(billId, orderEntry);
                }
                orderInfoMap.put("entryid_" + entryId, row.getString("srcentryid"));
                orderInfoS = new ArrayList<HashMap<String, String>>(1024);
                orderInfoS.add(orderInfoMap);
                srcOrderEntryIds.add(Long.parseLong(row.getString("srcentryid")));
                rowDeliverInfoMap.put(entryId.toString(), orderInfoS);
            }
        }
        if (!pushScheduleData.isEmpty()) {
            returnMap.putAll(ScpDeliveryScheduleHelper.pushMultiRowExecute(pushScheduleData, rowDeliverInfoMap, srcOrderEntryIds));
        }
        return returnMap;
    }

    @Deprecated
    public static Map<String, Object> pushMultiRowExecute(Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowDeliverInfoMap) {
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(1024);
        return ScpDeliveryScheduleHelper.pushMultiRowExecute(pushOrderData, rowDeliverInfoMap, srcOrderEntryIds);
    }

    public static Map<String, Object> pushMultiRowExecute(Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowDeliverInfoMap, Collection<Long> srcOrderEntryIds) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.TRUE);
        returnMap.put("message", "");
        ConvertRuleElement convertRuleElementParam = ScpDeliveryScheduleHelper.getConvertRuleElement();
        if (convertRuleElementParam != null) {
            log.info(convertRuleElementParam.getName().getLocaleValue());
            PushArgs pushArgs = new PushArgs();
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
                Long entryKey = entry.getKey();
                for (Long next : entry.getValue()) {
                    ListSelectedRow listSelectedRow = new ListSelectedRow();
                    listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                    listSelectedRow.setEntryEntityKey("materialentry");
                    listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                    selectedRowList.add(listSelectedRow);
                }
            }
            pushArgs.setSourceEntityNumber("pur_deliveryschedule");
            pushArgs.setTargetEntityNumber("scp_saloutstock");
            pushArgs.setBuildConvReport(true);
            pushArgs.setRuleId(convertRuleElementParam.getId());
            pushArgs.setSelectedRows(selectedRowList);
            for (Map.Entry<Object, Collection<Object>> entry : rowDeliverInfoMap.entrySet()) {
                pushArgs.addCustomParam((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
            }
            pushArgs.addCustomParam("srcOrderEntryIds", SerializationUtils.toJsonString(srcOrderEntryIds));
            returnMap.putAll(ScpDeliveryScheduleHelper.executePush(pushArgs));
        }
        return returnMap;
    }

    private static ConvertRuleElement getConvertRuleElement() {
        List ruleList;
        ConvertRuleElement convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)"1722045229550613504");
        if (!(convertRuleElementParam != null && convertRuleElementParam.isEnabled() || (ruleList = ConvertMetaServiceHelper.loadRules((String)"pur_deliveryschedule", (String)"scp_saloutstock")) == null || ruleList.isEmpty())) {
            for (ConvertRuleElement convertRuleElement : ruleList) {
                if (convertRuleElement.isEnabled() && convertRuleElement.isDefRule()) {
                    convertRuleElementParam = convertRuleElement;
                    break;
                }
                if (!convertRuleElement.isEnabled()) continue;
                convertRuleElementParam = convertRuleElement;
                break;
            }
        }
        return convertRuleElementParam;
    }

    public static Map<String, Object> executePush(PushArgs pushArgs) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.TRUE);
        returnMap.put("message", "");
        pushArgs.addCustomParam("ignorechecksource", "true");
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result != null) {
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"scp_saloutstock");
                IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                    }
                };
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                result.release(refDataProvider, mainType);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)"scp_saloutstock", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                if (operationResult != null) {
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        returnMap.put("data", operationResult.getSuccessPkIds());
                        returnMap.put("succed", Boolean.TRUE);
                    } else {
                        returnMap.put("succed", Boolean.FALSE);
                        StringBuilder messageError = new StringBuilder();
                        messageError.append(operationResult.getMessage()).append("\r\n");
                        operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\r\n"));
                        returnMap.put("message", messageError.toString());
                    }
                }
            } else {
                returnMap.put("succed", Boolean.FALSE);
                StringBuilder message = new StringBuilder();
                message.append(result.getMessage()).append("\r\n");
                result.getBillReports().forEach(row -> message.append(row.getFailMessage()).append("\r\n"));
                returnMap.put("message", message.toString());
            }
        } else {
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38", (String)"ScmcUtil_13", (String)"scm-common", (Object[])new Object[0]));
        }
        return returnMap;
    }

    public static String getOpName() {
        Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)SCP_SCHEDULE_DELIVERY, (String)"confirmpromise");
        return LanguageHelper.getLocalValue(entityOperate.get("name"));
    }

    public static String getOpMessage() {
        Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)SCP_SCHEDULE_DELIVERY, (String)"confirmpromise");
        return LanguageHelper.getLocalValue(entityOperate.get("successMsg"));
    }

    public static Boolean verifySupplierUserCanDo(Object billId) {
        HashSet<Long> availablePks = new HashSet<Long>(1);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)SCP_SCHEDULE_DELIVERY, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", billId).and(new QFilter("billstatus", "=", (Object)"C")).and(BizPartnerUtil.assembleQFilterBizPartner())}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                availablePks.add(row.getLong("id"));
            }
        }
        return !availablePks.isEmpty();
    }

    public static Map<String, String> assembleDeliveryExtEntryPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        return sdkEntryMap;
    }

    public static Map<String, String> assembleDeliveryExtStockBill(DynamicObject bill, Map<String, String> sdkEntryMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, sdkEntryMap, (boolean)false));
        return extStockData;
    }

    public static void writeBackRelateSalOutQty(Map<Long, Map<String, BigDecimal>> paramMap) {
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurDeliveryScheduleService", (String)"updateRelateSalOutQty", (Object[])new Object[]{paramMap});
    }

    public static FormShowParameter assembleShowParameter(Object entryId) {
        return (FormShowParameter)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurDeliveryScheduleService", (String)"assembleShowParameter", (Object[])new Object[]{entryId});
    }

    public static List<Long> getLinkSalStockBillIds(Collection<Long> entryIds) {
        HashSet selectRowEntryIds = new HashSet();
        entryIds.forEach(row -> selectRowEntryIds.add(row.toString()));
        ArrayList<Long> linkSalOutIds = new ArrayList<Long>(56);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_saloutstock", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.dsentryid", "in", selectRowEntryIds)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                linkSalOutIds.add(row2.getLong("id"));
            }
        }
        return linkSalOutIds;
    }

    public static Set<Long> assembleSelectRowIds(String listselectedrowcollection) {
        Object[] entryPrimaryKeyValues;
        ListSelectedRowCollection rows;
        HashSet<Long> selectRows = new HashSet<Long>(156);
        if (StringUtils.isNotBlank((CharSequence)listselectedrowcollection) && (rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)listselectedrowcollection, ListSelectedRowCollection.class)) != null && !rows.isEmpty() && (entryPrimaryKeyValues = rows.getEntryPrimaryKeyValues()) != null) {
            Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
        }
        return selectRows;
    }
}

