/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;
import kd.scm.scp.business.ScpBillParamHelper;
import kd.scm.scp.business.ScpBillTypeHelper;
import kd.scm.scp.business.ScpDeliveryScheduleHelper;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpDeliveryScheduleMatchHelper {
    private static final Log log = LogFactory.getLog((String)ScpDeliveryScheduleMatchHelper.class.getName());

    public static List<Long> assembleCanDeliveryData(List<DynamicObject> dynamicObjectCollection) {
        ArrayList<Long> canDeliveryEntry = new ArrayList<Long>(64);
        StringBuilder checkMessage = new StringBuilder();
        for (DynamicObject bill : dynamicObjectCollection) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                Long l = row.getLong("id");
            }
        }
        return canDeliveryEntry;
    }

    public static Map<Long, String> getUnConfirmOrderBillNos(List<DynamicObject> dynamicObjects) {
        HashSet<Long> orderBillIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            orderBillIds.add(dynamicObject.getLong("orderbillid1"));
        }
        HashMap<Long, String> unConfirmBillNoMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_order", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", orderBillIds).and("cfmstatus", "=", (Object)"A")}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                unConfirmBillNoMap.put(row.getLong("id"), row.getString("billno"));
            }
        }
        return unConfirmBillNoMap;
    }

    public static Map<String, Object> verifyDraftSaloutStockBill(List<DynamicObject> dynamicObjectCollection) {
        HashSet<String> checkScheduleEntry = new HashSet<String>(dynamicObjectCollection.size());
        HashSet<Long> scheduleBillIds = new HashSet<Long>(dynamicObjectCollection.size());
        HashSet<Long> orderBillIds = new HashSet<Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String orderbillid1 = dynamicObject.getString("orderbillid1");
            String schedulebillid1 = dynamicObject.getString("schedulebillid1");
            String scheduleentryid = dynamicObject.getString("scheduleentryid1");
            if (!orderbillid1.isEmpty() && !"0".equals(orderbillid1)) {
                orderBillIds.add(Long.parseLong(orderbillid1));
            }
            if (!scheduleentryid.isEmpty() && !"0".equals(scheduleentryid)) {
                checkScheduleEntry.add(scheduleentryid);
            }
            if (schedulebillid1.isEmpty() || "0".equals(schedulebillid1)) continue;
            scheduleBillIds.add(Long.parseLong(schedulebillid1));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        if (!checkScheduleEntry.isEmpty()) {
            resultMap.putAll(ScpOrderBillHelper.assembleEntryCheckMessage(orderBillIds));
            resultMap.putAll(ScpDeliveryScheduleHelper.assembleEntryCheckMessage(scheduleBillIds));
            if (!ScpBillParamHelper.getBooleanBillParam("scp_saloutstock", "verifydraftbill").booleanValue()) {
                resultMap.putAll(ScpSalOutStockBillHelper.verifySalOutDraftData(checkScheduleEntry, Boolean.FALSE));
            }
            scheduleBillIds.clear();
            checkScheduleEntry.clear();
            orderBillIds.clear();
        }
        return resultMap;
    }

    public static Map<String, Object> executeScheduleMatchOrderDeliver(List<DynamicObject> dynamicObjectCollection) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.TRUE);
        returnMap.put("message", "");
        LinkedHashMap<Long, Collection<Long>> pushScheduleData = new LinkedHashMap<Long, Collection<Long>>(20);
        LinkedHashMap<String, List<Map<String, String>>> rowDeliverInfoMap = new LinkedHashMap<String, List<Map<String, String>>>(56);
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(1024);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long schedulebillid = dynamicObject.getLong("schedulebillid1");
            Long scheduleentryid = dynamicObject.getLong("scheduleentryid1");
            if (schedulebillid.equals(0L) || scheduleentryid.equals(0L)) continue;
            HashSet<Long> collection = (HashSet<Long>)pushScheduleData.get(schedulebillid);
            if (collection == null) {
                collection = new HashSet<Long>();
            }
            collection.add(scheduleentryid);
            pushScheduleData.put(schedulebillid, collection);
            List<Map<String, String>> salOutInfoS = rowDeliverInfoMap.get(scheduleentryid.toString());
            if (salOutInfoS != null) {
                salOutInfoS.add(ScpDeliveryScheduleMatchHelper.assembleCosmicSelfParam(dynamicObject));
            } else {
                salOutInfoS = new ArrayList<Map<String, String>>();
                salOutInfoS.add(ScpDeliveryScheduleMatchHelper.assembleCosmicSelfParam(dynamicObject));
                rowDeliverInfoMap.put(scheduleentryid.toString(), salOutInfoS);
            }
            srcOrderEntryIds.add(dynamicObject.getLong("orderentryid1"));
        }
        returnMap.putAll(ScpDeliveryScheduleHelper.pushMultiRowExecute(pushScheduleData, rowDeliverInfoMap, srcOrderEntryIds));
        return returnMap;
    }

    private static Map<String, String> assembleCosmicSelfParam(DynamicObject dynamicObject) {
        LinkedHashMap<String, String> orderInfoMap = new LinkedHashMap<String, String>(64);
        String scheduleentryid = dynamicObject.getString("scheduleentryid1");
        String billId = dynamicObject.getString("orderbillid1");
        String billNo = dynamicObject.getString("orderbillno1");
        String entryId = dynamicObject.getString("orderentryid1");
        String unit = dynamicObject.getString("unit1.id");
        BigDecimal matchorderbasicqty = dynamicObject.getBigDecimal("matchorderbasicqty1");
        orderInfoMap.put("billid_" + scheduleentryid, billId);
        orderInfoMap.put("billno_" + scheduleentryid, billNo);
        orderInfoMap.put("entryid_" + scheduleentryid, entryId);
        orderInfoMap.put("matchorderbasicqty_" + scheduleentryid, matchorderbasicqty.toPlainString());
        orderInfoMap.put("unit_" + scheduleentryid, unit);
        return orderInfoMap;
    }

    public static Map<String, BigDecimal> getSalOutAvailableQtyMap(List<String> dsEntryIds) {
        HashMap<String, BigDecimal> availableQtyMap = new HashMap<String, BigDecimal>(16);
        try (DataSet salOutDataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_saloutstock", (String)"materialentry.basicqty basicqty,materialentry.entrystatus entrystatus,( materialentry.basicqty - materialentry.sumreceiptqty) sumreceiptqty,( materialentry.basicqty - materialentry.suminstockqty) suminstockqty,materialentry.dsentryid dsentryid,materialentry.sumreceiptbaseqty sumreceiptbaseqty,materialentry.suminstockbaseqty suminstockbaseqty", (QFilter[])new QFilter[]{new QFilter("materialentry.dsentryid", "in", dsEntryIds)}, (String)"id");){
            while (salOutDataSet.hasNext()) {
                Row row = salOutDataSet.next();
                String dsentryid = row.getString("dsentryid");
                BigDecimal basicqty = row.getBigDecimal("basicqty");
                String entrystatus = row.getString("entrystatus");
                BigDecimal suminstockqty = row.getBigDecimal("suminstockqty");
                BigDecimal sumreceiptqty = row.getBigDecimal("sumreceiptqty");
                BigDecimal availableQty = (BigDecimal)availableQtyMap.get(dsentryid);
                if (availableQty == null) {
                    availableQty = BigDecimal.ZERO;
                }
                BigDecimal maxStockQty = null;
                maxStockQty = suminstockqty.compareTo(sumreceiptqty) >= 0 ? basicqty.subtract(suminstockqty) : basicqty.subtract(sumreceiptqty);
                if ("B".equals(entrystatus)) {
                    availableQty = maxStockQty.compareTo(BigDecimal.ZERO) == 0 ? availableQty.add(basicqty) : availableQty.add(basicqty.subtract(maxStockQty));
                } else if ("A".equals(entrystatus)) {
                    availableQty = availableQty.add(suminstockqty);
                }
                availableQtyMap.put(dsentryid, availableQty);
            }
        }
        return availableQtyMap;
    }

    public static DataSet getScheduleDeliverData(List<Long> entryIds) {
        HashSet<String> properties = new HashSet<String>(64);
        properties.add("billno");
        properties.add("org");
        properties.add("supplier");
        properties.add("material");
        properties.add("basicunit");
        properties.add("unit");
        properties.add("deliverydate");
        properties.add("promisebasicqty");
        properties.add("promiseqty");
        properties.add("promisedate");
        properties.add("entryrcvorg");
        properties.add("estimateddeliverydate");
        properties.add("warehouse");
        properties.add("deliaddr");
        String entityFields = ScpBillTypeHelper.getEntityFields("scp_scheduledelivery", properties);
        return QueryServiceHelper.queryDataSet((String)"", (String)"scp_scheduledelivery", (String)("id schedulebillid,materialentry.id scheduleentryid," + entityFields), (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", entryIds)}, (String)"billno");
    }

    @Deprecated
    public static DataSet getDeliverOrderData(QFilter qFilter) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        properties.add("org");
        properties.add("supplier");
        properties.add("entryrcvorg");
        properties.add("qty");
        String entityFields = ScpBillTypeHelper.getEntityFields("scp_order", properties);
        return QueryServiceHelper.queryDataSet((String)"", (String)"scp_order", (String)("id orderbillid,billno orderbillno,auditdate orderauditdate,materialentry.id orderentryid,materialentry.seq orderseq,( materialentry.basicqty - materialentry.sumoutstockbaseqty + materialentry.sumrefundbaseqty) availableqty,( materialentry.basicqty - materialentry.sumreceiptbaseqty + materialentry.sumrefundbaseqty) availablereceiptqty,( materialentry.basicqty - materialentry.suminstockbaseqty + materialentry.sumrefundbaseqty) availableinstockqty," + entityFields), (QFilter[])new QFilter[]{qFilter}, (String)"auditdate asc");
    }

    public static List<DynamicObject> getDeliverOrderCollectionData(QFilter qFilter) {
        Collection properties = OrderAvailableStockQtyHelper.assmibleMustProperties();
        properties.add("org");
        properties.add("supplier");
        properties.add("entryrcvorg");
        properties.add("qty");
        String entityFields = ScpBillTypeHelper.getEntityFields("scp_order", properties);
        return OrderAvailableStockQtyHelper.queryOrderData((QFilter)qFilter, (String)("id orderbillid,billno orderbillno,auditdate orderauditdate,materialentry.seq orderseq,( materialentry.basicqty - materialentry.sumoutstockbaseqty + materialentry.sumrefundbaseqty) availableqty,( materialentry.basicqty - materialentry.sumreceiptbaseqty + materialentry.sumrefundbaseqty) availablereceiptqty,( materialentry.basicqty - materialentry.suminstockbaseqty + materialentry.sumrefundbaseqty) availableinstockqty," + entityFields), (String)"auditdate asc", new HashMap());
    }

    public static BigDecimal getMaxAvailableOrderQty(BigDecimal basicQty, BigDecimal relateoutstockbaseqty, BigDecimal sumrefundbaseqty, BigDecimal availableSalOutQty, BigDecimal availableReceiptQty, BigDecimal availableInStockQty) {
        BigDecimal minQty = BigDecimal.valueOf(Double.MAX_VALUE);
        if (log.isInfoEnabled()) {
            log.info("MaxAvailableOrderQty#basicQty:{},relateoutstockbaseqty:{},sumrefundbaseqty:{},availableSalOutQty:{},availableReceiptQty:{},availableInStockQty:{}", new Object[]{String.valueOf(basicQty), String.valueOf(relateoutstockbaseqty), String.valueOf(sumrefundbaseqty), String.valueOf(availableSalOutQty), String.valueOf(availableReceiptQty), String.valueOf(availableInStockQty)});
        }
        if (availableInStockQty != null && minQty.compareTo(availableInStockQty) > 0) {
            minQty = availableInStockQty;
        }
        if (availableReceiptQty != null && minQty.compareTo(availableReceiptQty) > 0) {
            minQty = availableReceiptQty;
        }
        BigDecimal fixedAvailableSalOutQty = BigDecimal.ZERO;
        if (availableSalOutQty != null && relateoutstockbaseqty != null && sumrefundbaseqty != null) {
            BigDecimal actOrderBasicQty = basicQty.add(sumrefundbaseqty);
            BigDecimal actMaxStockBillQty = actOrderBasicQty.subtract(minQty);
            BigDecimal subBasicQty = relateoutstockbaseqty.subtract(actMaxStockBillQty);
            fixedAvailableSalOutQty = subBasicQty.compareTo(BigDecimal.ZERO) > 0 ? actOrderBasicQty.subtract(relateoutstockbaseqty) : (subBasicQty.compareTo(BigDecimal.ZERO) < 0 ? actOrderBasicQty.subtract(subBasicQty.abs()).subtract(relateoutstockbaseqty) : availableSalOutQty);
            minQty = fixedAvailableSalOutQty;
            if (log.isInfoEnabled()) {
                log.info("actOrderBasicQty:{},actMaxStockBillQty:{}:subBasicQty:{},fixedAvailableSalOutQty:{}", new Object[]{String.valueOf(actOrderBasicQty), String.valueOf(actMaxStockBillQty), String.valueOf(subBasicQty), String.valueOf(fixedAvailableSalOutQty)});
            }
        }
        return minQty;
    }

    public static void storeInitStockQty(QFilter qFilter) {
        qFilter.and(new QFilter("materialentry.sumreceiptbaseqty", ">", (Object)BigDecimal.ZERO).or(new QFilter("materialentry.suminstockbaseqty", ">", (Object)BigDecimal.ZERO))).and(new QFilter("materialentry.relateoutstockbaseqty", "=", (Object)BigDecimal.ZERO).or(new QFilter("materialentry.sumoutstockbaseqty", "=", (Object)BigDecimal.ZERO)));
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"scp_order", (String)"materialentry.material,materialentry.basicunit,materialentry.unit,materialentry.relateoutstockqty,materialentry.sumoutstockqty,materialentry.relateoutstockbaseqty,materialentry.sumoutstockbaseqty,materialentry.sumreceiptbaseqty,materialentry.suminstockbaseqty,", (QFilter[])new QFilter[]{qFilter});
        if (orders != null) {
            for (DynamicObject order : orders) {
                DynamicObjectCollection rows = order.getDynamicObjectCollection("materialentry");
                DynamicObjectType rowsDynamicObjectType = rows.getDynamicObjectType();
                DynamicProperty relateoutstockbaseqtyPro = rowsDynamicObjectType.getProperty("relateoutstockbaseqty");
                DynamicProperty relateoutstockqtyPro = rowsDynamicObjectType.getProperty("relateoutstockqty");
                DynamicProperty sumoutstockqtyPro = rowsDynamicObjectType.getProperty("sumoutstockqty");
                DynamicProperty sumoutstockbaseqtyPro = rowsDynamicObjectType.getProperty("sumoutstockbaseqty");
                for (DynamicObject row : rows) {
                    BigDecimal suminstockbaseqty;
                    BigDecimal relateoutstockbaseqty = row.getBigDecimal("relateoutstockbaseqty");
                    BigDecimal relateoutstockqty = row.getBigDecimal("relateoutstockqty");
                    BigDecimal sumoutstockqty = row.getBigDecimal("sumoutstockqty");
                    BigDecimal sumoutstockbaseqty = row.getBigDecimal("sumoutstockbaseqty");
                    DynamicObject material = row.getDynamicObject("material");
                    DynamicObject basicunit = row.getDynamicObject("basicunit");
                    DynamicObject unit = row.getDynamicObject("unit");
                    BigDecimal sumreceiptbaseqty = row.getBigDecimal("sumreceiptbaseqty");
                    BigDecimal maxStockBasicQty = sumreceiptbaseqty.compareTo(suminstockbaseqty = row.getBigDecimal("suminstockbaseqty")) >= 0 ? sumreceiptbaseqty : suminstockbaseqty;
                    BigDecimal maxStockQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicunit, (BigDecimal)maxStockBasicQty, (DynamicObject)unit);
                    if (relateoutstockbaseqty.compareTo(BigDecimal.ZERO) == 0 || relateoutstockqty.compareTo(BigDecimal.ZERO) == 0) {
                        relateoutstockbaseqtyPro.setValue((Object)row, (Object)maxStockBasicQty);
                        sumoutstockbaseqtyPro.setValue((Object)row, (Object)maxStockBasicQty);
                        relateoutstockqtyPro.setValue((Object)row, (Object)maxStockQty);
                        sumoutstockqtyPro.setValue((Object)row, (Object)maxStockQty);
                        continue;
                    }
                    if (sumoutstockqty.compareTo(BigDecimal.ZERO) != 0 && sumoutstockbaseqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    sumoutstockbaseqtyPro.setValue((Object)row, (Object)maxStockBasicQty);
                    sumoutstockqtyPro.setValue((Object)row, (Object)maxStockQty);
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
    }
}

