/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.common.util.ScpPmStatusUtil;

public final class ScpScDataHandleHelper {
    private static Log log = LogFactory.getLog(ScpScDataHandleHelper.class);

    public static ScDataHandleResult execOrderConfirm(DynamicObject[] dynamicObjects, Boolean scconsistencyservice) {
        ScDataHandleResult scDataHandleResult = null;
        if (scconsistencyservice.booleanValue()) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderconfirm", (DynamicObject[])dynamicObjects);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
            if (ApiConfigUtil.hasCQScmConfig()) {
                ArrayList<String> allowLogisticsStatus = new ArrayList<String>();
                allowLogisticsStatus.add("");
                allowLogisticsStatus.add(LogisticsStatusEnum.CONFIRM.getVal());
                ScpPmStatusUtil.updatePmStatus((DynamicObject[])dynamicObjects, (String)ConfirmStatusEnum.CONFIRM.getVal(), allowLogisticsStatus);
            } else if (ApiConfigUtil.hasEASScmConfig() || ApiConfigUtil.hasXKScmConfig()) {
                scDataHandleResult = ScpScDataHandleHelper.doExecuteCosmicOrderConfirm(dynamicObjects);
            }
        }
        return scDataHandleResult;
    }

    @Deprecated
    public static ScDataHandleResult doExecuteCosmicOrderConfirm(DynamicObject[] dynamicObjects) {
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        HashMap<String, Object> param = new HashMap<String, Object>();
        Set<String> billnoSet = ScpOrderBillHelper.getBillNoSetOfConfirmStatus(dynamicObjects, ConfirmStatusEnum.CONFIRM.getVal());
        String msg = "500";
        if (billnoSet.size() > 0) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("billno", billnoSet);
            dataMap.put("cmfstatus", "3");
            param.put("data", dataMap);
            param.put("billtype", "scp_order");
            param.put("action", "confirm");
            param.put("code", "200");
            log.info(((Object)param).toString());
            try {
                msg = ApiUtil.purOrderConfirm(param);
            }
            catch (Exception ex) {
                log.info("\u8ba2\u5355\u786e\u8ba4\u5931\u8d25" + ExceptionUtil.getStackTrace((Throwable)ex));
            }
            log.info("\u786e\u8ba4\u8fd4\u56de" + msg);
        }
        if ("500".equals(msg)) {
            scDataHandleResult.setSuccess(false);
            scDataHandleResult.setMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScpBillConfirmPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        } else if (!"500".equals(msg) && msg.length() > 0) {
            try {
                Map errorMap = (Map)JSONObject.parseObject((String)msg, Map.class);
                boolean IsSuccess = (Boolean)errorMap.get("IsSuccess");
                if (!IsSuccess) {
                    scDataHandleResult.setSuccess(false);
                    scDataHandleResult.setMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScpBillConfirmPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                log.info("\u8ba2\u5355\u786e\u8ba4\u5931\u8d25" + ExceptionUtil.getStackTrace((Throwable)ex));
            }
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult execOrderUnConfirm(DynamicObject[] dynamicObjects, Boolean scconsistencyservice) {
        ScDataHandleResult scDataHandleResult = null;
        if (scconsistencyservice.booleanValue()) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderunconfirm", (DynamicObject[])dynamicObjects);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            if (ApiConfigUtil.hasCQScmConfig()) {
                ArrayList<String> allowLogisticsStatus = new ArrayList<String>();
                allowLogisticsStatus.add("");
                allowLogisticsStatus.add(LogisticsStatusEnum.CONFIRM.getVal());
                ScpPmStatusUtil.updatePmStatus((DynamicObject[])dynamicObjects, (String)ConfirmStatusEnum.UNCONFIRM.getVal(), allowLogisticsStatus);
            } else if (ApiConfigUtil.hasEASScmConfig() || ApiConfigUtil.hasXKScmConfig()) {
                scDataHandleResult = ScpScDataHandleHelper.doExecuteCosmicOrderUnConfirm(dynamicObjects);
            }
        }
        return scDataHandleResult;
    }

    @Deprecated
    public static ScDataHandleResult doExecuteCosmicOrderUnConfirm(DynamicObject[] dynamicObjects) {
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        HashMap<String, Object> param = new HashMap<String, Object>();
        Set<String> billnoSet = ScpOrderBillHelper.getBillNoSetOfConfirmStatus(dynamicObjects, ConfirmStatusEnum.UNCONFIRM.getVal());
        String msg = "500";
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("billno", billnoSet);
        dataMap.put("cmfstatus", ConfirmStatusEnum.UNCONFIRM.getVal());
        param.put("data", dataMap);
        param.put("billtype", "scp_order");
        param.put("action", "unconfirm");
        param.put("code", "200");
        try {
            msg = ApiUtil.purOrderUnConfirm(param);
        }
        catch (Exception ex) {
            log.info("\u8ba2\u5355\u53cd\u786e\u8ba4\u5931\u8d25" + ExceptionUtil.getStackTrace((Throwable)ex));
        }
        if ("500".equals(msg)) {
            scDataHandleResult.setSuccess(false);
            scDataHandleResult.setMessage(ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScpOrderUnConfirmOp_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        } else if (!"500".equals(msg) && msg.length() > 0) {
            try {
                Map errorMap = (Map)JSONObject.parseObject((String)msg, Map.class);
                boolean IsSuccess = (Boolean)errorMap.get("IsSuccess");
                if (!IsSuccess) {
                    scDataHandleResult.setSuccess(false);
                    scDataHandleResult.setMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScpBillConfirmPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                log.info("\u8ba2\u5355\u786e\u8ba4\u5931\u8d25" + ExceptionUtil.getStackTrace((Throwable)ex));
            }
        }
        return scDataHandleResult;
    }

    public static ScDataHandleResult execOrderReject(DynamicObject[] dynamicObjects, Boolean scconsistencyservice) {
        ScDataHandleResult scDataHandleResult = null;
        if (scconsistencyservice.booleanValue()) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"orderreject", (DynamicObject[])dynamicObjects);
        } else if (ApiConfigUtil.hasCQScmConfig()) {
            ArrayList<String> allowLogisticsStatus = new ArrayList<String>();
            allowLogisticsStatus.add("");
            allowLogisticsStatus.add(LogisticsStatusEnum.CONFIRM.getVal());
            allowLogisticsStatus.add(LogisticsStatusEnum.PARTOUTSTOCK.getVal());
            ScpPmStatusUtil.updatePmStatus((DynamicObject[])dynamicObjects, (String)ConfirmStatusEnum.REJECT.getVal(), allowLogisticsStatus);
        } else if (ApiConfigUtil.hasXKScmConfig() || ApiConfigUtil.hasEASScmConfig()) {
            ScpScDataHandleHelper.doExecuteCosmicOrderReject(dynamicObjects);
        }
        return scDataHandleResult;
    }

    @Deprecated
    public static void doExecuteCosmicOrderReject(DynamicObject[] dynamicObjects) {
        String msg = "";
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        param.put("code", "200");
        param.put("action", "reject");
        param.put("billtype", "scp_order");
        data.put("cmfstatus", "2");
        data.put("billno", ScpOrderBillHelper.getBillNoSetOfConfirmStatus(dynamicObjects, ConfirmStatusEnum.REJECT.getVal()));
        param.put("data", data);
        log.info(((Object)param).toString());
        try {
            msg = ApiUtil.purOrderReject(param);
        }
        catch (Exception ex) {
            log.info("\u8ba2\u5355\u6253\u56de\u5931\u8d25" + ExceptionUtil.getStackTrace((Throwable)ex));
        }
    }

    public static ScDataHandleResult execSalOutStockAudit(DynamicObject[] dynamicObjects, Boolean scconsistencyservice) {
        ScDataHandleResult scDataHandleResult = null;
        Map poEntryId_QtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])dynamicObjects);
        HashSet poEntryPks = new HashSet(poEntryId_QtyMap.keySet());
        String seltcor = "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.pobillid, materialentry.poentryid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.sumrefundqty,materialentry.entrystatus,materialentry.rowlogstatus,materialentry.linetype,materialentry.taxamount,materialentry.sumapaccepttaxamount,materialentry.sumaccepttaxamount,materialentry.relateapaccepttaxamount";
        DynamicObject[] orders = OrderUtil.getOrdersByPoEntryIdS((String)seltcor, poEntryPks);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])orders, new ArrayList(poEntryPks));
        if (scconsistencyservice.booleanValue()) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"saloutstockaudit", (DynamicObject[])dynamicObjects);
        } else if (ApiConfigUtil.hasCQScmConfig()) {
            ScpPmStatusUtil.updatePmStatus((DynamicObject[])dynamicObjects, (String)ConfirmStatusEnum.CONFIRM.getVal(), null);
        } else if (ApiConfigUtil.hasXKScmConfig() || ApiConfigUtil.hasEASScmConfig()) {
            ScpScDataHandleHelper.doExecuteCosmicSalOutStockAudit(dynamicObjects, orders);
        }
        return scDataHandleResult;
    }

    @Deprecated
    public static void doExecuteCosmicSalOutStockAudit(DynamicObject[] dynamicObjects, DynamicObject[] orders) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Map poEntryId_qtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])dynamicObjects);
            Set allReciptIdSet = OrderUtil.getPkValueSet((DynamicObject[])orders, (boolean)true);
            Set partialReciptIdSet = OrderUtil.getPkValueSet((DynamicObject[])orders, (boolean)false);
            dataMap.put("billid", allReciptIdSet);
            dataMap.put("allReceiptBillid", allReciptIdSet);
            dataMap.put("partialReciptBillid", partialReciptIdSet);
            dataMap.put("saloutqty", poEntryId_qtyMap);
            param.put("billtype", "scp_saloutstock");
            param.put("action", "audit");
            param.put("data", dataMap);
            ApiUtil.purSaloutAudit(param);
        }
        catch (Exception exep) {
            log.info("\u53d1\u8d27\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u539f\u56e0\uff1a" + exep.getMessage());
        }
    }

    public static ScDataHandleResult execSalOutStockUnAudit(DynamicObject[] dynamicObjects, Boolean scconsistencyservice) {
        ScDataHandleResult scDataHandleResult = null;
        Map poEntryId_QtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])dynamicObjects);
        HashSet poEntryPks = new HashSet(poEntryId_QtyMap.keySet());
        String seltcor = "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.pobillid, materialentry.poentryid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.sumrefundqty,materialentry.entrystatus,materialentry.rowlogstatus,materialentry.linetype,materialentry.taxamount,materialentry.sumapaccepttaxamount,materialentry.sumaccepttaxamount,materialentry.relateapaccepttaxamount";
        DynamicObject[] orders = OrderUtil.getOrdersByPoEntryIdS((String)seltcor, poEntryPks);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])orders, new ArrayList(poEntryPks));
        if (scconsistencyservice.booleanValue()) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)"saloutstockunaudit", (DynamicObject[])dynamicObjects);
        } else if (ApiConfigUtil.hasCQScmConfig()) {
            ArrayList<String> allowLogisticsStatus = new ArrayList<String>();
            allowLogisticsStatus.add("");
            allowLogisticsStatus.add(LogisticsStatusEnum.CONFIRM.getVal());
            allowLogisticsStatus.add(LogisticsStatusEnum.PARTOUTSTOCK.getVal());
            ScpPmStatusUtil.updatePmStatus((DynamicObject[])dynamicObjects, (String)ConfirmStatusEnum.CONFIRM.getVal(), allowLogisticsStatus);
        } else if (ApiConfigUtil.hasXKScmConfig() || ApiConfigUtil.hasEASScmConfig()) {
            ScpScDataHandleHelper.doExecuteCosmicSalOutStockUnAudit(orders, poEntryId_QtyMap);
        }
        return scDataHandleResult;
    }

    @Deprecated
    public static void doExecuteCosmicSalOutStockUnAudit(DynamicObject[] orders, Map<String, Object> poEntryId_QtyMap) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map pkValMap = OrderUtil.getPKValueStr((DynamicObject[])orders);
        if (pkValMap != null && pkValMap.size() > 0) {
            HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
            dataMap.put("billid", pkValMap);
            dataMap.put("saloutqty", poEntryId_QtyMap);
            param.put("billtype", "scp_saloutstock");
            param.put("action", "unaudit");
            param.put("data", dataMap);
            ApiUtil.purSaloutUnaudit(param);
        }
    }
}

