/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;

public final class ScpVMIPanelServiceHelper {
    private static final Log log = LogFactory.getLog((String)ScpVMIPanelServiceHelper.class.getName());
    private static final String[] GROUPBYFIELDS_WAREHOUSE = new String[]{"supplier", "material", "recorg", "unit", "warehouse", "materialgroup"};
    private static final String[] GROUPBYFIELDS_NOWAREHOUSE = new String[]{"supplier", "material", "recorg", "unit", "materialgroup"};
    private static final String[] GROUPBYTIME_NOWAREHOUSE = new String[]{"supplier", "material", "recorg", "unit", "materialgroup", "updatetime"};
    private static final String[] GROUPBYTIME_WAREHOUSE = new String[]{"supplier", "material", "recorg", "unit", "warehouse", "materialgroup", "updatetime"};

    public static QFilter getInitCommonQfilter() {
        RequestContext rc = RequestContext.get();
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        HasPermOrgResult permission = PermissionServiceHelper.getAllPermOrgs((long)rc.getCurrUserId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (boolean)false, null, (String)"scp_vmipanel", (String)"47150e89000000ac");
        QFilter invqFilter = new QFilter("supplier.bizpartner", "in", (Object)idSet);
        if (!permission.hasAllOrgPerm()) {
            invqFilter.and(new QFilter("recorg", "in", (Object)permission.getHasPermOrgs()));
        }
        return invqFilter;
    }

    public static DynamicObjectCollection initImInventory(QFilter qFilter, Boolean iswarehouse) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)"pur_iminventory", (boolean)false);
        DynamicObjectCollection pur_iminventorys = QueryServiceHelper.query((String)"pur_iminventory", (String)(selectfields + ",unit.precision,id"), (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> groupData = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject dyn : pur_iminventorys) {
            String keyStr;
            Long material = dyn.getLong("material.id");
            Long recorg = dyn.getLong("recorg.id");
            Long warehouse = dyn.getLong("warehouse.id");
            StringBuilder strBuffer = new StringBuilder();
            strBuffer.append(material).append("_").append(recorg);
            if (iswarehouse.booleanValue()) {
                if (null != warehouse) {
                    strBuffer.append("_").append(warehouse);
                } else {
                    strBuffer.append("_0");
                }
            }
            if (groupData.containsKey(keyStr = strBuffer.toString())) {
                BigDecimal newQty = dyn.getBigDecimal("qty").add(((DynamicObject)groupData.get(keyStr)).getBigDecimal("qty"));
                dyn.set("qty", (Object)newQty);
                groupData.put(keyStr, dyn);
                continue;
            }
            groupData.put(keyStr, dyn);
        }
        DynamicObjectCollection newImInv = new DynamicObjectCollection();
        for (Map.Entry map : groupData.entrySet()) {
            newImInv.add(map.getValue());
        }
        return newImInv;
    }

    public static DynamicObjectCollection newinitImInventory(QFilter qFilter, final Boolean iswarehouse, Set<Long> materialIdSet, List<Long> orgs, QFilter conmaterialQfilter) {
        DataSet part1DataSet = ScpVMIPanelServiceHelper.getImInventoryGroupDataSet(qFilter, iswarehouse);
        DataSet copypart1DataSet = part1DataSet.copy();
        final HashMap<Long, Long> baseunitMap = new HashMap<Long, Long>();
        final HashMap<String, Long> unitOrgMap = new HashMap<String, Long>();
        HashSet<Long> invunitSet = new HashSet<Long>();
        QFilter materialFilter = new QFilter("entryentity.material", "in", materialIdSet);
        materialFilter.and(conmaterialQfilter);
        DataSet conmaterialSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"pur_conmatreial", (String)"supplier,entryentity.material material,entryentity.material.name", (QFilter[])materialFilter.toArray(), null);
        HashSet<Long> allMaterialIdSet = new HashSet<Long>(materialIdSet);
        for (Row row : copypart1DataSet) {
            allMaterialIdSet.add(row.getLong("material"));
        }
        QFilter filter = new QFilter("masterid", "in", allMaterialIdSet);
        filter.and(new QFilter("status", "=", (Object)"C"));
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"bd_materialinventoryinfo", (String)"masterid,inventoryunit unit,createorg", (QFilter[])filter.toArray(), null);
        DataSet unitCopyDataset = unitDataSet.copy();
        for (Object row : unitCopyDataset) {
            Long masterid = row.getLong("masterid");
            Long unit = row.getLong("unit");
            Long createorg = row.getLong("createorg");
            String materialOrg = masterid + "_" + createorg;
            if (unit == null || unit == 0L) continue;
            unitOrgMap.put(materialOrg, unit);
            invunitSet.add(unit);
        }
        DataSet baseunitDataSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"bd_material", (String)"id,baseunit", (QFilter[])filter.toArray(), null);
        for (Row row : baseunitDataSet) {
            Long materialid = row.getLong("id");
            baseunitMap.put(materialid, row.getLong("baseunit"));
            invunitSet.add(row.getLong("baseunit"));
        }
        final Map multimeasureunitMap = BusinessDataServiceHelper.loadFromCache((Object[])invunitSet.toArray(), (String)"bd_measureunits");
        QFilter materialGroupFilter = new QFilter("material.id", "in", materialIdSet);
        DataSet materialGroupDataSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"bd_materialgroupdetail", (String)"group materialgroup,material", (QFilter[])materialGroupFilter.toArray(), null);
        JoinDataSet joinUnitSet = conmaterialSet.join(unitDataSet, JoinType.LEFT);
        joinUnitSet.on("material", "masterid");
        joinUnitSet.select(new String[]{"supplier", "material", "unit"});
        DataSet unitDataset = joinUnitSet.finish();
        JoinDataSet joiMaterialGroupSet = unitDataset.join(materialGroupDataSet, JoinType.LEFT);
        joiMaterialGroupSet.on("material", "material");
        joiMaterialGroupSet.select(new String[]{"supplier", "material", "materialgroup", "unit", "0 as qty"});
        DataSet groupUnitDataSet = joiMaterialGroupSet.finish();
        QFilter invlevelFilter = ScpVMIPanelServiceHelper.buildInvlevelQFilter(materialIdSet, orgs, iswarehouse);
        DataSet invlevelSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"msplan_invlevel", (String)"entryentity.bos_org recorg,entryentity.bd_warehouse warehouse,entryentity.bd_material bdmaterial,entryentity.min min,entryentity.max max", (QFilter[])invlevelFilter.toArray(), null);
        GroupbyDataSet groupbyDataSet = iswarehouse != false ? (invlevelSet != null ? invlevelSet.groupBy(new String[]{"bdmaterial", "recorg", "warehouse"}) : null) : (invlevelSet != null ? invlevelSet.groupBy(new String[]{"bdmaterial", "recorg"}) : null);
        DataSet part2DataSet = null;
        if (groupbyDataSet != null) {
            DataSet sumDataSet = groupbyDataSet.finish();
            JoinDataSet joinDataSet = groupUnitDataSet.join(sumDataSet, JoinType.INNER);
            joinDataSet.on("material", "bdmaterial");
            JoinDataSet resultSet = iswarehouse != false ? joinDataSet.select(new String[]{"supplier", "material", "materialgroup", "recorg", "qty", "unit", "warehouse"}) : joinDataSet.select(new String[]{"supplier", "material", "materialgroup", "recorg", "qty", "unit"});
            part2DataSet = resultSet.finish();
        }
        DataSet unionData = ScpVMIPanelServiceHelper.getUnionData(part1DataSet, part2DataSet);
        String[] groupBy = iswarehouse == false ? GROUPBYFIELDS_NOWAREHOUSE : GROUPBYFIELDS_WAREHOUSE;
        if (unionData == null) {
            return null;
        }
        GroupbyDataSet unionGroupBySet = unionData.groupBy(groupBy);
        unionGroupBySet.sum("qty");
        DataSet finalUnionSet = unionGroupBySet.finish();
        String[] orderBy = new String[]{"material", "recorg"};
        DataSet finalSet = finalUnionSet.orderBy(orderBy);
        DataSet updateTimeSet = ScpVMIPanelServiceHelper.getUpdateTimeSet(qFilter);
        JoinDataSet joinUpadateTimeSet = finalSet.join(updateTimeSet, JoinType.LEFT);
        joinUpadateTimeSet.on("supplier", "supplier");
        joinUpadateTimeSet.on("material", "material");
        joinUpadateTimeSet.on("recorg", "recorg");
        if (!iswarehouse.booleanValue()) {
            joinUpadateTimeSet.select(new String[]{"supplier", "material", "recorg", "unit", "materialgroup", "qty", "updatetime"});
        } else {
            joinUpadateTimeSet.select(new String[]{"supplier", "material", "recorg", "unit", "warehouse", "materialgroup", "qty", "updatetime"});
        }
        DataSet finish = joinUpadateTimeSet.finish();
        DataSet sameunitDataset = finish.reduceGroup(new ReduceGroupFunctionWithCollector(){

            public void reduce(Iterator<Row> iter, Collector collector) {
                Object[] resultRow = null;
                while (iter.hasNext()) {
                    Row row = iter.next();
                    Long material = row.getLong("material");
                    Long recorg = row.getLong("recorg");
                    String materialAndOrg = material + "_" + recorg;
                    Long desUnit = unitOrgMap.containsKey(materialAndOrg) ? (Long)unitOrgMap.get(materialAndOrg) : (Long)baseunitMap.get(material);
                    BigDecimal desQty = CommonUtil.getDesQtyConv((Long)material, (Long)row.getLong("unit"), (BigDecimal)row.getBigDecimal("qty"), (DynamicObject)((DynamicObject)multimeasureunitMap.get(desUnit)));
                    resultRow = iswarehouse == false ? new Object[]{row.get("supplier"), row.get("material"), row.get("recorg"), desUnit, row.get("materialgroup"), desQty, row.get("updatetime")} : new Object[]{row.get("supplier"), row.get("material"), row.get("recorg"), desUnit, row.get("warehouse"), row.get("materialgroup"), desQty, row.get("updatetime")};
                    collector.collect(resultRow);
                }
            }

            public RowMeta getResultRowMeta() {
                if (!iswarehouse.booleanValue()) {
                    return new RowMeta(new String[]{"supplier", "material", "recorg", "unit", "materialgroup", "qty", "updatetime"}, new DataType[]{DataType.LongType, DateType.LongType, DateType.LongType, DateType.LongType, DateType.LongType, DateType.BigDecimalType, DateType.DateType});
                }
                return new RowMeta(new String[]{"supplier", "material", "recorg", "unit", "warehouse", "materialgroup", "qty", "updatetime"}, new DataType[]{DataType.LongType, DateType.LongType, DateType.LongType, DateType.LongType, DateType.LongType, DateType.LongType, DateType.BigDecimalType, DateType.DateType});
            }
        });
        if (!iswarehouse.booleanValue()) {
            GroupbyDataSet groupbyWarehouseDataSet = sameunitDataset.groupBy(GROUPBYTIME_NOWAREHOUSE);
            DataSet sumqtyDataSet = groupbyWarehouseDataSet.sum("qty").finish();
            return ScpVMIPanelServiceHelper.buildResultData(iswarehouse, sumqtyDataSet);
        }
        GroupbyDataSet groupbyWarehouseDataSet = sameunitDataset.groupBy(GROUPBYTIME_WAREHOUSE);
        DataSet sumqtyDataSet = groupbyWarehouseDataSet.sum("qty").finish();
        return ScpVMIPanelServiceHelper.buildResultData(iswarehouse, sumqtyDataSet);
    }

    private static DynamicObjectCollection buildResultData(Boolean iswarehouse, DataSet finish) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        DataSet copyCache = finish.copy();
        HashSet<Long> materialIds = new HashSet<Long>(64);
        HashSet<Long> warehouseIds = new HashSet<Long>(64);
        HashSet<Long> supplierIds = new HashSet<Long>(64);
        HashSet<Long> recorgIds = new HashSet<Long>(64);
        HashSet<Long> unitIds = new HashSet<Long>(64);
        HashSet<Long> materialgroupIds = new HashSet<Long>(64);
        while (copyCache.hasNext()) {
            Row row = copyCache.next();
            materialIds.add(row.getLong("material"));
            if (iswarehouse.booleanValue()) {
                warehouseIds.add(row.getLong("warehouse"));
            }
            supplierIds.add(row.getLong("supplier"));
            recorgIds.add(row.getLong("recorg"));
            unitIds.add(row.getLong("unit"));
            materialgroupIds.add(row.getLong("materialgroup"));
        }
        materialIds.remove(null);
        warehouseIds.remove(null);
        supplierIds.remove(null);
        recorgIds.remove(null);
        unitIds.remove(null);
        materialgroupIds.remove(null);
        Map materialCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map warehouseCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])warehouseIds.toArray(), (String)"bd_warehouse");
        Map supplierCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])supplierIds.toArray(), (String)"bd_supplier");
        Map orgCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])recorgIds.toArray(), (String)"bos_org");
        Map measureunitsCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        Map materialgroupCacheMap = BusinessDataServiceHelper.loadFromCache((Object[])materialgroupIds.toArray(), (String)"bd_materialgroup");
        for (Row row : finish) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"pur_iminventory");
            dynamicObject.set("material", materialCacheMap.get(row.get("material")));
            if (iswarehouse.booleanValue()) {
                dynamicObject.set("warehouse", warehouseCacheMap.get(row.get("warehouse")));
            }
            dynamicObject.set("supplier", supplierCacheMap.get(row.get("supplier")));
            dynamicObject.set("recorg", orgCacheMap.get(row.get("recorg")));
            dynamicObject.set("unit", measureunitsCacheMap.get(row.get("unit")));
            dynamicObject.set("materialgroup", materialgroupCacheMap.get(row.get("materialgroup")));
            dynamicObject.set("qty", row.get("qty"));
            dynamicObject.set("updatetime", row.get("updatetime"));
            dynamicObjects.add((Object)dynamicObject);
        }
        return dynamicObjects;
    }

    private static DataSet getUnionData(DataSet part1DataSet, DataSet part2DataSet) {
        if (part1DataSet == null && part2DataSet == null) {
            return null;
        }
        if (part1DataSet != null) {
            return part1DataSet.union(part2DataSet);
        }
        return part2DataSet.union(part1DataSet);
    }

    private static DataSet getUpdateTimeSet(QFilter qFilter) {
        String selectfields = "supplier,material,recorg,updatetime";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"pur_iminventory", (String)selectfields, (QFilter[])qFilter.toArray(), (String)"updatetime desc");
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"supplier", "material", "recorg"});
        return groupbyDataSet.reduceGroup(new ReduceGroupFunctionWithCollector(){

            public void reduce(Iterator<Row> iter, Collector collector) {
                Object[] resultRow = null;
                int i = 0;
                while (iter.hasNext()) {
                    Row row = iter.next();
                    if (i == 0) {
                        resultRow = new Object[]{row.get("supplier"), row.get("material"), row.get("recorg"), row.get("updatetime")};
                    }
                    ++i;
                }
                collector.collect(resultRow);
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new String[]{"supplier", "material", "recorg", "updatetime"}, new DataType[]{DataType.LongType, DateType.LongType, DateType.LongType, DateType.DateType});
            }
        });
    }

    private static QFilter buildInvlevelQFilter(Set<Long> materialIdSet, List<Long> hasPermOrgs, Boolean iswarehouse) {
        QFilter statusFiler = new QFilter("status", "=", (Object)"C");
        QFilter enableFiler = new QFilter("enable", "=", (Object)"1");
        statusFiler.and(enableFiler);
        QFilter materialIdFilter = new QFilter("entryentity.bd_material", "in", materialIdSet);
        QFilter orgFilter = new QFilter("entryentity.bos_org", "in", hasPermOrgs);
        if (iswarehouse.booleanValue()) {
            QFilter warehouseFilter = new QFilter("entryentity.bd_warehouse", "!=", (Object)0);
            return statusFiler.and(materialIdFilter).and(orgFilter).and(warehouseFilter);
        }
        return statusFiler.and(materialIdFilter).and(orgFilter);
    }

    private static DataSet getImInventoryGroupDataSet(QFilter qFilter, Boolean iswarehouse) {
        String selectfields = iswarehouse != false ? "supplier,material,materialgroup,recorg,qty,unit,warehouse" : "supplier,material,materialgroup,recorg,qty,unit";
        return QueryServiceHelper.queryDataSet((String)"ScpVMIPanelService", (String)"pur_iminventory", (String)selectfields, (QFilter[])qFilter.toArray(), null);
    }

    public static void doDealMinMaxQty(DynamicObjectCollection pur_iminventorys, boolean iswarehouse) {
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        HashSet<Long> materialGroupIdSet = new HashSet<Long>(1024);
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        for (int i = 0; i < pur_iminventorys.size(); ++i) {
            DynamicObject iminv = (DynamicObject)pur_iminventorys.get(i);
            if (0L != iminv.getLong("material.id")) {
                materialIdSet.add(iminv.getLong("material.id"));
            }
            if (0L != iminv.getLong("materialgroup.id")) {
                materialGroupIdSet.add(iminv.getLong("materialgroup.id"));
            }
            if (0L == iminv.getLong("recorg.id")) continue;
            orgIdSet.add(iminv.getLong("recorg.id"));
        }
        Map<String, Set<String>> warehouseMap = ScpVMIPanelServiceHelper.getWarehouseMapByIminventory(materialIdSet, orgIdSet);
        Map<String, String> group_value = ScpVMIPanelServiceHelper.getMsplanInvlevelGroup(orgIdSet, materialIdSet, materialGroupIdSet);
        ScpVMIPanelServiceHelper.setMinMaxQty(pur_iminventorys, group_value, warehouseMap, iswarehouse);
    }

    private static void setMinMaxQty(DynamicObjectCollection pur_iminventorys, Map<String, String> group_value, Map<String, Set<String>> warehouseMap, boolean iswarehouse) {
        for (int i = 0; i < pur_iminventorys.size(); ++i) {
            String warehouseStr;
            DynamicObject dyn = (DynamicObject)pur_iminventorys.get(i);
            DynamicObject material = dyn.getDynamicObject("material");
            DynamicObject materialgroup = dyn.getDynamicObject("materialgroup");
            DynamicObject recorg = dyn.getDynamicObject("recorg");
            DynamicObject warehouse = dyn.getDynamicObject("warehouse");
            String materialStr = material == null ? "0" : material.getString("id");
            String materialgroupStr = materialgroup == null ? "0" : materialgroup.getString("id");
            String recorgStr = recorg == null ? "0" : recorg.getString("id");
            String string = warehouseStr = warehouse == null ? "0" : warehouse.getString("id");
            if (iswarehouse) {
                String min_max;
                StringBuilder strBuffer = new StringBuilder();
                strBuffer.append(materialStr).append("_").append(recorgStr).append("_").append(warehouseStr).append("_").append("0");
                if (group_value.containsKey(strBuffer.toString())) {
                    min_max = group_value.get(strBuffer.toString());
                    ScpVMIPanelServiceHelper.setImInventoryMinMax(dyn, min_max);
                    continue;
                }
                strBuffer.setLength(0);
                strBuffer.append("0").append("_").append(recorgStr).append("_").append(warehouseStr).append("_").append(materialgroupStr);
                if (!group_value.containsKey(strBuffer.toString())) continue;
                min_max = group_value.get(strBuffer.toString());
                ScpVMIPanelServiceHelper.setImInventoryMinMax(dyn, min_max);
                continue;
            }
            BigDecimal min = BigDecimal.ZERO;
            BigDecimal max = BigDecimal.ZERO;
            boolean flag = false;
            for (Map.Entry<String, String> entry : group_value.entrySet()) {
                String[] keyArr = entry.getKey().split("_");
                String[] min_max = entry.getValue().split("_");
                if (keyArr[0] == null || !materialStr.equals(keyArr[0]) || keyArr[1] == null || !recorgStr.equals(keyArr[1])) continue;
                min = min.add(new BigDecimal(min_max[0]));
                max = max.add(new BigDecimal(min_max[1]));
                flag = true;
            }
            String min_maxStr = min + "_" + max;
            ScpVMIPanelServiceHelper.setImInventoryMinMax(dyn, min_maxStr);
            if (flag) continue;
            StringBuilder strBuffer = new StringBuilder();
            BigDecimal min1 = BigDecimal.ZERO;
            BigDecimal max1 = BigDecimal.ZERO;
            for (Map.Entry<String, String> group : group_value.entrySet()) {
                String groupKey = group.getKey();
                strBuffer.setLength(0);
                strBuffer.append(materialStr).append("_").append(recorgStr);
                String[] min_maxArr = group.getValue().split("_");
                String[] groupArr = groupKey.split("_");
                Set<String> warehouseSet = warehouseMap.get(materialStr + "_" + materialgroupStr + "_" + recorgStr);
                if (null == warehouseSet || !warehouseSet.contains(groupArr[2])) continue;
                if (groupKey.contains(strBuffer.toString())) {
                    min1 = min.add(new BigDecimal(min_maxArr[0]));
                    max1 = max.add(new BigDecimal(min_maxArr[1]));
                    continue;
                }
                if (!groupKey.contains(materialStr) || !groupKey.contains(recorgStr) || !groupKey.contains(materialgroupStr)) continue;
                min1 = min.add(new BigDecimal(min_maxArr[0]));
                max1 = max.add(new BigDecimal(min_maxArr[1]));
            }
            String min_maxStr1 = String.valueOf(min1) + "_" + String.valueOf(max1);
            ScpVMIPanelServiceHelper.setImInventoryMinMax(dyn, min_maxStr1);
        }
    }

    private static void setImInventoryMinMax(DynamicObject dyn, String min_max) {
        String[] min_maxArr = min_max.split("_");
        BigDecimal min = new BigDecimal(min_maxArr[0]);
        BigDecimal max = new BigDecimal(min_maxArr[1]);
        dyn.set("minqty", (Object)min);
        dyn.set("maxqty", (Object)max);
    }

    private static Map<String, String> getMsplanInvlevelGroup(Set<Long> orgIdSet, Set<Long> materialIdSet, Set<Long> materialGroupIdSet) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        HashSet<String> objectNum = new HashSet<String>(1024);
        objectNum.add("bd_material");
        objectNum.add("bd_warehouse");
        objectNum.add("bos_org");
        objectNum.add("bd_materialgroup");
        qFilter.and(new QFilter("entryentity.associationobject.id", "in", objectNum));
        DynamicObjectCollection msplan_plan_dimensions = QueryServiceHelper.query((String)"msplan_plan_dimension", (String)"entryentity.associationobject,id", (QFilter[])qFilter.toArray());
        HashSet dimensionIdSet = new HashSet(1024);
        HashMap<Long, HashSet<String>> dimensionIdMap = new HashMap<Long, HashSet<String>>(1024);
        for (DynamicObject dyn : msplan_plan_dimensions) {
            long id = dyn.getLong("id");
            HashSet<String> associateSet = (HashSet<String>)dimensionIdMap.get(id);
            if (null == associateSet) {
                associateSet = new HashSet<String>(1024);
            }
            associateSet.add(dyn.getString("entryentity.associationobject"));
            dimensionIdMap.put(id, associateSet);
        }
        for (Map.Entry map : dimensionIdMap.entrySet()) {
            Set associateSet = (Set)map.getValue();
            if (associateSet.size() == 2 && associateSet.contains("bos_org") && (associateSet.contains("bd_material") || associateSet.contains("bd_materialgroup"))) {
                dimensionIdSet.add(map.getKey());
            }
            if (associateSet.size() != 3 || !associateSet.contains("bos_org") || !associateSet.contains("bd_warehouse") || !associateSet.contains("bd_material") && !associateSet.contains("bd_materialgroup")) continue;
            dimensionIdSet.add(map.getKey());
        }
        qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("dimension.id", "in", dimensionIdSet));
        qFilter.and(new QFilter("entryentity.bos_org.id", "in", orgIdSet));
        qFilter.and(new QFilter("entryentity.bd_material.id", "in", materialIdSet).or(new QFilter("entryentity.bd_materialgroup.id", "in", materialGroupIdSet)));
        qFilter.and(new QFilter("entryentity.plantype", "=", (Object)"B"));
        Date currentSystemTime = TimeServiceHelper.getCurrentSystemTime();
        qFilter.and(new QFilter("entryentity.datestart", "<", (Object)currentSystemTime));
        qFilter.and(new QFilter("entryentity.dateend", ">", (Object)currentSystemTime));
        String selectors = "number,status,enable,entryentity.bd_material,entryentity.bos_org,entryentity.bd_warehouse,entryentity.bd_materialgroup,entryentity.max,entryentity.min";
        DynamicObjectCollection msplan_invlevels = QueryServiceHelper.query((String)"msplan_invlevel", (String)selectors, (QFilter[])qFilter.toArray());
        HashMap<String, String> group_value = new HashMap<String, String>(1024);
        for (DynamicObject entry : msplan_invlevels) {
            StringBuilder strBuffer = new StringBuilder();
            String material = entry.getLong("entryentity.bd_material") == 0L ? "0_" : entry.getString("entryentity.bd_material") + "_";
            String org = entry.getLong("entryentity.bos_org") == 0L ? "0_" : entry.getString("entryentity.bos_org") + "_";
            String warehouse = entry.getLong("entryentity.bd_warehouse") == 0L ? "0_" : entry.getString("entryentity.bd_warehouse") + "_";
            String group = entry.getLong("entryentity.bd_materialgroup") == 0L ? "0" : entry.getString("entryentity.bd_materialgroup") + "";
            String min_max = entry.getBigDecimal("entryentity.min").toString() + "_" + entry.getBigDecimal("entryentity.max").toString();
            strBuffer.append(material).append(org).append(warehouse).append(group);
            group_value.put(strBuffer.toString(), min_max);
        }
        return group_value;
    }

    private static Map<String, Set<String>> getWarehouseMapByIminventory(Set<Long> materialIdSet, Set<Long> orgIdSet) {
        HashMap<String, Set<String>> warehouseMap = new HashMap<String, Set<String>>(1024);
        QFilter invQfilter = new QFilter("material", "in", materialIdSet);
        invQfilter.and(new QFilter("recorg", "in", orgIdSet));
        DynamicObjectCollection iminventory = QueryServiceHelper.query((String)"pur_iminventory", (String)"material,materialgroup,recorg,warehouse", (QFilter[])invQfilter.toArray());
        for (DynamicObject iminv : iminventory) {
            HashSet<String> idSet;
            String key = iminv.getString("material") + "_" + iminv.getString("materialgroup") + "_" + iminv.getString("recorg");
            if (warehouseMap.containsKey(key)) {
                idSet = (HashSet<String>)warehouseMap.get(key);
                idSet.add(iminv.getString("warehouse"));
                warehouseMap.put(key, idSet);
                continue;
            }
            idSet = new HashSet<String>(1024);
            idSet.add(iminv.getString("warehouse"));
            warehouseMap.put(key, idSet);
        }
        return warehouseMap;
    }

    public static void doDealQtyFiled(DynamicObjectCollection pur_iminventorys) {
        for (DynamicObject dyn : pur_iminventorys) {
            if (dyn.getBigDecimal("qty").compareTo(dyn.getBigDecimal("minqty")) >= 0) continue;
            dyn.set("outqty", (Object)dyn.getBigDecimal("minqty").subtract(dyn.getBigDecimal("qty")));
        }
    }

    public static Set<Long> doDealReqQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        Date startDate = DateUtil.string2date((String)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)new Date(), (int)-12)), null);
        QFilter qFilter = new QFilter("billdate", ">=", (Object)startDate);
        if (null != pur_iminventorys) {
            ScpVMIPanelServiceHelper.setFilterValue(materialIdSet, orgIdSet, pur_iminventorys);
        }
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        qFilter.and(new QFilter("bizpartner", "in", (Object)idSet));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("orderstatus", "=", (Object)"A").or(new QFilter("orderstatus", "=", (Object)"B")));
        if (null != bizQFilter) {
            qFilter.and(bizQFilter);
        } else {
            qFilter.and(new QFilter("entryentity.invorg", "in", orgIdSet));
            qFilter.and(new QFilter("entryentity.material", "in", materialIdSet));
        }
        String seltor = "id,entryentity.invorg,entryentity.material,entryentity.baseqty,entryentity.orderedbaseqty,entryentity.baseunit";
        DynamicObjectCollection reqlenishReqCols = QueryServiceHelper.query((String)"pur_replenishreq", (String)seltor, (QFilter[])qFilter.toArray());
        HashMap<String, BigDecimal> reqQtyMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, Long> baseUnitMap = new HashMap<String, Long>(1024);
        HashMap<String, Set> billIDSetMap = new HashMap<String, Set>(1024);
        for (DynamicObject entry : reqlenishReqCols) {
            Long baseunit = entry.getLong("entryentity.baseunit");
            BigDecimal baseqty = entry.getBigDecimal("entryentity.baseqty");
            BigDecimal orderedbaseqty = entry.getBigDecimal("entryentity.orderedbaseqty");
            BigDecimal qty = baseqty.subtract(orderedbaseqty);
            String keyStr = entry.getString("entryentity.invorg") + "_" + entry.getString("entryentity.material");
            if (!reqQtyMap.containsKey(keyStr)) {
                if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                reqQtyMap.put(keyStr, qty);
                baseUnitMap.put(keyStr, baseunit);
                HashSet<Long> billIdSet = new HashSet<Long>(1024);
                billIdSet.add(entry.getLong("id"));
                billIDSetMap.put(keyStr, billIdSet);
                continue;
            }
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal invQty = (BigDecimal)reqQtyMap.get(keyStr);
            reqQtyMap.put(keyStr, invQty.add(qty));
            Set billIdSet = (Set)billIDSetMap.get(keyStr);
            billIdSet.add(entry.getLong("id"));
            billIDSetMap.put(keyStr, billIdSet);
            if (baseunit == null) continue;
            baseUnitMap.put(keyStr, baseunit);
        }
        HashSet<Long> billIDSet = new HashSet<Long>(1024);
        if (null != pur_iminventorys) {
            for (DynamicObject dyn : pur_iminventorys) {
                Long recorg = dyn.getLong("recorg.id");
                Long material = dyn.getLong("material.id");
                Long unit = dyn.getLong("unit.id");
                int precision = dyn.getInt("unit.precision");
                String keyStr = recorg + "_" + material;
                if (!reqQtyMap.containsKey(keyStr)) continue;
                Long baseunit = (Long)baseUnitMap.get(keyStr);
                BigDecimal qty = (BigDecimal)reqQtyMap.get(keyStr);
                BigDecimal reqQty = ScpVMIPanelServiceHelper.getDesQtyConv(material, baseunit, qty, unit, precision);
                dyn.set("repqty", (Object)reqQty);
                billIDSet.addAll((Collection)billIDSetMap.get(keyStr));
            }
        } else {
            for (Map.Entry key : billIDSetMap.entrySet()) {
                if (!billIDSetMap.containsKey(org_material)) continue;
                billIDSet.addAll((Collection)key.getValue());
            }
        }
        return billIDSet;
    }

    public static Set<Long> doDealOrderQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        if (null != pur_iminventorys) {
            ScpVMIPanelServiceHelper.setFilterValue(materialIdSet, orgIdSet, pur_iminventorys);
        }
        Date startDate = DateUtil.string2date((String)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)new Date(), (int)-12)), null);
        QFilter qFilter = new QFilter("billdate", ">=", (Object)startDate);
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        qFilter.and(new QFilter("bizpartner", "in", (Object)idSet));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (null != bizQFilter) {
            qFilter.and(bizQFilter);
        } else {
            qFilter.and(new QFilter("materialentry.entryrcvorg", "in", orgIdSet));
            qFilter.and(new QFilter("materialentry.material", "in", materialIdSet));
        }
        String seltor = "id,materialentry.entryrcvorg,materialentry.material,materialentry.basicqty,materialentry.sumoutstockbaseqty,materialentry.entrystatus,materialentry.basicunit";
        DynamicObjectCollection reqlenishReqCols = QueryServiceHelper.query((String)"pur_order", (String)seltor, (QFilter[])qFilter.toArray());
        HashMap<String, BigDecimal> reqQtyMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, Long> baseUnitMap = new HashMap<String, Long>(1024);
        HashMap<String, Set> billIDSetMap = new HashMap<String, Set>(1024);
        for (DynamicObject entry : reqlenishReqCols) {
            long invorg = entry.getLong("materialentry.entryrcvorg");
            long material = entry.getLong("materialentry.material");
            long baseunit = entry.getLong("materialentry.basicunit");
            BigDecimal baseqty = entry.getBigDecimal("materialentry.basicqty");
            BigDecimal orderedbaseqty = entry.getBigDecimal("materialentry.sumoutstockbaseqty");
            BigDecimal qty = baseqty.subtract(orderedbaseqty);
            String invorgStr = invorg == 0L ? "0" : entry.getString("materialentry.entryrcvorg");
            String materialStr = material == 0L ? "0" : entry.getString("materialentry.material");
            String keyStr = invorgStr + "_" + materialStr;
            if (!"A".equals(entry.getString("materialentry.entrystatus"))) continue;
            if (!reqQtyMap.containsKey(keyStr)) {
                if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                reqQtyMap.put(keyStr, qty);
                baseUnitMap.put(keyStr, baseunit);
                HashSet<Long> billIdSet = new HashSet<Long>(1024);
                billIdSet.add(entry.getLong("id"));
                billIDSetMap.put(keyStr, billIdSet);
                continue;
            }
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal invQty = (BigDecimal)reqQtyMap.get(keyStr);
            reqQtyMap.put(keyStr, invQty.add(qty));
            Set billIdSet = (Set)billIDSetMap.get(keyStr);
            billIdSet.add(entry.getLong("id"));
            billIDSetMap.put(keyStr, billIdSet);
        }
        HashSet<Long> billIDSet = new HashSet<Long>(1024);
        if (null != pur_iminventorys) {
            for (DynamicObject dyn : pur_iminventorys) {
                long recorg = dyn.getLong("recorg.id");
                long material = dyn.getLong("material.id");
                long unit = dyn.getLong("unit.id");
                int precision = dyn.getInt("unit.precision");
                String keyStr = recorg + "_" + material;
                if (!reqQtyMap.containsKey(keyStr)) continue;
                long baseunit = (Long)baseUnitMap.get(keyStr);
                BigDecimal qty = (BigDecimal)reqQtyMap.get(keyStr);
                BigDecimal reqQty = ScpVMIPanelServiceHelper.getDesQtyConv(material, baseunit, qty, unit, precision);
                dyn.set("orderqty", (Object)reqQty);
                billIDSet.addAll((Collection)billIDSetMap.get(keyStr));
            }
        } else {
            for (Map.Entry key : billIDSetMap.entrySet()) {
                if (!billIDSetMap.containsKey(org_material)) continue;
                billIDSet.addAll((Collection)key.getValue());
            }
        }
        return billIDSet;
    }

    public static Set<Long> doDealInQty(DynamicObjectCollection pur_iminventorys, QFilter bizQFilter, String org_material) {
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        if (null != pur_iminventorys) {
            ScpVMIPanelServiceHelper.setFilterValue(materialIdSet, orgIdSet, pur_iminventorys);
        }
        Date startDate = DateUtil.string2date((String)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)new Date(), (int)-12)), null);
        QFilter qFilter = new QFilter("billdate", ">=", (Object)startDate);
        if (null != bizQFilter) {
            qFilter.and(bizQFilter);
        } else {
            qFilter.and(new QFilter("materialentry.entryrcvorg", "in", orgIdSet));
            qFilter.and(new QFilter("materialentry.material", "in", materialIdSet));
        }
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        qFilter.and(new QFilter("bizpartner", "in", (Object)idSet));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        String seltor = "id,materialentry.unit.precision,materialentry.entryrcvorg,materialentry.material,materialentry.unit,materialentry.basicqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.basicunit,materialentry.entrystatus";
        DynamicObjectCollection reqlenishReqCols = QueryServiceHelper.query((String)"pur_saloutstock", (String)seltor, (QFilter[])qFilter.toArray());
        HashMap<String, BigDecimal> reqQtyMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, Long> baseUnitMap = new HashMap<String, Long>(1024);
        HashMap<String, Set> billIDSetMap = new HashMap<String, Set>(1024);
        for (DynamicObject entry : reqlenishReqCols) {
            if (!"A".equals(entry.getString("materialentry.entrystatus"))) continue;
            long invorg = entry.getLong("materialentry.entryrcvorg");
            long material = entry.getLong("materialentry.material");
            long baseunit = entry.getLong("materialentry.basicunit");
            long unit = entry.getLong("materialentry.unit");
            BigDecimal baseqty = entry.getBigDecimal("materialentry.basicqty");
            BigDecimal suminstockqty = entry.getBigDecimal("materialentry.suminstockqty");
            BigDecimal sumreceiptqty = entry.getBigDecimal("materialentry.sumreceiptqty");
            BigDecimal sumQty = ScpVMIPanelServiceHelper.getMaxSumQty(suminstockqty, sumreceiptqty);
            int precision = entry.getInt("materialentry.unit.precision");
            BigDecimal sumBaseQty = ScpVMIPanelServiceHelper.getDesQtyConv(material, unit, sumQty, baseunit, precision);
            BigDecimal qty = baseqty.subtract(sumBaseQty);
            String keyStr = invorg + "_" + material;
            if (!reqQtyMap.containsKey(keyStr)) {
                if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                reqQtyMap.put(keyStr, qty);
                baseUnitMap.put(keyStr, baseunit);
                HashSet<Long> billIdSet = new HashSet<Long>(1024);
                billIdSet.add(entry.getLong("id"));
                billIDSetMap.put(keyStr, billIdSet);
                continue;
            }
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal invQty = (BigDecimal)reqQtyMap.get(keyStr);
            reqQtyMap.put(keyStr, invQty.add(qty));
            Set billIdSet = (Set)billIDSetMap.get(keyStr);
            billIdSet.add(entry.getLong("id"));
            billIDSetMap.put(keyStr, billIdSet);
        }
        HashSet<Long> billIDSet = new HashSet<Long>(1024);
        if (null != pur_iminventorys) {
            for (DynamicObject dyn : pur_iminventorys) {
                long recorg = dyn.getLong("recorg.id");
                long material = dyn.getLong("material.id");
                long unit = dyn.getLong("unit.id");
                int precision = dyn.getInt("unit.precision");
                String keyStr = recorg + "_" + material;
                if (!reqQtyMap.containsKey(keyStr)) continue;
                long baseunit = (Long)baseUnitMap.get(keyStr);
                BigDecimal qty = (BigDecimal)reqQtyMap.get(keyStr);
                BigDecimal reqQty = ScpVMIPanelServiceHelper.getDesQtyConv(material, baseunit, qty, unit, precision);
                dyn.set("inqty", (Object)reqQty);
                billIDSet.addAll((Collection)billIDSetMap.get(keyStr));
            }
        } else {
            for (Map.Entry key : billIDSetMap.entrySet()) {
                if (!billIDSetMap.containsKey(org_material)) continue;
                billIDSet.addAll((Collection)key.getValue());
            }
        }
        return billIDSet;
    }

    private static BigDecimal getMaxSumQty(BigDecimal suminstockqty, BigDecimal sumreceiptqty) {
        if (suminstockqty.compareTo(sumreceiptqty) == 0) {
            return suminstockqty;
        }
        if (suminstockqty.compareTo(sumreceiptqty) > 0) {
            return suminstockqty;
        }
        return sumreceiptqty;
    }

    public static void doDealStatus(DynamicObjectCollection pur_iminventorys) {
        log.info("$$$$doDealStatus$$$$");
        for (DynamicObject dyn : pur_iminventorys) {
            BigDecimal minqty = dyn.getBigDecimal("minqty");
            BigDecimal maxqty = dyn.getBigDecimal("maxqty");
            BigDecimal qty = dyn.getBigDecimal("qty");
            if (minqty.compareTo(BigDecimal.ZERO) <= 0) {
                dyn.set("status", (Object)"B");
                continue;
            }
            if (qty.compareTo(minqty) < 0) {
                dyn.set("status", (Object)"A");
                continue;
            }
            if (qty.compareTo(maxqty) > 0) {
                dyn.set("status", (Object)"C");
                continue;
            }
            dyn.set("status", (Object)"B");
        }
        log.info("$$$$doDealStatus--end$$$$");
    }

    public static BigDecimal getDesQtyConv(Long materialId, Long srcUnit, BigDecimal srcQty, Long desUnit, Integer unitPrecision) {
        BigDecimal desQty = BigDecimal.ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null) {
            if (srcUnit.equals(desUnit)) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnit, (Long)desUnit);
                if (muConv != null) {
                    int numerator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        RoundingMode unitPrecisionType = RoundingMode.HALF_UP;
                        desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), (int)unitPrecision, unitPrecisionType);
                    }
                }
            }
            return desQty;
        }
        return BigDecimal.ZERO;
    }

    private static void setFilterValue(Set<Long> materialIdSet, Set<Long> orgIdSet, DynamicObjectCollection pur_iminventorys) {
        for (int i = 0; i < pur_iminventorys.size(); ++i) {
            DynamicObject iminv = (DynamicObject)pur_iminventorys.get(i);
            if (0L != iminv.getLong("material.id")) {
                materialIdSet.add(iminv.getLong("material.id"));
            }
            if (0L == iminv.getLong("recorg.id")) continue;
            orgIdSet.add(iminv.getLong("recorg.id"));
        }
    }
}

