/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.invcloud.AwsInvoiceCloudServiceHelper;
import kd.scm.common.invcloud.InvoiceCloudHelper;
import kd.scm.common.invcloud.InvoiceCloudServiceHelper;
import kd.scm.common.invcloud.KingdeeInvoiceCloudConfig;
import kd.scm.common.invcloud.bean.ImportInvocieResp;
import kd.scm.common.invcloud.bean.InvoiceData;
import kd.scm.common.invcloud.bean.ValidateInvocieRespParam;
import kd.scm.common.invcloud.enums.InvCheckStatusEnum;
import kd.scm.common.invcloud.enums.InvSourceEnum;
import kd.scm.common.invcloud.enums.InvoiceTypeEnum;

public abstract class AbstractInvoiceCloudPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(AbstractInvoiceCloudPlugin.class);

    protected void showSelectedInvoicePage() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbstractImportInvoicePlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> serialNos = this.getAllSerialNos();
        InvoiceCloudHelper.showSelectedInvoicePage((AbstractFormPlugin)this, (IDataModel)this.getModel(), (String)this.getCloseCallBackKey(), serialNos);
    }

    protected void showInvoice() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbstractImportInvoicePlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> serialNos = this.getAllSerialNos();
        if (serialNos == null) {
            return;
        }
        if (!serialNos.isEmpty()) {
            InvoiceCloudHelper.showInvoiceList((AbstractFormPlugin)this, (IDataModel)this.getModel(), serialNos, (String)"viewInvoice");
        }
    }

    protected void showInvoiceList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbstractImportInvoicePlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> serialNos = this.getAllSerialNos();
        if (serialNos == null) {
            return;
        }
        if (!serialNos.isEmpty()) {
            InvoiceCloudHelper.showInvoiceList((AbstractFormPlugin)this, (IDataModel)this.getModel(), serialNos, (String)"viewInvoiceList");
        }
    }

    private Set<String> getAllSerialNos() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection dynamicObjectCols = model.getEntityEntity(this.getEntryentitykey());
        if (dynamicObjectCols.isEmpty()) {
            return new HashSet<String>(8);
        }
        HashSet<String> serialNos = new HashSet<String>(8);
        for (DynamicObject dynamicObject : dynamicObjectCols) {
            serialNos.add(dynamicObject.getString("invserialnum"));
        }
        return serialNos;
    }

    protected void validateInvoice() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject dy = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCols = model.getEntityEntity(this.getEntryentitykey());
        if (dynamicObjectCols.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u53d1\u7968\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        List dynamicInvsourceCols = dynamicObjectCols.stream().filter(d -> InvSourceEnum.INVOICECLOUD.getVal().equals(d.getString("invsource"))).collect(Collectors.toList());
        if (dynamicInvsourceCols == null || dynamicInvsourceCols.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> invoiceList = new ArrayList<Object>(8);
        for (Object dynamicObject : dynamicInvsourceCols) {
            String invcheckstatus = dynamicObject.getString("invcheckstatus");
            String invsource = dynamicObject.getString("invsource");
            if (InvCheckStatusEnum.PASS.getVal().equals(invcheckstatus) || !InvSourceEnum.INVOICECLOUD.getVal().equals(invsource)) continue;
            invoiceList.add(dynamicObject);
        }
        List validateInvoices = InvoiceCloudHelper.check((DynamicObject)dy, invoiceList);
        if (!CollectionUtils.isEmpty((Collection)validateInvoices)) {
            model.beginInit();
            for (ValidateInvocieRespParam validateInvoice : validateInvoices) {
                if (!validateInvoice.isPass()) {
                    sb.append(ResManager.loadKDString((String)MessageFormat.format("\u53d1\u7968\u53f7\u7801\u4e3a:{0}\u7684\u53d1\u7968\u67e5\u9a8c\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a{1}", validateInvoice.getInvoiceNo(), validateInvoice.getMsg()), (String)"AbstractImportInvoicePlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
                    continue;
                }
                for (DynamicObject dynamicObject : dynamicInvsourceCols) {
                    String invno = dynamicObject.getString("invno");
                    if (invno == null || !invno.equals(validateInvoice.getInvoiceNo())) continue;
                    dynamicObject.set("invcheckstatus", (Object)InvCheckStatusEnum.PASS.getVal());
                    if (Objects.isNull(validateInvoice) || !StringUtils.isNotEmpty((String)validateInvoice.getSerialNo())) continue;
                    dynamicObject.set("invserialnum", (Object)validateInvoice.getSerialNo());
                    if (validateInvoice.getTotalAmount() != null) {
                        dynamicObject.set("invamount", (Object)validateInvoice.getTotalAmount());
                    }
                    if (validateInvoice.getInvoiceCode() != null) {
                        dynamicObject.set("invcode", (Object)validateInvoice.getInvoiceCode());
                    }
                    if (validateInvoice.getInvoiceNo() != null) {
                        dynamicObject.set("invno", (Object)validateInvoice.getInvoiceNo());
                    }
                    if (validateInvoice.getCheckCode() != null) {
                        dynamicObject.set("invid", (Object)validateInvoice.getCheckCode());
                    }
                    if (validateInvoice.getInvoiceAmount() != null) {
                        dynamicObject.set("invoiceamount", (Object)validateInvoice.getInvoiceAmount());
                    }
                    if (validateInvoice.getTotalTaxAmount() != null) {
                        dynamicObject.set("invtax", (Object)validateInvoice.getTotalTaxAmount());
                    }
                    if (validateInvoice.getBuyerName() != null) {
                        dynamicObject.set("reccompany", (Object)validateInvoice.getBuyerName());
                    }
                    if (validateInvoice.getSalerName() == null) continue;
                    dynamicObject.set("invcompany", (Object)validateInvoice.getSalerName());
                }
            }
            DynamicObject[] dynamicObjects = (DynamicObject[])dynamicObjectCols.toArray((Object[])new DynamicObject[0]);
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            model.endInit();
            this.getView().updateView();
            if (!StringUtils.isEmpty((String)sb.toString())) {
                this.getView().showErrorNotification(sb.toString());
                return;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u67e5\u9a8c\u6210\u529f\u3002", (String)"AbstractImportInvoicePlugin_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        Object returnData = closedCallBackEvent.getReturnData();
        logger.info("\u53d1\u7968\u4e91CP\u524d\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + JSONObject.toJSONString((Object)returnData));
        if (returnData != null && (actionId = closedCallBackEvent.getActionId()).equalsIgnoreCase(this.getCloseCallBackKey())) {
            try {
                List queryInvoices = null;
                if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
                    ImportInvocieResp invocieRespParam = (ImportInvocieResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)returnData), ImportInvocieResp.class);
                    List invoiceDatas = invocieRespParam.getInvoiceData();
                    if (invoiceDatas.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u53d1\u7968\u4e91\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AbstractImportInvoicePlugin_5", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List serialNos = invoiceDatas.stream().map(InvoiceData::getSerialNo).collect(Collectors.toList());
                    queryInvoices = InvoiceCloudServiceHelper.queryVerify(serialNos);
                } else if (returnData instanceof Map) {
                    Map returnMap = (Map)returnData;
                    String serialNos = (String)returnMap.get("serialNos");
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    queryInvoices = AwsInvoiceCloudServiceHelper.queryCloudInvoice((Long)((Long)org.getPkValue()), (String)serialNos);
                }
                if (queryInvoices != null) {
                    this.batchCreateNewEntiy(queryInvoices);
                }
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u53d1\u7968\u4e91\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\u3002", (String)"AbstractImportInvoicePlugin_6", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                logger.error("AbstractImportInvoicePlugin_showSelectedInvoicePage: \u4ece\u53d1\u7968\u4e91\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\u3002error:" + e);
            }
        }
    }

    private void batchCreateNewEntiy(List<InvoiceData> invoiceVOs) {
        int entryRowCount;
        String entryentity = this.getEntryentitykey();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(8);
        DynamicObjectCollection entityEntityCol = model.getEntityEntity(entryentity);
        if (!entityEntityCol.isEmpty()) {
            for (DynamicObject entityEntity : entityEntityCol) {
                Object invno = entityEntity.get("invno");
                if (invno != null && !StringUtils.isEmpty((String)invno.toString())) continue;
                int seq = entityEntity.getInt("seq") - 1;
                rowIndexs.add(seq);
            }
        }
        if (rowIndexs.size() > 0) {
            int[] array = rowIndexs.stream().mapToInt(Integer::intValue).toArray();
            model.deleteEntryRows(entryentity, array);
        }
        if (!this.checkInvoiceType(invoiceVOs, entityEntityCol, entryRowCount = entityEntityCol.size() - rowIndexs.size())) {
            return;
        }
        DynamicObjectCollection newentityEntityCol = model.getEntityEntity(entryentity);
        for (DynamicObject dy : newentityEntityCol) {
            Optional<InvoiceData> findAny;
            String invserialnum = dy.getString("invserialnum");
            if (StringUtils.isBlank((String)invserialnum) || !(findAny = invoiceVOs.stream().filter(i -> i.getSerialNo().equals(invserialnum)).findAny()).isPresent()) continue;
            InvoiceData invoiceData = findAny.get();
            invoiceVOs.remove(invoiceData);
        }
        DynamicObject curr = model.getDataEntity(true).getDynamicObject("curr");
        Map<String, Object> map = this.getInvoiceTypes();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (InvoiceData invoiceVO : invoiceVOs) {
            this.setExtensionData(vs, invoiceVO, rowCount);
            BigDecimal invamount = Optional.ofNullable(invoiceVO.getTotalAmount()).orElse(BigDecimal.ZERO);
            vs.set("invamount", (Object)invamount, rowCount);
            vs.set("invcode", (Object)invoiceVO.getInvoiceCode(), rowCount);
            vs.set("invno", (Object)invoiceVO.getInvoiceNo(), rowCount);
            vs.set("invdate", (Object)invoiceVO.getInvoiceDate(), rowCount);
            vs.set("invserialnum", (Object)invoiceVO.getSerialNo(), rowCount);
            vs.set("invid", (Object)invoiceVO.getCheckCode(), rowCount);
            vs.set("invremark", (Object)invoiceVO.getRemark(), rowCount);
            BigDecimal invoiceamount = Optional.ofNullable(invoiceVO.getAmount()).orElse(BigDecimal.ZERO);
            vs.set("invoiceamount", (Object)invoiceamount, rowCount);
            BigDecimal invtax = Optional.ofNullable(invoiceVO.getTaxAmount()).orElse(BigDecimal.ZERO);
            vs.set("invtax", (Object)invtax, rowCount);
            vs.set("invsource", (Object)InvSourceEnum.INVOICECLOUD.getVal(), rowCount);
            vs.set("invcheckstatus", (Object)InvCheckStatusEnum.fromVal((String)invoiceVO.getCheckStatus()).getVal(), rowCount);
            vs.set("reccompany", (Object)invoiceVO.getBuyerName(), rowCount);
            Long currencyId = invoiceVO.getCurrencyId();
            if ((currencyId == null || currencyId == 0L) && curr != null) {
                currencyId = (Long)curr.getPkValue();
            }
            vs.set("invcurr", (Object)currencyId, rowCount);
            vs.set("invcompany", (Object)invoiceVO.getSalerName(), rowCount);
            String invoiceTypeInv = invoiceVO.getInvoiceType();
            Object invoicetypePkid = map.get(invoiceTypeInv);
            if (invoicetypePkid == null) {
                invoicetypePkid = map.get("01");
            }
            vs.set("invoicetype", invoicetypePkid, rowCount);
            if (this.isOverseasInvoices(invoiceTypeInv)) {
                vs.set("invoiceamount", (Object)invamount, rowCount);
                vs.set("invtax", (Object)0, rowCount);
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entryentity, vs);
        model.endInit();
        this.getView().updateView();
    }

    private boolean isOverseasOrDigitalInvoices(String invoiceType) {
        return InvoiceTypeEnum.INVOICETYPE30.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE26.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE27.getVal().equals(invoiceType);
    }

    private boolean isOverseasInvoices(String invoiceType) {
        return InvoiceTypeEnum.INVOICETYPE30.getVal().equals(invoiceType);
    }

    private boolean checkInvoiceType(List<InvoiceData> invoiceVOs, DynamicObjectCollection entityEntityCol, int entryRowCount) {
        if (entryRowCount > 0) {
            boolean isExistInvoiceType30 = entityEntityCol.stream().anyMatch(entry -> this.isOverseasInvoices(entry.getDynamicObject("invoicetype").getString("number")));
            boolean anyMatch = invoiceVOs.stream().anyMatch(inv -> this.isOverseasInvoices(inv.getInvoiceType()));
            if (isExistInvoiceType30 && !anyMatch || !isExistInvoiceType30 && anyMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f62\u5f0f\u53d1\u7968\u548c\u975e\u5f62\u5f0f\u53d1\u7968\u4e0d\u53ef\u540c\u65f6\u5f55\u5165\u3002", (String)"AbstractImportInvoicePlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        boolean isExistOtherInvoiceType = invoiceVOs.stream().anyMatch(inv -> !this.isOverseasInvoices(inv.getInvoiceType()));
        boolean isExistInvoiceType30 = invoiceVOs.stream().anyMatch(inv -> this.isOverseasInvoices(inv.getInvoiceType()));
        if (isExistOtherInvoiceType && isExistInvoiceType30) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f62\u5f0f\u53d1\u7968\u548c\u975e\u5f62\u5f0f\u53d1\u7968\u4e0d\u53ef\u540c\u65f6\u5f55\u5165\u3002", (String)"AbstractImportInvoicePlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getInvoiceTypes() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        DynamicObjectCollection invoicetypes = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,number", null);
        for (DynamicObject dy : invoicetypes) {
            map.put(dy.getString("number"), dy.getLong("id"));
        }
        return map;
    }

    public abstract void setExtensionData(TableValueSetter var1, InvoiceData var2, int var3);

    public abstract String getCloseCallBackKey();

    public abstract String getEntryentitykey();
}

