/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.scp.common.util.ScpBillUtil;
import kd.scm.scp.formplugin.ScpCoreBillEditPlugin;

public class ScpAcceptApplyEditPlugin
extends ScpCoreBillEditPlugin
implements IConfirmCallBack,
EntryGridBindDataListener {
    private static final String CHECKTAX_AMOUNT_ACTION = "checktax_amount_action";
    private static final String CHECKSTATUS = "checkstatus";
    private ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        this.iCalDynamic.calSum(model.getDataEntity(true), "materialentry");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (null != args.getOperationResult() && args.getOperationResult().isSuccess() && "revoke".equals(operateKey)) {
            String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
            if (BillStatusEnum.AUDIT.getVal().equals(billstatus)) {
                this.getView().invokeOperation("unaudit");
            } else {
                this.getView().invokeOperation("unsubmit");
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTaxAmountMap();
        this.setIsPersentUnable("materialentry", "ispresent", "taxamount");
    }

    public void initTaxAmountMap() {
        String pageId = this.getView().getPageId();
        HashMap<String, String> taxaMountmap = new HashMap<String, String>(8);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long pkValue = (Long)dataEntity.getPkValue();
        DynamicObjectCollection cols = this.getModel().getEntryEntity("materialentry");
        for (int i = 0; i < cols.size(); ++i) {
            BigDecimal taxamount = ((DynamicObject)cols.get(i)).getBigDecimal("taxamount");
            Long id = ((DynamicObject)cols.get(i)).getLong("id");
            String poentryId = ((DynamicObject)cols.get(i)).getString("poentryid");
            String key = String.valueOf(id) + poentryId;
            if (taxamount.compareTo(BigDecimal.ZERO) <= 0) continue;
            taxaMountmap.put(key, taxamount.toString());
        }
        this.getView().getPageCache().put(pageId + pkValue + "taxamount", JSON.toJSONString(taxaMountmap));
    }

    private BigDecimal getInitTaxAmount(String id) {
        BigDecimal ret = null;
        String pageId = this.getView().getPageId();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String strMap = this.getView().getPageCache().get(pageId + pkValue + "taxamount");
        if (!StringUtils.isEmpty((CharSequence)strMap)) {
            JSONObject map = JSON.parseObject((String)strMap);
            if (CollectionUtils.isEmpty((Map)map) || !map.containsKey(id)) {
                return ret;
            }
            Object taxAmountObj = map.get(id);
            if (taxAmountObj != null) {
                ret = new BigDecimal((String)taxAmountObj);
            }
        }
        return ret;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releasInitMap();
        e.setCheckDataChange(false);
    }

    private void releasInitMap() {
        String pageId = this.getView().getPageId();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.getView().getPageCache().remove(pageId + pkValue.toString() + "taxamount");
        this.getView().getPageCache().remove(pageId + pkValue.toString() + "note");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        IDataModel dataModel = this.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = dataModel.getEntryCurrentRowIndex("materialentry");
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl("materialentry");
                grid.selectRows(rowIndex, true);
            }
            if ("taxamount".equals(property.getName())) {
                if (ScpBillUtil.compareTaxAmountAndSumAmount((DynamicObject)this.getModel().getDataEntity(true), (int)rowIndex)) {
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7d2f\u8ba1\u4ef7\u7a0e\u5408\u8ba1\u5c06\u5927\u4e8e\u6e90\u8ba2\u5355\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8d85\u989d\u3002", (String)"ScpAcceptApplyEditPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHECKTAX_AMOUNT_ACTION));
                    continue;
                }
                this.iCalDynamic.proChanged(dataEntity, "materialentry", property.getName(), rowIndex);
                this.iCalDynamic.calSum(dataEntity, "materialentry");
                this.getView().updateView();
                continue;
            }
            if (!"qty".equals(property.getName())) continue;
            this.iCalDynamic.proChanged(dataEntity, "materialentry", property.getName(), "scp_accept_apply", rowIndex);
            ScpBillUtil.updateEntryBasicQtyByLineIndex((DynamicObject)this.getModel().getEntryRowEntity("materialentry", rowIndex));
        }
        if ("qty".equals(property.getName())) {
            this.iCalDynamic.calSum(dataEntity, "materialentry");
            this.getView().updateView();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object billstatus;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        if ("signout".equals(operate.getOperateKey()) && "A".equals(billstatus = this.getModel().getValue("billstatus"))) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9a8c\u6536\u7533\u8bf7\u5355\u5904\u4e8e\u8349\u7a3f\u72b6\u6001\uff0c\u63d0\u4ea4\u7533\u8bf7\u540e\u624d\u751f\u6548\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\u7533\u8bf7\uff1f", (String)"ScpAcceptApplyEditPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CHECKSTATUS));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (callBackId.equals(CHECKTAX_AMOUNT_ACTION)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Cancel)) {
                String index = this.getPageCache().get("rowIndex");
                int rowIndex = 0;
                rowIndex = null == index ? this.getModel().getEntryCurrentRowIndex("materialentry") : Integer.parseInt(index.toString());
                DynamicObject entryObj = this.getModel().getEntryRowEntity("materialentry", rowIndex);
                if (entryObj == null) {
                    return;
                }
                Long id = entryObj.getLong("id");
                String poentryId = entryObj.getString("poentryid");
                String key = String.valueOf(id) + poentryId;
                BigDecimal taxAmount = this.getInitTaxAmount(key);
                BigDecimal newtaxamount = CommonUtil.getBigDecimalPro((Object)entryObj.getBigDecimal("taxamount"));
                if (null != taxAmount && newtaxamount.compareTo(taxAmount) > 0) {
                    entryObj.set("taxamount", (Object)taxAmount);
                }
                this.iCalDynamic.proChanged(dataEntity, "materialentry", "taxamount", rowIndex);
                this.iCalDynamic.calSum(dataEntity, "materialentry");
                this.getView().updateView();
            }
        } else if (CHECKSTATUS.equals(callBackId)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                OperationResult result = this.getView().invokeOperation("submit");
                if (result.isSuccess()) {
                    this.getView().close();
                }
            } else {
                this.getView().close();
            }
        }
    }
}

