/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;

public class ScpCheckSplitPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String AUTOAPLIT = "autosplit";
    private static boolean isFirstChange = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_autosplit", "btn_save"});
        TextEdit text = (TextEdit)this.getControl("invseq");
        text.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
        this.getModel().setDataChanged(false);
    }

    private void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("billno", customParams.get("billno"));
        model.setValue("curr", customParams.get("curr"));
        model.setValue("uninvoicedtaxamount", customParams.get("unInvoicedTaxAmount"));
        model.setValue("sumtaxamount", customParams.get("unInvoicedTaxAmount"));
        Object chkScheme = customParams.get("chkscheme");
        if (chkScheme != null) {
            model.setValue("upamount", (Object)this.getUpamount(chkScheme));
        }
    }

    private BigDecimal getUpamount(Object chkScheme) {
        DynamicObject scheme;
        BigDecimal upAmount = BigDecimal.ZERO;
        if (chkScheme != null && (scheme = this.getSchemeData(Long.parseLong(chkScheme.toString()))) != null) {
            upAmount = CommonUtil.getBigDecimalPro((Object)scheme.get("invupamount"));
        }
        return upAmount;
    }

    public DynamicObject getSchemeData(long schemeId) {
        String selectFields = "id,number,invupamount";
        HashMap<String, Long> filterMap = new HashMap<String, Long>(1);
        filterMap.put("id", schemeId);
        DynamicObject returnData = null;
        returnData = ORMUtil.queryOneByPro((String)"scp_chkscheme", (String)selectFields, filterMap);
        return returnData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "autosplit": {
                this.returnVal();
            }
        }
    }

    private void returnVal() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(4);
        IDataModel model = this.getModel();
        Object sumTaxAmount = model.getValue("sumtaxamount");
        returnData.put("sumTaxAmount", sumTaxAmount);
        Object downAmount = model.getValue("downamount");
        returnData.put("downAmount", downAmount);
        Object upAmount = model.getValue("upamount");
        returnData.put("upAmount", upAmount);
        Object invSeq = model.getValue("invseq");
        if (null != invSeq) {
            returnData.put("invSeq", this.getPageCache().get("fieldNumber"));
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (isFirstChange && "sumtaxamount".equals(property)) {
            isFirstChange = false;
            ChangeData[] changeData = e.getChangeSet();
            BigDecimal unInvoiceAmount = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("uninvoicedtaxamount"));
            BigDecimal value = CommonUtil.getBigDecimalPro((Object)changeData[0].getNewValue());
            if (value.compareTo(unInvoiceAmount) > 0) {
                IDataModel model = this.getModel();
                model.setValue("sumtaxamount", changeData[0].getOldValue());
                this.getView().showMessage(ResManager.loadKDString((String)"\u672c\u6b21\u5f00\u7968\u603b\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u5f00\u7968\u91d1\u989d\u3002", (String)"ScpCheckSplitPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
            isFirstChange = true;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.selectOrderFields();
    }

    private void selectOrderFields() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"scp_selectorderfield", (Map)customParams, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "selectfield"), (ShowType)ShowType.Modal);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String accountId;
        super.closedCallBack(closedCallBackEvent);
        switch (accountId = closedCallBackEvent.getActionId()) {
            case "selectfield": {
                Map selectReturnData = (Map)closedCallBackEvent.getReturnData();
                if (null == selectReturnData) {
                    return;
                }
                IPageCache cache = this.getPageCache();
                for (Map.Entry returnData : selectReturnData.entrySet()) {
                    cache.put((String)returnData.getKey(), returnData.getValue().toString());
                }
                this.getModel().setValue("invSeq", selectReturnData.get("fieldName"));
                break;
            }
        }
    }
}

