/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class ScpGenericLogisticsInfoInputPlugin
extends AbstractFormPlugin {
    protected static final String ENTRY_KEY = "ENTRY_KEY";
    protected static final String ENTRY_ENTITY = "entryentity";
    protected static final String LOG_ENTRY_ENTITY = "logentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.allotDynamicData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String evtItemKey;
        super.itemClick(evt);
        switch (evtItemKey = evt.getItemKey()) {
            case "bar_save": {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
                String entryKey = this.getPageCache().get(ENTRY_KEY);
                this.saveBillInfo(dynamicObjectCollection, entryKey);
                this.clearData();
                this.getView().updateView();
                this.allotDynamicData();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String evtItemKey;
        switch (evtItemKey = evt.getItemKey()) {
            case "bar_save": {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (!this.fitNullValue(dynamicObjectCollection)) break;
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity(LOG_ENTRY_ENTITY);
                if (entryColl == null || entryColl.size() == 0) {
                    this.getModel().createNewEntryRow(LOG_ENTRY_ENTITY);
                }
                evt.setCancel(true);
                break;
            }
        }
    }

    public boolean fitNullValue(DynamicObjectCollection dynamicObjectsParam) {
        HashMap<String, StringBuffer> messageMap = new HashMap<String, StringBuffer>();
        boolean returnFlag = false;
        for (DynamicObject dynamicObject : dynamicObjectsParam) {
            String billNo = dynamicObject.getString("billno");
            StringBuffer fitReturnResult = new StringBuffer();
            StringBuffer fitDataResult = new StringBuffer();
            StringBuffer fitDateResult = new StringBuffer();
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(LOG_ENTRY_ENTITY);
            if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                int index = 1;
                boolean dateFlag = false;
                boolean mustInt = false;
                DataEntityPropertyCollection properties = dynamicObjectCollection.getDynamicObjectType().getProperties();
                for (DynamicObject logRow : dynamicObjectCollection) {
                    fitDataResult.setLength(0);
                    fitDateResult.setLength(0);
                    Date logDate = logRow.getDate("logdate");
                    fitDataResult.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a", (String)"ScpGenericLogisticsInfoInputPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0]), index));
                    for (IDataEntityProperty entityProperty : properties) {
                        String name = entityProperty.getName();
                        Object value = logRow.get(name);
                        switch (name) {
                            case "logsupplier": {
                                if (value != null && !"".equals(value.toString().trim())) break;
                                fitDataResult.append(this.getModel().getProperty(name).getDisplayName().getLocaleValue()).append('\u3001');
                                mustInt = true;
                                break;
                            }
                            case "logdate": {
                                if (value != null && !"".equals(value.toString().trim())) break;
                                fitDataResult.append(this.getModel().getProperty(name).getDisplayName().getLocaleValue()).append('\u3001');
                                mustInt = true;
                                break;
                            }
                            case "logbillno": {
                                if (value != null && !"".equals(value.toString().trim())) break;
                                fitDataResult.append(this.getModel().getProperty(name).getDisplayName().getLocaleValue()).append('\u3001');
                                mustInt = true;
                                break;
                            }
                            case "logdelidate": {
                                String deliDateName = this.getModel().getProperty(name).getDisplayName().getLocaleValue();
                                String logDateName = this.getModel().getProperty("logdate").getDisplayName().getLocaleValue();
                                if (value == null || logDate == null || !((Date)value).before(logDate)) break;
                                fitDateResult.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u4e0d\u80fd\u65e9\u4e8e\u201c{1}\u201d\u3002", (String)"ScpGenericLogisticsInfoInputPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), deliDateName, logDateName));
                                dateFlag = true;
                            }
                        }
                    }
                    if (!dateFlag && !mustInt) {
                        fitDataResult.delete(fitDataResult.length() - 4, fitDataResult.length());
                    }
                    if (dateFlag && mustInt) {
                        fitReturnResult.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u7b49\u5b57\u6bb5\u672a\u5f55\u5165\uff0c{1}", (String)"ScpGenericLogisticsInfoInputPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), fitDataResult, fitDateResult));
                    } else if (!dateFlag && mustInt) {
                        fitReturnResult.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u7b49\u5b57\u6bb5\u672a\u5f55\u5165\u3002", (String)"ScpGenericLogisticsInfoInputPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]), fitDataResult));
                    } else if (!mustInt && dateFlag) {
                        fitReturnResult.append(fitDataResult).append(fitDateResult);
                    }
                    ++index;
                }
            }
            if (fitReturnResult.length() <= 0) continue;
            messageMap.put(billNo, fitReturnResult);
        }
        StringBuilder stringBuffer = new StringBuilder();
        for (Map.Entry entry : messageMap.entrySet()) {
            returnFlag = true;
            stringBuffer.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7{0}\uff1a", (String)"ScpGenericLogisticsInfoInputPlugin_5", (String)"scm-scp-formplugin", (Object[])new Object[0]), entry.getValue())).append('\n').delete(stringBuffer.length(), stringBuffer.length());
        }
        if (stringBuffer.length() > 0) {
            returnFlag = true;
            this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6d41\u4fe1\u606f\u5f55\u5165\u5931\u8d25\u3002", (String)"ScpGenericLogisticsInfoInputPlugin_6", (String)"scm-scp-formplugin", (Object[])new Object[0]), stringBuffer.toString(), MessageTypes.Commit);
        }
        return returnFlag;
    }

    public void clearData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(LOG_ENTRY_ENTITY);
        model.deleteEntryData(ENTRY_ENTITY);
    }

    protected void allotDynamicData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.size() > 0) {
            Long t1 = System.currentTimeMillis();
            String entryKey = this.assembleShowEntryKey(customParams);
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.queryDynamicObjectCollection((String)entryKey, (String)this.assembleSelectFields(entryKey), this.assembleQueryFilterMap(customParams));
            HashSet<String> billNoSet = new HashSet<String>();
            ArrayList<DynamicObject> headArrayList = new ArrayList<DynamicObject>();
            HashMap entryListHashMap = new HashMap();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String billNo = dynamicObject.getString("billno");
                ArrayList<DynamicObject> entryDynamicObjectList = new ArrayList<DynamicObject>();
                for (DynamicObject entryLog : dynamicObjectCollection) {
                    if (!billNo.equals(entryLog.getString("billno"))) continue;
                    entryDynamicObjectList.add(entryLog);
                }
                entryListHashMap.put(billNo, entryDynamicObjectList);
                if (billNoSet.contains(billNo)) continue;
                headArrayList.add(dynamicObject);
                billNoSet.add(billNo);
            }
            if (headArrayList.size() > 0) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                List propertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(ENTRY_ENTITY).getDynamicObjectType());
                int rowCount = 0;
                EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
                DataEntityPropertyCollection entityProperties = ((DynamicObject)headArrayList.get(0)).getDynamicObjectType().getProperties();
                for (DynamicObject dynamicObject : headArrayList) {
                    model.createNewEntryRow(ENTRY_ENTITY);
                    for (IDataEntityProperty entityProperty : entityProperties) {
                        String proName = entityProperty.getName().toLowerCase();
                        Object value = entityProperty.getValue((Object)dynamicObject);
                        if (!propertiesEntity.contains(proName) || value == null) continue;
                        model.setValue(proName, value, rowCount);
                    }
                    DynamicObjectCollection dynamicObjectCollectionUI = model.getEntryEntity(ENTRY_ENTITY, rowCount).getDynamicObjectCollection(LOG_ENTRY_ENTITY);
                    List subPropertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)dynamicObjectCollectionUI.getDynamicObjectType());
                    if (null != entryListHashMap.get(dynamicObject.getString("billno")) && ((ArrayList)entryListHashMap.get(dynamicObject.getString("billno"))).size() > 0) {
                        grid.selectRows(rowCount);
                        model.deleteEntryData(LOG_ENTRY_ENTITY);
                        model.batchCreateNewEntryRow(LOG_ENTRY_ENTITY, DynamicFormUtil.batchBindData((List)((List)entryListHashMap.get(dynamicObject.getString("billno"))), (List)subPropertiesEntity, (String)""));
                    }
                    ++rowCount;
                }
                grid.selectRows(0);
            }
            Long l = System.currentTimeMillis();
        }
    }

    public Map<String, Map<String, Object>> assembleQueryFilterMap(Map<String, Object> showParameterMap) {
        Map queryFilterMap = BillFormUtil.assembleFormParamMap(showParameterMap);
        queryFilterMap.putAll(BizPartnerUtil.assembleBizPartner());
        return queryFilterMap;
    }

    public String assembleSelectFields(String billKey) {
        switch (billKey) {
            case "scp_order": {
                return "id as billid,billno,billdate,org.id purorg,supplier.id as supplier,logentryentity.id as logentryid,logentryentity.logsupplier.id logsupplier,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_saloutstock": {
                return "id as billid,billno,billdate,purorg.id purorg,org.id rcvorg,supplier.id supplier,logentryentity.id as logentryid,logentryentity.logsupplier.id logsupplier,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_receive": {
                return "id as billid,billno,billdate,org.id purorg,rcvorg.id rcvorg,supplier.id supplier,logentryentity.id as logentryid,logentryentity.logsupplier.id logsupplier,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_invoice": {
                return "id as billid,billno,billdate,purorg.id purorg,org.id org,supplier.id supplier,logentryentity.id as logentryid,logentryentity.logsupplier.id logsupplier,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
        }
        return null;
    }

    public String assembleShowEntryKey(Map<String, Object> showParameterMap) {
        String entryKey = showParameterMap.get(ENTRY_KEY).toString();
        if (entryKey != null) {
            this.getPageCache().put(ENTRY_KEY, entryKey);
            return entryKey;
        }
        this.getPageCache().put(ENTRY_KEY, "scp_order");
        return "scp_order";
    }

    public void saveBillInfo(DynamicObjectCollection dynamicObjectsParam, String entryEntityKey) {
        HashMap<String, DynamicObjectCollection> logCollMap = new HashMap<String, DynamicObjectCollection>();
        HashSet<Long> billIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjectsParam) {
            String billId = dynamicObject.getString("billid");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(LOG_ENTRY_ENTITY);
            if (billId != null) {
                billIdSet.add(Long.parseLong(billId));
            }
            if (dynamicObjectCollection.size() <= 0) continue;
            logCollMap.put(billId, dynamicObjectCollection);
        }
        HashMap filterMap = new HashMap();
        HashMap<String, HashSet<Long>> pkIdMap = new HashMap<String, HashSet<Long>>();
        pkIdMap.put("in", billIdSet);
        filterMap.put("id", pkIdMap);
        String selected = "id,logentryentity,logentryentity.seq,logentryentity.logsupplier,logentryentity.logbillno,logentryentity.logdate,logentryentity.logdelidate,logentryentity.lognote";
        DynamicObject[] dynamicObjects = ORMUtil.load((String)entryEntityKey, (String)selected, filterMap);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            HashMap<String, DynamicObject> dynamicObjectHashMap = new HashMap<String, DynamicObject>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection saveLogColl = dynamicObject.getDynamicObjectCollection(LOG_ENTRY_ENTITY);
                DynamicObjectCollection dyCollUILog = (DynamicObjectCollection)logCollMap.get(dynamicObject.getString("id"));
                ArrayList<String> dbIds = new ArrayList<String>();
                ArrayList<String> modifyIdsSet = new ArrayList<String>();
                ArrayList<String> deleteIdsSet = new ArrayList<String>();
                for (DynamicObject dynamicObjectLog : saveLogColl) {
                    if (dynamicObjectLog.getString("id") == null) continue;
                    dbIds.add(dynamicObjectLog.getString("id"));
                    dynamicObjectHashMap.put(dynamicObjectLog.getString("id"), dynamicObjectLog);
                }
                if (dyCollUILog != null) {
                    for (DynamicObject entryRow : dyCollUILog) {
                        String logEntryId = entryRow.getString("logentryid").trim();
                        if (dbIds.contains(logEntryId)) {
                            this.assembleColl(entryRow, (DynamicObject)dynamicObjectHashMap.get(logEntryId));
                            modifyIdsSet.add(logEntryId);
                            continue;
                        }
                        DynamicObject newDynamicObject = ORMUtil.newDynamicObject((DynamicObjectType)saveLogColl.getDynamicObjectType());
                        saveLogColl.add((Object)this.assembleColl(entryRow, newDynamicObject));
                    }
                } else {
                    deleteIdsSet.addAll(dbIds);
                }
                int seq = 1;
                for (DynamicObject temp : saveLogColl) {
                    temp.set("seq", (Object)seq);
                    ++seq;
                }
                dbIds.forEach(row -> {
                    if (!modifyIdsSet.contains(row)) {
                        deleteIdsSet.add((String)row);
                    }
                });
                saveLogColl.removeIf(o -> deleteIdsSet.contains(o.getString("id")));
                dynamicObject.set(LOG_ENTRY_ENTITY, (Object)saveLogColl);
                modifyIdsSet.clear();
                deleteIdsSet.clear();
                dynamicObjectHashMap.clear();
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7269\u6d41\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\u3002", (String)"ScpGenericLogisticsInfoInputPlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
        }
    }

    public DynamicObject assembleColl(DynamicObject dynamicObjectUI, DynamicObject newDynamicObject) {
        DataEntityPropertyCollection properties = dynamicObjectUI.getDataEntityType().getProperties();
        for (IDataEntityProperty entityProperty : properties) {
            String name = entityProperty.getName();
            Object value = dynamicObjectUI.get(name);
            switch (name) {
                case "id": {
                    if (!(value instanceof Long) || (Long)value == 0L) break;
                    newDynamicObject.set(name, value);
                    break;
                }
                case "logsupplier": {
                    newDynamicObject.set(name, value);
                    break;
                }
                case "logbillno": {
                    newDynamicObject.set(name, value);
                    break;
                }
                case "logdate": {
                    newDynamicObject.set(name, value);
                    break;
                }
                case "logdelidate": {
                    newDynamicObject.set(name, value);
                    break;
                }
                case "lognote": {
                    newDynamicObject.set(name, value);
                }
            }
        }
        return newDynamicObject;
    }
}

