/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ScpInventoryLogPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object supplierObj = formShowParameter.getCustomParam("supplier");
        Object materialObj = formShowParameter.getCustomParam("material");
        Object org = formShowParameter.getCustomParam("org");
        if (supplierObj == null || materialObj == null || org == null) {
            return;
        }
        long supplier = Long.parseLong(supplierObj.toString());
        long material = Long.parseLong(materialObj.toString());
        this.fillEntryData(supplier, material, org);
    }

    public void fillEntryData(long supplierId, long materialId) {
        this.fillEntryData(supplierId, materialId, null);
    }

    private void fillEntryData(long supplierId, long materialId, Object orgId) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        QFilter filter = new QFilter("supplier.id", "=", (Object)supplierId);
        filter.and("material.id", "=", (Object)materialId);
        if (orgId != null) {
            filter.and("org.id", "=", orgId);
        }
        DynamicObjectCollection logRecord = QueryServiceHelper.query((String)"scp_inventorylog_record", (String)"operation,modifier,updatetime", (QFilter[])new QFilter[]{filter}, (String)"updatetime desc");
        for (int i = 0; i < logRecord.size(); ++i) {
            vs.set("operation", ((DynamicObject)logRecord.get(i)).get("operation"), i);
            vs.set("updatetime", ((DynamicObject)logRecord.get(i)).get("updatetime"), i);
            vs.set("modifier", ((DynamicObject)logRecord.get(i)).get("modifier"), i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", vs);
    }
}

