/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;

public class ScpInventoryPanelPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ScpInventoryPanelPlugin.class);

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        DynamicObject selectRow = (DynamicObject)entryentity.get(rowIndex);
        switch (fieldName) {
            case "updatelog": {
                long material = selectRow.getLong("material.id");
                long supplier = selectRow.getLong("supplier.id");
                long org = selectRow.getLong("org.id");
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("supplier", supplier);
                paramMap.put("material", material);
                paramMap.put("org", org);
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_inventory_log", (ShowType)ShowType.Modal, paramMap, null);
                break;
            }
        }
    }

    private QFilter initQfilter() {
        QFilter invqFilter = new QFilter("billstatus", "=", (Object)"C");
        invqFilter.and(new QFilter("materialentry.entrystatus", "=", (Object)"A"));
        HashSet<String> logisticsStatusSet = new HashSet<String>();
        logisticsStatusSet.add(LogisticsStatusEnum.CONFIRM.getVal());
        logisticsStatusSet.add(LogisticsStatusEnum.PARTOUTSTOCK.getVal());
        logisticsStatusSet.add(LogisticsStatusEnum.ALLOUTSTOCK.getVal());
        logisticsStatusSet.add(LogisticsStatusEnum.PARTRECIPT.getVal());
        logisticsStatusSet.add(LogisticsStatusEnum.PARTINSTOCK.getVal());
        invqFilter.and(new QFilter("materialentry.rowlogstatus", "in", logisticsStatusSet));
        return invqFilter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(this::searchByMaterial);
        EntryGrid billList = (EntryGrid)this.getView().getControl("entryentity");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData(null);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barexport": {
                break;
            }
            case "barrefresh": {
                this.initData(null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "refreshdata": {
                this.initData(null);
                break;
            }
            case "exportdata": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u51fa\u4e2d\u3002", (String)"ScpInventoryPanelPlugin_0", (String)"scm-scp-formplugin", (Object[])new Object[0])));
                    this.export();
                    break;
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "inventoryqty": {
                String operation;
                ChangeData changeData = changeSet[0];
                int rowIndex = changeData.getRowIndex();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
                long orgId = dynamicObject.getLong("org.id");
                long materialId = dynamicObject.getLong("material.id");
                long supplierId = dynamicObject.getLong("supplier.id");
                QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
                QFilter materialFilter = new QFilter("material.id", "=", (Object)materialId);
                QFilter supplierFilter = new QFilter("supplier.id", "=", (Object)supplierId);
                DynamicObject purStock = BusinessDataServiceHelper.loadSingle((String)"pur_stock", (QFilter[])new QFilter[]{orgFilter.and(materialFilter).and(supplierFilter)});
                if (purStock == null) break;
                BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
                BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                if (BigDecimal.ZERO.compareTo(newValue) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u4ee5\u8f93\u5165\u5c0f\u4e8e\u96f6\u7684\u6570\u3002", (String)"ScpInventoryPanelPlugin_17", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    return;
                }
                purStock.set("inventoryqty", changeSet[0].getNewValue());
                Date now = TimeServiceHelper.now();
                model.setValue("updatetime", (Object)now, rowIndex);
                purStock.set("updatetime", (Object)now);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purStock});
                if (BigDecimal.ZERO.compareTo(oldValue) == 0) {
                    oldValue = BigDecimal.ZERO;
                }
                DynamicObject inventoryLog = BusinessDataServiceHelper.newDynamicObject((String)"scp_inventorylog_record");
                if (model.getValue("unit", rowIndex) != null) {
                    DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
                    String unitName = unit.getString("name");
                    operation = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf\u4ece%1$s%2$s\u53d8\u6210\u4e86%3$s%4$s", (String)"ScpInventoryPanelPlugin_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), oldValue.setScale(0), unitName, newValue.setScale(0), unitName);
                } else {
                    operation = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf\u4ece%1$s\u53d8\u6210\u4e86%2$s", (String)"ScpInventoryPanelPlugin_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), changeData.getOldValue(), changeData.getNewValue());
                }
                inventoryLog.set("org", (Object)orgId);
                inventoryLog.set("supplier", (Object)supplierId);
                inventoryLog.set("material", (Object)materialId);
                inventoryLog.set("operation", (Object)operation);
                inventoryLog.set("modifier", (Object)RequestContext.get().getCurrUserId());
                inventoryLog.set("updatetime", (Object)now);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inventoryLog});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ScpInventoryPanelPlugin_3", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void initData(HashSet<String> materialFilters) {
        Set idSet = BizPartnerUtil.getBizPartnerIds();
        QFilter filter = new QFilter("bizpartner", "in", (Object)idSet);
        List permissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
        filter.and("org", "in", (Object)permissionOrgs);
        if (null != materialFilters && materialFilters.size() > 0) {
            QFilter materialNameFilter = this.getSearchFilter("material.name", materialFilters);
            QFilter materialNumFilter = this.getSearchFilter("material.number", materialFilters);
            if (null != materialNameFilter && null != materialNumFilter) {
                filter = filter.and(materialNameFilter.or(materialNumFilter));
            }
        }
        DynamicObjectCollection newInventoryData = QueryServiceHelper.query((String)"pur_stock", (String)"org,material,supplier,inventoryqty,orderqty,unit,updatetime", (QFilter[])new QFilter[]{filter}, (String)"updatetime");
        this.dealEntry(newInventoryData);
    }

    private QFilter getSearchFilter(String name, HashSet<String> materialFilters) {
        QFilter qFilter = null;
        for (String key : materialFilters) {
            if (qFilter == null) {
                qFilter = new QFilter(name, "like", (Object)("%" + key + "%"));
                continue;
            }
            qFilter.or(new QFilter(name, "like", (Object)("%" + key + "%")));
        }
        return qFilter;
    }

    public void searchByMaterial(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null) {
            this.initData(null);
            return;
        }
        HashSet<String> materialFilters = new HashSet<String>(1);
        for (Map searchField : searchFields) {
            List fieldNames = (List)searchField.get("fieldName");
            List values = (List)searchField.get("value");
            if (CollectionUtils.isEmpty((Collection)values) || !fieldNames.contains("materialname") && !fieldNames.contains("material")) continue;
            materialFilters.addAll(values);
        }
        this.initData(materialFilters);
    }

    private void dealEntry(DynamicObjectCollection inventorys) {
        if (!inventorys.isEmpty()) {
            this.initEntry(inventorys);
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void initEntry(DynamicObjectCollection inventorys) {
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DataEntityPropertyCollection properties = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity").getDynamicObjectType().getProperties();
        List props = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
        ArrayList<String> allProsList = new ArrayList<String>();
        allProsList.add("org");
        allProsList.add("material");
        allProsList.add("supplier");
        allProsList.add("inventoryqty");
        allProsList.add("orderqty");
        allProsList.add("unit");
        allProsList.add("updatetime");
        int index = 0;
        boolean isAddIndex = false;
        for (DynamicObject dyn : inventorys) {
            for (String key : props) {
                if (!allProsList.contains(key)) continue;
                Object o = dyn.get(key);
                if (o instanceof DynamicObject) {
                    vs.set(key, ((DynamicObject)o).getPkValue(), index);
                    isAddIndex = true;
                    continue;
                }
                vs.set(key, dyn.get(key), index);
                isAddIndex = true;
            }
            if (!isAddIndex) continue;
            ++index;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
    }

    private void export() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"ScpInventoryPanelPlugin_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u770b\u677f.xlsx", (String)"ScpInventoryPanelPlugin_5", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            this.setColumn(excelDataEntity);
            ScpInventoryPanelPlugin.setExcelHeader(excelDataEntity);
            ScpInventoryPanelPlugin.setEexclBody(excelDataEntity, model, selectRows);
            excelDataEntity.setExcelHeaderStyle(1, 4);
            excelDataEntity.setDataFormatForNumberic(0, 1, 1, selectRows.length);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            log.warn((Throwable)e);
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ScpInventoryPanelPlugin_6", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        }
    }

    public void setColumn(ExcelDataEntity column) {
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("seq");
        columnList.add("org");
        columnList.add("material");
        columnList.add("materialname");
        columnList.add("model");
        columnList.add("supplier");
        columnList.add("orderqty");
        columnList.add("inventoryqty");
        columnList.add("unit");
        columnList.add("updatetime");
        column.setColumnKeyList(columnList);
    }

    private static void setExcelHeader(ExcelDataEntity excelDataEntity) throws IOException {
        ArrayList<String> columnTitle = new ArrayList<String>();
        columnTitle.add(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ScpInventoryPanelPlugin_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ScpInventoryPanelPlugin_16", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"ScpInventoryPanelPlugin_8", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"ScpInventoryPanelPlugin_9", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"ScpInventoryPanelPlugin_10", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"ScpInventoryPanelPlugin_11", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf", (String)"ScpInventoryPanelPlugin_12", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf", (String)"ScpInventoryPanelPlugin_13", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ScpInventoryPanelPlugin_14", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        columnTitle.add(ResManager.loadKDString((String)"\u66f4\u65b0\u65f6\u95f4", (String)"ScpInventoryPanelPlugin_15", (String)"scm-scp-formplugin", (Object[])new Object[0]));
        excelDataEntity.setExcelHeader(columnTitle);
    }

    private static void setEexclBody(ExcelDataEntity excelDataEntity, IDataModel model, int[] selectRows) throws IOException {
        List columnKeyList = excelDataEntity.getColumnKeyList();
        int index = 0;
        for (int i : selectRows) {
            List<String> rowData = ScpInventoryPanelPlugin.getRowDataByIndex(model, columnKeyList, i);
            excelDataEntity.createRow(0, index + 1);
            excelDataEntity.setRowValue(0, rowData, index + 1);
            ++index;
        }
    }

    private static List<String> getRowDataByIndex(IDataModel model, List<String> columnKeyList, int i) {
        ArrayList<String> rowData = new ArrayList<String>(columnKeyList.size());
        DynamicObject dyObj = model.getEntryRowEntity("entryentity", i);
        for (String column : columnKeyList) {
            Object val = "";
            if (column.equals("materialname")) {
                if (null != dyObj.get("material")) {
                    val = ((DynamicObject)dyObj.get("material")).get("name");
                }
                rowData.add(String.valueOf(val));
                continue;
            }
            if (column.equals("model")) {
                if (null != dyObj.get("material")) {
                    val = ((DynamicObject)dyObj.get("material")).get("modelnum");
                }
                rowData.add(String.valueOf(val));
                continue;
            }
            if (column.equals("updatetime")) {
                if (null != dyObj.get("updatetime")) {
                    Date updatetime = dyObj.getDate("updatetime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    val = simpleDateFormat.format(updatetime);
                }
                rowData.add(val.toString());
                continue;
            }
            Object columnVal = dyObj.get(column);
            if (columnVal == null) {
                val = "";
            } else if (columnVal instanceof DynamicObject) {
                val = ((DynamicObject)columnVal).get("name");
                if ("material".equals(column)) {
                    val = ((DynamicObject)columnVal).get("number");
                }
            } else {
                val = columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : columnVal) : columnVal;
            }
            if (val instanceof BigDecimal) {
                int scale = 2;
                if (null != dyObj.getDynamicObject("unit")) {
                    scale = dyObj.getDynamicObject("unit").getInt("precision");
                }
                val = ((BigDecimal)val).setScale(scale);
            }
            rowData.add(String.valueOf(val));
        }
        return rowData;
    }
}

