/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.OrgUtil;

public class ScpOrgsPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgType = (String)formShowParameter.getCustomParam("orgType");
        if (StringUtils.isEmpty((String)orgType)) {
            return;
        }
        switch (orgType) {
            case "purorg": {
                List purorgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
                this.fillEntryData(purorgIds);
                break;
            }
            case "invorg": {
                List invorgIds = OrgUtil.getUserHasAllInvPermissionOrgs();
                this.fillEntryData(invorgIds);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List orgNameList = (List)formShowParameter.getCustomParam("selectdOrgs");
        ArrayList<Integer> selectedList = new ArrayList<Integer>();
        if (orgNameList != null) {
            DynamicObjectCollection entrydatas = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entrydata : entrydatas) {
                if (!orgNameList.contains(entrydata.get("name"))) continue;
                int seq = (Integer)entrydata.get("seq");
                selectedList.add(seq - 1);
            }
        }
        int[] selects = selectedList.stream().mapToInt(Integer::valueOf).toArray();
        entryentity.selectRows(selects, 0);
    }

    public void fillEntryData(List<Long> ids) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection purorgs = QueryServiceHelper.query((String)"bos_org", (String)"number,name,id", (QFilter[])new QFilter[]{filter}, (String)"number");
        for (int i = 0; i < purorgs.size(); ++i) {
            vs.set("number", ((DynamicObject)purorgs.get(i)).get("number"), i);
            vs.set("name", ((DynamicObject)purorgs.get(i)).get("name"), i);
            vs.set("orgid", ((DynamicObject)purorgs.get(i)).get("id"), i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("confirm".equals(formOperate.getOperateKey())) {
            this.setReturnDataToParent();
        }
    }

    private void setReturnDataToParent() {
        HashMap returnData = new HashMap();
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryentity.getSelectRows();
        DynamicObjectCollection entrydata = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> nameList = new ArrayList<String>(selectRows.length);
        ArrayList<String> orgidList = new ArrayList<String>(selectRows.length);
        for (int i : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entrydata.get(i);
            nameList.add(dynamicObject.getString("name"));
            orgidList.add(dynamicObject.getString("orgid"));
        }
        returnData.put("orgNameList", nameList);
        returnData.put("orgidList", orgidList);
        this.getView().returnDataToParent(returnData);
    }
}

