/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.formplugin.ScpVMIPanelService;

public class ScpReplenishreqEditPlugin
extends AbstractBillPlugIn {
    private ScpVMIPanelService scpVMIPanelService = new ScpVMIPanelService();

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        List dataList = (List)param.get("data");
        HashSet<Long> materialIdSet = new HashSet<Long>(1024);
        HashSet<Long> unitIdSet = new HashSet<Long>(1024);
        for (Object data : dataList) {
            Map dataMap = (Map)data;
            Object material = dataMap.get("material");
            Object unit = dataMap.get("unit");
            unitIdSet.add(Long.parseLong(unit.toString()));
            materialIdSet.add(Long.parseLong(material.toString()));
        }
        QFilter qFilter = new QFilter("id", "in", materialIdSet);
        DynamicObject[] materials = BusinessDataServiceHelper.load((String)"bd_material", (String)"modelnum,number,name,baseunit.number", (QFilter[])qFilter.toArray());
        HashMap<String, Object> materialMap = new HashMap<String, Object>(1024);
        for (DynamicObject material : materials) {
            materialMap.put(material.getString("id"), material);
        }
        qFilter = new QFilter("masterid", "in", materialIdSet);
        DynamicObject[] materialsPurchase = BusinessDataServiceHelper.load((String)"bd_materialpurchaseinfo", (String)"masterid,purchaseunit.number", (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> materialsPurchaseMap = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject materialpur : materialsPurchase) {
            materialsPurchaseMap.put(materialpur.getDynamicObject("masterid").getString("id"), materialpur);
        }
        qFilter = new QFilter("id", "in", unitIdSet);
        DynamicObject[] units = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"id,name,number", (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> unitMap = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject unit : units) {
            unitMap.put(unit.getString("id"), unit);
        }
        model.setValue("org", ((Map)dataList.get(0)).get("org"));
        RequestContext rc = RequestContext.get();
        model.setValue("bizpartner", ((Map)dataList.get(0)).get("bizpartner"));
        model.setValue("supplier", ((Map)dataList.get(0)).get("supplier"));
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < dataList.size(); ++i) {
            Map dataMap = (Map)dataList.get(i);
            Object material = dataMap.get("material");
            Object recorg = dataMap.get("invorg");
            Object auxpty = dataMap.get("auxpty");
            Object unit = dataMap.get("unit");
            Object qty = dataMap.get("qty");
            DynamicObject unitDyn = (DynamicObject)unitMap.get(unit.toString());
            materialIdSet.add(Long.parseLong(material.toString()));
            DynamicObject materialDyn = (DynamicObject)materialMap.get(material.toString());
            DynamicObject materialsPur = (DynamicObject)materialsPurchaseMap.get(materialDyn.getString("id"));
            Date date = DateUtil.addDays((Date)TimeServiceHelper.getCurrentSystemTime(), (int)1);
            vs.set("unit", unit, i);
            if (null != materialsPur) {
                DynamicObject purchaseunit = materialsPur.getDynamicObject("purchaseunit");
                vs.set("unit", (Object)purchaseunit, i);
                vs.set("unit_id", purchaseunit.getPkValue(), i);
                DynamicObject baseUnitDyn = ((DynamicObject)materialMap.get(material.toString())).getDynamicObject("baseunit");
                vs.set("baseunit", (Object)baseUnitDyn, i);
                vs.set("baseunit_id", baseUnitDyn.getPkValue(), i);
                BigDecimal baseqty = ScpVMIPanelService.getDesQtyConv(Long.parseLong(material.toString()), unitDyn, new BigDecimal(qty.toString()), baseUnitDyn);
                vs.set("baseqty", (Object)baseqty, i);
                BigDecimal purQty = ScpVMIPanelService.getDesQtyConv(Long.parseLong(material.toString()), baseUnitDyn, baseqty, purchaseunit);
                vs.set("qty", (Object)purQty, i);
                vs.set("confirmqty", (Object)purQty, i);
                vs.set("deliverdate", (Object)date, i);
            }
            vs.set("material", (Object)materialDyn, i);
            vs.set("material_id", materialDyn.getPkValue(), i);
            String materialName = materialDyn.getString("name");
            vs.set("materialname", (Object)materialName, i);
            vs.set("invorg_id", recorg, i);
            if (null == auxpty || "".equals(auxpty)) continue;
            vs.set("auxpty_id", auxpty, i);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        int rowIndex;
        String name = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        if (name.equals("material")) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            value = dataModel.getValue(name);
            if (null != value) {
                DynamicObject material = (DynamicObject)value;
                String materialName = material.getString("name");
                dataModel.setValue("materialname", (Object)materialName, rowIndex);
            }
        }
        if (name.equals("qty") && null != (value = dataModel.getValue(name, rowIndex = e.getChangeSet()[0].getRowIndex()))) {
            BigDecimal qty = new BigDecimal(value.toString());
            dataModel.setValue("confirmqty", (Object)qty, rowIndex);
            DynamicObject material = (DynamicObject)dataModel.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)dataModel.getValue("unit", rowIndex);
            DynamicObject baseunit = (DynamicObject)dataModel.getValue("baseunit", rowIndex);
            BigDecimal baseqty = ScpVMIPanelService.getDesQtyConv(material.getLong("id"), unit, qty, baseunit);
            dataModel.setValue("baseqty", (Object)baseqty, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("submit".equals(operateKey) || "unaudit".equals(operateKey)) {
            BillModel model = (BillModel)this.getModel();
            model.load(model.getPKValue());
            this.getView().updateView("billstatus");
            this.getView().updateView("auditor");
            this.getView().updateView("auditdate");
            this.getView().updateView("entryentity");
        }
    }
}

