/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;

public final class ScpProblemNoticeEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("feedback")) {
            this.setEntryFieldsStatus(true, "#FFFACD");
            this.doFeedEnableBtn(true);
        } else {
            this.setEntryFieldsStatus(false, "#ffffff");
            this.doFeedEnableBtn(false);
        }
    }

    private void doFeedEnableBtn(Boolean status) {
        this.getView().setVisible(status, new String[]{"bar_comfirmfeedback", "bar_returnfeedback"});
        this.getView().setVisible(Boolean.valueOf(status == false), new String[]{"bar_feedback", "bar_refresh", "bar_close"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "comfirmfeedback": 
                case "returnfeedback": {
                    this.getPageCache().remove("focus");
                    this.getView().getFormShowParameter().getCustomParams().remove("feedback");
                    this.doFeedEnableBtn(false);
                    this.setEntryFieldsStatus(false, "#ffffff");
                    if (!"comfirmfeedback".equals(operateKey)) break;
                    BillModel model = (BillModel)this.getModel();
                    model.load(model.getPKValue());
                    this.getView().updateView("materialentry");
                    break;
                }
                case "feedback": {
                    this.getView().getFormShowParameter().getCustomParams().put("feedback", "feedback");
                    this.doFeedEnableBtn(true);
                    this.setEntryFieldsStatus(true, "#FFFACD");
                    break;
                }
            }
        }
        if ("returnfeedback".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            boolean isExists;
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            List qFilters = ScpCoreListFilterHelper.setFilter(new ArrayList(8));
            if (pkId != null) {
                qFilters.add(new QFilter("id", "=", (Object)Long.parseLong(pkId.toString())));
            }
            if (!(isExists = QueryServiceHelper.exists((String)"scp_problemnotice", (QFilter[])qFilters.toArray(new QFilter[0])))) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u4e0d\u6ee1\u8db3\u5904\u7406\u6761\u4ef6\u3002", (String)"ScpProblemNoticeEdit_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setEntryFieldsStatus(boolean status, String color) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCOl = dataEntity.getDynamicObjectCollection("materialentry");
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
        int index = Integer.MAX_VALUE;
        for (int i = 0; i < entryCOl.size(); ++i) {
            DynamicObject row = (DynamicObject)entryCOl.get(i);
            String feedbackstatus = row.getString("feedbackstatus");
            if ("A".equals(feedbackstatus)) {
                this.getView().setEnable(Boolean.valueOf(status), i, new String[]{"feedbackdesc", "feedattachment"});
                if (index >= i) {
                    index = i;
                }
                if (!status) continue;
                ArrayList<CellStyle> csList = new ArrayList<CellStyle>(1024);
                this.setEntryFieldColor(csList, "feedbackdesc", i, color);
                this.setEntryFieldColor(csList, "feedattachment", i, color);
                grid.setCellStyle(csList);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"feedbackdesc", "feedattachment"});
        }
        IPageCache pageCache = this.getPageCache();
        if (index >= 0 && status && null == pageCache.get("focus")) {
            grid.focusCell(index, "feedbackdesc");
        }
    }

    private void setEntryFieldColor(List<CellStyle> csList, String field, int i, String color) {
        CellStyle cs = new CellStyle();
        cs.setBackColor(color);
        cs.setFieldKey(field);
        cs.setRow(i);
        csList.add(cs);
    }
}

