/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.annotation.PluginEvent;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.business.ScpBillFormHelper;
import kd.scm.scp.business.ScpDeliveryScheduleHelper;
import kd.scm.scp.common.util.StringPatternUtil;
import kd.scm.scp.formplugin.formhelper.ScpDeliverScheduleFormHelper;
import kd.scm.scp.formplugin.formhelper.ScpSaloutStockFormHelper;

public final class ScpScheduleDeliveryEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener,
CellClickListener {
    private static final Log log = LogFactory.getLog((String)ScpScheduleDeliveryEdit.class.getName());
    private static String[] setColorPro = new String[]{"promiseqty", "promisedate", "supplierremark", "estimateddeliverydate"};
    private static List<String> needRecordPro = new ArrayList<String>();
    private static String ACTUAL_SELECT_ROWS = "actualselectrows";
    private static final String FEEDBACK = "feedback";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String pkIdStr;
        Object pkId;
        super.preOpenForm(e);
        e.getFormShowParameter().setCustomParam("checkRightAppId", (Object)"scp");
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter && (pkId = ((BillShowParameter)formShowParameter).getPkId()) != null && !ScpDeliveryScheduleHelper.verifySupplierUserCanDo((Object)Long.parseLong(pkIdStr = pkId.toString())).booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(this.getCanMessage());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("materialentry");
        if (grid != null) {
            grid.addHyperClickListener((HyperLinkClickListener)this);
            grid.addCellClickListener((CellClickListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object feedback = formShowParameter.getCustomParam(FEEDBACK);
        String feedbackCache = this.getFeedBack();
        if (feedbackCache == null) {
            feedbackCache = String.valueOf(feedback);
            this.putFeedBackCache(feedbackCache);
        }
        if ("true".equalsIgnoreCase(feedbackCache)) {
            this.fireFeedBack();
            this.setDefaultPromiseData();
        } else {
            this.setEntryFieldsStatus(false);
        }
        this.setMustInput("promiseqty");
        this.setMustInput("promisedate");
        this.setMinDate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String feedback = this.getFeedBack();
        if ("true".equalsIgnoreCase(feedback)) {
            this.fireFeedBack();
            this.putFeedBackCache("false");
        } else {
            this.setEntryFieldsStatus(false);
        }
    }

    private void putFeedBackCache(String feedback) {
        if (feedback != null && !feedback.isEmpty()) {
            this.getView().getPageCache().put(FEEDBACK, feedback);
        }
    }

    private String getFeedBack() {
        return this.getView().getPageCache().get(FEEDBACK);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("barconfirm".equalsIgnoreCase(itemKey) && this.checkSelectRows()) {
            evt.setCancel(true);
            this.getView().showTipNotification(this.getMessage(), Integer.valueOf(Integer.parseInt("8000")));
        }
        if ("bardeliver".equals(itemKey) && this.checkSelectRows()) {
            evt.setCancel(true);
            this.getView().showTipNotification(this.getMessage(), Integer.valueOf(Integer.parseInt("8000")));
        }
    }

    private boolean checkSelectRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        int[] rowIndexs = entryGrid.getSelectRows();
        return rowIndexs == null || rowIndexs.length == 0;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        int[] rowIndexs = entryGrid.getSelectRows();
        switch (itemKey) {
            case "barfeedback": {
                OperationResult operationResultCheck = ScpDeliveryScheduleHelper.executeConfirmPromiseCheck((Object[])new Object[]{this.getModel().getDataEntity(true).getPkValue()}, (ListSelectedRowCollection)this.getListSelectedRowCollection(rowIndexs));
                if (operationResultCheck.isSuccess() || operationResultCheck.getSuccessPkIds().size() > 0) {
                    this.fireFeedBack();
                    this.setDefaultPromiseData();
                    break;
                }
                this.getView().showOperationResult(operationResultCheck, ScpDeliveryScheduleHelper.getOpName());
                break;
            }
            case "barconfirm": {
                int[] actualSelectRows = this.getActualSelectRows();
                if (actualSelectRows.length == 0) {
                    actualSelectRows = rowIndexs;
                }
                if (actualSelectRows == null || actualSelectRows.length == 0) {
                    this.getView().showTipNotification(this.getMessage(), Integer.valueOf(Integer.parseInt("8000")));
                    break;
                }
                OperationResult operationResultPromise = ScpDeliveryScheduleHelper.executeConfirmPromise((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (ListSelectedRowCollection)this.getListSelectedRowCollection(actualSelectRows));
                if (operationResultPromise.isSuccess() || operationResultPromise.getSuccessPkIds().size() > 0) {
                    operationResultPromise.setMessage(ScpDeliveryScheduleHelper.getOpMessage());
                    this.getView().showOperationResult(operationResultPromise, ScpDeliveryScheduleHelper.getOpName());
                    ((BillModel)this.getModel()).load(this.getModel().getDataEntity().getPkValue());
                    this.getView().updateView("materialentry");
                    this.setEntryFieldsStatus(false);
                    this.clearSelectRows();
                    break;
                }
                this.getView().showOperationResult(operationResultPromise, ScpDeliveryScheduleHelper.getOpName());
                this.clearSelectRows();
                break;
            }
            case "barcancel": {
                ((BillModel)this.getModel()).load(this.getModel().getDataEntity().getPkValue());
                this.getView().updateView("materialentry");
                this.setEntryFieldsStatus(false);
                break;
            }
            case "bardeliver": {
                this.setEntryFieldsStatus(false);
                break;
            }
            case "barlinkstock": {
                List linkSalStockBillIds = ScpDeliveryScheduleHelper.getLinkSalStockBillIds(this.getSelectRows());
                if (!linkSalStockBillIds.isEmpty()) {
                    this.getView().showForm(ScpDeliverScheduleFormHelper.assembleShowParameter(linkSalStockBillIds));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u8d27\u5355\u53ef\u67e5\u770b\u3002", (String)"ScpDeliveryScheduleEdit_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @PluginEvent(enableOverride=true)
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSets = e.getChangeSet();
        switch (proName) {
            case "promiseqty": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
                this.setBaseQty(model, rowIndex, newValue);
                break;
            }
            case "promisedate": {
                for (ChangeData changeSet : changeSets) {
                    Date promisedate;
                    DynamicObject entryRowEntity;
                    Date estimateddeliverydate;
                    int rowIndex2 = changeSet.getRowIndex();
                    Object promisedateObj = changeSet.getNewValue();
                    if (promisedateObj == null || (estimateddeliverydate = (entryRowEntity = model.getEntryRowEntity("materialentry", rowIndex2)).getDate("estimateddeliverydate")) == null || (promisedate = (Date)promisedateObj).compareTo(estimateddeliverydate) >= 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u9884\u8ba1\u53d1\u8d27\u65e5\u671f\u3002", (String)"ScpDeliveryScheduleList_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    model.setValue("promisedate", changeSet.getOldValue(), rowIndex2);
                }
                break;
            }
            case "estimateddeliverydate": {
                for (ChangeData changeSet : changeSets) {
                    Date estimateddeliverydate;
                    DynamicObject entryRowEntity;
                    Date promisedate;
                    int rowIndex2 = changeSet.getRowIndex();
                    Object estimateddeliverydateObj = changeSet.getNewValue();
                    if (estimateddeliverydateObj == null || (promisedate = (entryRowEntity = model.getEntryRowEntity("materialentry", rowIndex2)).getDate("promisedate")) == null || promisedate.compareTo(estimateddeliverydate = (Date)estimateddeliverydateObj) >= 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u9884\u8ba1\u53d1\u8d27\u65e5\u671f\u3002", (String)"ScpDeliveryScheduleList_7", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    model.setValue("estimateddeliverydate", changeSet.getOldValue(), rowIndex2);
                }
                break;
            }
            case "supplierremark": {
                break;
            }
        }
    }

    private void setBaseQty(IDataModel model, int rowIndex, Object newValue) {
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != newValue) {
            BigDecimal promiseqty = new BigDecimal(String.valueOf(model.getValue("promiseqty", rowIndex)));
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject basicunit = (DynamicObject)model.getValue("basicunit", rowIndex);
            if (null != material && null != unit && null != basicunit) {
                baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)promiseqty, (DynamicObject)basicunit);
            }
        }
        model.setValue("promisebasicqty", (Object)baseQty, rowIndex);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject query;
        Object value;
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("srcbillno".equals(fieldName) && (value = this.getModel().getValue(fieldName, rowIndex)) != null && (query = QueryServiceHelper.queryOne((String)"scp_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)value.toString())})) != null) {
            long id = query.getLong("id");
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("scp_order");
            bsp.setPkId((Object)id);
            bsp.setBillStatus(BillOperationStatus.VIEW);
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)bsp);
        }
        if ("relateoutstockqty".equals(fieldName)) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("materialentry", hyperLinkClickEvent.getRowIndex());
            Object entryPrimaryKeyValue = dynamicObject.get("id");
            FormShowParameter formShowParameter = ScpDeliveryScheduleHelper.assembleShowParameter((Object)entryPrimaryKeyValue);
            this.getView().showForm(formShowParameter);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        int row = cellClickEvent.getRow();
        String fieldKey = cellClickEvent.getFieldKey();
        if (this.needRecordPro(fieldKey)) {
            this.putActualRow(row);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("promisedate".equalsIgnoreCase(fieldKey)) {
            this.setMinDate();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deliver".equals(operateKey)) {
            int[] actualSelectRows = this.getActualSelectRows();
            ListSelectedRowCollection listSelectedRows = this.getListSelectedRowCollection(actualSelectRows);
            formOperate.getOption().setVariableValue("bos_listselectedrowcollection", SerializationUtils.toJsonString((Object)listSelectedRows));
            IFormView mainView = this.getView().getMainView();
            if (ScpDeliveryScheduleHelper.verifySourceOrderBill((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, this.getSelectRows())) {
                Map result = ScpDeliveryScheduleHelper.verifyDraftSaloutStockBill((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, this.getSelectRows());
                Set salOutStockBillIds = (Set)result.get("data");
                Object message = result.get("message");
                if (salOutStockBillIds != null && !salOutStockBillIds.isEmpty()) {
                    beforeDoOperationEventArgs.setCancel(true);
                    this.getPageCache().put("salOutStockBillIds", StringUtils.join((Object[])salOutStockBillIds.toArray(new Long[salOutStockBillIds.size()]), (String)","));
                    this.showConfirmPage(message.toString());
                } else if (!((Boolean)result.get("succed")).booleanValue()) {
                    beforeDoOperationEventArgs.setCancel(true);
                    if (mainView != null && message != null) {
                        mainView.showTipNotification(message.toString(), Integer.valueOf(Integer.parseInt("12000")));
                        this.getView().sendFormAction(mainView);
                    }
                }
            }
        }
    }

    private void showConfirmPage(String titleMessage) {
        HashMap<String, String> customMap = new HashMap<String, String>(16);
        customMap.put("message", titleMessage);
        this.getView().showForm(ScpBillFormHelper.assembleDraftBillConfirm(customMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "deliveryPushEdit")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deliver": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                try {
                    ((BillModel)this.getModel()).load(((BillModel)this.getModel()).getPKValue());
                    Set deliverEntryId = ScpDeliveryScheduleHelper.assembleCanDeliveryData((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, this.getSelectRows());
                    if (!ScpDeliveryScheduleHelper.verifySourceOrderBill((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, this.getSelectRows())) {
                        List<Long> unLockEntry = ScpDeliverScheduleFormHelper.getUnLockEntry(new ArrayList<Long>(this.getSelectRows()));
                        if (!unLockEntry.isEmpty()) {
                            this.getView().showForm(ScpDeliverScheduleFormHelper.getShowFormParameter(unLockEntry));
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6240\u6709\u5206\u5f55\u884c\uff0c\u6b63\u5728\u88ab\u4f60\u6216\u8005\u5176\u4ed6\u7528\u6237\u6267\u884c\u53d1\u8d27\uff0c\u6682\u65e0\u6cd5\u6267\u884c\u53d1\u8d27\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpDeliveryScheduleEdit_5", (String)"scm-scp-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                        break;
                    }
                    if (deliverEntryId.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u72b6\u6001\u4e3a\u6b63\u5e38\u4e14\u5df2\u786e\u8ba4\u7684\u5206\u5f55\u624d\u5141\u8bb8\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleEdit_3", (String)"scm-scp-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                        break;
                    }
                    Map deliverResult = ScpDeliveryScheduleHelper.executeDeliver((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (Set)deliverEntryId);
                    Boolean success = (Boolean)deliverResult.get("succed");
                    if (!success.booleanValue()) {
                        String message = (String)deliverResult.get("message");
                        if (message == null) break;
                        this.getView().showTipNotification(message, Integer.valueOf(Integer.parseInt("8000")));
                        break;
                    }
                    List data = (List)deliverResult.get("data");
                    if (data == null) break;
                    if (data.size() == 1) {
                        BillShowParameter param = new BillShowParameter();
                        param.setPkId(data.get(0));
                        param.setBillStatus(BillOperationStatus.EDIT);
                        param.setBillTypeId("scp_saloutstock");
                        param.setFormId("scp_saloutstock");
                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        this.getView().showForm((FormShowParameter)param);
                    } else if (data.size() > 1) {
                        ListShowParameter param = new ListShowParameter();
                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        param.getOpenStyle().setTargetKey("_submaintab_");
                        param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)data));
                        param.setBillFormId("scp_saloutstock");
                        param.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
                        this.getView().showForm((FormShowParameter)param);
                    }
                }
                catch (KDException exception) {
                    this.showMsg(exception);
                }
                this.setEntryFieldsStatus(false);
                break;
            }
            case "refresh": {
                this.setEntryFieldsStatus(false);
                break;
            }
            case "batchfillentry": {
                int currentRow = this.getModel().getEntryCurrentRowIndex("materialentry");
                BillModel model = (BillModel)this.getModel();
                int filterEntryRowCount = model.getEntryRowCount("materialentry");
                for (int i = currentRow; i < filterEntryRowCount; ++i) {
                    this.putActualRow(i);
                }
                break;
            }
        }
    }

    private void showMsg(KDException exception) {
        String message = String.valueOf(exception.getMessage());
        int lines = StringPatternUtil.getLines((String)message);
        if (lines <= 1) {
            this.getView().showTipNotification(message, Integer.valueOf(Integer.parseInt("8000")));
        } else {
            this.getView().showMessage(message);
        }
    }

    private Set<Long> getSelectRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
        int[] rowIndexs = entryGrid.getSelectRows();
        HashSet<Long> selectRows = new HashSet<Long>(156);
        for (int rowIndex : rowIndexs) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity("materialentry", rowIndex);
            selectRows.add(entryRow.getLong("id"));
        }
        return selectRows;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getPageCache().put("checksource", "close");
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("deliveryPushEdit".equals(actionId)) {
            if ("enter".equals(returnData)) {
                String salOutBillIds = this.getPageCache().get("salOutStockBillIds");
                List<String> billIdList = Arrays.asList(salOutBillIds.split(","));
                ArrayList<Long> salOutStockBillIds = new ArrayList<Long>(billIdList.size());
                billIdList.forEach(t -> salOutStockBillIds.add(Long.parseLong(t)));
                this.getView().showForm(ScpSaloutStockFormHelper.getShowParam(salOutStockBillIds));
            }
            this.setEntryFieldsStatus(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("ignoreConfirm".equalsIgnoreCase(callBackId)) {
            MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
            if (MessageBoxOptions.Toast.getValue() == messageBoxResult.getValue()) {
                String checksource = this.getPageCache().get("checksource");
                if ("close".equalsIgnoreCase(checksource)) {
                    this.getPageCache().put("isForceClose", "true");
                    this.getView().close();
                } else if ("click".equalsIgnoreCase(checksource)) {
                    this.setEntryFieldsStatus(true);
                }
            } else {
                this.setEntryFieldsStatus(false);
                this.getPageCache().put("isForceClose", "true");
                this.getModel().setDataChanged(false);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.checkDataChange();
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }

    private boolean needRecordPro(String fieldKey) {
        return !needRecordPro.isEmpty() && needRecordPro.contains(fieldKey);
    }

    private void putActualRow(int row) {
        String actualStr = this.getPageCache().get(ACTUAL_SELECT_ROWS);
        Set<Integer> actualSelectRows = null;
        if (actualStr != null && !actualStr.isEmpty()) {
            try {
                actualSelectRows = (Set)SerializationUtils.fromJsonString((String)actualStr, Set.class);
            }
            catch (RuntimeException exception) {
                log.warn((Throwable)exception);
                actualSelectRows = new HashSet(16);
            }
            actualSelectRows.add(row);
        } else {
            actualSelectRows = new HashSet<Integer>(16);
            actualSelectRows.add(row);
        }
        this.getPageCache().put(ACTUAL_SELECT_ROWS, SerializationUtils.toJsonString(actualSelectRows));
    }

    private int[] getActualSelectRows() {
        String actualStr = this.getPageCache().get(ACTUAL_SELECT_ROWS);
        if (actualStr != null && !actualStr.isEmpty()) {
            int[] rowIndexs;
            HashSet<Integer> actualSelectRows = null;
            try {
                actualSelectRows = (HashSet<Integer>)SerializationUtils.fromJsonString((String)actualStr, Set.class);
            }
            catch (RuntimeException exception) {
                log.warn((Throwable)exception);
                actualSelectRows = new HashSet<Integer>(16);
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentry");
            for (int rowIndex : rowIndexs = entryGrid.getSelectRows()) {
                actualSelectRows.add(rowIndex);
            }
            int[] selectIndexs = new int[actualSelectRows.size()];
            Iterator integerIterator = actualSelectRows.iterator();
            int index = 0;
            while (integerIterator.hasNext()) {
                selectIndexs[index] = (Integer)integerIterator.next();
                ++index;
            }
            return selectIndexs;
        }
        return new int[0];
    }

    private void clearSelectRows() {
        this.getPageCache().remove(ACTUAL_SELECT_ROWS);
    }

    private void checkDataChange() {
        if (this.getModel().getDataChanged()) {
            String isForceClose = this.getPageCache().get("isForceClose");
            if (isForceClose == null || "false".equalsIgnoreCase(isForceClose)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5185\u5bb9\u5df2\u53d8\u5316\uff0c\u662f\u5426\u53cd\u9988\u3002", (String)"ScpDeliveryScheduleEdit_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ignoreConfirm", (IFormPlugin)this));
            }
        } else {
            this.setEntryFieldsStatus(false);
        }
    }

    private void setRowColor() {
        int rowCount = this.getModel().getEntryRowCount("materialentry");
        HashSet<Integer> validSelectRows = new HashSet<Integer>(rowCount);
        for (int indexRow = 0; indexRow < rowCount; ++indexRow) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity("materialentry", indexRow);
            String promisestatus = entryRow.getString("promisestatus");
            if (!"A".equalsIgnoreCase(promisestatus) && !"C".equalsIgnoreCase(promisestatus)) continue;
            validSelectRows.add(indexRow);
        }
        if (!validSelectRows.isEmpty()) {
            ArrayList csList = ScpBillFormHelper.assmbleCellStyle(validSelectRows, (String[])setColorPro);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
            grid.setCellStyle((List)csList);
        }
    }

    private void setFocusFirstRow() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
        grid.selectRows(0);
    }

    private String getMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"ScpDeliveryScheduleEdit_0", (String)"scm-scp-formplugin", (Object[])new Object[0]);
    }

    private String getCanMessage() {
        return ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u4e0d\u6ee1\u8db3\u5904\u7406\u6761\u4ef6\u3002", (String)"ScpDeliveryScheduleEdit_2", (String)"scm-scp-formplugin", (Object[])new Object[0]);
    }

    private void setMustInput(String fieldKey) {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(fieldKey);
        if (fieldEdit != null) {
            fieldEdit.setMustInput(true);
        }
    }

    private void setDefaultPromiseData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("materialentry");
        DynamicProperty promiseqty = entryEntity.getDynamicObjectType().getProperty("promiseqty");
        DynamicProperty promisedate = entryEntity.getDynamicObjectType().getProperty("promisedate");
        Date now = DateUtil.addDays((Date)TimeServiceHelper.today(), (int)-1);
        for (DynamicObject row : entryEntity) {
            String promisestatus = row.getString("promisestatus");
            if (!"A".equalsIgnoreCase(promisestatus) && !"C".equalsIgnoreCase(promisestatus)) continue;
            promiseqty.setValue((Object)row, (Object)row.getBigDecimal("qty"));
            Date deliverydate = row.getDate("deliverydate");
            if (deliverydate != null && deliverydate.after(now)) {
                promisedate.setValue((Object)row, (Object)deliverydate);
            }
            this.setBaseQtyByDyn(row);
        }
        this.getView().updateView("materialentry");
    }

    private void fireFeedBack() {
        this.setRowColor();
        this.setEntryFieldsStatus(true);
        this.setMustInput("promiseqty");
        this.setMustInput("promisedate");
        this.clearSelectRows();
    }

    private void setBaseQtyByDyn(DynamicObject entry) {
        BigDecimal baseQty = BigDecimal.ZERO;
        BigDecimal promiseqty = entry.getBigDecimal("promiseqty");
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject basicunit = entry.getDynamicObject("basicunit");
        if (null != material && null != unit && null != basicunit) {
            baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)promiseqty, (DynamicObject)basicunit);
        }
        entry.set("promisebasicqty", (Object)baseQty);
    }

    private void setMinDate() {
        DateTimeEdit estimateddeliverydate;
        DateTimeEdit promisedate = (DateTimeEdit)this.getControl("promisedate");
        if (promisedate != null) {
            promisedate.setMinDate(TimeServiceHelper.today());
        }
        if ((estimateddeliverydate = (DateTimeEdit)this.getControl("estimateddeliverydate")) != null) {
            estimateddeliverydate.setMinDate(TimeServiceHelper.today());
        }
    }

    private ListSelectedRowCollection getListSelectedRowCollection(int[] rowIndexs) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        for (int rowIndex : rowIndexs) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity("materialentry", rowIndex);
            ListSelectedRow listSelectedRow = new ListSelectedRow(pkValue);
            listSelectedRow.setEntryEntityKey("materialentry");
            listSelectedRow.setEntryPrimaryKeyValue(entryRow.getPkValue());
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }

    private void setEntryFieldsStatus(boolean status) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCOl = dataEntity.getDynamicObjectCollection("materialentry");
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("materialentry");
        int index = Integer.MAX_VALUE;
        for (int i = 0; i < entryCOl.size(); ++i) {
            DynamicObject row = (DynamicObject)entryCOl.get(i);
            String promisestatus = row.getString("promisestatus");
            String entrystatus = row.getString("entrystatus");
            if ("B".equalsIgnoreCase(promisestatus) || "D".equalsIgnoreCase(promisestatus) || "B".equalsIgnoreCase(entrystatus)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"promiseqty", "promisedate", "supplierremark", "estimateddeliverydate"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(status), i, new String[]{"promiseqty", "promisedate", "supplierremark", "estimateddeliverydate"});
        }
        IPageCache pageCache = this.getPageCache();
        if (index >= 0 && status && null == pageCache.get("focus")) {
            grid.focusCell(index, "promiseqty");
        }
        this.doFeedVisibleBtn(status);
    }

    private void doFeedVisibleBtn(Boolean status) {
        this.getView().setVisible(status, new String[]{"barconfirm", "barcancel"});
        this.getView().setVisible(Boolean.valueOf(status == false), new String[]{"barfeedback", "bardeliver", "bar_print", "bar_more", "barrefresh", "bar_close"});
        this.getView().setEnable(status, new String[]{"batchfillentry"});
    }

    static {
        needRecordPro.add("promiseqty");
        needRecordPro.add("promisedate");
        needRecordPro.add("supplierremark");
        needRecordPro.add("estimateddeliverydate");
    }
}

