/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.formhelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;

public final class ScpDeliverScheduleFormHelper {
    public static final String MATCHDELIVERENTRYIDS = "matchdeliverentryids";

    public static List<Long> getUnLockEntry(List<Long> entryIds) {
        ArrayList<Long> unLockEntryIds = new ArrayList<Long>(entryIds.size());
        DataMutex dataMutex = DataMutex.create();
        Map<String, Object> mutexLockInfo = null;
        ArrayList<Map<String, Object>> lockInfoList = new ArrayList<Map<String, Object>>(entryIds.size());
        for (Long entryId : entryIds) {
            mutexLockInfo = ScpDeliverScheduleFormHelper.getMutexLockInfo(entryId);
            lockInfoList.add(mutexLockInfo);
        }
        Map batchRequireMap = dataMutex.batchrequire(lockInfoList);
        if (batchRequireMap != null && !batchRequireMap.isEmpty()) {
            for (Map.Entry entry : batchRequireMap.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                unLockEntryIds.add(Long.parseLong((String)entry.getKey()));
            }
        }
        return unLockEntryIds;
    }

    public static void clearEntryLock(List<Long> entryIds) {
        DataMutex dataMutex = DataMutex.create();
        ArrayList<Map<String, Object>> lockInfoList = new ArrayList<Map<String, Object>>(entryIds.size());
        Map<String, Object> lockInfo = null;
        for (Long entryId : entryIds) {
            lockInfo = ScpDeliverScheduleFormHelper.getMutexLockInfo(entryId);
            lockInfoList.add(lockInfo);
        }
        dataMutex.batchRelease(lockInfoList);
    }

    private static Map<String, Object> getMutexLockInfo(Long entryId) {
        HashMap<String, Object> lockInfo = new HashMap<String, Object>(4);
        lockInfo.put("dataObjId", String.valueOf(entryId));
        lockInfo.put("entityKey", "pur_deliveryschedule");
        lockInfo.put("operationKey", "modify");
        lockInfo.put("isStrict", Boolean.TRUE);
        lockInfo.put("groupId", "default_netctrl");
        return lockInfo;
    }

    public static FormShowParameter getShowFormParameter(List<Long> entryIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("scp_schedulematchdelivery");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(MATCHDELIVERENTRYIDS, (Object)SerializationUtils.toJsonString(entryIds));
        return formShowParameter;
    }

    public static FormShowParameter assembleShowParameter(List<Long> linkSalOutIds) {
        ListShowParameter formShowParameter = null;
        if (!linkSalOutIds.isEmpty()) {
            if (linkSalOutIds.size() > 1) {
                formShowParameter = new ListShowParameter();
                formShowParameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
                formShowParameter.setBillFormId("scp_saloutstock");
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", linkSalOutIds));
            } else {
                formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("scp_saloutstock");
                ((BillShowParameter)formShowParameter).setPkId((Object)linkSalOutIds.get(0));
                ((BillShowParameter)formShowParameter).setBillStatus(BillOperationStatus.VIEW);
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        return formShowParameter;
    }
}

