/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.list;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.BizPartnerUtil;

public class ScpBizPersonList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && "true".equals(customParams.get("isPurchaser"))) {
            return;
        }
        qFilters.add(BizPartnerUtil.assembleQFilterBizPartner());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        StringBuilder sb = new StringBuilder();
        boolean isAdmin = false;
        switch (key) {
            case "tbldisable": 
            case "tblenable": {
                for (ListSelectedRow object : list.getSelectedRows()) {
                    int selectedIndex = object.getRowKey();
                    isAdmin = ScpBizPersonList.bizPartnerIsAdmin(object.getPrimaryKeyValue());
                    if (isAdmin) continue;
                    String desc = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"ScpBizPersonList_1", (String)"scm-scp-formplugin", (Object[])new Object[0]), selectedIndex);
                    sb.append(desc).append(System.lineSeparator());
                }
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)sb.toString())) {
            String title = ResManager.loadKDString((String)"\u4e0d\u662f\u4f9b\u5e94\u5546\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u201c\u542f\u7528\u201d\u6216\u201c\u7981\u7528\u201d\u534f\u540c\u4e1a\u52a1\u5458\u3002", (String)"ScpBizPersonList_2", (String)"scm-scp-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title);
            evt.setCancel(true);
        }
    }

    public static final boolean bizPartnerIsAdmin(Object supplierUserId) {
        DynamicObject supplierUser = BusinessDataServiceHelper.loadSingle((Object)supplierUserId, (String)"scp_bizperson");
        ArrayList pkIds = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner,user", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", supplierUser.getDynamicObject("bizpartner").getPkValue())).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()))}, (String)"user");){
            dataSet.forEach(row -> pkIds.add(row.getLong("user")));
        }
        return pkIds.size() > 0;
    }
}

