/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.scp.business.ScpBillFormHelper;
import kd.scm.scp.business.ScpDeliveryScheduleHelper;
import kd.scm.scp.common.util.StringPatternUtil;
import kd.scm.scp.formplugin.ScpCoreListPlugin;
import kd.scm.scp.formplugin.formhelper.ScpDeliverScheduleFormHelper;
import kd.scm.scp.formplugin.formhelper.ScpSaloutStockFormHelper;

public final class ScpScheduleDeliveryList
extends ScpCoreListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("relateoutstockqty".equals(args.getFieldName())) {
            args.setCancel(true);
            Object entryPrimaryKeyValue = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
            FormShowParameter formShowParameter = ScpDeliveryScheduleHelper.assembleShowParameter((Object)entryPrimaryKeyValue);
            this.getView().showForm(formShowParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Object[] entryPrimaryKeyValues;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
        ArrayList<Long> selectRows = new ArrayList<Long>(156);
        if (listSelectedRows != null && (entryPrimaryKeyValues = listSelectedRows.getEntryPrimaryKeyValues()) != null) {
            Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
        }
        switch (itemKey) {
            case "barfeedback": {
                if (listSelectedRows == null) break;
                Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
                if (primaryKeyValues.length == 1) {
                    OperationResult operationResultCheck = ScpDeliveryScheduleHelper.executeConfirmPromiseCheck((Object[])primaryKeyValues, (ListSelectedRowCollection)listSelectedRows);
                    if (operationResultCheck.isSuccess() || operationResultCheck.getSuccessPkIds().size() > 0) {
                        this.getPageCache().put("feedback", "true");
                        ((ListView)this.getView()).invokeOperation("modify");
                        break;
                    }
                    this.getView().showOperationResult(operationResultCheck, ScpDeliveryScheduleHelper.getOpName());
                    break;
                }
                if (primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u5355\u4e2a\u4ea4\u8d27\u8ba1\u5212\u53cd\u9988\u3002", (String)"ScpDeliveryScheduleList_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(this.getMessage());
                break;
            }
            case "barmatchdeliver": {
                this.getView().showForm(ScpDeliverScheduleFormHelper.getShowFormParameter(selectRows));
                break;
            }
            case "barlinkstock": {
                List linkSalStockBillIds = ScpDeliveryScheduleHelper.getLinkSalStockBillIds(selectRows);
                if (!linkSalStockBillIds.isEmpty()) {
                    this.getView().showForm(ScpDeliverScheduleFormHelper.assembleShowParameter(linkSalStockBillIds));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u8d27\u5355\u53ef\u67e5\u770b\u3002", (String)"ScpDeliveryScheduleList_4", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deliver".equals(operateKey)) {
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            formOperate.getOption().setVariableValue("bos_listselectedrowcollection", SerializationUtils.toJsonString((Object)listSelectedRows));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("deliver".equals(operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()) != null && operationResult.isSuccess()) {
            Object[] entryPrimaryKeyValues;
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            HashSet selectRows = new HashSet(156);
            if (listSelectedRows != null && (entryPrimaryKeyValues = listSelectedRows.getEntryPrimaryKeyValues()) != null) {
                Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
            }
            try {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])operationResult.getSuccessPkIds().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_deliveryschedule"));
                if (ScpDeliveryScheduleHelper.verifyUniqueSourceBill((DynamicObject[])dynamicObjects, selectRows)) {
                    Set deliverEntryId = ScpDeliveryScheduleHelper.assembleCanDeliveryData((DynamicObject[])dynamicObjects, selectRows);
                    if (ScpDeliveryScheduleHelper.verifySourceOrderBill((DynamicObject[])dynamicObjects, selectRows)) {
                        Map result = ScpDeliveryScheduleHelper.verifyDraftSaloutStockBill((DynamicObject[])dynamicObjects, selectRows);
                        Set salOutStockBillIds = (Set)result.get("data");
                        Object checkMessage = result.get("message");
                        IFormView mainView = this.getView().getMainView();
                        if (salOutStockBillIds != null && !salOutStockBillIds.isEmpty()) {
                            this.getPageCache().put("salOutStockBillIds", StringUtils.join((Object[])salOutStockBillIds.toArray(new Long[salOutStockBillIds.size()]), (String)","));
                            this.showConfirmPage(checkMessage.toString());
                        } else if (!((Boolean)result.get("succed")).booleanValue()) {
                            if (mainView != null && checkMessage != null) {
                                mainView.showTipNotification(checkMessage.toString(), Integer.valueOf(Integer.parseInt("12000")));
                                this.getView().sendFormAction(mainView);
                            }
                        } else if (!deliverEntryId.isEmpty()) {
                            Map deliverResult = ScpDeliveryScheduleHelper.executeDeliver((DynamicObject[])dynamicObjects, (Set)deliverEntryId);
                            Boolean success = (Boolean)deliverResult.get("succed");
                            if (success.booleanValue()) {
                                List data = (List)deliverResult.get("data");
                                if (data != null) {
                                    if (data.size() == 1) {
                                        BillShowParameter param = new BillShowParameter();
                                        param.setPkId(data.get(0));
                                        param.setBillStatus(BillOperationStatus.EDIT);
                                        param.setBillTypeId("scp_saloutstock");
                                        param.setFormId("scp_saloutstock");
                                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                        this.getView().showForm((FormShowParameter)param);
                                    } else if (data.size() > 1) {
                                        ListShowParameter param = new ListShowParameter();
                                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                        param.getOpenStyle().setTargetKey("_submaintab_");
                                        param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)data));
                                        param.setBillFormId("scp_saloutstock");
                                        param.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
                                        this.getView().showForm((FormShowParameter)param);
                                    }
                                }
                            } else {
                                String deliverMessage = (String)deliverResult.get("message");
                                if (deliverMessage != null) {
                                    this.getView().showTipNotification(deliverMessage, Integer.valueOf(Integer.parseInt("8000")));
                                }
                            }
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u72b6\u6001\u4e3a\u6b63\u5e38\u4e14\u5df2\u786e\u8ba4\u7684\u5206\u5f55\u624d\u5141\u8bb8\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleList_6", (String)"scm-scp-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                        }
                    } else {
                        List<Long> unLockEntry = ScpDeliverScheduleFormHelper.getUnLockEntry(new ArrayList<Long>(selectRows));
                        if (!unLockEntry.isEmpty()) {
                            this.getView().showForm(ScpDeliverScheduleFormHelper.getShowFormParameter(unLockEntry));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6240\u6709\u5206\u5f55\u884c\uff0c\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u6267\u884c\u53d1\u8d27\uff0c\u6682\u65e0\u6cd5\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpDeliveryScheduleList_5", (String)"scm-scp-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                        }
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u8ba2\u5355\u548c\u65e0\u6765\u6e90\u7684\u4ea4\u8d27\u8ba1\u5212\u8bf7\u5206\u5f00\u53d1\u8d27\u3002", (String)"ScpDeliveryScheduleList_2", (String)"scm-scp-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("8000")));
                }
            }
            catch (KDException exception) {
                this.showMsg(exception);
            }
        }
    }

    private void showMsg(KDException exception) {
        String message = String.valueOf(exception.getMessage());
        int lines = StringPatternUtil.getLines((String)message);
        if (lines <= 1) {
            this.getView().showTipNotification(message, Integer.valueOf(Integer.parseInt("8000")));
        } else {
            String title = ResManager.loadKDString((String)"\u53d1\u8d27\u5931\u8d25", (String)"ScpDeliveryScheduleList_3", (String)"scm-scp-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, message, MessageTypes.Default);
        }
    }

    private void showConfirmPage(String titleMessage) {
        HashMap<String, String> customMap = new HashMap<String, String>(16);
        customMap.put("message", titleMessage);
        this.getView().showForm(ScpBillFormHelper.assembleDraftBillConfirm(customMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "deliveryPushList")));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("deliveryPushList".equals(actionId) && "enter".equals(returnData)) {
            String salOutBillIds = this.getPageCache().get("salOutStockBillIds");
            List<String> billIdList = Arrays.asList(salOutBillIds.split(","));
            ArrayList<Long> salOutStockBillIds = new ArrayList<Long>(billIdList.size());
            billIdList.forEach(t -> salOutStockBillIds.add(Long.parseLong(t)));
            this.getView().showForm(ScpSaloutStockFormHelper.getShowParam(salOutStockBillIds));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        ((ListView)this.getView()).invokeOperation("modify");
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        ((ListView)this.getView()).invokeOperation("modify");
    }

    public void entryRowClick(RowClickEvent evt) {
        ((ListView)this.getView()).invokeOperation("modify");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String feedback = this.getPageCache().get("feedback");
        if ("true".equalsIgnoreCase(feedback)) {
            this.getPageCache().remove("feedback");
            e.getParameter().setCustomParam("feedback", (Object)"true");
            e.getParameter().setBillStatus(BillOperationStatus.EDIT);
        }
    }

    private String getMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"ScpDeliveryScheduleList_0", (String)"scm-scp-formplugin", (Object[])new Object[0]);
    }
}

