/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.matchdevliver;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;
import kd.scm.scp.business.ScpBillParamHelper;
import kd.scm.scp.business.ScpDeliveryScheduleMatchHelper;
import kd.scm.scp.formplugin.formhelper.ScpDeliverScheduleFormHelper;
import kd.scm.scp.formplugin.formhelper.ScpSaloutStockFormHelper;
import kd.scm.scp.formplugin.matchdevliver.domain.DeliverScheduleMatchOrderInfo;

public final class ScpScheduleMatchDeliverPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)ScpScheduleMatchDeliverPlugin.class.getName());
    private static final String ENTRYENTITY = "entryentity";
    private static final String MATCHORDERENTITY = "entryentity1";
    private static final String MATCHORDERSUFFIX = "1";
    private static final String MODIFYSCHEDULEENTITY = "entryentity2";
    private static final String MODIFYSCHEDULESUFFIX = "2";
    private static final String MODIFYORDERENTITY = "entryentity3";
    private static final String MODIFYORDERSUFFIX = "3";
    private static final String CURRENCYDELIVERBASICQTYCACHE = "currencydeliverbasicqtycache";
    private static final String MATCHBASICQTYCACHE = "matchbasicqtycache";
    private final Set<String> ENTRYENTITYFIELDS = new HashSet<String>(56);
    private final Set<String> MATCHORDERENTITYFIELDS = new HashSet<String>(56);
    private final Set<String> MODIFYSCHEDULESUFFIXFIELDS = new HashSet<String>(56);
    private final Set<String> MODIFYORDERENTITYFIELDS = new HashSet<String>(56);
    private static final IAppCache orderHaveMatchCache = AppCache.get((String)"scm-scp-schedulematchorder");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"modifymatch", "previewschedule", "matchorder", "confirmdeliver", "confirmmatch", "cancelmatch"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.openSchedulePreviewPanel();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "currencydeliverbasicqty": {
                for (ChangeData changeData : e.getChangeSet()) {
                    BigDecimal availableqty;
                    BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                    int rowIndex = changeData.getRowIndex();
                    DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
                    if (rowEntity == null || newValue.compareTo(availableqty = rowEntity.getBigDecimal("availableqty")) <= 0) continue;
                    this.getModel().setValue("currencydeliverbasicqty", (Object)availableqty, rowIndex);
                }
                break;
            }
            case "matchorderbasicqty3": {
                for (ChangeData changeData : e.getChangeSet()) {
                    BigDecimal availableqty;
                    BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                    int rowIndex = changeData.getRowIndex();
                    DynamicObject rowEntity = this.getModel().getEntryRowEntity(MODIFYORDERENTITY, rowIndex);
                    if (rowEntity == null || newValue.compareTo(availableqty = rowEntity.getBigDecimal("availableqty3")) <= 0) continue;
                    this.getModel().setValue("matchorderbasicqty3", (Object)availableqty, rowIndex);
                }
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if ("matchorder".equals(key)) {
            ArrayList<Long> selectRows = new ArrayList<Long>(1024);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(ENTRYENTITY)) {
                BigDecimal availableqty = dynamicObject.getBigDecimal("currencydeliverbasicqty");
                if (availableqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                Long scheduleEntryId = dynamicObject.getLong("scheduleentryid");
                selectRows.add(scheduleEntryId);
            }
            if (selectRows.isEmpty()) {
                evt.setCancel(true);
                String deliveryBasicQtyName = this.getModel().getProperty("currencydeliverbasicqty").getDisplayName().getLocaleValue();
                this.getView().showMessage(ResManager.loadKDString((String)"{0}\u5747\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"", (String)"", (Object[])new Object[]{deliveryBasicQtyName}));
            }
        } else if ("modifymatch".equals(key)) {
            List<DynamicObject> dynamicObjectOrders = this.getSelectRows(MATCHORDERENTITY);
            if (dynamicObjectOrders.isEmpty()) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"", (String)"", (Object[])new Object[0]));
            } else if (dynamicObjectOrders.size() > 1) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u6539\u5339\u914d\u6570\u636e\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
        } else if ("confirmdeliver".equals(key)) {
            ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(1024);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(MATCHORDERENTITY)) {
                BigDecimal availableqty = dynamicObject.getBigDecimal("matchorderbasicqty1");
                if (availableqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                selectRows.add(dynamicObject);
            }
            if (!selectRows.isEmpty()) {
                Map unConfirmOrderBillNoMap = ScpDeliveryScheduleMatchHelper.getUnConfirmOrderBillNos(selectRows);
                if (unConfirmOrderBillNoMap.isEmpty()) {
                    Map result = ScpDeliveryScheduleMatchHelper.verifyDraftSaloutStockBill(selectRows);
                    Set salOutStockBillIds = (Set)result.get("data");
                    Object message = result.get("message");
                    IFormView mainView = this.getView().getMainView();
                    if (salOutStockBillIds != null && !salOutStockBillIds.isEmpty()) {
                        evt.setCancel(true);
                        String title = ResManager.loadKDString((String)"\u9009\u62e9\u8ba2\u5355\u5df2\u5b58\u5728\u6682\u5b58\u72b6\u6001\u7684\u53d1\u8d27\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"", (String)"", (Object[])new Object[0]);
                        MessageBoxOptions messageBoxOptions = MessageBoxOptions.YesNo;
                        ConfirmTypes confirmTypes = ConfirmTypes.Default;
                        this.getView().showConfirm(title, message.toString(), messageBoxOptions, confirmTypes, new ConfirmCallBackListener("verifydraftbillconfirm", (IFormPlugin)this), null, SerializationUtils.toJsonString((Object)salOutStockBillIds));
                    } else if (!((Boolean)result.get("succed")).booleanValue()) {
                        evt.setCancel(true);
                        if (mainView != null && message != null) {
                            mainView.showTipNotification(message.toString(), Integer.valueOf(Integer.parseInt("12000")));
                            this.getView().sendFormAction(mainView);
                        }
                    }
                } else {
                    String orderBillString = StringUtils.join((Object[])unConfirmOrderBillNoMap.values().toArray(new String[0]), (String)",");
                    String message = ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u5982\u4e0b\uff1a{0}", (String)"", (String)"", (Object[])new Object[]{orderBillString});
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5339\u914d\u8ba2\u5355\u672a\u786e\u8ba4\uff0c\u786e\u8ba4\u540e\u624d\u80fd\u53d1\u8d27\u3002\u662f\u5426\u7acb\u5373\u786e\u8ba4\uff1f", (String)"", (String)"", (Object[])new Object[0]), message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmOrderStatus", (IFormPlugin)this), null, SerializationUtils.toJsonString(unConfirmOrderBillNoMap.keySet()));
                    evt.setCancel(true);
                }
            } else {
                evt.setCancel(true);
                String matchOrderBasicQtyName = this.getModel().getProperty("matchorderbasicqty1").getDisplayName().getLocaleValue();
                this.getView().showMessage(ResManager.loadKDString((String)"{0}\u5747\u4e3a0\uff0c\u65e0\u6cd5\u6267\u884c\u53d1\u8d27\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"", (String)"", (Object[])new Object[]{matchOrderBasicQtyName}));
            }
        } else if ("confirmmatch".equals(key)) {
            List<DynamicObject> dynamicObjectSchedules = this.getScheduleAvailableData(MODIFYSCHEDULEENTITY);
            if (dynamicObjectSchedules.isEmpty()) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"", (String)"", (Object[])new Object[0]));
            } else if (dynamicObjectSchedules.size() > 1) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u6539\u5339\u914d\u6570\u636e\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
            if (dynamicObjectSchedules.size() == 1) {
                String matchOrderBasicQtyName = this.getModel().getProperty("matchorderbasicqty3").getDisplayName().getLocaleValue();
                String currencyBasicBasicQtyName = this.getModel().getProperty("currencydeliverbasicqty2").getDisplayName().getLocaleValue();
                DynamicObject dynamicObject = dynamicObjectSchedules.get(0);
                BigDecimal currencybasicqty = dynamicObject.getBigDecimal("currencydeliverbasicqty2");
                DynamicObjectCollection dynamicObjectOrders = this.getModel().getEntryEntity(MODIFYORDERENTITY);
                BigDecimal totalMatchQty = BigDecimal.ZERO;
                BigDecimal totalAvailableQty = BigDecimal.ZERO;
                for (DynamicObject order : dynamicObjectOrders) {
                    BigDecimal matchorderbasicqty = order.getBigDecimal("matchorderbasicqty3");
                    BigDecimal availableqty = order.getBigDecimal("availableqty3");
                    totalAvailableQty = totalAvailableQty.add(availableqty);
                    if (totalMatchQty.compareTo(currencybasicqty) > 0) {
                        evt.setCancel(true);
                        this.getView().showMessage(ResManager.loadKDString((String)"{0}\u7684\u7d2f\u8ba1\u503c\u4e0d\u80fd\u8d85\u8fc7{1}\u3002", (String)"", (String)"", (Object[])new Object[]{matchOrderBasicQtyName, currencyBasicBasicQtyName}));
                        continue;
                    }
                    totalMatchQty = totalMatchQty.add(matchorderbasicqty);
                }
                if (totalAvailableQty.compareTo(currencybasicqty) > 0 && totalMatchQty.compareTo(currencybasicqty) != 0) {
                    evt.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"{0}\u7684\u7d2f\u8ba1\u503c\u5fc5\u987b\u7b49\u4e8e{1}\u3002", (String)"", (String)"", (Object[])new Object[]{matchOrderBasicQtyName, currencyBasicBasicQtyName}));
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if ("matchorder".equals(key)) {
            ArrayList<Map<String, Object>> scheduleInfoMapList = new ArrayList<Map<String, Object>>(64);
            HashMap<String, String> cacheMap = new HashMap<String, String>(16);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(ENTRYENTITY)) {
                BigDecimal availableqty = dynamicObject.getBigDecimal("currencydeliverbasicqty");
                if (availableqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                scheduleInfoMapList.add(this.getScheduleDataMap(dynamicObject));
                cacheMap.put(String.valueOf(dynamicObject.getLong("scheduleentryid")), availableqty.toPlainString());
            }
            this.putCurrencyDeliverBasicQtyMapCache(cacheMap);
            HashMap<Long, List<Map<String, Object>>> matchOrderInfoMap = new HashMap<Long, List<Map<String, Object>>>(16);
            this.openMatchOrderPanel(scheduleInfoMapList, matchOrderInfoMap);
        } else if ("modifymatch".equals(key)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(MATCHORDERENTITY);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(MATCHORDERENTITY, currentRowIndex);
            if (dynamicObject != null) {
                Long scheduleentryid = dynamicObject.getLong("scheduleentryid1");
                DynamicObject scheduleData = null;
                List<DynamicObject> selectRows = this.getSelectRows(ENTRYENTITY);
                for (DynamicObject dynamicObject2 : selectRows) {
                    if (!scheduleentryid.equals(dynamicObject2.getLong("scheduleentryid"))) continue;
                    scheduleData = dynamicObject2;
                }
                if (scheduleData == null) {
                    DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
                    for (DynamicObject scheduleAll : dynamicObjectCollection) {
                        if (!scheduleentryid.equals(scheduleAll.getLong("scheduleentryid"))) continue;
                        scheduleData = scheduleAll;
                    }
                }
                if (scheduleData != null) {
                    Map<String, Object> matchScheduleInfoMap = this.getScheduleDataMap(scheduleData);
                    HashMap<Long, Map<String, Object>> hashMap = new HashMap<Long, Map<String, Object>>(64);
                    HashMap<String, Number> orderMatchOrderInfo = null;
                    for (DynamicObject order : this.getModel().getEntryEntity(MATCHORDERENTITY)) {
                        if (!scheduleentryid.equals(order.getLong("scheduleentryid1"))) continue;
                        orderMatchOrderInfo = new HashMap<String, Number>();
                        Long orderEntryId = order.getLong("orderentryid1");
                        orderMatchOrderInfo.put("matchorderbasicqty", order.getBigDecimal("matchorderbasicqty1"));
                        orderMatchOrderInfo.put("orderbillid", order.getLong("orderbillid1"));
                        orderMatchOrderInfo.put("orderentryid", order.getLong("orderentryid1"));
                        hashMap.put(orderEntryId, orderMatchOrderInfo);
                    }
                    this.openModifyMatchData(matchScheduleInfoMap, hashMap);
                }
            }
        } else if ("previewschedule".equals(key)) {
            this.clearOrderMatchBasicQtyRedisCache();
            this.openSchedulePreviewPanel();
        } else if ("confirmdeliver".equals(key)) {
            ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(64);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(MATCHORDERENTITY)) {
                BigDecimal availableqty = dynamicObject.getBigDecimal("matchorderbasicqty1");
                if (availableqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                selectRows.add(dynamicObject);
            }
            if (!selectRows.isEmpty()) {
                Map deliverResult = ScpDeliveryScheduleMatchHelper.executeScheduleMatchOrderDeliver(selectRows);
                Boolean success = (Boolean)deliverResult.get("succed");
                if (success.booleanValue()) {
                    List data = (List)deliverResult.get("data");
                    if (data != null) {
                        if (data.size() == 1) {
                            BillShowParameter param = new BillShowParameter();
                            param.setPkId(data.get(0));
                            param.setBillStatus(BillOperationStatus.EDIT);
                            param.setBillTypeId("scp_saloutstock");
                            param.setFormId("scp_saloutstock");
                            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            this.getView().showForm((FormShowParameter)param);
                        } else if (data.size() > 1) {
                            ListShowParameter param = new ListShowParameter();
                            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            param.getOpenStyle().setTargetKey("_submaintab_");
                            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)data));
                            param.setBillFormId("scp_saloutstock");
                            param.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
                            this.getView().showForm((FormShowParameter)param);
                        }
                        this.getView().close();
                    }
                } else {
                    String message = (String)deliverResult.get("message");
                    if (message != null) {
                        this.getView().showTipNotification(message, Integer.valueOf(Integer.parseInt("8000")));
                    }
                }
            }
        } else if ("cancelmatch".equals(key)) {
            ArrayList<Map<String, Object>> scheduleInfoMapList = new ArrayList<Map<String, Object>>(64);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(ENTRYENTITY)) {
                scheduleInfoMapList.add(this.getScheduleDataMap(dynamicObject));
            }
            HashMap<Long, List<Map<String, Object>>> matchOrderInfoMap = new HashMap<Long, List<Map<String, Object>>>(64);
            matchOrderInfoMap.putAll(this.getHaveMatchData(null));
            this.openMatchOrderPanel(scheduleInfoMapList, matchOrderInfoMap);
        } else if ("confirmmatch".equals(key)) {
            ArrayList<Map<String, Object>> scheduleInfoMapList = new ArrayList<Map<String, Object>>(64);
            for (DynamicObject dynamicObject : this.getScheduleAvailableData(ENTRYENTITY)) {
                scheduleInfoMapList.add(this.getScheduleDataMap(dynamicObject));
            }
            Long scheduleentryid = null;
            List<DynamicObject> dynamicObjectCollection = this.getScheduleAvailableData(MODIFYSCHEDULEENTITY);
            if (dynamicObjectCollection.size() == 1) {
                scheduleentryid = dynamicObjectCollection.get(0).getLong("scheduleentryid2");
            }
            HashMap<Long, List<Map<String, Object>>> matchOrderInfoMap = new HashMap<Long, List<Map<String, Object>>>(64);
            ArrayList orderMatchInfoList = new ArrayList(64);
            for (DynamicObject dynamicObject : this.getModel().getEntryEntity(MODIFYORDERENTITY)) {
                BigDecimal matchOrderBasicQty = dynamicObject.getBigDecimal("matchorderbasicqty3");
                String orderEntryId = dynamicObject.getString("orderentryid3");
                String matchBasicQtyCache = this.getMatchBasicQtyCache(orderEntryId);
                BigDecimal cacheQty = BigDecimal.ZERO;
                if (matchBasicQtyCache != null) {
                    cacheQty = new BigDecimal(matchBasicQtyCache);
                }
                this.putMatchBasicQtyMapCache(orderEntryId, matchOrderBasicQty.toPlainString());
                if (matchOrderBasicQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                HashMap<String, Object> orderInfoMap = new HashMap<String, Object>();
                orderInfoMap.put("availableqty", dynamicObject.getBigDecimal("availableqty3"));
                orderInfoMap.put("orderbillno", dynamicObject.getString("orderbillno3"));
                orderInfoMap.put("orderauditdate", dynamicObject.getString("orderauditdate3"));
                orderInfoMap.put("orderseq", dynamicObject.getString("orderseq3"));
                orderInfoMap.put("orderbillid", dynamicObject.getString("orderbillid3"));
                orderInfoMap.put("orderentryid", dynamicObject.getString("orderentryid3"));
                orderInfoMap.put("basicqty", dynamicObject.getBigDecimal("basicqty3"));
                orderInfoMap.put("matchorderbasicqty", dynamicObject.getBigDecimal("matchorderbasicqty3"));
                orderInfoMap.put("relateoutstockbaseqty", dynamicObject.getBigDecimal("relateoutstockbaseqty3"));
                orderInfoMap.put("sumreceiptbaseqty", dynamicObject.getBigDecimal("sumreceiptbaseqty3"));
                orderInfoMap.put("suminstockbaseqty", dynamicObject.getBigDecimal("suminstockbaseqty3"));
                orderInfoMap.put("sumrefundbaseqty", dynamicObject.getBigDecimal("sumrefundbaseqty3"));
                orderMatchInfoList.add(orderInfoMap);
            }
            matchOrderInfoMap.put(scheduleentryid, orderMatchInfoList);
            matchOrderInfoMap.putAll(this.getHaveMatchData(scheduleentryid));
            this.openMatchOrderPanel(scheduleInfoMapList, matchOrderInfoMap);
        }
    }

    private Map<Long, List<Map<String, Object>>> getHaveMatchData(Long scheduleentryid) {
        HashMap<Long, List<Map<String, Object>>> matchOrderInfoMap = new HashMap<Long, List<Map<String, Object>>>(64);
        for (DynamicObject dynamicObject : this.getModel().getEntryEntity(MATCHORDERENTITY)) {
            Long matchScheduleEntryId = dynamicObject.getLong("scheduleentryid1");
            if (matchScheduleEntryId.equals(scheduleentryid)) continue;
            ArrayList allStepList = (ArrayList)matchOrderInfoMap.get(matchScheduleEntryId);
            if (allStepList == null) {
                allStepList = new ArrayList(64);
            }
            HashMap<String, Object> orderInfoMap = new HashMap<String, Object>();
            orderInfoMap.put("availableqty", dynamicObject.getBigDecimal("availableqty1"));
            orderInfoMap.put("orderbillno", dynamicObject.getString("orderbillno1"));
            orderInfoMap.put("orderauditdate", dynamicObject.getString("orderauditdate1"));
            orderInfoMap.put("orderseq", dynamicObject.getString("orderseq1"));
            orderInfoMap.put("orderbillid", dynamicObject.getString("orderbillid1"));
            orderInfoMap.put("orderentryid", dynamicObject.getString("orderentryid1"));
            orderInfoMap.put("basicqty", dynamicObject.getBigDecimal("basicqty1"));
            orderInfoMap.put("matchorderbasicqty", dynamicObject.getBigDecimal("matchorderbasicqty1"));
            orderInfoMap.put("relateoutstockbaseqty", dynamicObject.getBigDecimal("relateoutstockbaseqty1"));
            orderInfoMap.put("sumreceiptbaseqty", dynamicObject.getBigDecimal("sumreceiptbaseqty1"));
            orderInfoMap.put("suminstockbaseqty", dynamicObject.getBigDecimal("suminstockbaseqty1"));
            orderInfoMap.put("sumrefundbaseqty", dynamicObject.getBigDecimal("sumrefundbaseqty1"));
            allStepList.add(orderInfoMap);
            matchOrderInfoMap.put(matchScheduleEntryId, allStepList);
        }
        return matchOrderInfoMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String customValue;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmOrderStatus".equals(callBackId)) {
            String customValue2;
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && (customValue2 = messageBoxClosedEvent.getCustomVaule()) != null) {
                Set unConfirmBillIds = (Set)SerializationUtils.fromJsonString((String)customValue2, Set.class);
                try {
                    OperationServiceHelper.executeOperate((String)"agreeorder", (String)"scp_order", (Object[])unConfirmBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                }
                catch (RuntimeException runtimeException) {
                    SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
                }
            }
        } else if ("verifydraftbillconfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && (customValue = messageBoxClosedEvent.getCustomVaule()) != null) {
            Set salOutStockBillIds = (Set)SerializationUtils.fromJsonString((String)customValue, Set.class);
            this.getView().showForm(ScpSaloutStockFormHelper.getShowParam(new ArrayList<Long>(salOutStockBillIds)));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.clearScheduleEntryDataMutex();
        this.clearOrderMatchBasicQtyRedisCache();
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.clearScheduleEntryDataMutex();
        this.clearOrderMatchBasicQtyRedisCache();
    }

    private void clearScheduleEntryDataMutex() {
        String entryIdsString = (String)this.getView().getFormShowParameter().getCustomParam("matchdeliverentryids");
        if (entryIdsString != null) {
            List entryIds = (List)SerializationUtils.fromJsonString((String)entryIdsString, List.class);
            ScpDeliverScheduleFormHelper.clearEntryLock(entryIds);
        }
    }

    private void clearOrderMatchBasicQtyRedisCache() {
        Map<String, String> orderBasicQtyMapCache = this.getCurrencyOrderBasicQtyMapCache();
        for (Map.Entry<String, String> entry : orderBasicQtyMapCache.entrySet()) {
            BigDecimal matchOrderBasicQty;
            String matchBasicQtyCache = this.getMatchBasicQtyCache(entry.getKey());
            BigDecimal cacheQty = BigDecimal.ZERO;
            if (matchBasicQtyCache != null) {
                cacheQty = new BigDecimal(matchBasicQtyCache);
            }
            this.putMatchBasicQtyMapCache(entry.getKey(), (cacheQty = cacheQty.subtract(matchOrderBasicQty = new BigDecimal(entry.getValue()))).compareTo(BigDecimal.ZERO) > 0 ? cacheQty.toPlainString() : BigDecimal.ZERO.toPlainString());
        }
    }

    private void putMatchBasicQtyMapCache(String orderEntryId, String basicQtyParam) {
        orderHaveMatchCache.put(orderEntryId, (Object)basicQtyParam);
    }

    private String getMatchBasicQtyCache(String orderEntryId) {
        return (String)orderHaveMatchCache.get(orderEntryId, String.class);
    }

    private void putCurrencyOrderBasicQtyMapCache(Map<String, String> currencyDeliverBasicQtyMap) {
        this.getPageCache().put(MATCHBASICQTYCACHE, SerializationUtils.toJsonString(currencyDeliverBasicQtyMap));
    }

    private Map<String, String> getCurrencyOrderBasicQtyMapCache() {
        String cacheString = this.getPageCache().get(MATCHBASICQTYCACHE);
        HashMap<String, String> cacheMap = new HashMap<String, String>(1024);
        try {
            if (cacheString != null) {
                cacheMap.putAll((Map)SerializationUtils.fromJsonString((String)cacheString, Map.class));
            }
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        return cacheMap;
    }

    private void putCurrencyDeliverBasicQtyMapCache(Map<String, String> currencyDeliverBasicQtyMap) {
        this.getPageCache().put(CURRENCYDELIVERBASICQTYCACHE, SerializationUtils.toJsonString(currencyDeliverBasicQtyMap));
    }

    private Map<String, String> getCurrencyDeliverBasicQtyMapCache() {
        String cacheString = this.getPageCache().get(CURRENCYDELIVERBASICQTYCACHE);
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        try {
            if (cacheString != null) {
                cacheMap.putAll((Map)SerializationUtils.fromJsonString((String)cacheString, Map.class));
            }
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        return cacheMap;
    }

    private List<DynamicObject> getScheduleAvailableData(String entryNumber) {
        ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(16);
        selectRows.addAll(this.getSelectRows(entryNumber));
        if (selectRows.isEmpty()) {
            selectRows.addAll((Collection<DynamicObject>)this.getModel().getEntryEntity(entryNumber));
        }
        return selectRows;
    }

    private List<DynamicObject> getSelectRows(String entryNumber) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryNumber);
        int[] rowIndexs = entryGrid.getSelectRows();
        ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(156);
        for (int rowIndex : rowIndexs) {
            DynamicObject entryRow = this.getView().getModel().getEntryRowEntity(entryNumber, rowIndex);
            selectRows.add(entryRow);
        }
        return selectRows;
    }

    private void openSchedulePreviewPanel() {
        String entryIdsString = (String)this.getView().getFormShowParameter().getCustomParam("matchdeliverentryids");
        if (entryIdsString != null) {
            List entryIds = (List)SerializationUtils.fromJsonString((String)entryIdsString, List.class);
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            DataEntityPropertyCollection dataEntityProperties = this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType().getProperties();
            for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
                this.ENTRYENTITYFIELDS.add(dataEntityProperty.getName());
            }
            ArrayList dsEntryIds = new ArrayList(entryIds.size());
            entryIds.forEach(row -> dsEntryIds.add(row.toString()));
            Map availableQtyMap = ScpDeliveryScheduleMatchHelper.getSalOutAvailableQtyMap(dsEntryIds);
            Map<String, String> cacheMap = this.getCurrencyDeliverBasicQtyMapCache();
            int rowIndex = 0;
            try (DataSet dataSet = ScpDeliveryScheduleMatchHelper.getScheduleDeliverData((List)entryIds);){
                String[] fieldNames = dataSet.getRowMeta().getFieldNames();
                while (dataSet.hasNext()) {
                    Row row2 = dataSet.next();
                    String entryid = row2.getString("scheduleentryid");
                    BigDecimal availableQty = (BigDecimal)availableQtyMap.get(entryid);
                    BigDecimal promisebasicqty = row2.getBigDecimal("promisebasicqty");
                    if (availableQty == null || availableQty.compareTo(BigDecimal.ZERO) == 0) {
                        availableQty = promisebasicqty;
                    } else if (availableQty.compareTo(promisebasicqty) > 0) {
                        availableQty = promisebasicqty;
                    } else if (availableQty.compareTo(BigDecimal.ZERO) > 0 && availableQty.compareTo(promisebasicqty) <= 0) {
                        availableQty = promisebasicqty.subtract(availableQty);
                    }
                    for (String key : fieldNames) {
                        if (!this.ENTRYENTITYFIELDS.contains(key)) continue;
                        tableValueSetter.set(key, row2.get(key), rowIndex);
                    }
                    BigDecimal currencyBasicQty = null;
                    String cacheDeliverBasicQty = cacheMap.get(entryid);
                    if (cacheDeliverBasicQty != null) {
                        currencyBasicQty = new BigDecimal(cacheDeliverBasicQty);
                    }
                    if (currencyBasicQty == null) {
                        currencyBasicQty = availableQty;
                    }
                    if (this.ENTRYENTITYFIELDS.contains("availableqty") || this.ENTRYENTITYFIELDS.contains("currencydeliverbasicqty")) {
                        tableValueSetter.set("availableqty", (Object)availableQty, rowIndex);
                        tableValueSetter.set("currencydeliverbasicqty", (Object)currencyBasicQty, rowIndex);
                    }
                    ++rowIndex;
                }
            }
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
            abstractFormDataModel.deleteEntryData(ENTRYENTITY);
            abstractFormDataModel.beginInit();
            abstractFormDataModel.batchCreateNewEntryRow(ENTRYENTITY, tableValueSetter);
            abstractFormDataModel.endInit();
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"preview_image", "preview_imaged", "matchorder_image", "matchorder_imaged", "fs_previewschdule", "fs_matchorderinfo", "fs_modifymatchdata", "fs_matchdeliverbar"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fs_matchdeliverbar", "fs_previewschdule", "preview_imaged", "matchorder_image"});
    }

    /*
     * WARNING - void declaration
     */
    private void openMatchOrderPanel(List<Map<String, Object>> scheduleInfoMapList, Map<Long, List<Map<String, Object>>> matchOrderInfoParamMap) {
        Long scheduleentryid;
        Iterator<String> entryId;
        ArrayList matchDoneOrderIds = new ArrayList(64);
        scheduleInfoMapList.forEach(row -> {
            Long scheduleEntryId = (Long)row.get("scheduleentryid");
            if (matchOrderInfoParamMap.containsKey(scheduleEntryId)) {
                matchDoneOrderIds.add(scheduleEntryId);
            }
        });
        LinkedHashMap<Long, DeliverScheduleMatchOrderInfo> deliverScheduleMatchOrderInfoMap = new LinkedHashMap<Long, DeliverScheduleMatchOrderInfo>(64);
        HashMap<Long, BigDecimal> scheduleEntryQtyMap = new HashMap<Long, BigDecimal>(64);
        Map<String, String> matchFilterFieldMap = this.getMatchFilterFieldMap();
        LinkedHashMap<Long, List<Map<String, Object>>> matchOrderInfoMap = new LinkedHashMap<Long, List<Map<String, Object>>>(matchOrderInfoParamMap);
        for (Map<String, Object> data : scheduleInfoMapList) {
            Long scheduleentryid2 = (Long)data.get("scheduleentryid");
            if (matchDoneOrderIds.contains(scheduleentryid2)) continue;
            Long org = 0L;
            if (matchFilterFieldMap.containsKey("org")) {
                org = (Long)data.get("org");
            }
            Long supplier = 0L;
            if (matchFilterFieldMap.containsKey("supplier")) {
                supplier = (Long)data.get("supplier");
            }
            Long material = 0L;
            if (matchFilterFieldMap.containsKey("material")) {
                material = (Long)data.get("material");
            }
            Long basicunit = 0L;
            if (matchFilterFieldMap.containsKey("basicunit")) {
                basicunit = (Long)data.get("basicunit");
            }
            Long entryrcvorg = 0L;
            if (matchFilterFieldMap.containsKey("entryrcvorg")) {
                entryrcvorg = (Long)data.get("entryrcvorg");
            }
            DeliverScheduleMatchOrderInfo scheduleMatchOrderInfo = new DeliverScheduleMatchOrderInfo(org, supplier, material, basicunit, entryrcvorg);
            deliverScheduleMatchOrderInfoMap.put(scheduleentryid2, scheduleMatchOrderInfo);
            BigDecimal promisebasicqty = (BigDecimal)data.get("currencydeliverbasicqty");
            scheduleEntryQtyMap.put(scheduleentryid2, promisebasicqty);
        }
        HashMap<Long, BigDecimal> scheduleEntryMatchQtyMap = new HashMap<Long, BigDecimal>(1024);
        ArrayList orderInfoMatchMap = null;
        HashMap<String, Object> OrderInfoMap = null;
        List<DynamicObject> jointBills = this.queryOrderCollectionData(scheduleInfoMapList, matchFilterFieldMap);
        Iterator<DynamicObject> orderBillDataSet = jointBills.iterator();
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put("tgtbilltype", "scp_saloutstock");
        customParamMap.put("valueproperty", "relateoutstockbaseqty");
        customParamMap.put("keyField", "orderbillid");
        customParamMap.put("jointChannelField", "jointdatachannelid");
        Map orderAvailableBasicQty = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicCustomQty(jointBills, customParamMap);
        HashMap<String, BigDecimal> logMap = new HashMap<String, BigDecimal>(8);
        HashMap logDetailMap = new HashMap(8);
        while (orderBillDataSet.hasNext()) {
            void var22_23;
            DynamicObject row2 = orderBillDataSet.next();
            Object org = 0L;
            if (matchFilterFieldMap.containsKey("org")) {
                org = row2.getLong("org");
            }
            Long supplier = 0L;
            if (matchFilterFieldMap.containsKey("supplier")) {
                supplier = row2.getLong("supplier");
            }
            Long material = 0L;
            if (matchFilterFieldMap.containsKey("material")) {
                material = row2.getLong("material");
            }
            Object basicunit = 0L;
            if (matchFilterFieldMap.containsKey("basicunit")) {
                basicunit = row2.getLong("basicunit");
            }
            Long l = 0L;
            if (matchFilterFieldMap.containsKey("entryrcvorg")) {
                Long l2 = row2.getLong("entryrcvorg");
            }
            BigDecimal orderRowAvailableQty = BigDecimal.ZERO;
            entryId = row2.getLong("orderentryid");
            orderRowAvailableQty = orderAvailableBasicQty.getOrDefault(entryId, BigDecimal.ZERO);
            BigDecimal orderHaveMatchQty = BigDecimal.ZERO;
            String orderEntryId = row2.getString("orderentryid");
            String haveMatchBasicQtyCache = this.getMatchBasicQtyCache(orderEntryId);
            if (haveMatchBasicQtyCache != null) {
                orderHaveMatchQty = new BigDecimal(haveMatchBasicQtyCache);
            }
            logMap.put(orderEntryId, orderHaveMatchQty);
            boolean anyNotFullMatch = scheduleEntryQtyMap.entrySet().stream().anyMatch(k -> {
                BigDecimal fullMatchQty = (BigDecimal)scheduleEntryMatchQtyMap.get(k.getKey());
                return fullMatchQty == null || fullMatchQty.compareTo((BigDecimal)k.getValue()) < 0;
            });
            if (!anyNotFullMatch) break;
            DeliverScheduleMatchOrderInfo scheduleMatchOrderInfo = new DeliverScheduleMatchOrderInfo((Long)org, supplier, material, (Long)basicunit, (Long)var22_23);
            BigDecimal orderRowMatchAvailableQty = null;
            for (Map.Entry entry : deliverScheduleMatchOrderInfoMap.entrySet()) {
                if (!((DeliverScheduleMatchOrderInfo)entry.getValue()).equals(scheduleMatchOrderInfo)) continue;
                scheduleentryid = (Long)entry.getKey();
                BigDecimal promiseBasicQty = (BigDecimal)scheduleEntryQtyMap.get(scheduleentryid);
                BigDecimal haveMatchQty = (BigDecimal)scheduleEntryMatchQtyMap.get(scheduleentryid);
                if (haveMatchQty == null) {
                    haveMatchQty = BigDecimal.ZERO;
                }
                if ((orderInfoMatchMap = (ArrayList)matchOrderInfoMap.get(scheduleentryid)) == null) {
                    orderInfoMatchMap = new ArrayList(64);
                }
                orderRowMatchAvailableQty = orderRowAvailableQty.subtract(orderHaveMatchQty);
                HashMap<String, BigDecimal> logDetailMapLog = new HashMap<String, BigDecimal>(8);
                logDetailMapLog.put("promiseBasicQty", promiseBasicQty);
                logDetailMapLog.put("haveMatchQty", haveMatchQty);
                logDetailMapLog.put("orderHaveMatchQty", orderHaveMatchQty);
                logDetailMapLog.put("orderRowAvailableQty", orderRowMatchAvailableQty);
                if (orderRowMatchAvailableQty.compareTo(BigDecimal.ZERO) > 0 && promiseBasicQty.compareTo(haveMatchQty) > 0) {
                    BigDecimal matchOrderQty = BigDecimal.ZERO;
                    matchOrderQty = haveMatchQty.add(orderRowMatchAvailableQty).compareTo(promiseBasicQty) > 0 ? promiseBasicQty.subtract(haveMatchQty) : orderRowMatchAvailableQty;
                    OrderInfoMap = new HashMap<String, Object>(64);
                    OrderInfoMap.put("availableqty", matchOrderQty);
                    OrderInfoMap.put("orderbillno", row2.getString("orderbillno"));
                    OrderInfoMap.put("orderauditdate", row2.getDate("orderauditdate"));
                    OrderInfoMap.put("orderseq", row2.getInt("orderseq"));
                    OrderInfoMap.put("orderbillid", row2.getString("orderbillid"));
                    OrderInfoMap.put("unit", row2.getLong("unit"));
                    OrderInfoMap.put("orderentryid", row2.getString("orderentryid"));
                    OrderInfoMap.put("qty", row2.getBigDecimal("qty"));
                    OrderInfoMap.put("basicqty", row2.getBigDecimal("basicqty"));
                    OrderInfoMap.put("relateoutstockbaseqty", row2.getBigDecimal("relateoutstockbaseqty"));
                    OrderInfoMap.put("sumreceiptbaseqty", row2.getBigDecimal("sumreceiptbaseqty"));
                    OrderInfoMap.put("suminstockbaseqty", row2.getBigDecimal("suminstockbaseqty"));
                    OrderInfoMap.put("sumrefundbaseqty", row2.getBigDecimal("sumrefundbaseqty"));
                    OrderInfoMap.put("matchorderbasicqty", matchOrderQty);
                    haveMatchQty = haveMatchQty.add(matchOrderQty);
                    orderHaveMatchQty = orderHaveMatchQty.add(matchOrderQty);
                    scheduleEntryMatchQtyMap.put(scheduleentryid, haveMatchQty);
                    orderInfoMatchMap.add(OrderInfoMap);
                    matchOrderInfoMap.put(scheduleentryid, orderInfoMatchMap);
                }
                logDetailMapLog.put("orderHaveMatchQtyNew", orderHaveMatchQty);
                logDetailMapLog.put("haveMatchQtyNew", haveMatchQty);
                logDetailMap.put(String.valueOf(scheduleentryid), logDetailMapLog);
                if (orderRowAvailableQty.compareTo(orderHaveMatchQty) > 0) continue;
                break;
            }
            this.putMatchBasicQtyMapCache(orderEntryId, orderHaveMatchQty.toPlainString());
        }
        if (log.isInfoEnabled()) {
            log.info("haveMatchBasicQtyCache# logMap={}", (Object)JSON.toJSONString(logMap));
        }
        if (log.isInfoEnabled()) {
            log.info("haveMatchBasicQtyCache# logMap={}", (Object)JSON.toJSONString(logDetailMap));
        }
        DataEntityPropertyCollection dataEntityProperties = this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType().getProperties();
        for (Object dataEntityProperty : dataEntityProperties) {
            this.ENTRYENTITYFIELDS.add(dataEntityProperty.getName());
        }
        DataEntityPropertyCollection dataEntityProperties1 = this.getModel().getEntryEntity(MATCHORDERENTITY).getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties1) {
            this.MATCHORDERENTITYFIELDS.add(dataEntityProperty.getName());
        }
        int rowIndex = 0;
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (Map map : scheduleInfoMapList) {
            scheduleentryid = (Long)map.get("scheduleentryid");
            List orderInfoMapList = (List)matchOrderInfoMap.get(scheduleentryid);
            if (orderInfoMapList != null) {
                entryId = orderInfoMapList.iterator();
                while (entryId.hasNext()) {
                    Map orderInfoMap = (Map)((Object)entryId.next());
                    for (String key : this.ENTRYENTITYFIELDS) {
                        String proKey = key + MATCHORDERSUFFIX;
                        if (!this.MATCHORDERENTITYFIELDS.contains(proKey)) continue;
                        tableValueSetter.set(proKey, map.get(key), rowIndex);
                    }
                    for (Map.Entry entry : orderInfoMap.entrySet()) {
                        String proKey = (String)entry.getKey() + MATCHORDERSUFFIX;
                        if (!this.MATCHORDERENTITYFIELDS.contains(proKey)) continue;
                        tableValueSetter.set(proKey, entry.getValue(), rowIndex);
                    }
                    ++rowIndex;
                }
                continue;
            }
            for (String key : this.ENTRYENTITYFIELDS) {
                String proKey = key + MATCHORDERSUFFIX;
                if (!this.MATCHORDERENTITYFIELDS.contains(proKey)) continue;
                tableValueSetter.set(proKey, map.get(key), rowIndex);
            }
            ++rowIndex;
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.deleteEntryData(MATCHORDERENTITY);
        abstractFormDataModel.beginInit();
        abstractFormDataModel.batchCreateNewEntryRow(MATCHORDERENTITY, tableValueSetter);
        abstractFormDataModel.endInit();
        this.getView().updateView(MATCHORDERENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"preview_image", "preview_imaged", "matchorder_image", "matchorder_imaged", "fs_previewschdule", "fs_matchorderinfo", "fs_modifymatchdata", "fs_matchdeliverbar"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fs_matchdeliverbar", "preview_image", "matchorder_imaged", "fs_matchorderinfo"});
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(64);
        DynamicObjectCollection matchOrderEntrys = this.getView().getModel().getEntryEntity(MATCHORDERENTITY);
        for (DynamicObject row3 : matchOrderEntrys) {
            String orderEntryId = row3.getString("orderentryid1");
            if (orderEntryId == null) continue;
            BigDecimal stepQty = (BigDecimal)hashMap.get(orderEntryId);
            BigDecimal matchOrderBasicQty = row3.getBigDecimal("matchorderbasicqty1");
            stepQty = stepQty == null ? matchOrderBasicQty : matchOrderBasicQty.add(stepQty);
            hashMap.put(orderEntryId, stepQty);
        }
        HashMap<String, String> currencyOrderMatchStringQtyMap = new HashMap<String, String>(64);
        for (Map.Entry entry : hashMap.entrySet()) {
            currencyOrderMatchStringQtyMap.put((String)entry.getKey(), ((BigDecimal)entry.getValue()).toPlainString());
        }
        this.putCurrencyOrderBasicQtyMapCache(currencyOrderMatchStringQtyMap);
    }

    private void openModifyMatchData(Map<String, Object> matchScheduleInfoMap, Map<Long, Map<String, Object>> orderMatchDataInfoMap) {
        DataEntityPropertyCollection dataEntityProperties3 = this.getModel().getEntryEntity(MODIFYORDERENTITY).getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties3) {
            this.MODIFYORDERENTITYFIELDS.add(dataEntityProperty.getName());
        }
        Map<String, String> matchFilterFieldMap = this.getMatchFilterFieldMap();
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        DataEntityPropertyCollection dataEntityProperties2 = abstractFormDataModel.getEntryEntity(MODIFYSCHEDULEENTITY).getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties2) {
            this.MODIFYSCHEDULESUFFIXFIELDS.add(dataEntityProperty.getName());
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        for (Map.Entry<String, Object> entry : matchScheduleInfoMap.entrySet()) {
            Object entryValue = entry.getValue();
            String entryKey = entry.getKey();
            String proKey = entryKey + MODIFYSCHEDULESUFFIX;
            if (!this.MODIFYSCHEDULESUFFIXFIELDS.contains(proKey)) continue;
            tableValueSetter.set(proKey, entryValue, rowIndex);
        }
        abstractFormDataModel.deleteEntryData(MODIFYSCHEDULEENTITY);
        abstractFormDataModel.beginInit();
        abstractFormDataModel.batchCreateNewEntryRow(MODIFYSCHEDULEENTITY, tableValueSetter);
        abstractFormDataModel.endInit();
        this.getView().updateView(MODIFYSCHEDULEENTITY);
        ArrayList<Map<String, Object>> matchScheduleInfoMapList = new ArrayList<Map<String, Object>>(1);
        matchScheduleInfoMapList.add(matchScheduleInfoMap);
        List<DynamicObject> jointBills = this.queryOrderCollectionData(matchScheduleInfoMapList, matchFilterFieldMap);
        Iterator<DynamicObject> orderBillDataSet = jointBills.iterator();
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put("tgtbilltype", "scp_saloutstock");
        customParamMap.put("keyField", "orderbillid");
        customParamMap.put("valueproperty", "relateoutstockbaseqty");
        customParamMap.put("jointChannelField", "jointdatachannelid");
        Map orderAvailableBasicQty = OrderAvailableStockQtyHelper.assembleOrderAvailableBasicCustomQty(jointBills, customParamMap);
        TableValueSetter tableValueSetterOrder = new TableValueSetter(new String[0]);
        HashSet<String> dataFields = new HashSet<String>(1024);
        if (jointBills.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection dataEntityProperties = jointBills.get(0).getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            dataFields.add(dataEntityProperty.getName());
        }
        while (orderBillDataSet.hasNext()) {
            DynamicObject row = orderBillDataSet.next();
            BigDecimal orderRowAvailableQty = BigDecimal.ZERO;
            Long entryId = row.getLong("orderentryid");
            orderRowAvailableQty = orderAvailableBasicQty.getOrDefault(entryId, BigDecimal.ZERO);
            Long orderEntryId = row.getLong("orderentryid");
            if (orderRowAvailableQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            for (String key : dataFields) {
                String proKey = key + MODIFYORDERSUFFIX;
                if (!this.MODIFYORDERENTITYFIELDS.contains(proKey)) continue;
                tableValueSetterOrder.set(proKey, row.get(key), rowIndex);
            }
            Map<String, Object> orderMatchInfoMap = orderMatchDataInfoMap.get(orderEntryId);
            if (orderMatchInfoMap != null) {
                tableValueSetterOrder.set("matchorderbasicqty3", orderMatchInfoMap.get("matchorderbasicqty"), rowIndex);
            } else {
                String haveMatchBasicQtyCache = this.getMatchBasicQtyCache(String.valueOf(orderEntryId));
                if (haveMatchBasicQtyCache != null) {
                    orderRowAvailableQty = orderRowAvailableQty.subtract(new BigDecimal(haveMatchBasicQtyCache));
                }
            }
            tableValueSetterOrder.set("availableqty3", (Object)orderRowAvailableQty, rowIndex);
            ++rowIndex;
        }
        abstractFormDataModel.deleteEntryData(MODIFYORDERENTITY);
        abstractFormDataModel.beginInit();
        abstractFormDataModel.batchCreateNewEntryRow(MODIFYORDERENTITY, tableValueSetterOrder);
        abstractFormDataModel.endInit();
        this.getView().updateView(MODIFYORDERENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"preview_image", "preview_imaged", "matchorder_image", "matchorder_imaged", "fs_previewschdule", "fs_matchorderinfo", "fs_modifymatchdata", "fs_matchdeliverbar"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fs_modifymatchdata"});
    }

    private Map<String, Object> getScheduleDataMap(DynamicObject scheduleData) {
        HashMap<String, Object> matchScheduleInfoMap = new HashMap<String, Object>(64);
        matchScheduleInfoMap.put("org", scheduleData.getLong("org.id"));
        matchScheduleInfoMap.put("billno", scheduleData.getString("billno"));
        matchScheduleInfoMap.put("supplier", scheduleData.getLong("supplier.id"));
        matchScheduleInfoMap.put("material", scheduleData.getLong("material.id"));
        matchScheduleInfoMap.put("unit", scheduleData.getLong("unit.id"));
        matchScheduleInfoMap.put("basicunit", scheduleData.getLong("basicunit.id"));
        matchScheduleInfoMap.put("promiseqty", scheduleData.getBigDecimal("promiseqty"));
        matchScheduleInfoMap.put("promisebasicqty", scheduleData.getBigDecimal("promisebasicqty"));
        matchScheduleInfoMap.put("availableqty", scheduleData.getBigDecimal("availableqty"));
        matchScheduleInfoMap.put("currencydeliverbasicqty", scheduleData.getBigDecimal("currencydeliverbasicqty"));
        matchScheduleInfoMap.put("entryrcvorg", scheduleData.getLong("entryrcvorg.id"));
        matchScheduleInfoMap.put("warehouse", scheduleData.getLong("warehouse.id"));
        matchScheduleInfoMap.put("deliaddr", scheduleData.getString("deliaddr"));
        matchScheduleInfoMap.put("deliverydate", scheduleData.getDate("deliverydate"));
        matchScheduleInfoMap.put("promisedate", scheduleData.getDate("promisedate"));
        matchScheduleInfoMap.put("estimateddeliverydate", scheduleData.getDate("estimateddeliverydate"));
        matchScheduleInfoMap.put("schedulebillid", scheduleData.getLong("schedulebillid"));
        matchScheduleInfoMap.put("scheduleentryid", scheduleData.getLong("scheduleentryid"));
        return matchScheduleInfoMap;
    }

    private List<DynamicObject> queryOrderCollectionData(List<Map<String, Object>> matchScheduleInfoMaps, Map<String, String> matchFilterFieldMap) {
        HashMap<String, ArrayList<Object>> orderFilterMap = new HashMap<String, ArrayList<Object>>(16);
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (Map<String, Object> map : matchScheduleInfoMaps) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object filterValue = entry.getValue();
                String entryKey = entry.getKey();
                String orderFilterKey = matchFilterFieldMap.get(entryKey);
                if (orderFilterKey == null) continue;
                ArrayList<Object> objects = (ArrayList<Object>)orderFilterMap.get(orderFilterKey);
                if (objects == null) {
                    objects = new ArrayList<Object>();
                    objects.add(filterValue);
                } else {
                    objects.add(filterValue);
                }
                orderFilterMap.put(orderFilterKey, objects);
            }
        }
        for (Map.Entry entry : orderFilterMap.entrySet()) {
            qFilter.and((String)entry.getKey(), "in", entry.getValue());
        }
        qFilter.and(new QFilter("cfmstatus", "in", (Object)new String[]{"A", "B", "E"}).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A")));
        qFilter.and(QFilter.of((String)"materialentry.basicqty > ( materialentry.sumoutstockbaseqty - materialentry.sumrefundbaseqty )", (Object[])new Object[0]));
        return ScpDeliveryScheduleMatchHelper.getDeliverOrderCollectionData((QFilter)qFilter);
    }

    private DataSet queryOrderData(List<Map<String, Object>> matchScheduleInfoMaps, Map<String, String> matchFilterFieldMap) {
        HashMap<String, ArrayList<Object>> orderFilterMap = new HashMap<String, ArrayList<Object>>(16);
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (Map<String, Object> map : matchScheduleInfoMaps) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object filterValue = entry.getValue();
                String entryKey = entry.getKey();
                String orderFilterKey = matchFilterFieldMap.get(entryKey);
                if (orderFilterKey == null) continue;
                ArrayList<Object> objects = (ArrayList<Object>)orderFilterMap.get(orderFilterKey);
                if (objects == null) {
                    objects = new ArrayList<Object>();
                    objects.add(filterValue);
                } else {
                    objects.add(filterValue);
                }
                orderFilterMap.put(orderFilterKey, objects);
            }
        }
        for (Map.Entry entry : orderFilterMap.entrySet()) {
            qFilter.and((String)entry.getKey(), "in", entry.getValue());
        }
        qFilter.and(new QFilter("cfmstatus", "in", (Object)new String[]{"A", "B", "E"}).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A")));
        qFilter.and(QFilter.of((String)"materialentry.basicqty > ( materialentry.sumoutstockbaseqty - materialentry.sumrefundbaseqty )", (Object[])new Object[0]));
        QFilter forInitDataFilter = qFilter.copy();
        ScpDeliveryScheduleMatchHelper.storeInitStockQty((QFilter)forInitDataFilter);
        return ScpDeliveryScheduleMatchHelper.getDeliverOrderData((QFilter)qFilter);
    }

    private Map<String, String> getMatchFilterFieldMap() {
        HashMap<String, String> matchFilterFieldMap = new HashMap<String, String>(16);
        matchFilterFieldMap.put("supplier", "supplier");
        matchFilterFieldMap.put("material", "materialentry.material");
        matchFilterFieldMap.put("basicunit", "materialentry.basicunit");
        if (ScpBillParamHelper.getBooleanBillParam((String)"scp_scheduledelivery", (String)"matchpurorg").booleanValue()) {
            matchFilterFieldMap.put("org", "org");
        }
        if (ScpBillParamHelper.getBooleanBillParam((String)"scp_scheduledelivery", (String)"matchreceiveorg").booleanValue()) {
            matchFilterFieldMap.put("entryrcvorg", "materialentry.entryrcvorg");
        }
        return matchFilterFieldMap;
    }
}

